<?php
/**
 * The style "default" of the Blogger
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

$args = get_query_var('trx_addons_args_sc_blogger');

if ($args['slider']) {
	?><div class="swiper-slide"><?php
} else if ((int)$args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

$post_format = get_post_format();
$post_format = empty($post_format) ? 'standard' : str_replace('post-format-', '', $post_format);
$post_link = get_permalink();
$post_title = get_the_title();
$image_hover = mckinney_politics_get_theme_option('image_hover');

?><div id="post-<?php the_ID(); ?>"	<?php post_class( 'sc_blogger_item post_format_'.esc_attr($post_format) ); ?>><?php

	// Featured image
	if ( has_post_thumbnail() ) {
		?><div class="sc_blogger_item_featured post_featured with_thumb hover_<?php echo esc_attr($image_hover); ?>">
			<?php the_post_thumbnail( trx_addons_get_thumb_size($args['columns'] > 2 ? 'small' : 'medium'), array( 'alt' => $post_title ) ); ?>
			<div class="mask"></div>
			<?php mckinney_politics_hovers_add_icons($image_hover); ?>
		</div><?php
	}
	
	// Post content
	?><div class="sc_blogger_item_content entry-content"><?php

		// Post title
		if ( !in_array($post_format, array('link', 'aside', 'status', 'quote')) ) {
			?><div class="sc_blogger_item_header entry-header"><?php 
				// Post title
				the_title( sprintf( '<h4 class="sc_blogger_item_title entry-title"><a href="%s" rel="bookmark">', esc_url( $post_link ) ), '</a></h4>' );
				// Post meta
				trx_addons_sc_show_post_meta('sc_blogger', array(
					'date' => true,
					'categories' => true
					)
				);
			?></div><!-- .entry-header --><?php
		}		
		
	?></div><!-- .entry-content --><?php
	
?></div><!-- .sc_blogger_item --><?php

if ($args['slider'] || (int)$args['columns'] > 1) {
	?></div><?php
}
?>