//-------------------------------------------
// Meta Boxes manipulations
//-------------------------------------------
jQuery(document).ready(function() {
	"use strict";

	// jQuery Tabs
	jQuery('#mckinney_politics_override_options_tabs').tabs();

	// Toggle inherit button and cover
	jQuery('#mckinney_politics_override_options_tabs').on('click', '.mckinney_politics_override_options_inherit_lock,.mckinney_politics_override_options_inherit_cover', function (e) {
		"use strict";
		var parent = jQuery(this).parents('.mckinney_politics_override_options_item');
		var inherit = parent.hasClass('mckinney_politics_override_options_inherit_on');
		if (inherit) {
			parent.removeClass('mckinney_politics_override_options_inherit_on').addClass('mckinney_politics_override_options_inherit_off');
			parent.find('.mckinney_politics_override_options_inherit_cover').fadeOut().find('input[type="hidden"]').val('');
		} else {
			parent.removeClass('mckinney_politics_override_options_inherit_off').addClass('mckinney_politics_override_options_inherit_on');
			parent.find('.mckinney_politics_override_options_inherit_cover').fadeIn().find('input[type="hidden"]').val('inherit');
			
		}
		e.preventDefault();
		return false;
	});

    // Check for dependencies
    //-----------------------------------------------------------------------------
    function mckinney_politics_override_options_start_check_dependencies() {
        jQuery( '.mckinney_politics_override_options .mckinney_politics_override_options_section' ).each(
            function () {
                mckinney_politics_override_options_check_dependencies( jQuery( this ) );
            }
        );
    }
    // Check all inner dependencies
    jQuery( document ).ready( mckinney_politics_override_options_start_check_dependencies );
    // Check external dependencies (for example, "Page template" in the page edit mode)
    jQuery( window ).on('load', mckinney_politics_override_options_start_check_dependencies );
	jQuery('.mckinney_politics_override_override_options .mckinney_politics_override_override_options_item_field [name^="mckinney_politics_override_override_options_field_"]').on('change', function () {
		"use strict";
		mckinney_politics_override_override_options_check_dependencies(jQuery(this).parents('.mckinney_politics_override_override_options_section'));
	});

});

// Return value of the field
function mckinney_politics_override_options_get_field_value(fld, num) {
    "use strict";
    var ctrl = fld.parents( '.mckinney_politics_override_options_item_field' );
    var val  = fld.attr( 'type' ) == 'checkbox' || fld.attr( 'type' ) == 'radio'
        ? (ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).length > 0
                ? (num === true
                        ? ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).parent().index() + 1
                        : (ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).val() !== ''
                            && '' + ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).val() != '0'
                                ? ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).val()
                                : 1
                        )
                )
                : 0
        )
        : (num === true ? fld.find( ':selected' ).index() + 1 : fld.val());
    if (val === undefined || val === null) {
        val = '';
    }
    return val;
}

// Check for dependencies
function mckinney_politics_override_options_check_dependencies(cont) {
	if ( typeof mckinney_politics_dependencies == 'undefined' || MCKINNEY_POLITICS_STORAGE['check_dependencies_now'] ) {
		return;
	}
	MCKINNEY_POLITICS_STORAGE['check_dependencies_now'] = true;
	cont.find( '.mckinney_politics_override_options_item_field,.mckinney_politics_override_options_group[data-param]' ).each( function() {
		var ctrl = jQuery( this ),
			id = ctrl.data( 'param' );
		if (id === undefined) {
			return;
		}
		var depend = false, fld;
		for (fld in mckinney_politics_dependencies) {
			if (fld == id) {
				depend = mckinney_politics_dependencies[id];
				break;
			}
		}
		if (depend) {
			var dep_cnt    = 0, dep_all = 0;
			var dep_cmp    = typeof depend.compare != 'undefined' ? depend.compare.toLowerCase() : 'and';
			var dep_strict = typeof depend.strict != 'undefined';
			var val        = undefined;
			var name       = '', subname = '';
			var parts      = '', parts2 = '';
			var i;
			fld = null;
			for (i in depend) {
				if (i == 'compare' || i == 'strict') {
					continue;
				}
				dep_all++;
				name    = i;
				subname = '';
				if (name.indexOf( '[' ) > 0) {
					parts   = name.split( '[' );
					name    = parts[0];
					subname = parts[1].replace( ']', '' );
				}
				// If a name is a selector to the DOM-object 
				if (name.charAt( 0 ) == '#' || name.charAt( 0 ) == '.') {
					fld = jQuery( name );
					if ( fld.length > 0 ) {
						var panel = fld.closest('.edit-post-sidebar');
						if ( panel.length === 0 ) {
							if ( ! fld.hasClass('mckinney_politics_inited') ) {
								fld.addClass('mckinney_politics_inited').on('change', function () {
									jQuery('.mckinney_politics_override_options .mckinney_politics_override_options_section').each( function () {
										mckinney_politics_override_options_check_dependencies(jQuery(this));
									} );
								} );
							}
						} else {
							if ( ! panel.hasClass('mckinney_politics_inited') ) {
								panel.addClass('mckinney_politics_inited').on('change', fld, function () {
									jQuery('.mckinney_politics_override_options .mckinney_politics_override_options_section').each( function () {
										mckinney_politics_override_options_check_dependencies(jQuery(this));
									} );
								} );
							}
						}
					} else if ( name == '#page_template' || name == '.editor-page-attributes__template select' ) {
						if ( typeof wp == 'object' && typeof wp.data == 'object' ) {
							if ( typeof MCKINNEY_POLITICS_STORAGE['page_template'] == 'undefined' ) {
								var tpl = wp.data.select( 'core/editor' ).getEditedPostAttribute( 'template' );
								if ( tpl !== undefined ) {
									MCKINNEY_POLITICS_STORAGE['page_template'] = tpl;
								}
							}
							val = typeof MCKINNEY_POLITICS_STORAGE['page_template'] != 'undefined' ? MCKINNEY_POLITICS_STORAGE['page_template'] : '';
							var $body = jQuery( 'body' );
							if ( ! $body.hasClass( 'mckinney_politics_page_template_inited' ) ) {
								$body.addClass( 'mckinney_politics_page_template_inited' );
								// Call a check_dependencies() on a page template changed
								wp.data.subscribe( function() {
									var tpl = wp.data.select( 'core/editor' ).getEditedPostAttribute( 'template' );
									if ( tpl !== undefined && ( typeof MCKINNEY_POLITICS_STORAGE['page_template'] == 'undefined' || tpl != MCKINNEY_POLITICS_STORAGE['page_template'] ) ) {
										MCKINNEY_POLITICS_STORAGE['page_template'] = tpl;
										jQuery('.mckinney_politics_override_options .mckinney_politics_override_options_section').each( function () {
											mckinney_politics_override_options_check_dependencies(jQuery(this));
										} );
									}

								} );
							}
						}
					}
				// A name is a field from options
				} else {
					fld = cont.find( '[name="mckinney_politics_override_options_field_' + name + '"]' );
				}
				if ( val !== undefined || ( fld && fld.length > 0 ) ) {
					if ( val === undefined ) {
						val = mckinney_politics_override_options_get_field_value( fld );
					}
					if ( val == 'inherit' ) {
						dep_cnt = 0;
						dep_all = 1;
						var parent = ctrl,
							tag;
						if ( ! parent.hasClass('mckinney_politics_override_options_group') ) {
							parent = parent.parents('.mckinney_politics_override_options_item');
						}
						var lock = parent.find( '.mckinney_politics_override_options_inherit_lock' );
						if ( lock.length ) {
							if ( ! parent.hasClass( 'mckinney_politics_override_options_inherit_on' ) ) {
								lock.trigger( 'click' );
							}
						} else if ( ctrl.data('type') == 'select' ) {
							tag = ctrl.find('select');
							if ( tag.find('option[value="inherit"]').length ) {
								tag.val('inherit').trigger('change');
							}
						} else if ( ctrl.data('type') == 'radio' ) {
							tag = ctrl.find('input[type="radio"][value="inherit"]');
							if ( tag.length && ! tag.get(0).checked ) {
								ctrl.find('input[type="radio"]:checked').get(0).checked = false;
								tag.get(0).checked = true;
								tag.trigger('change');
							}
						}
						break;
					} else {
						if (subname !== '') {
							parts = val.split( '|' );
							for (var p = 0; p < parts.length; p++) {
								parts2 = parts[p].split( '=' );
								if (parts2[0] == subname) {
									val = parts2[1];
								}
							}
						}
						if ( typeof depend[i] != 'object' && typeof depend[i] != 'array' ) {
							depend[i] = { '0': depend[i] };
						}
						for (var j in depend[i]) {
							if (
								(depend[i][j] == 'not_empty' && val !== '')   // Main field value is not empty - show current field
								|| (depend[i][j] == 'is_empty' && val === '') // Main field value is empty - show current field
								|| (val !== '' && ( ! isNaN( depend[i][j] )   // Main field value equal to specified value - show current field
												? val == depend[i][j]
												: (dep_strict
														? val == depend[i][j]
														: ('' + val).indexOf( depend[i][j] ) === 0
													)
											)
								)
								|| (val !== '' && ("" + depend[i][j]).charAt( 0 ) == '^' && ('' + val).indexOf( depend[i][j].substr( 1 ) ) == -1)
																			// Main field value not equal to specified value - show current field
							) {
								dep_cnt++;
								break;
							}
						}
					}
				} else {
					dep_all--;
				}
				if (dep_cnt > 0 && dep_cmp == 'or') {
					break;
				}
			}
			if ( ! ctrl.hasClass('mckinney_politics_override_options_group') ) {
				ctrl = ctrl.parents('.mckinney_politics_override_options_item');
			}
			var section = ctrl.parents('.mckinney_politics_tabs_section'),
				tab = jQuery( '[aria-labelledby="' + section.attr('aria-labelledby') + '"]' );
			if (((dep_cnt > 0 || dep_all === 0) && dep_cmp == 'or') || (dep_cnt == dep_all && dep_cmp == 'and')) {
				ctrl.slideDown().removeClass( 'mckinney_politics_override_options_no_use' );
				if ( section.find('>.mckinney_politics_override_options_item:not(.mckinney_politics_override_options_item_info),>.mckinney_politics_override_options_group[data-param]').length != section.find('.mckinney_politics_override_options_no_use').length ) {
					if ( tab.hasClass( 'mckinney_politics_override_options_item_hidden' ) ) {
						tab.removeClass('mckinney_politics_override_options_item_hidden');
					}
				}
			} else {
				ctrl.slideUp().addClass( 'mckinney_politics_override_options_no_use' );
				if ( section.find('>.mckinney_politics_override_options_item:not(.mckinney_politics_override_options_item_info),>.mckinney_politics_override_options_group[data-param]').length == section.find('.mckinney_politics_override_options_no_use').length ) {
					if ( ! tab.hasClass( 'mckinney_politics_override_options_item_hidden' ) ) {
						tab.addClass('mckinney_politics_override_options_item_hidden');
						if ( tab.hasClass('ui-state-active') ) {
							tab.parents('.mckinney_politics_tabs').find(' > ul > li:not(.mckinney_politics_override_options_item_hidden)').eq(0).find('> a').trigger('click');
						}
					}
				}
			}
		}

		// Individual dependencies
		//------------------------------------

		// Remove 'false' to disable color schemes less then main scheme!
		// This behavious is not need for the version with sorted schemes (leave false)
		if (false && id == 'color_scheme') {
			fld = ctrl.find( '[name="mckinney_politics_override_options_field_' + id + '"]' );
			if (fld.length > 0) {
				val     = mckinney_politics_override_options_get_field_value( fld );
				var num = mckinney_politics_override_options_get_field_value( fld, true );
				cont.find( '.mckinney_politics_override_options_item_field' ).each(
					function() {
						var ctrl2 = jQuery( this ), id2 = ctrl2.data( 'param' );
						if (id2 == undefined) {
							return;
						}
						if (id2 == id || id2.substr( -7 ) != '_scheme') {
							return;
						}
						var fld2 = ctrl2.find( '[name="mckinney_politics_override_options_field_' + id2 + '"]' ),
						val2     = mckinney_politics_override_options_get_field_value( fld2 );
						if (fld2.attr( 'type' ) != 'radio') {
							fld2 = fld2.find( 'option' );
						}
						fld2.each(
							function(idx2) {
								var dom_obj      = jQuery( this ).get( 0 );
								dom_obj.disabled = idx2 !== 0 && idx2 < num;
								if (dom_obj.disabled) {
									if (jQuery( this ).val() == val2) {
										if (fld2.attr( 'type' ) == 'radio') {
											fld2.each(
												function(idx3) {
													jQuery( this ).get( 0 ).checked = idx3 === 0;
												}
											);
										} else {
											fld2.each(
												function(idx3) {
													jQuery( this ).get( 0 ).selected = idx3 === 0;
												}
											);
										}
									}
								}
							}
						);
					}
				);
			}
		}
	} );
	MCKINNEY_POLITICS_STORAGE['check_dependencies_now'] = false;
}

// Return value of the field or number (index) of selected item (if second param is true)
function mckinney_politics_override_options_get_field_value(fld, num) {
	var item = fld.parents( '.mckinney_politics_override_options_item' );
	var ctrl = fld.parents( '.mckinney_politics_override_options_item_field' );
	var val  = fld.attr( 'type' ) == 'checkbox' || fld.attr( 'type' ) == 'radio'
			? (ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).length > 0
				? (num === true
					? ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).parent().index() + 1
					: (ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).val() !== ''
						&& '' + ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).val() != '0'
							? ctrl.find( '[name^="mckinney_politics_override_options_field_"]:checked' ).val()
							: 1
						)
					)
				: 0
				)
			: (num === true ? fld.find( ':selected' ).index() + 1 : fld.val());
	if ( item.length && item.hasClass( 'mckinney_politics_override_options_inherit_on' ) ) {
		val = num === true ? 0 : 'inherit';
	} else if (val === undefined || val === null) {
		val = num === true ? 0 : '';
	}
	return val;
}

