<?php
/**
 * The template for displaying main menu
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */
$header_image = get_query_var('mckinney_politics_header_image');
?>
<div class="top_panel_fixed_wrap"></div>
<div class="top_panel_navi 
			<?php if ($header_image!='') echo ' with_bg_image'; ?>
			scheme_<?php echo esc_attr(mckinney_politics_is_inherit(mckinney_politics_get_theme_option('menu_scheme')) 
												? (mckinney_politics_is_inherit(mckinney_politics_get_theme_option('header_scheme')) 
													? mckinney_politics_get_theme_option('color_scheme') 
													: mckinney_politics_get_theme_option('header_scheme')) 
												: mckinney_politics_get_theme_option('menu_scheme')); ?>">
	<div class="menu_main_wrap clearfix">
		<div class="content_wrap">
			<?php
			// Logo
			get_template_part( 'templates/header-logo' );
			if (mckinney_politics_get_theme_option("menu_style") != 'side') {
				// Main menu
				?><nav class="menu_main_nav_area menu_hover_<?php echo esc_attr(mckinney_politics_get_theme_option('menu_hover')); ?>"><?php
					$mckinney_politics_menu_main = mckinney_politics_get_nav_menu('menu_main');
					if (empty($mckinney_politics_menu_main)) $mckinney_politics_menu_main = mckinney_politics_get_nav_menu();
					mckinney_politics_show_layout($mckinney_politics_menu_main);
					// Store menu layout for the mobile menu
					set_query_var('mckinney_politics_menu_main', $mckinney_politics_menu_main);
					// Display search field
					set_query_var('mckinney_politics_search_in_header', true);
					get_template_part( 'templates/search-field' );


                // Woocommerce Cart
                    if (function_exists('mckinney_politics_exists_woocommerce') && mckinney_politics_exists_woocommerce() && (mckinney_politics_is_woocommerce_page() && mckinney_politics_get_theme_option('show_cart')=='shop' || mckinney_politics_get_theme_option('show_cart')=='always') && !(is_checkout() || is_cart() || defined('WOOCOMMERCE_CHECKOUT') || defined('WOOCOMMERCE_CART'))) {
                    ?><div class="contact_field contact_cart"><?php do_action('trx_addons_show_contact_info_cart'); ?></div><?php
                }


                ?></nav><?php
			}
			?>
		</div>
	</div>
</div><!-- /.top_panel_navi -->