<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

$sidebar_position = mckinney_politics_get_theme_option('sidebar_position');
if (mckinney_politics_sidebar_present()) {
	$sidebar_name = mckinney_politics_get_theme_option('sidebar_widgets');
	mckinney_politics_storage_set('current_sidebar', 'sidebar');
	?>
	<div class="sidebar <?php echo esc_attr($sidebar_position); ?> widget_area<?php if (!mckinney_politics_is_inherit(mckinney_politics_get_theme_option('sidebar_scheme'))) echo ' scheme_'.esc_attr(mckinney_politics_get_theme_option('color_scheme')); ?>" role="complementary">
		<div class="sidebar_inner">
			<?php
			ob_start();
			do_action( 'before_sidebar' );
            if ( is_active_sidebar( $sidebar_name ) ) {
                dynamic_sidebar( $sidebar_name );
            }
			do_action( 'after_sidebar' );
			$out = ob_get_contents();
			ob_end_clean();
			mckinney_politics_show_layout(chop(preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $out)));
			?>
		</div><!-- /.sidebar_inner -->
	</div><!-- /.sidebar -->
	<?php
}
?>