<?php
/* Cookie Information support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_gdpr_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_gdpr_theme_setup9', 9 );
	function mckinney_politics_gdpr_theme_setup9() {

		if (mckinney_politics_exists_gdpr()) {
			add_filter( 'mckinney_politics_filter_merge_styles',						'mckinney_politics_gdpr_merge_styles' );
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',			'mckinney_politics_gdpr_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_gdpr_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_gdpr_tgmpa_required_plugins');
	function mckinney_politics_gdpr_tgmpa_required_plugins($list=array()) {
        if (in_array('wp-gdpr-compliance', (array)mckinney_politics_storage_get('required_plugins'))) {
			$list[] = array(
				'name' 		=> esc_html__('Cookie Information', 'mckinney-politics'),
				'slug' 		=> 'wp-gdpr-compliance',
				'required' 	=> false
			);

		}
		return $list;
	}
}

// Check if gdpr installed and activated
if ( !function_exists( 'mckinney_politics_exists_gdpr' ) ) {
	function mckinney_politics_exists_gdpr() {
		return defined( 'WP_GDPR_C_ROOT_FILE' ) || defined( 'WPGDPRC_ROOT_FILE' );
	}
}