<?php
/* Woocommerce support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if (!function_exists('mckinney_politics_woocommerce_theme_setup1')) {
	add_action( 'after_setup_theme', 'mckinney_politics_woocommerce_theme_setup1', 1 );
	function mckinney_politics_woocommerce_theme_setup1() {
		add_theme_support( 'woocommerce', array( 'product_grid' => array( 'max_columns' => 5 ) ) );
		
		// Next setting from the WooCommerce 3.0+ enable built-in image zoom on the single product page
		add_theme_support( 'wc-product-gallery-zoom' );
		
		// Next setting from the WooCommerce 3.0+ enable built-in image slider on the single product page
		add_theme_support( 'wc-product-gallery-slider' );
		
		// Next setting from the WooCommerce 3.0+ enable built-in image lightbox on the single product page
		add_theme_support( 'wc-product-gallery-lightbox' );
	 
		add_filter( 'mckinney_politics_filter_list_sidebars', 'mckinney_politics_woocommerce_list_sidebars' );

		// Detect if WooCommerce support 'Product Grid' feature
        $product_grid = mckinney_politics_exists_woocommerce() && function_exists( 'wc_get_theme_support' ) ? wc_get_theme_support( 'product_grid' ) : false;
        add_theme_support( 'wc-product-grid-enable', isset( $product_grid['min_columns'] ) && isset( $product_grid['max_columns'] ) );

	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if (!function_exists('mckinney_politics_woocommerce_theme_setup3')) {
	add_action( 'after_setup_theme', 'mckinney_politics_woocommerce_theme_setup3', 3 );
	function mckinney_politics_woocommerce_theme_setup3() {
		if (mckinney_politics_exists_woocommerce()) {
			mckinney_politics_storage_merge_array('options', '', array(
				// Section 'WooCommerce' - settings for show pages
				'shop' => array(
					"title" => esc_html__('Shop', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select parameters to display the shop pages', 'mckinney-politics') ),
					"type" => "section"
					),
				'expand_content_shop' => array(
					"title" => esc_html__('Expand content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'mckinney-politics') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
				'shop_mode' => array(
					"title" => esc_html__('Shop mode', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select style for the products list', 'mckinney-politics') ),
					"std" => 'thumbs',
					"options" => array(
						'thumbs'=> esc_html__('Thumbnails', 'mckinney-politics'),
						'list'	=> esc_html__('List', 'mckinney-politics'),
					),
					"type" => "select"
					),
				'header_widgets_shop' => array(
					"title" => esc_html__('Header widgets', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on the shop pages', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'sidebar_widgets_shop' => array(
					"title" => esc_html__('Sidebar widgets', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select sidebar to show on the shop pages', 'mckinney-politics') ),
					"std" => 'woocommerce_widgets',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'sidebar_position_shop' => array(
					"title" => esc_html__('Sidebar position', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select position to show sidebar on the shop pages', 'mckinney-politics') ),
					"refresh" => false,
					"std" => 'left',
					"options" => mckinney_politics_get_list_sidebars_positions(),
					"type" => "select"
					),
				'widgets_above_page_shop' => array(
					"title" => esc_html__('Widgets above the page', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_above_content_shop' => array(
					"title" => esc_html__('Widgets above the content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_below_content_shop' => array(
					"title" => esc_html__('Widgets below the content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_below_page_shop' => array(
					"title" => esc_html__('Widgets below the page', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					)
				)
			);
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_woocommerce_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_woocommerce_theme_setup9', 9 );
	function mckinney_politics_woocommerce_theme_setup9() {
		if (mckinney_politics_exists_woocommerce()) {
			add_action( 'wp_enqueue_scripts', 										'mckinney_politics_woocommerce_frontend_scripts', 1100 );
			add_filter( 'mckinney_politics_filter_merge_styles',						'mckinney_politics_woocommerce_merge_styles' );
			add_filter( 'mckinney_politics_filter_get_css',							'mckinney_politics_woocommerce_get_css', 10, 3 );
			if (!is_admin()){
				add_filter( 'mckinney_politics_filter_detect_blog_mode',				'mckinney_politics_woocommerce_detect_blog_mode' );
				add_filter( 'mckinney_politics_filter_post_type_taxonomy',			'mckinney_politics_woocommerce_post_type_taxonomy', 10, 2 );
				add_filter( 'mckinney_politics_filter_get_blog_all_posts_link', 		'mckinney_politics_woocommerce_get_blog_all_posts_link');
				add_filter( 'mckinney_politics_filter_get_blog_title', 				'mckinney_politics_woocommerce_get_blog_title');
				add_filter( 'mckinney_politics_filter_need_page_title', 				'mckinney_politics_woocommerce_need_page_title');
				add_filter( 'mckinney_politics_filter_sidebar_present',				'mckinney_politics_woocommerce_sidebar_present' );
				add_filter( 'mckinney_politics_filter_get_post_categories', 			'mckinney_politics_woocommerce_get_post_categories');
				add_filter( 'mckinney_politics_filter_allow_override_header_image',	'mckinney_politics_woocommerce_allow_override_header_image' );
			}
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',				'mckinney_politics_woocommerce_tgmpa_required_plugins' );
		}

		// Add wrappers and classes to the standard WooCommerce output
		if (mckinney_politics_exists_woocommerce()) {

			// Remove WOOC sidebar
			remove_action( 'woocommerce_sidebar', 						'woocommerce_get_sidebar', 10 );

			// Remove link around product item
			remove_action('woocommerce_before_shop_loop_item',			'woocommerce_template_loop_product_link_open', 10);
			remove_action('woocommerce_after_shop_loop_item',			'woocommerce_template_loop_product_link_close', 5);

			// Remove link around product category
			remove_action('woocommerce_before_subcategory',				'woocommerce_template_loop_category_link_open', 10);
			remove_action('woocommerce_after_subcategory',				'woocommerce_template_loop_category_link_close', 10);
			
			// Open main content wrapper - <article>
			remove_action( 'woocommerce_before_main_content',			'woocommerce_output_content_wrapper', 10);
			add_action(    'woocommerce_before_main_content',			'mckinney_politics_woocommerce_wrapper_start', 10);
			// Close main content wrapper - </article>
			remove_action( 'woocommerce_after_main_content',			'woocommerce_output_content_wrapper_end', 10);		
			add_action(    'woocommerce_after_main_content',			'mckinney_politics_woocommerce_wrapper_end', 10);

			// Close header section
			add_action( 'woocommerce_archive_description',				'mckinney_politics_woocommerce_archive_description', 15 );

			// Add theme specific search form
			add_filter(    'get_product_search_form',					'mckinney_politics_woocommerce_get_product_search_form' );

			// Change text on 'Add to cart' button
			add_filter(    'woocommerce_product_add_to_cart_text',		'mckinney_politics_woocommerce_add_to_cart_text' );
			add_filter(    'woocommerce_product_single_add_to_cart_text','mckinney_politics_woocommerce_add_to_cart_text' );

			// Add list mode buttons
			add_action(    'woocommerce_before_shop_loop', 				'mckinney_politics_woocommerce_before_shop_loop', 10 );

			// Set columns number for the products loop
			add_filter(    'post_class',								'mckinney_politics_woocommerce_loop_shop_columns_class' );
			add_filter(    'product_cat_class',							'mckinney_politics_woocommerce_loop_shop_columns_class', 10, 3 );
			// Open product/category item wrapper
			add_action(    'woocommerce_before_subcategory_title',		'mckinney_politics_woocommerce_item_wrapper_start', 9 );
			add_action(    'woocommerce_before_shop_loop_item_title',	'mckinney_politics_woocommerce_item_wrapper_start', 9 );
			// Close featured image wrapper and open title wrapper
			add_action(    'woocommerce_before_subcategory_title',		'mckinney_politics_woocommerce_title_wrapper_start', 20 );
			add_action(    'woocommerce_before_shop_loop_item_title',	'mckinney_politics_woocommerce_title_wrapper_start', 20 );

			// Add tags before title
			add_action(    'woocommerce_before_shop_loop_item_title',	'mckinney_politics_woocommerce_title_tags', 30 );

			// Wrap product title into link
			add_action(    'the_title',									'mckinney_politics_woocommerce_the_title');
			// Close title wrapper and add description in the list mode
			add_action(    'woocommerce_after_shop_loop_item_title',	'mckinney_politics_woocommerce_title_wrapper_end', 7);
			add_action(    'woocommerce_after_subcategory_title',		'mckinney_politics_woocommerce_title_wrapper_end2', 10 );
			// Close product/category item wrapper
			add_action(    'woocommerce_after_subcategory',				'mckinney_politics_woocommerce_item_wrapper_end', 20 );
			add_action(    'woocommerce_after_shop_loop_item',			'mckinney_politics_woocommerce_item_wrapper_end', 20 );

			// Add product ID into product meta section (after categories and tags)
			add_action(    'woocommerce_product_meta_end',				'mckinney_politics_woocommerce_show_product_id', 10);

			// Add awards into single image
			add_filter(    'woocommerce_single_product_image_html',		'mckinney_politics_woocommerce_single_product_image_html', 10, 2 );
			
			// Set columns number for the product's thumbnails
			add_filter(    'woocommerce_product_thumbnails_columns',	'mckinney_politics_woocommerce_product_thumbnails_columns' );

			// Set columns number for the related products
			add_filter(    'woocommerce_output_related_products_args',	'mckinney_politics_woocommerce_output_related_products_args' );

			// Decorate price
			add_filter(    'woocommerce_get_price_html',				'mckinney_politics_woocommerce_get_price_html' );

			// Add 'Out of stock' label
			add_action( 'mckinney_politics_action_woocommerce_item_featured_link_start', 'mckinney_politics_woocommerce_add_out_of_stock_label' );


	
			// Detect current shop mode
			if (!is_admin()) {
				$shop_mode = mckinney_politics_get_value_gpc('mckinney_politics_shop_mode');
				if (empty($shop_mode) && mckinney_politics_check_theme_option('shop_mode'))
					$shop_mode = mckinney_politics_get_theme_option('shop_mode');
				if (empty($shop_mode))
					$shop_mode = 'thumbs';
				mckinney_politics_storage_set('shop_mode', $shop_mode);
			}
		}
	}
}



// Check if WooCommerce installed and activated
if ( !function_exists( 'mckinney_politics_exists_woocommerce' ) ) {
	function mckinney_politics_exists_woocommerce() {
		return class_exists('Woocommerce');
	}
}

// Return true, if current page is any woocommerce page
if ( !function_exists( 'mckinney_politics_is_woocommerce_page' ) ) {
	function mckinney_politics_is_woocommerce_page() {
		$rez = false;
		if (mckinney_politics_exists_woocommerce())
			$rez = is_woocommerce() || is_shop() || is_product() || is_product_category() || is_product_tag() || is_product_taxonomy() || is_cart() || is_checkout() || is_account_page();
		return $rez;
	}
}

// Detect current blog mode
if ( !function_exists( 'mckinney_politics_woocommerce_detect_blog_mode' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_detect_blog_mode', 'mckinney_politics_woocommerce_detect_blog_mode' );
	function mckinney_politics_woocommerce_detect_blog_mode($mode='') {
		if (is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy())
			$mode = 'shop';
		else if (is_product() || is_cart() || is_checkout() || is_account_page())
			$mode = 'shop';
		return $mode;
	}
}

// Return taxonomy for current post type
if ( !function_exists( 'mckinney_politics_woocommerce_post_type_taxonomy' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_post_type_taxonomy',	'mckinney_politics_woocommerce_post_type_taxonomy', 10, 2 );
	function mckinney_politics_woocommerce_post_type_taxonomy($tax='', $post_type='') {
		if ($post_type == 'product')
			$tax = 'product_cat';
		return $tax;
	}
}

// Return current page title
if ( !function_exists( 'mckinney_politics_woocommerce_get_blog_title' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_blog_title', 'mckinney_politics_woocommerce_get_blog_title');
	function mckinney_politics_woocommerce_get_blog_title($title='') {
		if (is_woocommerce() && is_shop()) $title = esc_html__('Shop', 'mckinney-politics');
		return $title;
	}
}

// Return link to main shop page for the breadcrumbs
if ( !function_exists( 'mckinney_politics_woocommerce_get_blog_all_posts_link' ) ) {
	//Handler of add_filter('mckinney_politics_filter_get_blog_all_posts_link', 'mckinney_politics_woocommerce_get_blog_all_posts_link');
	function mckinney_politics_woocommerce_get_blog_all_posts_link($link='') {
		if (empty($link) && mckinney_politics_is_woocommerce_page() && !is_shop())
			$link = '<a href="'.esc_url(mckinney_politics_woocommerce_get_shop_page_link()).'">'.esc_html__('Shop', 'mckinney-politics').'</a>';
		return $link;
	}
}

// Return true if page title section is allowed
if ( !function_exists( 'mckinney_politics_woocommerce_need_page_title' ) ) {
	//Handler of add_filter('mckinney_politics_filter_need_page_title', 'mckinney_politics_woocommerce_need_page_title');
	function mckinney_politics_woocommerce_need_page_title($need=false) {
		if (!$need)
			$need = is_shop() || is_product_category() || is_product_tag() || is_product_taxonomy() || is_product();
		return $need;
	}
}

// Return true if page title section is allowed
if ( !function_exists( 'mckinney_politics_woocommerce_allow_override_header_image' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_allow_override_header_image', 'mckinney_politics_woocommerce_allow_override_header_image' );
	function mckinney_politics_woocommerce_allow_override_header_image($allow=true) {
		return is_product() ? false : $allow;
	}
}

// Return shop page ID
if ( !function_exists( 'mckinney_politics_woocommerce_get_shop_page_id' ) ) {
	function mckinney_politics_woocommerce_get_shop_page_id() {
		return get_option('woocommerce_shop_page_id');
	}
}

// Return shop page link
if ( !function_exists( 'mckinney_politics_woocommerce_get_shop_page_link' ) ) {
	function mckinney_politics_woocommerce_get_shop_page_link() {
		$url = '';
		$id = mckinney_politics_woocommerce_get_shop_page_id();
		if ($id) $url = get_permalink($id);
		return $url;
	}
}

// Show categories of the current product
if ( !function_exists( 'mckinney_politics_woocommerce_get_post_categories' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_post_categories', 		'mckinney_politics_woocommerce_get_post_categories');
	function mckinney_politics_woocommerce_get_post_categories($cats='') {
		if (get_post_type()=='product') {
			$cats = mckinney_politics_get_post_terms(', ', get_the_ID(), 'product_cat');
		}
		return $cats;
	}
}
	
// Enqueue WooCommerce custom styles
if ( !function_exists( 'mckinney_politics_woocommerce_frontend_scripts' ) ) {
	//Handler of add_action( 'wp_enqueue_scripts', 'mckinney_politics_woocommerce_frontend_scripts', 1100 );
	function mckinney_politics_woocommerce_frontend_scripts() {
			if (mckinney_politics_is_on(mckinney_politics_get_theme_option('debug_mode')) && file_exists(mckinney_politics_get_file_dir('css/plugin.woocommerce.css')))
				wp_enqueue_style( 'mckinney-politics-plugin-woocommerce',  mckinney_politics_get_file_url('css/plugin.woocommerce.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'mckinney_politics_woocommerce_merge_styles' ) ) {
	//Handler of add_filter('mckinney_politics_filter_merge_styles', 'mckinney_politics_woocommerce_merge_styles');
	function mckinney_politics_woocommerce_merge_styles($css) {
		return $css . mckinney_politics_fgc(mckinney_politics_get_file_dir('css/plugin.woocommerce.css'));
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_woocommerce_tgmpa_required_plugins' ) ) {
	//Handler of add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_woocommerce_tgmpa_required_plugins');
	function mckinney_politics_woocommerce_tgmpa_required_plugins($list=array()) {
		if (in_array('woocommerce', mckinney_politics_storage_get('required_plugins')))
			$list[] = array(
					'name' 		=> esc_html__('WooCommerce', 'mckinney-politics'),
					'slug' 		=> 'woocommerce',
					'required' 	=> false
				);

		return $list;
	}
}

// Add WooCommerce specific items into lists
//------------------------------------------------------------------------

// Add sidebar
if ( !function_exists( 'mckinney_politics_woocommerce_list_sidebars' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_list_sidebars', 'mckinney_politics_woocommerce_list_sidebars' );
	function mckinney_politics_woocommerce_list_sidebars($list=array()) {
		$list['woocommerce_widgets'] = esc_html__('WooCommerce Widgets', 'mckinney-politics');
		return $list;
	}
}




// Decorate WooCommerce output: Loop
//------------------------------------------------------------------------

// Before main content
if ( !function_exists( 'mckinney_politics_woocommerce_wrapper_start' ) ) {
	//Handler of add_action('woocommerce_before_main_content', 'mckinney_politics_woocommerce_wrapper_start', 10);
	function mckinney_politics_woocommerce_wrapper_start() {
		if (is_product() || is_cart() || is_checkout() || is_account_page()) {
			?>
			<article class="post_item_single post_type_product">
			<?php
		} else {
			?>
			<div class="list_products shop_mode_<?php echo !mckinney_politics_storage_empty('shop_mode') ? mckinney_politics_storage_get('shop_mode') : 'thumbs'; ?>">
				<div class="list_products_header">
			<?php
		}
	}
}

// After main content
if ( !function_exists( 'mckinney_politics_woocommerce_wrapper_end' ) ) {
	//Handler of add_action('woocommerce_after_main_content', 'mckinney_politics_woocommerce_wrapper_end', 10);
	function mckinney_politics_woocommerce_wrapper_end() {
		if (is_product() || is_cart() || is_checkout() || is_account_page()) {
			?>
			</article><!-- /.post_item_single -->
			<?php
		} else {
			?>
			</div><!-- /.list_products -->
			<?php
		}
	}
}

// Close header section
if ( !function_exists( 'mckinney_politics_woocommerce_archive_description' ) ) {
	//Handler of add_action( 'woocommerce_archive_description', 'mckinney_politics_woocommerce_archive_description', 15 );
	function mckinney_politics_woocommerce_archive_description() {
		?>
		</div><!-- /.list_products_header -->
		<?php
	}
}

// Add list mode buttons
if ( !function_exists( 'mckinney_politics_woocommerce_before_shop_loop' ) ) {
	//Handler of add_action( 'woocommerce_before_shop_loop', 'mckinney_politics_woocommerce_before_shop_loop', 10 );
	function mckinney_politics_woocommerce_before_shop_loop() {
		?>
		<div class="mckinney_politics_shop_mode_buttons"><form action="<?php echo esc_url(mckinney_politics_get_current_url()); ?>" method="post"><input type="hidden" name="mckinney_politics_shop_mode" value="<?php echo esc_attr(mckinney_politics_storage_get('shop_mode')); ?>" /><a href="#" class="woocommerce_thumbs icon-th" title="<?php esc_attr_e('Show products as thumbs', 'mckinney-politics'); ?>"></a><a href="#" class="woocommerce_list icon-th-list" title="<?php esc_attr_e('Show products as list', 'mckinney-politics'); ?>"></a></form></div><!-- /.mckinney_politics_shop_mode_buttons -->
		<?php
	}
}

// Add column class into product item in shop streampage
if ( !function_exists( 'mckinney_politics_woocommerce_loop_shop_columns_class' ) ) {
	//Handler of add_filter( 'post_class', 'mckinney_politics_woocommerce_loop_shop_columns_class' );
	//Handler of add_filter( 'product_cat_class', 'mckinney_politics_woocommerce_loop_shop_columns_class', 10, 3 );
	function mckinney_politics_woocommerce_loop_shop_columns_class($classes, $class='', $cat='') {
		global $woocommerce_loop;
		if (is_product()) {
			if (!empty($woocommerce_loop['columns']))
				$classes[] = ' column-1_'.esc_attr($woocommerce_loop['columns']);
		} else if (is_shop() || is_product_category() && is_product_taxonomy()) {
            $cols = function_exists('wc_get_default_products_per_row') ? wc_get_default_products_per_row() : 2;
            $classes[] = ' column-1_' . $cols;
		}
		return $classes;
	}
}


// Open item wrapper for categories and products
if ( !function_exists( 'mckinney_politics_woocommerce_item_wrapper_start' ) ) {
	//Handler of add_action( 'woocommerce_before_subcategory_title', 'mckinney_politics_woocommerce_item_wrapper_start', 9 );
	//Handler of add_action( 'woocommerce_before_shop_loop_item_title', 'mckinney_politics_woocommerce_item_wrapper_start', 9 );
	function mckinney_politics_woocommerce_item_wrapper_start($cat='') {
		mckinney_politics_storage_set('in_product_item', true);
		?>
		<div class="post_item post_layout_<?php echo esc_attr(mckinney_politics_storage_get('shop_mode')); ?>">
			<div class="post_featured hover_shop">
				<a href="<?php echo esc_url(is_object($cat) ? get_term_link($cat->slug, 'product_cat') : get_permalink()); ?>">
		<?php
		do_action( 'mckinney_politics_action_woocommerce_item_featured_link_start' );
	}
}

// Open item wrapper for categories and products
if ( !function_exists( 'mckinney_politics_woocommerce_open_item_wrapper' ) ) {
	//Handler of add_action( 'woocommerce_before_subcategory_title', 'mckinney_politics_woocommerce_title_wrapper_start', 20 );
	//Handler of add_action( 'woocommerce_before_shop_loop_item_title', 'mckinney_politics_woocommerce_title_wrapper_start', 20 );
	function mckinney_politics_woocommerce_title_wrapper_start($cat='') {
				?>
				</a>
				<div class="mask"></div>
				<?php
				mckinney_politics_hovers_add_icons('shop');
				// Awards
                mckinney_politics_show_layout(mckinney_politics_woocommerce_get_awards_tag());
				?>
			</div><!-- /.post_featured -->
			<div class="post_data">
				<div class="post_header entry-header">
				<?php
	}
}

// Add awards into single image
if ( !function_exists( 'mckinney_politics_woocommerce_single_product_image_html' ) ) {
	//Handler of add_filter( 'woocommerce_single_product_image_html',	'mckinney_politics_woocommerce_single_product_image_html', 10, 2 );
	function mckinney_politics_woocommerce_single_product_image_html($html='', $id=0) {
		return str_replace('</a>', mckinney_politics_woocommerce_get_awards_tag().'</a>', $html);
	}
}

// Add awards
if ( !function_exists( 'mckinney_politics_woocommerce_get_awards_tag' ) ) {
	function mckinney_politics_woocommerce_get_awards_tag() {
		global $product;
		if (is_product()) {
		$attributes = $product->get_attributes();
		$output = '';
			if ( is_array( $attributes ) ) {
			foreach ( $attributes as $attribute ) {
					if ( strtolower( $attribute['name'] ) == strtolower( esc_html__( 'Awards', 'mckinney-politics' ) ) ) {
						$output = '<div class="product_awards"><span>' . esc_html( $attribute['value'] ) . '</span></div>';
				}
			}
		}
			
		return $output;
	}
	}
}


// Display product's tags before the title
if ( !function_exists( 'mckinney_politics_woocommerce_title_tags' ) ) {
	//Handler of add_action( 'woocommerce_before_shop_loop_item_title', 'mckinney_politics_woocommerce_title_tags', 30 );
	function mckinney_politics_woocommerce_title_tags() {
		global $product;
		mckinney_politics_show_layout(wc_get_product_tag_list( $product->get_id(), ', ', '<div class="post_tags product_tags">', '</div>' ));
	}
}

// Wrap product title into link
if ( !function_exists( 'mckinney_politics_woocommerce_the_title' ) ) {
	//Handler of add_filter( 'the_title', 'mckinney_politics_woocommerce_the_title' );
	function mckinney_politics_woocommerce_the_title($title) {
		if (mckinney_politics_storage_get('in_product_item') && get_post_type()=='product') {
			$title = '<a href="'.esc_url(get_permalink()).'">'.esc_html($title).'</a>';
		}
		return $title;
	}
}

// Add excerpt in output for the product in the list mode
if ( !function_exists( 'mckinney_politics_woocommerce_title_wrapper_end' ) ) {
	//Handler of add_action( 'woocommerce_after_shop_loop_item_title', 'mckinney_politics_woocommerce_title_wrapper_end', 7);
	function mckinney_politics_woocommerce_title_wrapper_end() {
		?>
			</div><!-- /.post_header -->
		<?php
		if (mckinney_politics_storage_get('shop_mode') == 'list' && is_shop() && !is_product()) {
		    $excerpt = apply_filters('the_excerpt', get_the_excerpt());
			?>
			<div class="post_content entry-content"><?php mckinney_politics_show_layout($excerpt); ?></div>
			<?php
		}
	}
}

// Add excerpt in output for the product in the list mode
if ( !function_exists( 'mckinney_politics_woocommerce_title_wrapper_end2' ) ) {
	//Handler of add_action( 'woocommerce_after_subcategory_title', 'mckinney_politics_woocommerce_title_wrapper_end2', 10 );
	function mckinney_politics_woocommerce_title_wrapper_end2($category) {
		?>
			</div><!-- /.post_header -->
		<?php
		if (mckinney_politics_storage_get('shop_mode') == 'list' && is_shop() && !is_product()) {
			?>
			<div class="post_content entry-content"><?php mckinney_politics_show_layout($category->description); ?></div><!-- /.post_content -->
			<?php
		}
	}
}

// Close item wrapper for categories and products
if ( !function_exists( 'mckinney_politics_woocommerce_close_item_wrapper' ) ) {
	//Handler of add_action( 'woocommerce_after_subcategory', 'mckinney_politics_woocommerce_item_wrapper_end', 20 );
	//Handler of add_action( 'woocommerce_after_shop_loop_item', 'mckinney_politics_woocommerce_item_wrapper_end', 20 );
	function mckinney_politics_woocommerce_item_wrapper_end($cat='') {
		?>
			</div><!-- /.post_data -->
		</div><!-- /.post_item -->
		<?php
		mckinney_politics_storage_set('in_product_item', false);
	}
}

// Change text on 'Add to cart' button to 'Buy now'
if ( ! function_exists( 'mckinney_politics_woocommerce_add_to_cart_text' ) ) {
	//Handler of the add_filter( 'woocommerce_product_add_to_cart_text',       'mckinney_politics_woocommerce_add_to_cart_text' );
	//Handler of the add_filter( 'woocommerce_product_single_add_to_cart_text','mckinney_politics_woocommerce_add_to_cart_text' );
	function mckinney_politics_woocommerce_add_to_cart_text( $text = '' ) {
		global $product;
		return is_object( $product )
				&& $product->is_in_stock()
				&& $product->is_purchasable()
				&& 'grouped' !== $product->get_type()
				&& ( 'external' !== $product->get_type() || $product->get_button_text() == '' )
					? esc_html__( 'Buy now', 'mckinney-politics' )
					: $text;
	}
}

// Decorate price
if ( !function_exists( 'mckinney_politics_woocommerce_get_price_html' ) ) {
	//Handler of add_filter(    'woocommerce_get_price_html',	'mckinney_politics_woocommerce_get_price_html' );
	function mckinney_politics_woocommerce_get_price_html($price='') {
		if (!empty($price)) {
			$sep = get_option('woocommerce_price_decimal_sep');
			if (empty($sep)) $sep = '.';
			$parts = explode($sep, $price);
			if (count($parts) < 2) $parts[] = '00';
			if (($pos = strpos($parts[1], '<')) !== false)
				$parts[1] = substr($parts[1], 0, $pos) . '</span>' . substr($parts[1], $pos);
			else
				$parts[1] .= '</span>';
			$price = join('<span class="decimals">', $parts);
		}
		return $price;
	}
}

// Add label 'out of stock'
if ( ! function_exists( 'mckinney_politics_woocommerce_add_out_of_stock_label' ) ) {
	function mckinney_politics_woocommerce_add_out_of_stock_label() {
	global $product;
	$cat = mckinney_politics_storage_get( 'in_product_category' );
		if ( empty($cat) || ! is_object($cat) ) {
			if ( is_object( $product ) && ! $product->is_in_stock() ) {
				?>
				<span class="outofstock_label"><?php esc_html_e( 'Out of stock', 'mckinney_politics' ); ?></span>
				<?php
			}
		}
	}
}


// Decorate WooCommerce output: Single product
//------------------------------------------------------------------------

// Hide sidebar on the single products and pages
if ( !function_exists( 'mckinney_politics_woocommerce_sidebar_present' ) ) {
	//Handler of add_action( 'mckinney_politics_filter_sidebar_present', 'mckinney_politics_woocommerce_sidebar_present' );
	function mckinney_politics_woocommerce_sidebar_present($present) {
		return is_product() || is_cart() || is_checkout() || is_account_page() ? false : $present;
	}
}

// Add Product ID for the single product
if ( !function_exists( 'mckinney_politics_woocommerce_show_product_id' ) ) {
	//Handler of add_action( 'woocommerce_product_meta_end', 'mckinney_politics_woocommerce_show_product_id', 10);
	function mckinney_politics_woocommerce_show_product_id() {
		$authors = wp_get_post_terms(get_the_ID(), 'pa_product_author');
		if (is_array($authors) && count($authors)>0) {
			echo '<span class="product_author">'.esc_html__('Author: ', 'mckinney-politics');
			$delim = '';
			foreach ($authors as $author) {
				echo  esc_html($delim) . '<span>' . esc_html($author->name) . '</span>';
				$delim = ', ';
			}
			echo '</span>';
		}
		echo '<span class="product_id">'.esc_html__('Product ID: ', 'mckinney-politics') . '<span>' . get_the_ID() . '</span></span>';
	}
}

// Number columns for the product's thumbnails
if ( !function_exists( 'mckinney_politics_woocommerce_product_thumbnails_columns' ) ) {
	//Handler of add_filter( 'woocommerce_product_thumbnails_columns', 'mckinney_politics_woocommerce_product_thumbnails_columns' );
	function mckinney_politics_woocommerce_product_thumbnails_columns($cols) {
		return 4;
	}
}

// Set columns number for the related products
if ( !function_exists( 'mckinney_politics_woocommerce_output_related_products_args' ) ) {
	//Handler of add_filter( 'woocommerce_output_related_products_args', 'mckinney_politics_woocommerce_output_related_products_args' );
	function mckinney_politics_woocommerce_output_related_products_args($args) {
		$ccc_add = in_array(mckinney_politics_get_theme_option('body_style'), array('fullwide', 'fullscreen')) ? 1 : 0;
		$ccc = mckinney_politics_sidebar_present() ? 2+$ccc_add : 3+$ccc_add;
		$args['posts_per_page'] = $ccc;
		$args['columns'] = $ccc;
		return $args;
	}
}



// Decorate WooCommerce output: Widgets
//------------------------------------------------------------------------

// Search form
if ( !function_exists( 'mckinney_politics_woocommerce_get_product_search_form' ) ) {
	//Handler of add_filter( 'get_product_search_form', 'mckinney_politics_woocommerce_get_product_search_form' );
	function mckinney_politics_woocommerce_get_product_search_form($form) {
		return '
		<form role="search" method="get" class="search_form" action="' . esc_url(home_url('/')) . '">
			<input type="text" class="search_field" placeholder="' . esc_attr__('Search for products &hellip;', 'mckinney-politics') . '" value="' . get_search_query() . '" name="s" /><button class="search_button" type="submit">' . esc_html__('Search', 'mckinney-politics') . '</button>
			<input type="hidden" name="post_type" value="product" />
		</form>
		';
	}
}



// Add WooCommerce specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'mckinney_politics_woocommerce_get_css' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_css', 'mckinney_politics_woocommerce_get_css', 10, 3 );
	function mckinney_politics_woocommerce_get_css($css, $colors, $fonts) {
		if (isset($css['colors'])) {
			$css['fonts'] .= <<<CSS

.woocommerce ul.products li.product .post_header, .woocommerce-page ul.products li.product .post_header,
.woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price,
.woocommerce .shop_table th,
.woocommerce div.product p.price,
.woocommerce div.product span.price,
.woocommerce div.product .summary .stock,
.woocommerce-MyAccount-navigation,
.woocommerce-MyAccount-content .woocommerce-Address-title a {
	font-family: {$fonts['h5']['family']};
}

.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li a,
.woocommerce span.onsale,
.woocommerce nav.woocommerce-pagination ul li a,
.woocommerce nav.woocommerce-pagination ul li span.current,
.woocommerce ul.products li.product .button, .woocommerce div.product form.cart .button,
.woocommerce .woocommerce-message .button,
.woocommerce #review_form #respond p.form-submit input[type="submit"], .woocommerce-page #review_form #respond p.form-submit input[type="submit"],
.woocommerce .button, .woocommerce-page .button,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce input.button
.woocommerce #respond input#submit,
.woocommerce input[type="button"], .woocommerce-page input[type="button"],
.woocommerce input[type="submit"], .woocommerce-page input[type="submit"] {
	font-family: {$fonts['p']['family']};
}

.woocommerce .shop_mode_list ul.products li.product .price, .woocommerce-page .shop_mode_list ul.products li.product .price {
	font-family: {$fonts['h6']['family']};
}


.shop_slider_content, .tp-caption.shop_slider_content,
.shop_slider_add_to_cart_button, .tp-caption.shop_slider_add_to_cart_button {
	font-family: {$fonts['h5']['family']};
}
.shop_slider_tags, .tp-caption.shop_slider_tags,
.shop_slider_title, .tp-caption.shop_slider_title,
.shop_slider_price, .tp-caption.shop_slider_price {
	font-family: {$fonts['h6']['family']};
}

CSS;
		}

		if (isset($css['colors'])) {
			$css['colors'] .= <<<CSS

/* Page header */
.woocommerce .woocommerce-breadcrumb {
	color: {$colors['text']};
}
.woocommerce .woocommerce-breadcrumb a {
	color: {$colors['text_link']};
}
.woocommerce .woocommerce-breadcrumb a:hover {
	color: {$colors['text_hover']};
}
.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
.woocommerce .widget_price_filter .ui-slider .ui-slider-handle {
	background-color: {$colors['text_link']};
}

/* List and Single product */
.woocommerce .woocommerce-ordering,
.woocommerce .woocommerce-ordering select {}
.woocommerce span.onsale {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
.woocommerce ul.products li.product .post_item,
.woocommerce .shop_mode_list ul.products li.product + li.product .post_item, .woocommerce-page .shop_mode_list ul.products li.product + li.product .post_item {
	border-color: {$colors['alter_bd_color']};
}
.woocommerce ul.products li.product .post_item:hover {
	border-color: {$colors['text_link']};
}
.woocommerce .related ul.products li.product .post_item:hover {
	border-color: {$colors['alter_bd_color']};
}
.woocommerce .shop_mode_list ul.products li.product .post_featured:hover, .woocommerce-page .shop_mode_list ul.products li.product .post_featured:hover {
	border-color: {$colors['alter_bd_color']};
}
.woocommerce .shop_mode_list ul.products li.product .post_featured, .woocommerce-page .shop_mode_list ul.products li.product .post_featured {
	border-color: {$colors['alter_bd_color']};
}

.product_awards {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}

.woocommerce ul.products li.product .post_header .post_tags a {
	color: {$colors['text']};
}
.woocommerce ul.products li.product .post_header .post_tags a:hover {
	color: {$colors['text_link']};
}
.woocommerce ul.products li.product .post_header a {
	color: {$colors['text_link']};
}
.woocommerce ul.products li.product .post_header a:hover {
	color: {$colors['text_hover']};
}
.woocommerce ul.products li.product .price, .woocommerce-page ul.products li.product .price {
	color: {$colors['text_dark']};
}

/* Products on the homepage */
.home_products .woocommerce ul.products li.product .post_item {
	background-color: {$colors['alter_bg_color']};
}

.woocommerce span.amount, .woocommerce-page span.amount {
	color: {$colors['text_dark']};
}
.woocommerce table.shop_table td span.amount {
	color: {$colors['text_dark']};
}
aside.woocommerce del,
.woocommerce del, .woocommerce del > span.amount, 
.woocommerce-page del, .woocommerce-page del > span.amount {
	color: {$colors['text_light']} !important;
}
.woocommerce .price del:before {
	background-color: {$colors['text_light']};
}
.woocommerce div.product form.cart div.quantity span, .woocommerce-page div.product form.cart div.quantity span {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
.woocommerce div.product form.cart div.quantity span:hover, .woocommerce-page div.product form.cart div.quantity span:hover {
	background-color: {$colors['text_hover']};
}
.woocommerce div.product form.cart div.quantity input[type="number"], .woocommerce-page div.product form.cart div.quantity input[type="number"] {
	border-color: {$colors['text_link']};
}

.woocommerce div.product .product_meta span > a,
.woocommerce div.product .product_meta span > span {
	color: {$colors['text_dark']};
}
.woocommerce div.product .product_meta a:hover {
	color: {$colors['text_link']};
}

.woocommerce div.product div.images img {
	border-color: {$colors['alter_bd_color']};
}
.woocommerce div.product div.images a:hover img {
	border-color: {$colors['text_link']};
}

.single-product div.product .trx-stretch-width .woocommerce-tabs {
	border-color: {$colors['bd_color']};
}
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li a {
	border-color: {$colors['text_dark']};
}
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li.active a {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_dark']};
}

.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li a.sc_button_hover_slide_left {		background: linear-gradient(to right,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li a.sc_button_hover_slide_right {	background: linear-gradient(to left,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li a.sc_button_hover_slide_top {		background: linear-gradient(to bottom,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li a.sc_button_hover_slide_bottom {	background: linear-gradient(to top,		{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li.active a.sc_button_hover_slide_left {		background: linear-gradient(to right,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li.active a.sc_button_hover_slide_right {		background: linear-gradient(to left,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li.active a.sc_button_hover_slide_top {		background: linear-gradient(to bottom,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li.active a.sc_button_hover_slide_bottom {	background: linear-gradient(to top,		{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li a:hover {
	color: {$colors['inverse_text']};
}
.single-product div.product .trx-stretch-width .woocommerce-tabs .wc-tabs li a:not([class*="sc_button_hover_"]):hover {
	background-color: {$colors['text_dark']};
}


/* Related Products */
.single-product .related {
	border-color: {$colors['bd_color']};
}
.single-product ul.products li.product .post_data {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_dark_mask']};
}
.single-product ul.products li.product .post_data .price span.amount {
	color: {$colors['inverse_text']};
}
.single-product ul.products li.product .post_data .post_header .post_tags a,
.single-product ul.products li.product .post_data a {
	color: {$colors['inverse_text']};
}
.single-product ul.products li.product .post_data .post_header .post_tags a:hover,
.single-product ul.products li.product .post_data a:hover {
	color: {$colors['text_link']};
}
.single-product ul.products li.product .post_data .button {
	color: {$colors['inverse_text']};
	border-color: {$colors['inverse_text']};
}
.single-product ul.products li.product .post_data .button:not([class*="sc_button_hover_"]),
.single-product ul.products li.product .post_data .button.sc_button_hover_slide_left {	background: linear-gradient(to right,	{$colors['alter_bg_color']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.single-product ul.products li.product .post_data .button.sc_button_hover_slide_right {	background: linear-gradient(to left,	{$colors['alter_bg_color']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.single-product ul.products li.product .post_data .button.sc_button_hover_slide_top {	background: linear-gradient(to bottom,	{$colors['alter_bg_color']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.single-product ul.products li.product .post_data .button.sc_button_hover_slide_bottom {background: linear-gradient(to top,		{$colors['alter_bg_color']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.single-product ul.products li.product .post_data .button:hover {
	color: {$colors['alter_dark']} !important;
    background-position: left bottom;
}
.single-product ul.products li.product .post_data .button:not([class*="sc_button_hover_"]):hover {
	background-color: {$colors['alter_bg_color']};
}

/* Rating */
.star-rating span {
	color: {$colors['text_link']};
}
#review_form #respond p.form-submit input[type="submit"] {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
#review_form #respond p.form-submit input[type="submit"]:not([class*="sc_button_hover_"]),
#review_form #respond p.form-submit input[type="submit"].sc_button_hover_slide_left {	background: linear-gradient(to right,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
#review_form #respond p.form-submit input[type="submit"].sc_button_hover_slide_right {	background: linear-gradient(to left,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
#review_form #respond p.form-submit input[type="submit"].sc_button_hover_slide_top {	background: linear-gradient(to bottom,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
#review_form #respond p.form-submit input[type="submit"].sc_button_hover_slide_bottom {	background: linear-gradient(to top,		{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

#review_form #respond p.form-submit input[type="submit"]:hover,
#review_form #respond p.form-submit input[type="submit"]:focus {
	color: {$colors['inverse_text']};
    background-position: left bottom;
}
#review_form #respond p.form-submit input[type="submit"]:not([class*="sc_button_hover_"]):hover,
#review_form #respond p.form-submit input[type="submit"]:not([class*="sc_button_hover_"]):focus {
	background-color: {$colors['text_dark']};
}

/* Buttons */
.mckinney_politics_shop_mode_buttons a {
	color: {$colors['text_dark']};
}
.mckinney_politics_shop_mode_buttons a:hover {
	color: {$colors['text_link']};
}
.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button,
.woocommerce a.button,
.woocommerce button.button,
.woocommerce nav.woocommerce-pagination ul li a,
.woocommerce nav.woocommerce-pagination ul li span.current,
.woocommerce .button, .woocommerce-page .button,
.woocommerce input[type="button"], .woocommerce-page input[type="button"],
.woocommerce input[type="submit"], .woocommerce-page input[type="submit"],
.woocommerce input.button {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
.woocommerce #respond input#submit.disabled, .woocommerce #respond input#submit:disabled, .woocommerce #respond input#submit[disabled]:disabled, .woocommerce a.button.disabled, .woocommerce a.button:disabled, .woocommerce a.button[disabled]:disabled, .woocommerce button.button.disabled, .woocommerce button.button:disabled, .woocommerce button.button[disabled]:disabled, .woocommerce input.button.disabled, .woocommerce input.button:disabled, .woocommerce input.button[disabled]:disabled {
   color: {$colors['inverse_text']} !important;
}
.woocommerce #respond input#submit:not([class*="sc_button_hover_"]),
.woocommerce nav.woocommerce-pagination ul li a:not([class*="sc_button_hover_"]),
.woocommerce nav.woocommerce-pagination ul li span.current,
.woocommerce a.button:not([class*="sc_button_hover_"]),
.woocommerce button.button:not([class*="sc_button_hover_"]),
.woocommerce input.button:not([class*="sc_button_hover_"]),
 .woocommerce #respond input#submit.alt:not([class*="sc_button_hover_"]),
.woocommerce a.button.alt:not([class*="sc_button_hover_"]),
.woocommerce button.button.alt:not([class*="sc_button_hover_"]),
.woocommerce input.button.alt:not([class*="sc_button_hover_"]) { background: linear-gradient(to top, 	{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.woocommerce #respond input#submit.sc_button_hover_slide_left,
.woocommerce nav.woocommerce-pagination ul li a.sc_button_hover_slide_left,
.woocommerce a.button.sc_button_hover_slide_left,
.woocommerce button.button.sc_button_hover_slide_left,
.woocommerce input.button.sc_button_hover_slide_left {	background: linear-gradient(to right, 	{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.woocommerce #respond input#submit.sc_button_hover_slide_right,
.woocommerce nav.woocommerce-pagination ul li a.sc_button_hover_slide_right,
.woocommerce a.button.sc_button_hover_slide_right,
.woocommerce button.button.sc_button_hover_slide_right,
.woocommerce input.button.sc_button_hover_slide_right {	background: linear-gradient(to left, 	{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.woocommerce #respond input#submit.sc_button_hover_slide_top,
.woocommerce nav.woocommerce-pagination ul li a.sc_button_hover_slide_top,
.woocommerce a.button.sc_button_hover_slide_top,
.woocommerce button.button.sc_button_hover_slide_top,
.woocommerce input.button.sc_button_hover_slide_top {	background: linear-gradient(to bottom, 	{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.woocommerce #respond input#submit.sc_button_hover_slide_bottom,
.woocommerce nav.woocommerce-pagination ul li a.sc_button_hover_slide_bottom,
.woocommerce a.button.sc_button_hover_slide_bottom,
.woocommerce button.button.sc_button_hover_slide_bottom,
.woocommerce input.button.sc_button_hover_slide_bottom {background: linear-gradient(to top, 	{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }


.contact_cart .woocommerce a.button:not([class*="sc_button_hover_"]),
.woocommerce .contact_cart a.button.sc_button_hover_slide_bottom,
.contact_cart a.button.sc_button_hover_slide_bottom {
    background: linear-gradient(to bottom, 	{$colors['text_link']} 50%, {$colors['inverse_text']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); 
}
.woocommerce .top_panel_navi.with_bg_image:not(.state_fixed) .contact_cart a.button.sc_button_hover_slide_bottom:hover,
.top_panel_navi:not(.state_fixed) .contact_cart a.button.sc_button_hover_slide_bottom:hover {
    color: {$colors['text_dark']} !important;
}
.woocommerce .contact_cart ul.cart_list li .quantity span.amount,
.contact_cart ul.cart_list li .quantity span.amount,
.woocommerce .contact_cart ul.cart_list li .quantity,
.contact_cart ul.cart_list li .quantity {
    color: {$colors['text_light']};
}
.woocommerce .contact_cart ul.cart_list li,
.contact_cart ul.cart_list li {
    border-bottom: 1px solid {$colors['text_light']};
}
.woocommerce #respond input#submit:hover,
.woocommerce nav.woocommerce-pagination ul li a:hover,
.woocommerce nav.woocommerce-pagination ul li span.current,
.woocommerce a.button:hover,
.woocommerce button.button:hover,
.woocommerce input.button:hover {
	color: {$colors['inverse_text']} !important;
	border-color: {$colors['text_dark']};
}
.woocommerce #respond input#submit:not([class*="sc_button_hover_"]):hover,
.woocommerce nav.woocommerce-pagination ul li a:not([class*="sc_button_hover_"]):hover,
.woocommerce a.button:not([class*="sc_button_hover_"]):hover,
.woocommerce button.button:not([class*="sc_button_hover_"]):hover,
.woocommerce input.button:not([class*="sc_button_hover_"]):hover {
	background-color: {$colors['text_hover']};
}

.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt {
	color: {$colors['inverse_text']};
	border-color: {$colors['text_link']};
	background-color: {$colors['text_link']};
}

.woocommerce #respond input#submit.alt.sc_button_hover_slide_left,
.woocommerce a.button.alt.sc_button_hover_slide_left,
.woocommerce button.button.alt.sc_button_hover_slide_left,
.woocommerce input.button.alt.sc_button_hover_slide_left {	background: linear-gradient(to right,	{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.woocommerce #respond input#submit.alt.sc_button_hover_slide_right,
.woocommerce a.button.alt.sc_button_hover_slide_right,
.woocommerce button.button.alt.sc_button_hover_slide_right,
.woocommerce input.button.alt.sc_button_hover_slide_right {	background: linear-gradient(to left,	{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.woocommerce #respond input#submit.alt.sc_button_hover_slide_top,
.woocommerce a.button.alt.sc_button_hover_slide_top,
.woocommerce button.button.alt.sc_button_hover_slide_top,
.woocommerce input.button.alt.sc_button_hover_slide_top {	background: linear-gradient(to bottom,	{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.woocommerce #respond input#submit.alt.sc_button_hover_slide_bottom,
.woocommerce a.button.alt.sc_button_hover_slide_bottom,
.woocommerce button.button.alt.sc_button_hover_slide_bottom,
.woocommerce input.button.alt.sc_button_hover_slide_bottom {	background: linear-gradient(to top,		{$colors['text_dark']} 50%, {$colors['text_link']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.woocommerce #respond input#submit.alt:hover,
.woocommerce a.button.alt:hover,
.woocommerce button.button.alt:hover,
.woocommerce input.button.alt:hover {
	color: {$colors['inverse_text']};
	border-color: {$colors['text_hover']};
    background-position: left bottom;
}
.woocommerce #respond input#submit.alt:not([class*="sc_button_hover_"]):hover,
.woocommerce a.button.alt:not([class*="sc_button_hover_"]):hover,
.woocommerce button.button.alt:not([class*="sc_button_hover_"]):hover,
.woocommerce input.button.alt:not([class*="sc_button_hover_"]):hover {
	background-color: {$colors['text_hover']};
}

/* Messages */
.woocommerce .woocommerce-message,
.woocommerce .woocommerce-info {
	background-color: {$colors['alter_bg_color']};
	border-top-color: {$colors['alter_dark']};
}
.woocommerce .woocommerce-message:before,
.woocommerce .woocommerce-info:before {
	color: {$colors['alter_dark']};
}
.woocommerce .woocommerce-message .button,
.woocommerce .woocommerce-info .button {
	color: {$colors['alter_dark']};
	border-color: {$colors['alter_dark']};
}
.woocommerce .woocommerce-message .button:not([class*="sc_button_hover_"]),
.woocommerce .woocommerce-info .button:not([class*="sc_button_hover_"]),
.woocommerce .woocommerce-message .button.sc_button_hover_slide_left,
.woocommerce .woocommerce-info .button.sc_button_hover_slide_left {				background: linear-gradient(to right,	{$colors['alter_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.woocommerce .woocommerce-message .button.sc_button_hover_slide_right,
.woocommerce .woocommerce-info .button.sc_button_hover_slide_right {			background: linear-gradient(to left,	{$colors['alter_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.woocommerce .woocommerce-message .button.sc_button_hover_slide_top,
.woocommerce .woocommerce-info .button.sc_button_hover_slide_top {				background: linear-gradient(to bottom,	{$colors['alter_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.woocommerce .woocommerce-message .button.sc_button_hover_slide_bottom,
.woocommerce .woocommerce-info .button.sc_button_hover_slide_bottom {			background: linear-gradient(to top,		{$colors['alter_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.woocommerce .woocommerce-message .button:hover,
.woocommerce .woocommerce-info .button:hover {
	color: {$colors['inverse_text']};
    background-position: left bottom;
}
.woocommerce .woocommerce-message .button:not([class*="sc_button_hover_"]):hover,
.woocommerce .woocommerce-info .button:not([class*="sc_button_hover_"]):hover {
	background-color: {$colors['alter_dark']};
}
.woocommerce .woocommerce-error {
	background-color: {$colors['alter_bg_color']};
	border-top-color: {$colors['alter_link']};
}
.woocommerce .woocommerce-error:before {
	color: {$colors['alter_link']};
}
.woocommerce .woocommerce-error .button {
	color: {$colors['inverse_text']};
	background-color: {$colors['alter_link']};
}
.woocommerce .woocommerce-error .button:not([class*="sc_button_hover_"]),
.woocommerce .woocommerce-error .button.sc_button_hover_slide_left {			background: linear-gradient(to right,	{$colors['alter_dark']} 50%, {$colors['alter_link']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.woocommerce .woocommerce-error .button.sc_button_hover_slide_right {			background: linear-gradient(to left,	{$colors['alter_dark']} 50%, {$colors['alter_link']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.woocommerce .woocommerce-error .button.sc_button_hover_slide_top {				background: linear-gradient(to bottom,	{$colors['alter_dark']} 50%, {$colors['alter_link']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.woocommerce .woocommerce-error .button.sc_button_hover_slide_bottom {			background: linear-gradient(to top,		{$colors['alter_dark']} 50%, {$colors['alter_link']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.woocommerce .woocommerce-error .button:hover {
	color: {$colors['inverse_text']};
	background-color: {$colors['alter_dark']};
    background-position: left bottom;
}

/* Cart */
.woocommerce table.shop_table td,
.woocommerce table.shop_table th {
	border-color: {$colors['text_link']} !important;
}
.woocommerce table.shop_table tfoot th, .woocommerce-page table.shop_table tfoot th {
	color: {$colors['text_dark']};
}
.woocommerce .quantity input.qty, .woocommerce #content .quantity input.qty, .woocommerce-page .quantity input.qty, .woocommerce-page #content .quantity input.qty {
	color: {$colors['input_dark']};
}
.woocommerce .cart-collaterals .cart_totals table select, .woocommerce-page .cart-collaterals .cart_totals table select {
	color: {$colors['input_light']};
	background-color: {$colors['input_bg_color']};
}
.woocommerce .cart-collaterals .cart_totals table select:focus, .woocommerce-page .cart-collaterals .cart_totals table select:focus {
	color: {$colors['input_text']};
	background-color: {$colors['input_bg_hover']};
}
.woocommerce .cart-collaterals .shipping_calculator .shipping-calculator-button:after, .woocommerce-page .cart-collaterals .shipping_calculator .shipping-calculator-button:after {
	color: {$colors['text_dark']};
}
.woocommerce table.shop_table .cart-subtotal .amount, .woocommerce-page table.shop_table .cart-subtotal .amount,
.woocommerce table.shop_table .shipping td, .woocommerce-page table.shop_table .shipping td {
	color: {$colors['text_dark']};
}
.woocommerce table.cart td+td a, .woocommerce #content table.cart td+td a, .woocommerce-page table.cart td+td a, .woocommerce-page #content table.cart td+td a,
.woocommerce table.cart td+td span, .woocommerce #content table.cart td+td span, .woocommerce-page table.cart td+td span, .woocommerce-page #content table.cart td+td span {
	color: {$colors['text_dark']};
}
.woocommerce table.cart td+td a:hover, .woocommerce #content table.cart td+td a:hover, .woocommerce-page table.cart td+td a:hover, .woocommerce-page #content table.cart td+td a:hover {
	color: {$colors['text_link']};
}

/* Checkout */
.woocommerce-checkout #payment {
	background-color:{$colors['alter_bg_color']};
}
.woocommerce .order_details li strong, .woocommerce-page .order_details li strong {
	color: {$colors['text_dark']};
}

/* My Account */
.woocommerce-account .woocommerce-MyAccount-navigation,
.woocommerce-MyAccount-navigation li+li {
	border-color: {$colors['bd_color']};
}
.woocommerce-MyAccount-navigation li.is-active a {
	color: {$colors['text_dark']};
}
}

/* Widgets */
.woocommerce.widget_product_search form:after {
	color: {$colors['input_light']};
}
.woocommerce.widget_product_search form:hover:after {
	color: {$colors['input_dark']};
}
.woocommerce.widget_product_search .search_button {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_text']};
}

.woocommerce .contact_cart .widget_shopping_cart .total strong, 
.woocommerce-page .contact_cart .widget_shopping_cart .contact_cart .total strong, 
.woocommerce .contact_cart .widget_shopping_cart .total span.amount, 
.woocommerce-page .contact_cart .widget_shopping_cart .contact_cart  .total span.amount,
.contact_cart .woocommerce.widget_shopping_cart .total span.amount,
.contact_cart .woocommerce.widget_shopping_cart .total strong {
    color: {$colors['inverse_text']};
}
.woocommerce.widget_shopping_cart .total, .woocommerce .widget_shopping_cart .total, .woocommerce-page.widget_shopping_cart .total, .woocommerce-page .widget_shopping_cart .total {
	color: {$colors['text_dark']};
	border-color: {$colors['bd_color']};
}
.woocommerce .widget_layered_nav ul li.chosen a, .woocommerce-page .widget_layered_nav ul li.chosen a {
	color: {$colors['text_dark']};
}
.woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content { 
	background: {$colors['text_light']};
}
.woocommerce .widget_price_filter .price_label span {
	color: {$colors['text_dark']};
}


/* Shop slider */
.shop_slider_price, .tp-caption.shop_slider_price {
	color: {$colors['text_link']};
}
.shop_slider_content, .tp-caption.shop_slider_content {
	color: {$colors['text_dark']};
}
.shop_slider_add_to_cart:before, .tp-caption.shop_slider_add_to_cart:before {
	border-color: {$colors['text_dark']};
}
.tp-bullets.custom .tp-bullet {
	border-color: {$colors['text_light']};
}
.tp-bullets.custom .tp-bullet.selected {
	border-color: {$colors['text_dark']};
	background-color: {$colors['text_dark']};
}

CSS;
		}
		
		return $css;
	}
}
?>