<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_trx_updater_theme_setup9')) {
    add_action( 'after_setup_theme', 'mckinney_politics_trx_updater_theme_setup9', 9 );
    function mckinney_politics_trx_updater_theme_setup9() {
        if (is_admin()) {
            add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',		'mckinney_politics_trx_updater_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_trx_updater_required_plugins' ) ) {
    function mckinney_politics_trx_updater_required_plugins($list=array()) {
        if (in_array('trx_updater', (array)mckinney_politics_storage_get('required_plugins'))) {
            $list[] = array(
                'name' 		=> esc_html__('ThemeREX Updater', 'mckinney-politics'),
                'slug' 		=> 'trx_updater',
                'version'   => '2.0.0',
                'source'	=> mckinney_politics_get_file_dir('plugins/install/trx_updater.zip'),
                'required' 	=> false
            );
        }
        return $list;
    }
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'mckinney_politics_exists_trx_updater' ) ) {
    function mckinney_politics_exists_trx_updater() {
        return defined('TRX_UPDATER_VERSION');
    }
}
?>