<?php
/* MCKINNEY_POLITICS Addons support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if (!function_exists('mckinney_politics_trx_addons_theme_setup1')) {
	add_action( 'after_setup_theme', 'mckinney_politics_trx_addons_theme_setup1', 1 );
	function mckinney_politics_trx_addons_theme_setup1() {
		add_filter( 'mckinney_politics_filter_list_sidebars', 'mckinney_politics_trx_addons_list_sidebars' );
		if (mckinney_politics_exists_trx_addons()) {
			add_filter( 'trx_addons_cpt_list',		'mckinney_politics_trx_addons_cpt_list');
			add_filter( 'trx_addons_sc_list',		'mckinney_politics_trx_addons_sc_list');
			add_filter( 'trx_addons_widgets_list',	'mckinney_politics_trx_addons_widgets_list');
		}
	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if (!function_exists('mckinney_politics_trx_addons_theme_setup3')) {
	add_action( 'after_setup_theme', 'mckinney_politics_trx_addons_theme_setup3', 3 );
	function mckinney_politics_trx_addons_theme_setup3() {
		if (mckinney_politics_exists_courses()) {
			mckinney_politics_storage_merge_array('options', '', array(
				// Section 'Courses' - settings for show pages
				'courses' => array(
					"title" => esc_html__('Courses', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select parameters to display the courses pages', 'mckinney-politics') ),
					"type" => "section"
					),
				'expand_content_courses' => array(
					"title" => esc_html__('Expand content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'mckinney-politics') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
				'header_widgets_courses' => array(
					"title" => esc_html__('Header widgets', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on the courses pages', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'sidebar_widgets_courses' => array(
					"title" => esc_html__('Sidebar widgets', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select sidebar to show on the courses pages', 'mckinney-politics') ),
					"std" => 'courses_widgets',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'sidebar_position_courses' => array(
					"title" => esc_html__('Sidebar position', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select position to show sidebar on the courses pages', 'mckinney-politics') ),
					"refresh" => false,
					"std" => 'left',
					"options" => mckinney_politics_get_list_sidebars_positions(),
					"type" => "select"
					),
				'widgets_above_page_courses' => array(
					"title" => esc_html__('Widgets above the page', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_above_content_courses' => array(
					"title" => esc_html__('Widgets above the content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_below_content_courses' => array(
					"title" => esc_html__('Widgets below the content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_below_page_courses' => array(
					"title" => esc_html__('Widgets below the page', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					)
				)
			);
		}
		if (mckinney_politics_exists_services()) {
			mckinney_politics_storage_merge_array('options', '', array(
					// Section 'Services' - settings for show pages
					'services' => array(
						"title" => esc_html__('Services', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Select parameters to display the services pages', 'mckinney-politics') ),
						"type" => "section"
					),
					'expand_content_services' => array(
						"title" => esc_html__('Expand content', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'mckinney-politics') ),
						"refresh" => false,
						"std" => 1,
						"type" => "checkbox"
					),
					'header_widgets_services' => array(
						"title" => esc_html__('Header widgets', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Select set of widgets to show in the header on the services pages', 'mckinney-politics') ),
						"std" => 'hide',
						"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
						"type" => "select"
					),
					'sidebar_widgets_services' => array(
						"title" => esc_html__('Sidebar widgets', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Select sidebar to show on the services pages', 'mckinney-politics') ),
						"std" => 'services_widgets',
						"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
						"type" => "select"
					),
					'sidebar_position_services' => array(
						"title" => esc_html__('Sidebar position', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Select position to show sidebar on the services pages', 'mckinney-politics') ),
						"refresh" => false,
						"std" => 'left',
						"options" => mckinney_politics_get_list_sidebars_positions(),
						"type" => "select"
					),
					'widgets_above_page_services' => array(
						"title" => esc_html__('Widgets above the page', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'mckinney-politics') ),
						"std" => 'hide',
						"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
						"type" => "select"
					),
					'widgets_above_content_services' => array(
						"title" => esc_html__('Widgets above the content', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'mckinney-politics') ),
						"std" => 'hide',
						"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
						"type" => "select"
					),
					'widgets_below_content_services' => array(
						"title" => esc_html__('Widgets below the content', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'mckinney-politics') ),
						"std" => 'hide',
						"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
						"type" => "select"
					),
					'widgets_below_page_services' => array(
						"title" => esc_html__('Widgets below the page', 'mckinney-politics'),
						"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'mckinney-politics') ),
						"std" => 'hide',
						"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
						"type" => "select"
					)
				)
			);
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_trx_addons_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_trx_addons_theme_setup9', 9 );
	function mckinney_politics_trx_addons_theme_setup9() {
		if (mckinney_politics_exists_trx_addons()) {
			add_filter( 'trx_addons_sc_atts',							'mckinney_politics_trx_addons_sc_atts', 10, 2);
			add_filter( 'trx_addons_sc_output',							'mckinney_politics_trx_addons_sc_output', 10, 4);
			add_filter( 'trx_addons_filter_add_thumb_sizes',			'mckinney_politics_trx_addons_add_thumb_sizes');
			add_filter( 'trx_addons_filter_get_thumb_size',				'mckinney_politics_trx_addons_get_thumb_size');
			add_filter( 'trx_addons_filter_testimonials_thumb_size',	'mckinney_politics_trx_addons_testimonials_thumb_size');
			add_filter( 'trx_addons_filter_services_thumb_size',	    'mckinney_politics_trx_addons_services_thumb_size');
			add_filter( 'trx_addons_filter_sc_item_title_tag',			'mckinney_politics_trx_addons_sc_item_title_tag');
			add_filter( 'trx_addons_filter_sc_item_button_args',		'mckinney_politics_trx_addons_sc_item_button_args', 10, 2);
			add_action( 'wp_enqueue_scripts', 							'mckinney_politics_trx_addons_frontend_scripts', 1100 );
			add_filter( 'mckinney_politics_filter_query_sort_order', 		'mckinney_politics_trx_addons_query_sort_order', 10, 3);
			add_filter( 'mckinney_politics_filter_merge_styles',			'mckinney_politics_trx_addons_merge_styles');
			add_filter( 'mckinney_politics_filter_get_css',				'mckinney_politics_trx_addons_get_css', 10, 3);
			add_filter( 'mckinney_politics_filter_get_post_categories', 	'mckinney_politics_trx_addons_get_post_categories');
			add_filter( 'mckinney_politics_filter_get_post_date',		 	'mckinney_politics_trx_addons_get_post_date');
			if (is_admin()) {
				add_filter( 'mckinney_politics_filter_importer_options',	'mckinney_politics_trx_addons_importer_set_options' );
				add_filter( 'mckinney_politics_filter_allow_override_options', 	'mckinney_politics_trx_addons_allow_override_options', 10, 2);
				add_filter( 'trx_addons_sc_type',						'mckinney_politics_trx_addons_sc_type', 10, 2);
				add_filter( 'trx_addons_sc_map',						'mckinney_politics_trx_addons_sc_map', 10, 2);
			} else {
				add_filter( 'mckinney_politics_filter_detect_blog_mode',			'mckinney_politics_trx_addons_detect_blog_mode' );
				add_filter( 'mckinney_politics_filter_post_type_taxonomy',		'mckinney_politics_trx_addons_post_type_taxonomy', 10, 2 );
				add_filter( 'mckinney_politics_filter_get_blog_all_posts_link', 	'mckinney_politics_trx_addons_get_blog_all_posts_link');
				add_filter( 'mckinney_politics_filter_get_blog_title', 			'mckinney_politics_trx_addons_get_blog_title');
				add_filter( 'mckinney_politics_filter_need_page_title', 			'mckinney_politics_trx_addons_need_page_title');
				add_filter( 'mckinney_politics_filter_sidebar_present',			'mckinney_politics_trx_addons_sidebar_present' );
				add_filter( 'mckinney_politics_filter_allow_override_header_image','mckinney_politics_trx_addons_allow_override_header_image' );
			}
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_importer_required_plugins',		'mckinney_politics_trx_addons_importer_required_plugins', 10, 2 );
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',		'mckinney_politics_trx_addons_tgmpa_required_plugins' );
			add_action( 'admin_enqueue_scripts', 								'mckinney_politics_trx_addons_editor_load_scripts_admin');
			add_filter( 'tiny_mce_before_init', 								'mckinney_politics_trx_addons_editor_init', 11);
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'mckinney_politics_exists_trx_addons' ) ) {
	function mckinney_politics_exists_trx_addons() {
		return defined('TRX_ADDONS_VERSION');
	}
}

// Return true if team is supported
if ( !function_exists( 'mckinney_politics_exists_team' ) ) {
	function mckinney_politics_exists_team() {
		return defined('TRX_ADDONS_CPT_TEAM_PT');
	}
}

// Return true if courses is supported
if ( !function_exists( 'mckinney_politics_exists_courses' ) ) {
	function mckinney_politics_exists_courses() {
		return defined('TRX_ADDONS_CPT_COURSES_PT');
	}
}

// Return true if services is supported
if ( !function_exists( 'mckinney_politics_exists_services' ) ) {
	function mckinney_politics_exists_services() {
		return defined('TRX_ADDONS_CPT_SERVICES_PT');
	}
}


// Return true if it's team page
if ( !function_exists( 'mckinney_politics_is_team_page' ) ) {
	function mckinney_politics_is_team_page() {
		return defined('TRX_ADDONS_CPT_TEAM_PT') 
					&& !is_search()
					&& (
						(is_single() && get_post_type()==TRX_ADDONS_CPT_TEAM_PT)
						|| is_post_type_archive(TRX_ADDONS_CPT_TEAM_PT)
						|| is_tax(TRX_ADDONS_CPT_TEAM_TAXONOMY)
						);
	}
}


// Return true if it's courses page
if ( !function_exists( 'mckinney_politics_is_courses_page' ) ) {
	function mckinney_politics_is_courses_page() {
		return defined('TRX_ADDONS_CPT_COURSES_PT') 
					&& !is_search()
					&& (
						(is_single() && get_post_type()==TRX_ADDONS_CPT_COURSES_PT)
						|| is_post_type_archive(TRX_ADDONS_CPT_COURSES_PT)
						|| is_tax(TRX_ADDONS_CPT_COURSES_TAXONOMY)
						);
	}
}


// Return true if it's services page
if ( !function_exists( 'mckinney_politics_is_services_page' ) ) {
	function mckinney_politics_is_services_page() {
		return defined('TRX_ADDONS_CPT_SERVICES_PT')
		&& !is_search()
		&& (
			(is_single() && get_post_type()==TRX_ADDONS_CPT_SERVICES_PT)
			|| is_post_type_archive(TRX_ADDONS_CPT_SERVICES_PT)
			|| is_tax(TRX_ADDONS_CPT_SERVICES_TAXONOMY)
		);
	}
}




// Enqueue custom styles
if ( !function_exists( 'mckinney_politics_trx_addons_frontend_scripts' ) ) {
	//Handler of add_action( 'wp_enqueue_scripts', 'mckinney_politics_trx_addons_frontend_scripts', 1100 );
	function mckinney_politics_trx_addons_frontend_scripts() {
		if (mckinney_politics_exists_trx_addons())
			if (mckinney_politics_is_on(mckinney_politics_get_theme_option('debug_mode')) && file_exists(mckinney_politics_get_file_dir('css/plugin.trx_addons.css')))
				wp_enqueue_style( 'mckinney-politics-plugin-trx-addons',  mckinney_politics_get_file_url('css/plugin.trx_addons.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'mckinney_politics_trx_addons_merge_styles' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_merge_styles', 'mckinney_politics_trx_addons_merge_styles');
	function mckinney_politics_trx_addons_merge_styles($css) {
		return $css . mckinney_politics_fgc(mckinney_politics_get_file_dir('css/plugin.trx_addons.css'));
	}
}

// Detect current blog mode
if ( !function_exists( 'mckinney_politics_trx_addons_detect_blog_mode' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_detect_blog_mode', 'mckinney_politics_trx_addons_detect_blog_mode' );
	function mckinney_politics_trx_addons_detect_blog_mode($mode='') {
		if ( mckinney_politics_is_team_page() )
			$mode = 'team';
		else if ( mckinney_politics_is_courses_page() )
			$mode = 'courses';
		else if ( mckinney_politics_is_services_page() )
			$mode = 'services';
		return $mode;
	}
}

// Return taxonomy for current post type
if ( !function_exists( 'mckinney_politics_trx_addons_post_type_taxonomy' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_post_type_taxonomy',	'mckinney_politics_trx_addons_post_type_taxonomy', 10, 2 );
	function mckinney_politics_trx_addons_post_type_taxonomy($tax='', $post_type='') {
		if ( defined('TRX_ADDONS_CPT_TEAM_PT') && $post_type == TRX_ADDONS_CPT_TEAM_PT )
			$tax = TRX_ADDONS_CPT_TEAM_TAXONOMY;
		else if ( defined('TRX_ADDONS_CPT_COURSES_PT') && $post_type == TRX_ADDONS_CPT_COURSES_PT )
			$tax = TRX_ADDONS_CPT_COURSES_TAXONOMY;
		else if ( defined('TRX_ADDONS_CPT_SERVICES_PT') && $post_type == TRX_ADDONS_CPT_SERVICES_PT )
			$tax = TRX_ADDONS_CPT_SERVICES_TAXONOMY;
		return $tax;
	}
}

// Return link to the all courses, team, etc. for the breadcrumbs
if ( !function_exists( 'mckinney_politics_trx_addons_get_blog_all_posts_link' ) ) {
	//Handler of add_filter('mckinney_politics_filter_get_blog_all_posts_link', 'mckinney_politics_trx_addons_get_blog_all_posts_link');
	function mckinney_politics_trx_addons_get_blog_all_posts_link($link='') {
		if ($link=='') {
			if (mckinney_politics_is_courses_page() && !is_post_type_archive(TRX_ADDONS_CPT_COURSES_PT))
				$link = '<a href="'.esc_url(get_post_type_archive_link( TRX_ADDONS_CPT_COURSES_PT )).'">'.esc_html__('All Courses', 'mckinney-politics').'</a>';
			else if (mckinney_politics_is_team_page() && !is_post_type_archive(TRX_ADDONS_CPT_TEAM_PT))
				$link = '<a href="'.esc_url(get_post_type_archive_link( TRX_ADDONS_CPT_TEAM_PT )).'">'.esc_html__('All Team Members', 'mckinney-politics').'</a>';
			else if (mckinney_politics_is_services_page() && !is_post_type_archive(TRX_ADDONS_CPT_SERVICES_PT))
				$link = '<a href="'.esc_url(get_post_type_archive_link( TRX_ADDONS_CPT_SERVICES_PT )).'">'.esc_html__('All Services', 'mckinney-politics').'</a>';
		}
		return $link;
	}
}

// Return current page title
if ( !function_exists( 'mckinney_politics_trx_addons_get_blog_title' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_blog_title', 'mckinney_politics_trx_addons_get_blog_title');
	function mckinney_politics_trx_addons_get_blog_title($title='') {

		if ( defined('TRX_ADDONS_CPT_TEAM_PT') ) {
			if (is_single() && get_post_type()==TRX_ADDONS_CPT_TEAM_PT)
				$title = array(
					'text' => get_the_title(),
					'class' => 'team_page_title'
				);
			else if ( is_post_type_archive(TRX_ADDONS_CPT_TEAM_PT) )
				$title = esc_html__('All Team Members', 'mckinney-politics');

		}
		
		if ( defined('TRX_ADDONS_CPT_COURSES_PT') ) {
			if (is_single() && get_post_type()==TRX_ADDONS_CPT_COURSES_PT) {
				$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);
				$title = array(
					'text' => get_the_title(),
					'class' => 'courses_page_title'
				);
				if (!empty($meta['product']) && (int) $meta['product'] > 0) {
					$title['link'] = get_permalink($meta['product']);
					$title['link_text'] = esc_html__('Join the Course', 'mckinney-politics');
				}
			} else if ( is_post_type_archive(TRX_ADDONS_CPT_COURSES_PT) )
				$title = esc_html__('All Courses', 'mckinney-politics');
		}

		if ( defined('TRX_ADDONS_CPT_SERVICES_PT') ) {
			if (is_single() && get_post_type()==TRX_ADDONS_CPT_SERVICES_PT) {
				$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);
				$title = array(
					'text' => get_the_title(),
					'class' => 'services_page_title'
				);
			}
			else if ( is_post_type_archive(TRX_ADDONS_CPT_SERVICES_PT) )
				$title = esc_html__('All Services', 'mckinney-politics');
		}

		return $title;
	}
}

// Return true if page title section is allowed
if ( !function_exists( 'mckinney_politics_trx_addons_need_page_title' ) ) {
	//Handler of add_filter('mckinney_politics_filter_need_page_title', 'mckinney_politics_trx_addons_need_page_title');
	function mckinney_politics_trx_addons_need_page_title($need=false) {
		if (!$need)
			$need = mckinney_politics_is_team_page() || mckinney_politics_is_courses_page() || mckinney_politics_is_services_page();
		return $need;
	}
}

// Disable override header image on team pages
if ( !function_exists( 'mckinney_politics_trx_addons_allow_override_header_image' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_allow_override_header_image', 'mckinney_politics_trx_addons_allow_override_header_image' );
	function mckinney_politics_trx_addons_allow_override_header_image($allow) {
		return mckinney_politics_is_team_page() ? false : $allow;
	}
}

// Hide sidebar on the team pages
if ( !function_exists( 'mckinney_politics_trx_addons_sidebar_present' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_sidebar_present', 'mckinney_politics_trx_addons_sidebar_present' );
	function mckinney_politics_trx_addons_sidebar_present($present) {
		return mckinney_politics_is_team_page() ? false : $present;
	}
}

// Show categories of the team, courses, etc.
if ( !function_exists( 'mckinney_politics_trx_addons_get_post_categories' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_post_categories', 		'mckinney_politics_trx_addons_get_post_categories');
	function mckinney_politics_trx_addons_get_post_categories($cats='') {

		if ( defined('TRX_ADDONS_CPT_TEAM_PT') ) {
			if (get_post_type()==TRX_ADDONS_CPT_TEAM_PT) {
				$cats = mckinney_politics_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_TEAM_TAXONOMY);
			}
		}
		if ( defined('TRX_ADDONS_CPT_COURSES_PT') ) {
			if (get_post_type()==TRX_ADDONS_CPT_COURSES_PT) {
				$cats = mckinney_politics_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_COURSES_TAXONOMY);
			}
		}
		if ( defined('TRX_ADDONS_CPT_SERVICES_PT') ) {
			if (get_post_type()==TRX_ADDONS_CPT_SERVICES_PT) {
				$cats = mckinney_politics_get_post_terms(', ', get_the_ID(), TRX_ADDONS_CPT_SERVICES_TAXONOMY);
			}
		}
		return $cats;
	}
}

// Show categories of the team, courses, etc.
if ( !function_exists( 'mckinney_politics_trx_addons_get_post_date' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_post_date',		 		'mckinney_politics_trx_addons_get_post_date');
	function mckinney_politics_trx_addons_get_post_date($dt='') {

		if ( defined('TRX_ADDONS_CPT_COURSES_PT') ) {
			if (get_post_type()==TRX_ADDONS_CPT_COURSES_PT) {
				$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);
				$dt = $meta['date'];
				$dt = sprintf($dt < date('Y-m-d') ? esc_html__('Started on %s', 'mckinney-politics') : esc_html__('Starting %s', 'mckinney-politics'), date(get_option('date_format'), strtotime($dt)));
			}
		}
		return $dt;
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_trx_addons_tgmpa_required_plugins' ) ) {
	//Handler of add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_trx_addons_tgmpa_required_plugins');
	function mckinney_politics_trx_addons_tgmpa_required_plugins($list=array()) {
		if (in_array('trx_addons', (array)mckinney_politics_storage_get('required_plugins'))) {
			$path = mckinney_politics_get_file_dir('plugins/install/trx_addons.zip');
			if (file_exists($path)) {
				$list[] = array(
						'name' 		=> esc_html__('ThemeREX Addons', 'mckinney-politics'),
						'slug' 		=> 'trx_addons',
						'version'	=> '1.71.2.3',
						'source'	=> $path,
						'required' 	=> true
					);
			}
		}
		return $list;
	}
}

// Check if override options is allow
if (!function_exists('mckinney_politics_trx_addons_allow_override_options')) {
	//Handler of add_filter( 'mckinney_politics_filter_allow_override_options', 'mckinney_politics_trx_addons_allow_override_options', 10, 2);
	function mckinney_politics_trx_addons_allow_override_options($allow, $post_type) {
		return $allow
					|| (defined('TRX_ADDONS_CPT_TEAM_PT') && $post_type==TRX_ADDONS_CPT_TEAM_PT) 
					|| (defined('TRX_ADDONS_CPT_COURSES_PT') && $post_type==TRX_ADDONS_CPT_COURSES_PT)
					|| (defined('TRX_ADDONS_CPT_SERVICES_PT') && $post_type==TRX_ADDONS_CPT_SERVICES_PT) ;
	}
}



// One-click import support
//------------------------------------------------------------------------

// Check MCKINNEY_POLITICS Addons in the required plugins
if ( !function_exists( 'mckinney_politics_trx_addons_importer_required_plugins' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_importer_required_plugins',	'mckinney_politics_trx_addons_importer_required_plugins', 10, 2 );
	function mckinney_politics_trx_addons_importer_required_plugins($not_installed='', $list='') {
		if (!mckinney_politics_exists_trx_addons() )
			$not_installed .= '<br>' . esc_html__('ThemeREX Addons', 'mckinney-politics');
		return $not_installed;
	}
}

// Set options for one-click importer
if ( !function_exists( 'mckinney_politics_trx_addons_importer_set_options' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_importer_options',	'mckinney_politics_trx_addons_importer_set_options' );
	function mckinney_politics_trx_addons_importer_set_options($options=array()) {
		if ( in_array('trx_addons', (array)mckinney_politics_storage_get('required_plugins')) && mckinney_politics_exists_trx_addons() ) {
			$options['additional_options'][] = 'trx_addons_%';	// Add slugs to export options for this plugin
		}
		return $options;
	}
}


// WP Editor addons
//------------------------------------------------------------------------

// Load required styles and scripts for admin mode
if ( !function_exists( 'mckinney_politics_trx_addons_editor_load_scripts_admin' ) ) {
	//Handler of add_action("admin_enqueue_scripts", 'mckinney_politics_trx_addons_editor_load_scripts_admin');
	function mckinney_politics_trx_addons_editor_load_scripts_admin() {
		// Add styles in the WP text editor
		add_editor_style( array(
							mckinney_politics_get_file_url('css/plugin.trx_addons.editor.css')
							)
						 );	
	}
}

if ( !function_exists( 'mckinney_politics_trx_addons_editor_init' ) ) {
	//Handler of add_filter( 'tiny_mce_before_init', 'mckinney_politics_trx_addons_editor_init', 11);
	function mckinney_politics_trx_addons_editor_init($opt) {
		if (!empty($opt['style_formats'])) {
			$style_formats = json_decode($opt['style_formats'], true);
			if (is_array($style_formats) && count($style_formats)>0 ) {
				foreach ($style_formats as $k=>$v) {
					if ( $v['title'] == esc_html__('List styles', 'mckinney-politics') ) {
						$style_formats[$k] = array(
							'title' => esc_html__('List styles', 'mckinney-politics'),
							'items' => array(
								array(
									'title' => esc_html__('Red dot', 'mckinney-politics'),
									'selector' => 'ul',
									'classes' => 'trx_addons_list trx_addons_list_dot_red'
								),
								array(
									'title' => esc_html__('Dark dot', 'mckinney-politics'),
									'selector' => 'ul',
									'classes' => 'trx_addons_list trx_addons_list_dot_dark'
								),
								array(
									'title' => esc_html__('Asterisk', 'mckinney-politics'),
									'selector' => 'ul',
									'classes' => 'trx_addons_list trx_addons_list_asterisk'
								),
								array(
									'title' => esc_html__('Arrow', 'mckinney-politics'),
									'selector' => 'ul',
									'classes' => 'trx_addons_list trx_addons_list_arrow'
								)
							)
						);
					}
				}
				$opt['style_formats'] = json_encode( $style_formats );		
			}
		}
		return $opt;
	}
}


// Thumb sizes
//------------------------------------------------------------------------

// Add thumb sizes
if ( !function_exists( 'mckinney_politics_trx_addons_add_thumb_sizes' ) ) {
	//Handler of add_filter( 'trx_addons_filter_add_thumb_sizes', 'mckinney_politics_trx_addons_add_thumb_sizes');
	function mckinney_politics_trx_addons_add_thumb_sizes($list=array()) {
		if (is_array($list)) {
			foreach ($list as $k=>$v) {
				if (in_array($k, array(
								'trx_addons-thumb-huge',
								'trx_addons-thumb-big',
								'trx_addons-thumb-medium',
								'trx_addons-thumb-small',
								'trx_addons-thumb-portrait',
								'trx_addons-thumb-avatar',
								'trx_addons-thumb-tiny',
								'trx_addons-thumb-masonry',
								'trx_addons-thumb-masonry-big'
								)
							)
						) unset($list[$k]);
			}
		}
		return $list;
	}
}

// Get thumb size
if ( !function_exists( 'mckinney_politics_trx_addons_get_thumb_size' ) ) {
	//Handler of add_filter( 'trx_addons_filter_get_thumb_size', 'mckinney_politics_trx_addons_get_thumb_size');
	function mckinney_politics_trx_addons_get_thumb_size($thumb_size='') {
		return str_replace(array(
							'trx_addons-thumb-huge',
							'trx_addons-thumb-huge-@retina',
							'trx_addons-thumb-big',
							'trx_addons-thumb-big-@retina',
							'trx_addons-thumb-medium',
							'trx_addons-thumb-medium-@retina',
							'trx_addons-thumb-small',
							'trx_addons-thumb-small-@retina',
							'trx_addons-thumb-portrait',
							'trx_addons-thumb-portrait-@retina',
							'trx_addons-thumb-avatar',
							'trx_addons-thumb-avatar-@retina',
							'trx_addons-thumb-tiny',
							'trx_addons-thumb-tiny-@retina',
							'trx_addons-thumb-masonry',
							'trx_addons-thumb-masonry-@retina',
							'trx_addons-thumb-masonry-big',
							'trx_addons-thumb-masonry-big-@retina',
							'trx_addons-thumb-masonry-big-extra',
							'trx_addons-thumb-masonry-big-extra-@retina'
							),
							array(
							'mckinney_politics-thumb-huge',
							'mckinney_politics-thumb-huge-@retina',
							'mckinney_politics-thumb-big',
							'mckinney_politics-thumb-big-@retina',
							'mckinney_politics-thumb-med',
							'mckinney_politics-thumb-med-@retina',
							'mckinney_politics-thumb-small',
							'mckinney_politics-thumb-small-@retina',
							'mckinney_politics-thumb-portrait',
							'mckinney_politics-thumb-portrait-@retina',
							'mckinney_politics-thumb-avatar',
							'mckinney_politics-thumb-avatar-@retina',
							'mckinney_politics-thumb-tiny',
							'mckinney_politics-thumb-tiny-@retina',
							'mckinney_politics-thumb-masonry',
							'mckinney_politics-thumb-masonry-@retina',
							'mckinney_politics-thumb-masonry-big',
							'mckinney_politics-thumb-masonry-big-@retina',
							'mckinney_politics-thumb-big-extra',
							'mckinney_politics-thumb-big-extra-@retina'
							),
							$thumb_size);
	}
}

// Get thumb size for the testimonials
if ( !function_exists( 'mckinney_politics_trx_addons_testimonials_thumb_size' ) ) {
	//Handler of add_filter( 'trx_addons_filter_testimonials_thumb_size',	'mckinney_politics_trx_addons_testimonials_thumb_size');
	function mckinney_politics_trx_addons_testimonials_thumb_size($thumb_size='') {
		return mckinney_politics_get_thumb_size('portrait');
	}
}


// Get thumb size for the services
if ( !function_exists( 'mckinney_politics_trx_addons_services_thumb_size' ) ) {
	//Handler of add_filter( 'trx_addons_filter_services_thumb_size',	'mckinney_politics_trx_addons_services_thumb_size');
	function mckinney_politics_trx_addons_services_thumb_size($thumb_size='') {
		return mckinney_politics_get_thumb_size('avatar');
	}
}

// Return tag for the item's title
if ( !function_exists( 'mckinney_politics_trx_addons_sc_item_title_tag' ) ) {
	//Handler of add_filter( 'trx_addons_filter_sc_item_title_tag', 'mckinney_politics_trx_addons_sc_item_title_tag');
	function mckinney_politics_trx_addons_sc_item_title_tag($tag='') {
		return $tag=='h1' ? 'h2' : $tag;
	}
}

// Return args for the item's button
if ( !function_exists( 'mckinney_politics_trx_addons_sc_item_button_args' ) ) {
	//Handler of add_filter( 'trx_addons_filter_sc_item_button_args', 'mckinney_politics_trx_addons_sc_item_button_args');
	function mckinney_politics_trx_addons_sc_item_button_args($args, $sc='') {
		if ($sc != 'sc_button') {
			$args['type'] = 'default';
			$args['icon_type'] = '';
			$args['icon_fontawesome'] = '';
			$args['icon_position'] = '';
		}
		return $args;
	}
}


// CPT support
//------------------------------------------------------------------------

// Enable/Disable CPT
if ( !function_exists( 'mckinney_politics_trx_addons_cpt_list' ) ) {
	//Handler of add_filter('trx_addons_cpt_list',	'mckinney_politics_trx_addons_cpt_list');
	function mckinney_politics_trx_addons_cpt_list($list=array()) {
		// To do: Enable/Disable CPT via add/remove it in the list
		if (is_array($list) && count($list) > 0) {
			$new = array();
			foreach ($list as $cpt)
				if (!in_array($cpt, array('courses')))	// List of the CPT disabled in the current theme
					$new[] = $cpt;
		    $list = $new;
		}
		return $list;
	}
}


// Widgets support
//------------------------------------------------------------------------

// Add sidebar
if ( !function_exists( 'mckinney_politics_trx_addons_list_sidebars' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_list_sidebars', 'mckinney_politics_trx_addons_list_sidebars' );
	function mckinney_politics_trx_addons_list_sidebars($list=array()) {
		return $list;
	}
}

// Add/Remove widgets
if ( !function_exists( 'mckinney_politics_trx_addons_widgets_list' ) ) {
	//Handler of add_filter('trx_addons_widgets_list',	'mckinney_politics_trx_addons_widgets_list');
	function mckinney_politics_trx_addons_widgets_list($list=array()) {
		// To do: Add/Remove widgets into list
		// If you add widget - in the theme's folder must exists /trx_addons/widgets/new_widget_name/new_widget_name.php
		
		return $list;
	}
}


// Shortcodes support
//------------------------------------------------------------------------

// Add/Remove shortcodes
if ( !function_exists( 'mckinney_politics_trx_addons_sc_list' ) ) {
	//Handler of add_filter('trx_addons_sc_list',	'mckinney_politics_trx_addons_sc_list');
	function mckinney_politics_trx_addons_sc_list($list=array()) {
		// To do: Add/Remove shortcodes into list
		// If you add new shortcode - in the theme's folder must exists /trx_addons/shortcodes/new_sc_name/new_sc_name.php
		return $list;
	}
}

// Add params into shortcode's atts
if ( !function_exists( 'mckinney_politics_trx_addons_sc_atts' ) ) {
	//Handler of add_filter( 'trx_addons_sc_atts', 'mckinney_politics_trx_addons_sc_atts', 10, 2);
	function mckinney_politics_trx_addons_sc_atts($atts, $sc) {
		
		// Param 'scheme'
		if (in_array($sc, array('trx_sc_content','trx_sc_blogger', 'trx_sc_courses', 'trx_sc_services', 'trx_sc_form', 'trx_sc_googlemap', 'trx_sc_promo', 'trx_sc_team', 'trx_sc_testimonials', 'trx_sc_events')))
			$atts['scheme'] = 'inherit';
		return $atts;
	}
}

// Add params into shortcodes VC map
if ( !function_exists( 'mckinney_politics_trx_addons_sc_map' ) ) {
	//Handler of add_filter( 'trx_addons_sc_map', 'mckinney_politics_trx_addons_sc_map', 10, 2);
	function mckinney_politics_trx_addons_sc_map($params, $sc) {

		// Param 'scheme'
		if (in_array($sc, array('trx_sc_content', 'trx_sc_blogger', 'trx_sc_courses', 'trx_sc_services', 'trx_sc_form', 'trx_sc_googlemap', 'trx_sc_promo', 'trx_sc_team', 'trx_sc_testimonials', 'trx_sc_events'))) {
			$params['params'][] = array(
					"param_name" => "scheme",
					"heading" => esc_html__("Color scheme", 'mckinney-politics'),
					"description" => wp_kses_data( __("Select color scheme to decorate this block", 'mckinney-politics') ),
					"group" => esc_html__('Colors', 'mckinney-politics'),
					"admin_label" => true,
					"value" => array_flip((array)mckinney_politics_get_list_schemes(true)),
					"type" => "dropdown"
				);
		}
		return $params;
	}
}

// Add params into shortcode's output
if ( !function_exists( 'mckinney_politics_trx_addons_sc_output' ) ) {
	//Handler of add_filter( 'trx_addons_sc_output', 'mckinney_politics_trx_addons_sc_output', 10, 4);
	function mckinney_politics_trx_addons_sc_output($output, $sc, $atts, $content) {
		
		// Param 'scheme'
		if (in_array($sc, array('trx_sc_googlemap'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_googlemap_content', 'class="scheme_'.esc_attr($atts['scheme']).' sc_googlemap_content', $output);
		} else if (in_array($sc, array('trx_sc_blogger'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_blogger ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_blogger ', $output);
		} else if (in_array($sc, array('trx_sc_courses'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_courses ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_courses ', $output);
		} else if (in_array($sc, array('trx_sc_services'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_services ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_services ', $output);
		} else if (in_array($sc, array('trx_sc_form'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_form ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_form ', $output);
		} else if (in_array($sc, array('trx_sc_promo'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_promo ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_promo ', $output);
		} else if (in_array($sc, array('trx_sc_team'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_team ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_team ', $output);
		} else if (in_array($sc, array('trx_sc_testimonials'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_testimonials ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_testimonials ', $output);
		} else if (in_array($sc, array('trx_sc_events'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_events ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_events ', $output);
		} else if (in_array($sc, array('trx_sc_content'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$output = str_replace('class="sc_content ', 'class="scheme_'.esc_attr($atts['scheme']).' sc_content ', $output);
		}
		return $output;
	}
}

// Add new types in the shortcodes
if ( !function_exists( 'mckinney_politics_trx_addons_sc_type' ) ) {
	//Handler of add_filter( 'trx_addons_sc_type', 'mckinney_politics_trx_addons_sc_type', 10, 2);
	function mckinney_politics_trx_addons_sc_type($list, $sc) {
		return $list;
	}
}


// Plugin API - theme-specific wrappers for plugin functions
//------------------------------------------------------------------------

// Debug functions wrappers
if (!function_exists('ddo')) { function ddo($obj, $level=-1) { return var_dump($obj); } }
if (!function_exists('dco')) { function dco($obj, $level=-1) { print_r($obj); } }
if (!function_exists('dcl')) { function dcl($msg, $level=-1) { echo '<br><pre>$msg</pre><br>'; } }
if (!function_exists('dfo')) { function dfo($obj, $level=-1) {} }
if (!function_exists('dfl')) { function dfl($msg, $level=-1) {} }

// Return image size multiplier
if (!function_exists('mckinney_politics_get_retina_multiplier')) {
	function mckinney_politics_get_retina_multiplier($force_retina=0) {
		static $mult = 0;
		if ($mult == 0) $mult = function_exists('trx_addons_get_retina_multiplier') ? trx_addons_get_retina_multiplier($force_retina) : 1;
		return max(1, $mult);
	}
}

// Return text for the "I agree ..." checkbox
if ( ! function_exists( 'mckinney_politics_trx_addons_privacy_text' ) ) {
    add_filter( 'trx_addons_filter_privacy_text', 'mckinney_politics_trx_addons_privacy_text' );
    function mckinney_politics_trx_addons_privacy_text( $text='' ) {
        return mckinney_politics_get_privacy_text();
    }
}

// Return slider layout
if (!function_exists('mckinney_politics_build_slider_layout')) {
	function mckinney_politics_build_slider_layout($args) {
		return function_exists('trx_addons_build_slider_layout') 
					? trx_addons_build_slider_layout($args) 
					: '';
	}
}

// Return links to the social profiles
if (!function_exists('mckinney_politics_get_socials_links')) {
	function mckinney_politics_get_socials_links($style='icons') {
		return function_exists('trx_addons_get_socials_links') 
					? trx_addons_get_socials_links($style)
					: '';
	}
}

// Return links to share post
if (!function_exists('mckinney_politics_get_share_links')) {
	function mckinney_politics_get_share_links($args=array()) {
		return function_exists('trx_addons_get_share_links') 
					? trx_addons_get_share_links($args)
					: '';
	}
}

// Return widgets args
if (!function_exists('mckinney_politics_get_widgets_args')) {
	function mckinney_politics_get_widgets_args() {
		return function_exists('trx_addons_get_widgets_args') 
					? trx_addons_get_widgets_args()
					: array(
						'before_widget' => '<aside id="%1$s" class="widget %2$s">',
						'after_widget'  => '</aside>',
						'before_title'  => '<h5 class="widget_title">',
						'after_title'   => '</h5>',
					);
	}
}

// Return image from the category
if (!function_exists('mckinney_politics_get_category_image')) {
	function mckinney_politics_get_category_image($term_id=0) {
		return function_exists('trx_addons_get_category_image') 
					? trx_addons_get_category_image($term_id)
					: '';
	}
}

// Return small image (icon) from the category
if (!function_exists('mckinney_politics_get_category_icon')) {
	function mckinney_politics_get_category_icon($term_id=0) {
		return function_exists('trx_addons_get_category_icon') 
					? trx_addons_get_category_icon($term_id)
					: '';
	}
}

// Return string with counters items
if (!function_exists('mckinney_politics_get_post_counters')) {
	function mckinney_politics_get_post_counters($counters='views') {
		return function_exists('trx_addons_get_post_counters')
					? str_replace('post_counters_item', 'post_meta_item post_counters_item', trx_addons_get_post_counters($counters))
					: '';
	}
}

// Return string with the likes counter for the specified comment
if (!function_exists('mckinney_politics_get_comment_counters')) {
	function mckinney_politics_get_comment_counters($counters = 'likes') {
		return function_exists('trx_addons_get_comment_counters') 
					? trx_addons_get_comment_counters($counters)
					: '';
	}
}

// Add query params to sort posts by views or likes
if (!function_exists('mckinney_politics_trx_addons_query_sort_order')) {
	//Handler of add_filter('mckinney_politics_filter_query_sort_order', 'mckinney_politics_trx_addons_query_sort_order', 10, 3);
	function mckinney_politics_trx_addons_query_sort_order($q=array(), $orderby='date', $order='desc') {
		if ($orderby == 'views') {
			$q['orderby'] = 'meta_value_num';
			$q['meta_key'] = 'trx_addons_post_views_count';
		} else if ($orderby == 'likes') {
			$q['orderby'] = 'meta_value_num';
			$q['meta_key'] = 'trx_addons_post_likes_count';
		}
		return $q;
	}
}

// Show contact form from plugin
if (!function_exists('mckinney_politics_show_contact_form')) {
	function mckinney_politics_show_contact_form($args=array()) {
		if (function_exists('trx_addons_show_contact_form')) 
			trx_addons_show_contact_form($args);
	}
}

// Add theme-specific options to the post's options
if (!function_exists('mckinney_politics_trx_addons_override_options')) {
    add_filter( 'trx_addons_filter_override_options', 'mckinney_politics_trx_addons_override_options');
    function mckinney_politics_trx_addons_override_options($options=array()) {
        return apply_filters('mckinney_politics_filter_override_options', $options);
    }
}

// Add plugin-specific rules into custom CSS
//------------------------------------------------------------------------

// Add css styles into global CSS stylesheet
if (!function_exists('mckinney_politics_trx_addons_get_css')) {
	//Handler of add_filter('mckinney_politics_filter_get_css', 'mckinney_politics_trx_addons_get_css', 10, 3);
	function mckinney_politics_trx_addons_get_css($css, $colors, $fonts) {
		
		if (isset($css['fonts'])) {
			$css['fonts'] .= <<<FONTS
.sc_price_price,
.trx_addons_tiny_text,
[class*="sc_input_hover_"] .sc_form_field_content,
.sc_skills .sc_skills_item_title,
.sc_action_item_link,
.sc_action_item_date,
.sc_action_item_description,
.sc_action_item_info,
.sc_events_detailed .sc_events_item,
.sc_icons_title,
.sc_table table th {
	font-family: {$fonts['h5']['family']};
}
.sc_item_subtitle,
.sc_price_period,
.sc_price_link,
.trx_addons_audio_player .audio_author,
.wp-block-button__link,
.sc_item_button a {
	font-family: {$fonts['p']['family']};
}
.sc_events_item_title,
.sc_events_item_day,
.trx_addons_dropcap,
.sc_action_item_subtitle,
.sc_action_item_title,
.sc_events_detailed .sc_events_item_title {
	font-family: {$fonts['h6']['family']};
}
[class*="sc_input_hover_"] input[type="text"],
[class*="sc_input_hover_"] input[type="number"],
[class*="sc_input_hover_"] input[type="email"],
[class*="sc_input_hover_"] input[type="password"],
[class*="sc_input_hover_"] input[type="search"],
[class*="sc_input_hover_"] select,
[class*="sc_input_hover_"] textarea {
	font-family: {$fonts['input']['family']};
}

FONTS;
		}
		
		if (isset($css['colors'])) {
			$css['colors'] .= <<<CSS

.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_icon:hover,
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_text a:hover {
	color: {$colors['text_hover']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_title > a:hover:after {
	border-color: {$colors['text_hover']};
}

/* User styles */
.trx_addons_accent,
.trx_addons_accent > * {
	color: {$colors['text_link']};
}
.trx_addons_accent_bg {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_text']};
}
.trx_addons_inverse {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_dark']};
}
.trx_addons_dark {
	color: {$colors['text_dark']};
}
.trx_addons_inverse {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_dark']};
}
.trx_addons_dropcap_style_1 {
	background-color: {$colors['text_link']};
}
.trx_addons_dropcap_style_2 {
	background-color: {$colors['text_dark']};
}
.trx_addons_tooltip {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
.trx_addons_tooltip:before {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_dark']};
}
.trx_addons_tooltip:after {
	border-top-color: {$colors['text_dark']};
}
ul.trx_addons_list_dot_red > li:before {
	background-color: {$colors['text_link']};
}
ul.trx_addons_list_dot_dark > li:before {
	background-color: {$colors['text_dark']};
}
ul.trx_addons_list_arrow > li:before {
	color: {$colors['text_link']};
}
ul.trx_addons_list.trx_addons_list_simple li {
	color: {$colors['text_link']};
}
blockquote.trx_addons_blockquote_style_1 {
	background-color: {$colors['alter_bg_color']};
}
blockquote.trx_addons_blockquote_style_1:before {
	color: {$colors['text_link']};
}
blockquote.trx_addons_blockquote_style_1 {
	color: {$colors['text']};
}
blockquote.trx_addons_blockquote_style_1 a,
blockquote.trx_addons_blockquote_style_1 cite {
	color: {$colors['alter_link']};
}
blockquote.trx_addons_blockquote_style_1 a:hover {
	color: {$colors['alter_hover']};
}
blockquote.trx_addons_blockquote_style_2 {
	background-color: {$colors['text_dark']};
	color: {$colors['inverse_text']};
}
blockquote.trx_addons_blockquote_style_2:before,
blockquote.trx_addons_blockquote_style_2 a,
blockquote.trx_addons_blockquote_style_2 cite {
	color: {$colors['inverse_link']};
}
blockquote.trx_addons_blockquote_style_2 a:hover {
	color: {$colors['inverse_hover']};
}

.trx_addons_hover_title {
	color: {$colors['inverse_text']};
}
.trx_addons_hover_text {
	color: {$colors['text_light']};
}
.trx_addons_hover_icon,
.trx_addons_hover_links a {
	color: {$colors['text_light']} !important;
}
.trx_addons_hover_icon:hover,
.trx_addons_hover_links a:hover {
	color: {$colors['inverse_text']} !important;
}

/* Posts slider */
.slider_swiper .slide_info.slide_info_large {
	background-color: {$colors['bg_color_alpha']};
}
.slider_swiper .slide_info.slide_info_large:hover {
	background-color: {$colors['bg_color']};
}
.slider_swiper .slide_info.slide_info_large .slide_cats a {
	color: {$colors['text_link']};
}
.slider_swiper .slide_info.slide_info_large .slide_title a {
	color: {$colors['text_dark']};
}
.slider_swiper .slide_info.slide_info_large .slide_date {
	color: {$colors['text']};
}
.slider_swiper .slide_info.slide_info_large:hover .slide_date {
	color: {$colors['text_light']};
}
.slider_swiper .slide_info.slide_info_large .slide_cats a:hover,
.slider_swiper .slide_info.slide_info_large .slide_title a:hover {
	color: {$colors['text_hover']};
}
.slider_swiper.slider_multi .slide_cats a:hover,
.slider_swiper.slider_multi .slide_title a:hover,
.slider_swiper.slider_multi a:hover .slide_title {
	color: {$colors['text_hover']};
}
.slider_swiper .swiper-pagination-bullet:hover,
.slider_swiper.slider_pagination .swiper-pagination-bullet-active {
	background-color: {$colors['text_link']};
}
.slider_swiper.slider_controls_bottom .slider_prev,
.slider_swiper.slider_controls_bottom .slider_next {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
.slider_swiper.slider_controls_bottom .slider_prev:hover,
.slider_swiper.slider_controls_bottom .slider_next:hover {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}
.slider_swiper.slider_controls_side .slider_prev,
.slider_swiper.slider_controls_side .slider_next {
	background-color: {$colors['text_link_alpha']};
}
.slider_swiper.slider_controls_side .slider_prev:hover,
.slider_swiper.slider_controls_side .slider_next:hover {
	background-color: {$colors['text_link']};
}

/* Widgets 
--------------------------------------------------- */

/* Widget with bg image */
aside.widget_bg_image a,
aside.widget_bg_image ul li a {
	color: {$colors['inverse_text']};
}
aside.widget_bg_image a:hover,
aside.widget_bg_image ul li a:hover {
	color: {$colors['alter_hover']};
}

/* Audio */
.trx_addons_audio_player.without_cover {
	border-color: {$colors['bd_color']};
}
.trx_addons_audio_player .audio_caption,
.trx_addons_audio_player .audio_author {
	color: {$colors['inverse_text']};
}
.trx_addons_audio_player .mejs-container .mejs-controls .mejs-time {
	color: {$colors['inverse_text']};
}

/* Categories list */
.widget_categories_list .categories_list_style_2 .categories_list_title a:hover {
	color: {$colors['text_dark']};
}

/* Contacts */
.widget_contacts .contacts_info {
	color: {$colors['text_dark']};
}
.widget_contacts .contacts_socials a {
	color: {$colors['text_dark']};
}
.widget_contacts .contacts_socials a:hover {
	color: {$colors['alter_hover']};
}

/* Socials */
.widget_socials .social_item span {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
.widget_socials .social_item a:hover span {
	color: {$colors['bg_color']};
	background-color: {$colors['text_hover']};
}
.slider_engine_revo .widget_socials .social_item span {
	color: {$colors['text_dark']};
}
.slider_engine_revo .widget_socials .social_item a:hover span {
	color: {$colors['text_link']};
}

/* Popular posts */
aside .trx_addons_tabs .trx_addons_tabs_titles li a {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
aside .trx_addons_tabs .trx_addons_tabs_titles li a:hover,
aside .trx_addons_tabs .trx_addons_tabs_titles li.ui-tabs-active a {
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}

/* Recent News */
.sc_recent_news_header {
	border-color: {$colors['text_dark']};
}
.sc_recent_news_header_category_item_more {
	color: {$colors['text_link']};
}
.sc_recent_news_header_more_categories {
	border-color: {$colors['alter_bd_color']};
	background-color:{$colors['alter_bg_color']};
}
.sc_recent_news_header_more_categories > a {
	color:{$colors['alter_link']};
}
.sc_recent_news_header_more_categories > a:hover {
	color:{$colors['alter_hover']};
	background-color:{$colors['alter_bg_hover']};
}
.sc_recent_news .post_counters_item,
.sc_recent_news .post_counters .post_counters_edit a {
	color:{$colors['inverse_text']};
	background-color:{$colors['text_link']};
}
.sc_recent_news .post_counters_item:hover,
.sc_recent_news .post_counters .post_counters_edit a:hover {
	color:{$colors['bg_color']};
	background-color:{$colors['text_dark']};
}
.sidebar .sc_recent_news .post_counters_item:hover,
.sidebar .sc_recent_news .post_counters .post_counters_edit a:hover {
	color:{$colors['alter_dark']};
	background-color:{$colors['alter_bg_color']};
}
.sc_recent_news_style_news-magazine .post_accented_border {
	border-color: {$colors['bd_color']};
}
.sc_recent_news_style_news-excerpt .post_item {
	border-color: {$colors['bd_color']};
}

/* Twitter */
.widget_twitter div {
	color: {$colors['text']};
}

/* Video */
.trx_addons_video_player.with_cover .video_hover {
	color: {$colors['inverse_text']};
	background: {$colors['text_link_alpha']};
}
.trx_addons_video_player.with_cover .video_hover:hover {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}




/* Shortcodes
--------------------------------------------------- */

.sc_item_subtitle {
	color:{$colors['text_link']};
}
.wp-block-button:not(.is-style-outline) .wp-block-button__link,
.sc_item_button a:not(.sc_button_bg_image) {
	color:{$colors['inverse_text']};
	background-color: {$colors['text_hover']};
}
.is-style-outline > .wp-block-button__link, .wp-block-button__link.is-style-outline {
	color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}
.wp-block-button:not(.is-style-outline) .wp-block-button__link,
.sc_item_button a:not(.sc_button_bg_image):not([class*="sc_button_hover_"]),
.sc_item_button a:not(.sc_button_bg_image).sc_button_hover_slide_left {    	background: linear-gradient(to right, 	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_item_button a:not(.sc_button_bg_image).sc_button_hover_slide_right {    background: linear-gradient(to left, 	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_item_button a:not(.sc_button_bg_image).sc_button_hover_slide_top {    	background: linear-gradient(to bottom, 	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.sc_item_button a:not(.sc_button_bg_image).sc_button_hover_slide_bottom {   background: linear-gradient(to top, 	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.sc_item_button a:not(.sc_button_bg_image):not([class*="sc_button_hover_"]).sc_button_simple,
.sc_item_button a:not(.sc_button_bg_image).sc_button_simple.sc_button_hover_slide_left {    	background: linear-gradient(to right, 	{$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_item_button a:not(.sc_button_bg_image).sc_button_simple.sc_button_hover_slide_right {    background: linear-gradient(to left, 	{$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_item_button a:not(.sc_button_bg_image).sc_button_simple.sc_button_hover_slide_top {    	background: linear-gradient(to bottom, 	{$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.sc_item_button a:not(.sc_button_bg_image).sc_button_simple.sc_button_hover_slide_bottom {   background: linear-gradient(to top, 	{$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }
.wp-block-button:not(.is-style-outline) .wp-block-button__link:hover,
.sc_item_button a:not(.sc_button_bg_image):hover {
	color:{$colors['inverse_dark']} !important;
    background-position: left bottom;
}
.is-style-outline > .wp-block-button__link:hover, 
.wp-block-button__link.is-style-outline:hover {
	color: {$colors['text_hover']};
	border-color: {$colors['text_hover']};
}
.sc_item_button a:not(.sc_button_bg_image):not([class*="sc_button_hover_"]):hover {
	background-color:{$colors['text_dark']};
}
.sc_item_button a.sc_button_simple:not(.sc_button_bg_image) {
	color:{$colors['inverse_text']};
}
.sc_item_button a.sc_button_simple:not(.sc_button_bg_image):hover {
	color:{$colors['inverse_text']} !important;
}

.trx_addons_hover_content .trx_addons_hover_links a {
	color:{$colors['inverse_text']};
	background-color:{$colors['text_link']};
}
.trx_addons_hover_content .trx_addons_hover_links a:not([class*="sc_button_hover_"]),
.trx_addons_hover_content .trx_addons_hover_links a.sc_button_hover_slide_left {	background: linear-gradient(to right,	{$colors['inverse_text']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.trx_addons_hover_content .trx_addons_hover_links a.sc_button_hover_slide_right {	background: linear-gradient(to left,	{$colors['inverse_text']} 50%, {$colors['text_link']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.trx_addons_hover_content .trx_addons_hover_links a.sc_button_hover_slide_top {		background: linear-gradient(to bottom,	{$colors['inverse_text']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.trx_addons_hover_content .trx_addons_hover_links a.sc_button_hover_slide_bottom {	background: linear-gradient(to top,		{$colors['inverse_text']} 50%, {$colors['text_link']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.trx_addons_hover_content .trx_addons_hover_links a:hover {
	color:{$colors['text_link']} !important;
    background-position: left bottom;
}
.trx_addons_hover_content .trx_addons_hover_links a:not([class*="sc_button_hover_"]):hover {
	background-color:{$colors['inverse_text']};
}

/* Action */
.sc_action_item_event .sc_action_item_subtitle {
	color:{$colors['text_link']};
}
.sc_action_item_description {
	color:{$colors['text_dark']};
}
.sc_action_item_date,
.sc_action_item_info {
	color:{$colors['text_dark']};
	border-color:{$colors['text']};
}
.sc_action_item_default .sc_action_item_link {
	color: {$colors['inverse_text']};
	border-color: {$colors['inverse_text']};
}
.sc_action_item_event .sc_action_item_link {
	color: {$colors['text_dark']};
	border-color: {$colors['text_dark']};
}
.sc_action_item .sc_action_item_link:not([class*="sc_button_hover_"]),
.sc_action_item .sc_action_item_link.sc_button_hover_slide_left {		background: linear-gradient(to right,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_action_item .sc_action_item_link.sc_button_hover_slide_right {		background: linear-gradient(to left,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_action_item .sc_action_item_link.sc_button_hover_slide_top {		background: linear-gradient(to bottom,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.sc_action_item .sc_action_item_link.sc_button_hover_slide_bottom {		background: linear-gradient(to top,		{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }
.sc_action_item .sc_action_item_link:hover {
	color: {$colors['inverse_text']};
	border-color: {$colors['text_dark']};
    background-position: left bottom;
}
.sc_action_item .sc_action_item_link:not([class*="sc_button_hover_"]):hover {
	color: {$colors['inverse_text']};
	border-color: {$colors['text_dark']};
	background-color: {$colors['text_dark']};
}


.sc_services_default .sc_services_item_title .count {
	color: {$colors['text_light']};
}
.sc_services_default .sc_services_item_button a:before {
	background-color: {$colors['text_link']};
}
.sc_services_default .sc_services_item_button a:hover:before {
	background-color: {$colors['text_hover']};
}

/* Anchor */
#toc_menu .toc_menu_icon {

}
#toc_menu .toc_menu_icon:before {
	color: {$colors['inverse_text']};
}
#toc_menu .toc_menu_item:hover .toc_menu_icon:before,
#toc_menu .toc_menu_item_active .toc_menu_icon:before {
	color: {$colors['inverse_text']};
}
#toc_menu .toc_menu_icon_default:before {
	background-color: {$colors['inverse_text']};
}
#toc_menu .toc_menu_item:hover .toc_menu_icon_default:before,
#toc_menu .toc_menu_item_active .toc_menu_icon_default:before {
	background-color: {$colors['inverse_text']};
}
#toc_menu .toc_menu_description {
	color: {$colors['text_link']};
}

/* Blogger */
.sc_blogger_default .sc_blogger_item {
	background-color: {$colors['bg_color']};
}
.sc_blogger_classic .sc_blogger_item {
	background-color: {$colors['alter_bg_color']};
}
.sc_blogger_default .sc_blogger_post_meta,
.sc_blogger_classic .sc_blogger_post_meta {
	color: {$colors['alter_light']};
}
.sc_blogger_default .sc_blogger_item_title a{
	color: {$colors['alter_dark']};
}
.sc_blogger_classic .sc_blogger_item_title a {
	color: {$colors['inverse_text']};
}
.sc_blogger_default .sc_blogger_item_title a:hover {
	color: {$colors['text_link']};
}
.sc_blogger_classic .sc_blogger_item_title a:hover {
	color: {$colors['inverse_text']};
}
.sc_blogger_default .sc_blogger_post_meta {
	color: {$colors['alter_light']};
}
.sc_blogger_default .sc_blogger_item_content {
	color: {$colors['alter_text']};
}
.sc_blogger_classic .sc_blogger_post_meta a,
.sc_blogger_classic .sc_blogger_post_meta a:hover {
	color: {$colors['inverse_text']};
}
.sc_blogger_classic .sc_blogger_item_content {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link_alpha']};
}
.sc_blogger_classic .sc_blogger_item .more-link {
	color: {$colors['alter_link']};
}
.sc_blogger_classic .sc_blogger_item .more-link:hover {
	color: {$colors['alter_dark']};
}

/* Courses */
.sc_courses_default .sc_courses_item {
	background-color: {$colors['alter_bg_color']};
}
.sc_courses_default .sc_courses_item_categories {
	background-color: {$colors['alter_dark']};
}
.sc_courses_default .sc_courses_item_categories a {
	color: {$colors['inverse_text']};
}
.sc_courses_default .sc_courses_item_categories a:hover {
	color: {$colors['alter_link']};
}
.sc_courses_default .sc_courses_item_price {
	color: {$colors['alter_link']};
}
.sc_courses_default .sc_courses_item_period {
	color: {$colors['alter_light']};
}



/* Events */
.sc_events_default .sc_events_item {
	background-color: {$colors['bg_color']};
}
.sc_events_default .sc_events_item_date {
	color: {$colors['inverse_text']};
}
.sc_events_default .sc_events_item:hover .sc_events_item_date {
	background-color: {$colors['text_link']};
}
.sc_events_default .sc_events_item_title {
	color: {$colors['text_dark']};
}
.sc_events_default .sc_events_item:hover .sc_events_item_title {
	color: {$colors['alter_link']};
}
.sc_events_default .sc_events_item_button {
	color: {$colors['text_link']};
}
.sc_events_default .sc_events_item:hover .sc_events_item_button {
	color: {$colors['text_hover']};
}
.sc_events_default .sc_events_item_button:before {
	background-color: {$colors['text_link']};
}

.sc_events_detailed .sc_events_item,
.sc_events_detailed .sc_events_item_time_wrap:before,
.sc_events_detailed .sc_events_item_button_wrap:before {
	border-color: {$colors['text_link']};
}
.sc_events_detailed .sc_events_item_date,
.sc_events_detailed .sc_events_item_button {
	color: {$colors['text_link']};
}
.sc_events_detailed .sc_events_item_title {
	color: {$colors['text_dark']};
}
.sc_events_detailed .sc_events_item_time {
	color: {$colors['text']};
}
.sc_events_detailed .sc_events_item:hover {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_text']};
}
.sc_events_detailed .sc_events_item:hover,
.sc_events_detailed .sc_events_item:hover .sc_events_item_date,
.sc_events_detailed .sc_events_item:hover .sc_events_item_button,
.sc_events_detailed .sc_events_item:hover .sc_events_item_title,
.sc_events_detailed .sc_events_item:hover .sc_events_item_time {
	color: {$colors['inverse_text']};
}
.sc_events_detailed .sc_events_item:hover,
.sc_events_detailed .sc_events_item:hover .sc_events_item_date_wrap,
.sc_events_detailed .sc_events_item:hover .sc_events_item_time_wrap:before,
.sc_events_detailed .sc_events_item:hover .sc_events_item_button_wrap:before {
	border-color: {$colors['inverse_text']};
}

/* Form */
.sc_form_field_title {
	color: {$colors['text_dark']};
}
.sc_form_field input[type="text"],
.sc_form_field textarea {
	color: {$colors['input_text']};
	border-color: {$colors['input_bd_color']};
	background-color: {$colors['input_bg_color']};
}

.sc_form_field input[type="text"]:focus,
.sc_form_field textarea:focus {
	color: {$colors['input_dark']};
	border-color: {$colors['input_bd_hover']};
	background-color: {$colors['input_bg_hover']};
}
.sc_form_info_item .sc_form_info_top {
	color: {$colors['text_dark']};
}

.sc_form_field button {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
.sc_form_field button:not([class*="sc_button_hover_"]),
.sc_form_field button.sc_button_hover_slide_left {		background: linear-gradient(to right,	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_form_field button.sc_button_hover_slide_right { 	background: linear-gradient(to left,	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_form_field button.sc_button_hover_slide_top {		background: linear-gradient(to bottom,	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.sc_form_field button.sc_button_hover_slide_bottom {	background: linear-gradient(to top,		{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.sc_form_field button:hover {
	color: {$colors['bg_color']} !important;
    background-position: left bottom;
}
.sc_form_field button:not([class*="sc_button_hover_"]):hover {
	background-color: {$colors['text_dark']} !important;
}
.sc_form .sc_form_info_icon {
	color: {$colors['text_link']};
}
.sc_form .sc_form_info_data > a,
.sc_form .sc_form_info_data > span {
	color: {$colors['text']};
}
.sc_form .sc_form_info_data > a:hover {
	color: {$colors['text_link']};
}

.vc_row-has-fill.scheme_dark .sc_form label{
    color: {$colors['inverse_text']};
}

.vc_row-has-fill.scheme_dark .sc_form label:before{
      color: {$colors['text']};
}

/* input hovers */
[class*="sc_input_hover_"] .sc_form_field_content {
	color: {$colors['text_dark']};
}
.sc_input_hover_accent input[type="text"]:focus,
.sc_input_hover_accent input[type="number"]:focus,
.sc_input_hover_accent input[type="email"]:focus,
.sc_input_hover_accent input[type="password"]:focus,
.sc_input_hover_accent input[type="search"]:focus,
.sc_input_hover_accent select:focus,
.sc_input_hover_accent textarea:focus {
	/*box-shadow: 0px 0px 0px 2px {$colors['text_link']};*/
	border-color: {$colors['text_link']} !important;
}
.sc_input_hover_accent .sc_form_field_hover:before {
	color: {$colors['text_link_alpha']};
}

.sc_input_hover_path .sc_form_field_graphic {
	stroke: {$colors['input_bd_color']};
}

.sc_input_hover_jump .sc_form_field_content {
	color: {$colors['input_dark']};
}
.sc_input_hover_jump .sc_form_field_content:before {
	color: {$colors['text_link']};
}
.sc_input_hover_jump input[type="text"],
.sc_input_hover_jump input[type="number"],
.sc_input_hover_jump input[type="email"],
.sc_input_hover_jump input[type="password"],
.sc_input_hover_jump input[type="search"],
.sc_input_hover_jump textarea {
	border-color: {$colors['input_bd_color']};
}
.sc_input_hover_jump input[type="text"]:focus,
.sc_input_hover_jump input[type="number"]:focus,
.sc_input_hover_jump input[type="email"]:focus,
.sc_input_hover_jump input[type="password"]:focus,
.sc_input_hover_jump input[type="search"]:focus,
.sc_input_hover_jump textarea:focus {
	border-color: {$colors['text_link']} !important;
}

.sc_input_hover_underline .sc_form_field_hover:before {
	background-color: {$colors['input_bd_color']};
}
.sc_input_hover_underline input:focus + .sc_form_field_hover:before,
.sc_input_hover_underline textarea:focus + .sc_form_field_hover:before,
.sc_input_hover_underline input.filled + .sc_form_field_hover:before,
.sc_input_hover_underline textarea.filled + .sc_form_field_hover:before {
	background-color: {$colors['text_link']};
}
.sc_input_hover_underline .sc_form_field_content {
	color: {$colors['input_dark']};
}
.sc_input_hover_underline input:focus,
.sc_input_hover_underline textarea:focus,
.sc_input_hover_underline input.filled,
.sc_input_hover_underline textarea.filled,
.sc_input_hover_underline input:focus + .sc_form_field_hover > .sc_form_field_content,
.sc_input_hover_underline textarea:focus + .sc_form_field_hover > .sc_form_field_content,
.sc_input_hover_underline input.filled + .sc_form_field_hover > .sc_form_field_content,
.sc_input_hover_underline textarea.filled + .sc_form_field_hover > .sc_form_field_content {
	color: {$colors['text_link']} !important;
}

.sc_input_hover_iconed .sc_form_field_hover {
	color: {$colors['input_text']};
}
.sc_input_hover_iconed input:focus + .sc_form_field_hover,
.sc_input_hover_iconed textarea:focus + .sc_form_field_hover,
.sc_input_hover_iconed input.filled + .sc_form_field_hover,
.sc_input_hover_iconed textarea.filled + .sc_form_field_hover {
	color: {$colors['input_dark']};
}

/* Googlemap */
.sc_googlemap_content,
.scheme_self.sc_googlemap_content {
	color: {$colors['text']};
	background-color: {$colors['bg_color']};
}
.sc_googlemap_content b,
.sc_googlemap_content strong,
.scheme_self.sc_googlemap_content b,
.scheme_self.sc_googlemap_content strong {
	color: {$colors['text_dark']};
}
.sc_googlemap_content_detailed:before {
	background-color: {$colors['text_link']};
}

/* Icons */
.sc_icons .sc_icons_icon {
	color: {$colors['text_link']};
}
.sc_icons .sc_icons_item_linked:hover .sc_icons_icon {
	color: {$colors['text_dark']};
}
.sc_icons .sc_icons_title {
	color: {$colors['text_link']};
}
.sc_icons_description,
.sc_icons_modern .sc_icons_description {
	color: {$colors['text_dark']};
}

/* Price */
.sc_price {
	color: {$colors['text']};
	background-color: {$colors['alter_bg_color']};
}
.sc_price .sc_price_icon {
	color: {$colors['text_link']};
}
.sc_price .sc_price_icon:hover {
	color: {$colors['text_hover']};
}
.sc_price_period {
	color: {$colors['text_dark']};
}
.sc_price .sc_price_price {
	color: {$colors['text_link']};
}
.sc_price .sc_price_description {
	color: {$colors['text_dark']};
}
.sc_price_link {
	color: {$colors['inverse_text']};
}
.sc_price_link:not([class*="sc_button_hover_"]),
.sc_price_link.sc_button_hover_slide_left {			background: linear-gradient(to right,	{$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_price_link.sc_button_hover_slide_right {		background: linear-gradient(to left,	{$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.sc_price_link.sc_button_hover_slide_top {			background: linear-gradient(to bottom,	{$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.sc_price_link.sc_button_hover_slide_bottom {		background: linear-gradient(to top,		{$colors['text_link']} 50%, {$colors['text_hover']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }
.sc_price_link:hover {
	color: {$colors['inverse_text']};
    background-position: left bottom;
	/*background-color: {$colors['text_dark']};*/
}
.sc_price_link:not([class*="sc_button_hover_"]):hover {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_dark']};
}

/* Promo */
.scheme_self.sc_promo {
	background-color: {$colors['bg_color']};
}
.sc_promo.sc_promo_size_normal .sc_promo_descr,
.scheme_self.sc_promo.sc_promo_size_normal .sc_promo_descr {}

/* Skills (Counters) */
.sc_skills_counter .sc_skills_icon {
	color:{$colors['text_link']};
}
.sc_skills .sc_skills_total,
.sc_skills .sc_skills_item_title,
.sc_skills .sc_skills_legend_title,
.sc_skills .sc_skills_legend_value {
	color:{$colors['text_dark']};
}
.sc_skills_counter .sc_skills_total {
	color:{$colors['text_link']};
}
.sc_skills_pie.sc_skills_compact_off .sc_skills_item_title {
	color:{$colors['text_link']};
}

/* Socials */
.sc_socials .socials_wrap a {
	color: {$colors['text']};
}
.sc_socials .socials_wrap a:hover {
	color: {$colors['text_link']};
}

/* Table */
.sc_table table tr:nth-child(odd) {
    background-color: {$colors['alter_bg_color']};
}
.sc_table table tr:first-child {
	color: {$colors['inverse_text']};
	background-color: {$colors['bd_color']};
}
.sc_table table td {
	color: {$colors['text']};
	border-color: {$colors['alter_bd_color']};
}

/* Testimonials */
.sc_testimonials_item_content {
	color: {$colors['text']};
}
.sc_testimonials_item_author {
	color: {$colors['text_dark']};
}
.sc_testimonials_item_author_title {
	color: {$colors['text_dark']};
}
.sc_testimonials_item_author_subtitle {
	color: {$colors['text_link']};
}
.sc_testimonials_simple .sc_testimonials_item_author_data:before  {
	background-color: {$colors['text']};
}
.sc_testimonials_item_wrap:before {
	color: {$colors['text_link']};
}

/* Team */
.sc_team_default .sc_team_item {
	background-color: {$colors['alter_bg_color']};
}
.sc_team_default .sc_team_item_subtitle {
	color: {$colors['text_link']};
}



/* Utils
--------------------------------------------------- */

/* Scroll to top */
.trx_addons_scroll_to_top,
.trx_addons_cv .trx_addons_scroll_to_top {
	border-color: {$colors['text_link']};
	background-color: {$colors['text_link']};
	color: {$colors['inverse_text']};
}
.trx_addons_scroll_to_top:hover,
.trx_addons_cv .trx_addons_scroll_to_top:hover {
	border-color: {$colors['text_dark']};
	background-color: {$colors['text_dark']};
	color: {$colors['inverse_text']};
}
.menu_style_side .trx_addons_scroll_to_top {
	border-color: transparent;
	background-color: transparent;
	color: {$colors['inverse_text']};
}
.menu_style_side .trx_addons_scroll_to_top:hover {
	border-color: transparent;
	background-color: transparent;
	color: {$colors['text_link']};
}

/* Profiler */
.trx_addons_profiler {
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['alter_bd_hover']};
}
.trx_addons_profiler_title {
	color: {$colors['alter_dark']};
}
.trx_addons_profiler table td,
.trx_addons_profiler table th {
	border-color: {$colors['alter_bd_color']};
}
.trx_addons_profiler table td {
	color: {$colors['alter_text']};
}
.trx_addons_profiler table th {
	background-color: {$colors['alter_light']};
	color: {$colors['alter_dark']};
}


/* CV */
.trx_addons_cv,
.trx_addons_cv_body_wrap {
	color: {$colors['alter_text']};
	background-color:{$colors['alter_bg_color']};
}
.trx_addons_cv a {
	color: {$colors['alter_link']};
}
.trx_addons_cv a:hover {
	color: {$colors['alter_hover']};
}

.trx_addons_cv_header {
	background-color: {$colors['bg_color']};
}
.trx_addons_cv_header_image img {
	border-color: {$colors['text_dark']};
}
.trx_addons_cv_header .trx_addons_cv_header_letter,
.trx_addons_cv_header .trx_addons_cv_header_text {
	color: {$colors['text_dark']};
}
.trx_addons_cv_header .trx_addons_cv_header_socials .social_item > a {
	color: {$colors['text_dark_alpha']};	
}
.trx_addons_cv_header .trx_addons_cv_header_socials .social_item > a:hover {
	color: {$colors['text_dark']};	
}

.trx_addons_cv_navi_buttons .trx_addons_cv_navi_buttons_area .trx_addons_cv_navi_buttons_item {
	color: {$colors['alter_light']};
	background-color: {$colors['alter_bg_color']};
	border-color: {$colors['bg_color']};
}
.trx_addons_cv_navi_buttons .trx_addons_cv_navi_buttons_area .trx_addons_cv_navi_buttons_item_active,
.trx_addons_cv_navi_buttons .trx_addons_cv_navi_buttons_area .trx_addons_cv_navi_buttons_item:hover {
	color: {$colors['alter_dark']};
	border-color: {$colors['alter_bg_color']};
}


.trx_addons_cv .trx_addons_cv_section_title,
.trx_addons_cv .trx_addons_cv_section_title a {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_section_title.ui-state-active {
	border-color: {$colors['alter_dark']};
}
.trx_addons_cv_section_content .trx_addons_tabs .trx_addons_tabs_titles li > a {
	color: {$colors['alter_light']};
}
.trx_addons_cv_section_content .trx_addons_tabs .trx_addons_tabs_titles li.ui-state-active > a,
.trx_addons_cv_section_content .trx_addons_tabs .trx_addons_tabs_titles li > a:hover {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_section .trx_addons_pagination > * {
	color:{$colors['alter_text']};
}
.trx_addons_cv_section .trx_addons_pagination > a:hover {
	color: {$colors['alter_dark']};
}
.trx_addons_pagination > span.active {
	color: {$colors['alter_dark']};
	border-color: {$colors['alter_dark']};
}
.trx_addons_cv_breadcrumbs .trx_addons_cv_breadcrumbs_item {
	color: {$colors['alter_light']};
}
.trx_addons_cv_breadcrumbs a.trx_addons_cv_breadcrumbs_item:hover {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_single .trx_addons_cv_single_title {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_single .trx_addons_cv_single_subtitle {
	color: {$colors['alter_light']};
}

.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_2 .trx_addons_cv_resume_column:nth-child(2n+2) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+2) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+3) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+2) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+3) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+4) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_2 .trx_addons_cv_resume_column:nth-child(2n+3) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_2 .trx_addons_cv_resume_column:nth-child(2n+4) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+4) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+5) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_3 .trx_addons_cv_resume_column:nth-child(3n+6) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+5) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+6) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+7) .trx_addons_cv_resume_item,
.trx_addons_tabs_content_delimiter .trx_addons_cv_resume_columns_4 .trx_addons_cv_resume_column:nth-child(4n+8) .trx_addons_cv_resume_item {
	border-color: {$colors['alter_bd_color']};
}
.trx_addons_cv_resume_item_meta {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_item .trx_addons_cv_resume_item_title,
.trx_addons_cv_resume_item .trx_addons_cv_resume_item_title a {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_item_subtitle {
	color: {$colors['alter_light']};
}
.trx_addons_cv_resume_style_skills .trx_addons_cv_resume_item_skills {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_style_skills .trx_addons_cv_resume_item_skill:after {
	border-color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_style_education .trx_addons_cv_resume_item_number {
	color: {$colors['alter_light']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_icon {
	color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_title > a:after {
	border-top-color: {$colors['alter_dark']};
}
.trx_addons_cv_resume_style_services .trx_addons_cv_resume_item_text a {
	color: {$colors['alter_dark']};
}

.trx_addons_cv_portfolio_item .trx_addons_cv_portfolio_item_title,
.trx_addons_cv_portfolio_item .trx_addons_cv_portfolio_item_title a {
	color: {$colors['alter_dark']};
}

.trx_addons_cv_testimonials_item .trx_addons_cv_testimonials_item_title,
.trx_addons_cv_testimonials_item .trx_addons_cv_testimonials_item_title a {
	color: {$colors['alter_dark']};
}

.trx_addons_cv_certificates_item .trx_addons_cv_certificates_item_title,
.trx_addons_cv_certificates_item .trx_addons_cv_certificates_item_title a {
	color: {$colors['alter_dark']};
}

/* Contact form */
.trx_addons_cv .trx_addons_contact_form .trx_addons_contact_form_title {
	color: {$colors['alter_dark']};
}
.trx_addons_cv .trx_addons_contact_form_field_title {
	color: {$colors['alter_dark']};
}
.trx_addons_contact_form .trx_addons_contact_form_field input[type="text"],
.trx_addons_contact_form .trx_addons_contact_form_field textarea {
	border-color: {$colors['alter_bd_color']};
	color: {$colors['alter_text']};
}
.trx_addons_contact_form .trx_addons_contact_form_field input[type="text"]:focus,
.trx_addons_contact_form .trx_addons_contact_form_field textarea:focus {
	background-color: {$colors['alter_bg_hover']};
	color: {$colors['alter_dark']};
}
.trx_addons_contact_form_field button {
	background-color: {$colors['alter_dark']};
	border-color: {$colors['alter_dark']};
	color: {$colors['bg_color']};
}
.trx_addons_contact_form_field button:hover {
	color: {$colors['alter_dark']};
}
.trx_addons_contact_form_info_icon {
	color: {$colors['alter_light']};
}
.trx_addons_contact_form_info_area {
	color: {$colors['alter_dark']};
}
.trx_addons_contact_form_info_item_phone .trx_addons_contact_form_info_data {
	color: {$colors['alter_dark']} !important;
}

/* Page About Me */
.trx_addons_cv_about_page .trx_addons_cv_single_title {
	color: {$colors['alter_dark']};
}

CSS;
		}

		return $css;
	}
}
?>