<?php
/* Tribe Events Calendar support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 1 - register filters, that add/remove lists items for the Theme Options
if (!function_exists('mckinney_politics_tribe_events_theme_setup1')) {
	add_action( 'after_setup_theme', 'mckinney_politics_tribe_events_theme_setup1', 1 );
	function mckinney_politics_tribe_events_theme_setup1() {
		add_filter( 'mckinney_politics_filter_list_sidebars', 'mckinney_politics_tribe_events_list_sidebars' );
	}
}

// Theme init priorities:
// 3 - add/remove Theme Options elements
if (!function_exists('mckinney_politics_tribe_events_theme_setup3')) {
	add_action( 'after_setup_theme', 'mckinney_politics_tribe_events_theme_setup3', 3 );
	function mckinney_politics_tribe_events_theme_setup3() {
		if (mckinney_politics_exists_tribe_events()) {
			mckinney_politics_storage_merge_array('options', '', array(
				// Section 'Tribe Events' - settings for show pages
				'events' => array(
					"title" => esc_html__('Events', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select parameters to display the events pages', 'mckinney-politics') ),
					"type" => "section"
					),
				'expand_content_events' => array(
					"title" => esc_html__('Expand content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'mckinney-politics') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
				'header_widgets_events' => array(
					"title" => esc_html__('Header widgets', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on the events pages', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'sidebar_widgets_events' => array(
					"title" => esc_html__('Sidebar widgets', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select sidebar to show on the events pages', 'mckinney-politics') ),
					"std" => 'tribe_events_widgets',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'sidebar_position_events' => array(
					"title" => esc_html__('Sidebar position', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select position to show sidebar on the events pages', 'mckinney-politics') ),
					"refresh" => false,
					"std" => 'left',
					"options" => mckinney_politics_get_list_sidebars_positions(),
					"type" => "select"
					),
				'widgets_above_page_events' => array(
					"title" => esc_html__('Widgets above the page', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show above page (content and sidebar)', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_above_content_events' => array(
					"title" => esc_html__('Widgets above the content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_below_content_events' => array(
					"title" => esc_html__('Widgets below the content', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					),
				'widgets_below_page_events' => array(
					"title" => esc_html__('Widgets below the page', 'mckinney-politics'),
					"desc" => wp_kses_data( __('Select widgets to show below the page (content and sidebar)', 'mckinney-politics') ),
					"std" => 'hide',
					"options" => array_merge(array('hide'=>esc_html__('- Select widgets -', 'mckinney-politics')), mckinney_politics_get_list_sidebars()),
					"type" => "select"
					)
				)
			);
		}
	}
}

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_tribe_events_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_tribe_events_theme_setup9', 9 );
	function mckinney_politics_tribe_events_theme_setup9() {
		if (mckinney_politics_exists_tribe_events()) {
			add_action( 'wp_enqueue_scripts', 										'mckinney_politics_tribe_events_frontend_scripts', 1100 );
			add_filter( 'mckinney_politics_filter_merge_styles',						'mckinney_politics_tribe_events_merge_styles' );
			add_filter( 'mckinney_politics_filter_get_css',							'mckinney_politics_tribe_events_get_css', 10, 3 );
			if (!is_admin()){
				add_filter( 'mckinney_politics_filter_detect_blog_mode',				'mckinney_politics_tribe_events_detect_blog_mode' );
				add_filter( 'mckinney_politics_filter_post_type_taxonomy',			'mckinney_politics_tribe_events_post_type_taxonomy', 10, 2 );
				add_filter( 'mckinney_politics_filter_get_blog_all_posts_link', 		'mckinney_politics_tribe_events_get_blog_all_posts_link');
				add_filter( 'mckinney_politics_filter_get_blog_title', 				'mckinney_politics_tribe_events_get_blog_title');
				add_filter( 'mckinney_politics_filter_need_page_title', 				'mckinney_politics_tribe_events_need_page_title');
				add_filter( 'mckinney_politics_filter_get_post_categories', 			'mckinney_politics_tribe_events_get_post_categories');
				add_filter( 'mckinney_politics_filter_get_post_date',		 			'mckinney_politics_tribe_events_get_post_date');
			}
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',			'mckinney_politics_tribe_events_tgmpa_required_plugins' );
		}

	}
}



// Check if Tribe Events is installed and activated
if ( !function_exists( 'mckinney_politics_exists_tribe_events' ) ) {
	function mckinney_politics_exists_tribe_events() {
		return class_exists( 'Tribe__Events__Main' );
	}
}

// Return true, if current page is any tribe_events page
if ( !function_exists( 'mckinney_politics_is_tribe_events_page' ) ) {
	function mckinney_politics_is_tribe_events_page() {
		$rez = false;
		if (mckinney_politics_exists_tribe_events())
			if (!is_search()) $rez = tribe_is_event() || tribe_is_event_query() || tribe_is_event_category() || tribe_is_event_venue() || tribe_is_event_organizer();
		return $rez;
	}
}

// Detect current blog mode
if ( !function_exists( 'mckinney_politics_tribe_events_detect_blog_mode' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_detect_blog_mode', 'mckinney_politics_tribe_events_detect_blog_mode' );
	function mckinney_politics_tribe_events_detect_blog_mode($mode='') {
		if (mckinney_politics_is_tribe_events_page())
			$mode = 'events';
		return $mode;
	}
}

// Return taxonomy for current post type
if ( !function_exists( 'mckinney_politics_tribe_events_post_type_taxonomy' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_post_type_taxonomy',	'mckinney_politics_tribe_events_post_type_taxonomy', 10, 2 );
	function mckinney_politics_tribe_events_post_type_taxonomy($tax='', $post_type='') {
		if (mckinney_politics_exists_tribe_events() && $post_type == Tribe__Events__Main::POSTTYPE)
			$tax = Tribe__Events__Main::TAXONOMY;
		return $tax;
	}
}

// Return current page title
if ( !function_exists( 'mckinney_politics_tribe_events_get_blog_title' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_blog_title', 'mckinney_politics_tribe_events_get_blog_title');
	function mckinney_politics_tribe_events_get_blog_title($title='') {
		if (mckinney_politics_is_tribe_events_page() ) {
			if (is_archive())
				$title = apply_filters( 'tribe_events_title', tribe_get_events_title( false ) );
			else {
				global $wp_query;
				if (!empty($wp_query->post)) {
					$title = $wp_query->post->post_title;
				}
			}
		}
		return $title;
	}
}

// Return link to main shop page for the breadcrumbs
if ( !function_exists( 'mckinney_politics_tribe_events_get_blog_all_posts_link' ) ) {
	//Handler of add_filter('mckinney_politics_filter_get_blog_all_posts_link', 'mckinney_politics_tribe_events_get_blog_all_posts_link');
	function mckinney_politics_tribe_events_get_blog_all_posts_link($link='') {
		if ($link=='' && mckinney_politics_is_tribe_events_page() && (!is_archive() || tribe_is_event_category()))
			$link = '<a href="'.esc_url(tribe_get_events_link()).'">'.esc_html__('Events', 'mckinney-politics').'</a>';
		return $link;
	}
}

// Return link to main shop page for the breadcrumbs
if ( !function_exists( 'mckinney_politics_tribe_events_show_page_title' ) ) {
	//Handler of add_filter('mckinney_politics_filter_show_page_title', 'mckinney_politics_tribe_events_show_page_title');
	function mckinney_politics_tribe_events_need_page_title($need=false) {
		if (!$need)
			$need = mckinney_politics_is_tribe_events_page();
		return $need;
	}
}

// Show categories of the current event
if ( !function_exists( 'mckinney_politics_tribe_events_get_post_categories' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_post_categories', 		'mckinney_politics_tribe_events_get_post_categories');
	function mckinney_politics_tribe_events_get_post_categories($cats='') {
		if (get_post_type()==Tribe__Events__Main::POSTTYPE) {
			$cats = mckinney_politics_get_post_terms(', ', get_the_ID(), Tribe__Events__Main::TAXONOMY);
		}
		return $cats;
	}
}

// Show categories of the current event
if ( !function_exists( 'mckinney_politics_tribe_events_get_post_date' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_post_date',		 		'mckinney_politics_tribe_events_get_post_date');
	function mckinney_politics_tribe_events_get_post_date($dt='') {
		if (get_post_type()==Tribe__Events__Main::POSTTYPE) {
			$dt = tribe_get_start_date(null, true, 'Y-m-d');
			$dt = sprintf($dt < date('Y-m-d') ? esc_html__('Started on %s', 'mckinney-politics') : esc_html__('Starting %s', 'mckinney-politics'), date(get_option('date_format'), strtotime($dt)));
		}
		return $dt;
	}
}
	
// Enqueue Tribe Events custom styles
if ( !function_exists( 'mckinney_politics_tribe_events_frontend_scripts' ) ) {
	//Handler of add_action( 'wp_enqueue_scripts', 'mckinney_politics_tribe_events_frontend_scripts', 1100 );
	function mckinney_politics_tribe_events_frontend_scripts() {
		if (mckinney_politics_is_tribe_events_page()) {
			if (mckinney_politics_is_on(mckinney_politics_get_theme_option('debug_mode')) && file_exists(mckinney_politics_get_file_dir('css/plugin.the-events-calendar.css')))
				wp_enqueue_style( 'mckinney-politics-plugin-the-events-calendar',  mckinney_politics_get_file_url('css/plugin.the-events-calendar.css'), array(), null );
		}
	}
}
	
// Merge custom styles
if ( !function_exists( 'mckinney_politics_tribe_events_merge_styles' ) ) {
	//Handler of add_filter('mckinney_politics_filter_merge_styles', 'mckinney_politics_tribe_events_merge_styles');
	function mckinney_politics_tribe_events_merge_styles($css) {
		return $css . mckinney_politics_fgc(mckinney_politics_get_file_dir('css/plugin.the-events-calendar.css'));
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_tribe_events_tgmpa_required_plugins' ) ) {
	//Handler of add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_tribe_events_tgmpa_required_plugins');
	function mckinney_politics_tribe_events_tgmpa_required_plugins($list=array()) {
		if (in_array('the-events-calendar', (array)mckinney_politics_storage_get('required_plugins')))
			$list[] = array(
					'name' 		=> esc_html__('Tribe Events Calendar', 'mckinney-politics'),
					'slug' 		=> 'the-events-calendar',
					'required' 	=> false
				);
		return $list;
	}
}

// Add Tribe Events specific items into lists
//------------------------------------------------------------------------

// Add sidebar
if ( !function_exists( 'mckinney_politics_tribe_events_list_sidebars' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_list_sidebars', 'mckinney_politics_tribe_events_list_sidebars' );
	function mckinney_politics_tribe_events_list_sidebars($list=array()) {
		$list['tribe_events_widgets'] = esc_html__('Tribe Events Widgets', 'mckinney-politics');
		return $list;
	}
}



// Add Tribe Events specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'mckinney_politics_tribe_events_get_css' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_css', 'mckinney_politics_tribe_events_get_css', 10, 3 );
	function mckinney_politics_tribe_events_get_css($css, $colors, $fonts) {
		if (isset($css['colors'])) {
			$css['fonts'] .= <<<CSS


.tribe-events-single-event-title,
.tribe-events-list .type-tribe_events h2 {
	font-family: {$fonts['h1']['family']};
}
.tribe-events-event-meta,
.tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button,
.tribe-events-content ol, .tribe-events-content p, .tribe-events-content ul,
.tribe-events-list .tribe-events-list-event-title {
	font-family: {$fonts['p']['family']};
}
.tribe-events-loop .tribe-events-event-meta,
.tribe-events-list .tribe-events-list-separator-month,
.tribe-events-schedule h2,
#tribe-bar-form button {
	font-family: {$fonts['p']['family']};
}
.tribe-events-calendar *,
#tribe-events-content.tribe-events-month,
#tribe-bar-form a,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a,
.tribe-events-read-more,
.tribe-events-button,
#tribe-events .tribe-events-button,
#tribe-bar-form input,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title,
#tribe-events-content .tribe-events-tooltip .entry-title,
#tribe-mobile-container .type-tribe_events,
.tribe-events-list-widget ol li .tribe-event-title {
	font-family: {$fonts['p']['family']};
}

CSS;
		}

		if (isset($css['colors'])) {
			$css['colors'] .= <<<CSS

.tribe-events-event-meta .tribe-event-schedule-details {
	color: {$colors['text_link']};
}
.tribe-events-event-meta .tribe-events-venue-details {
	color: {$colors['text_light']};
}

/* Filters bar */
#tribe-events-bar {
	background-color: {$colors['alter_bg_color']};
}
#tribe-bar-form {
	color: {$colors['text_dark']};
}
#tribe-bar-form input[type="text"] {
	color: {$colors['text_light']};
	border-color: {$colors['bg_color']};
	background-color: {$colors['bg_color']};
}
#tribe-bar-form input[type="text"]:focus {
	border-color: {$colors['input_bd_hover']};
	color: {$colors['text_dark']};
}

#tribe-bar-form input[type="text"]::-webkit-input-placeholder {color:{$colors['input_text']}; opacity: 1;}
#tribe-bar-form input[type="text"]::-moz-placeholder          {color:{$colors['input_text']}; opacity: 1;}/* Firefox 19+ */
#tribe-bar-form input[type="text"]:-moz-placeholder           {color:{$colors['input_text']}; opacity: 1;}/* Firefox 18- */
#tribe-bar-form input[type="text"]:-ms-input-placeholder      {color:{$colors['input_text']}; opacity: 1;}


#tribe-bar-form .tribe-bar-submit input[type="submit"] {
	color: {$colors['text_link']};
	color: {$colors['inverse_text']};
}
#tribe-bar-form .tribe-bar-submit input[type="submit"]:hover {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_hover']};
}

.tribe-bar-views-inner {
	color: {$colors['text_dark']};
}
#tribe-bar-views .tribe-bar-views-list {
	border-color: {$colors['text_dark']};
}
#tribe-bar-views .tribe-bar-views-list:hover {
	border-color: {$colors['text_link']};
}
#tribe-bar-views li.tribe-bar-views-option a,
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a {
	color: {$colors['inverse_text']};
	background: {$colors['text_link']};
}
#tribe-bar-views li.tribe-bar-views-option a:hover,
#tribe-bar-views .tribe-bar-views-list .tribe-bar-views-option.tribe-bar-active a:hover {
	color: {$colors['inverse_text']};
	background: {$colors['text_hover']};
}

/* Content */
.tribe-events-calendar thead th {
	color: {$colors['inverse_text']};
	background: {$colors['text_dark']} !important;
	border-color: {$colors['text_dark']} !important;
}
.tribe-events-calendar thead th + th:before {
	background: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td {
	border-color: {$colors['alter_bg_color']} !important;
}
.tribe-events-calendar td div[id*="tribe-events-daynum-"], .tribe-events-calendar td div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_dark']};
}
.tribe-events-calendar td.tribe-events-othermonth {
	color: {$colors['alter_light']};
}
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-othermonth div[id*="tribe-events-daynum-"] > a {
	color: {$colors['alter_light']};
}
.tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"], .tribe-events-calendar td.tribe-events-past div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_light']};
}
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"],
.tribe-events-calendar td.tribe-events-present div[id*="tribe-events-daynum-"] > a {
	color: {$colors['text_link']};
}
.tribe-events-calendar td.tribe-events-present:before {
	border-color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td,
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a {
	color: {$colors['text']};
}
#tribe-events-content .tribe-events-calendar div[id*="tribe-events-event-"] h3.tribe-events-month-event-title a:hover {
	color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active,
#tribe-events-content .tribe-events-calendar td.mobile-active:hover {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
#tribe-events-content .tribe-events-calendar td.mobile-active div[id*="tribe-events-daynum-"] {
	color: {$colors['bg_color']};
	background-color: {$colors['text_dark']};
}

/* Tooltip */
.recurring-info-tooltip,
.tribe-events-calendar .tribe-events-tooltip,
.tribe-events-week .tribe-events-tooltip,
.tribe-events-tooltip .tribe-events-arrow {
	color: {$colors['alter_text']};
	background: {$colors['alter_bg_color']};
}
#tribe-events-content .tribe-events-tooltip .entry-title { 
	color: {$colors['inverse_light']};
	background: {$colors['text_dark']};
}
.tribe-events-tooltip .tribe-event-duration {
	color: {$colors['inverse_light']};
}

/* Buttons */
#tribe-events .tribe-events-button,
.tribe-events-button,
.tribe-events-cal-links a,
.tribe-events-sub-nav li a,
#tribe-events-footer .tribe-events-sub-nav li a {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_hover']};
}
.tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button {
	color: {$colors['inverse_text']};
}
#tribe-bar-form .tribe-bar-submit input[type="submit"]:not([class*="sc_button_hover_"]),
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:not([class*="sc_button_hover_"]),
#tribe-events .tribe-events-button:not([class*="sc_button_hover_"]),
.tribe-events-button:not([class*="sc_button_hover_"]),
.tribe-events-cal-links a:not([class*="sc_button_hover_"]),
.tribe-events-sub-nav li a:not([class*="sc_button_hover_"]),
#tribe-bar-form .tribe-bar-submit input[type="submit"].sc_button_hover_slide_left,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"].sc_button_hover_slide_left,
#tribe-events .tribe-events-button.sc_button_hover_slide_left,
#tribe-events .tribe-events-button.sc_button_hover_slide_left,
#tribe-events .tribe-events.tribe-events-cal-links a.sc_button_hover_slide_left,
#tribe-events .tribe-events-sub-nav li a.sc_button_hover_slide_left {	background: linear-gradient(to right, 	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
#tribe-bar-form .tribe-bar-submit input[type="submit"].sc_button_hover_slide_right,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"].sc_button_hover_slide_right,
#tribe-events .tribe-events-button.sc_button_hover_slide_right,
#tribe-events .tribe-events-button.sc_button_hover_slide_right,
#tribe-events .tribe-events-cal-links a.sc_button_hover_slide_right,
#tribe-events .tribe-events-sub-nav li a.sc_button_hover_slide_right {	background: linear-gradient(to left, 	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
#tribe-bar-form .tribe-bar-submit input[type="submit"].sc_button_hover_slide_top,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"].sc_button_hover_slide_top,
#tribe-events .tribe-events-button.sc_button_hover_slide_top,
#tribe-events .tribe-events-button.sc_button_hover_slide_top,
#tribe-events .tribe-events-cal-links a.sc_button_hover_slide_top,
#tribe-events .tribe-events-sub-nav li a.sc_button_hover_slide_top {	background: linear-gradient(to bottom, 	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
#tribe-bar-form .tribe-bar-submit input[type="submit"].sc_button_hover_slide_bottom,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"].sc_button_hover_slide_bottom,
#tribe-events .tribe-events-button.sc_button_hover_slide_bottom,
#tribe-events .tribe-events-button.sc_button_hover_slide_bottom,
#tribe-events .tribe-events-cal-links a.sc_button_hover_slide_bottom,
#tribe-events .tribe-events-sub-nav li a.sc_button_hover_slide_bottom {	background: linear-gradient(to top, 	{$colors['text_hover']} 50%, {$colors['text_link']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

#tribe-bar-form .tribe-bar-submit input[type="submit"]:hover,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:hover,
#tribe-events .tribe-events-button:hover,
.tribe-events-button:hover,
.tribe-events-cal-links a:hover,
.tribe-events-sub-nav li a:hover {
	color: {$colors['inverse_text']};
    background-position: left bottom;
}
.tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:hover {
	color: {$colors['inverse_text']};
}
#tribe-bar-form .tribe-bar-submit input[type="submit"]:not([class*="sc_button_hover_"]):hover,
#tribe-bar-form.tribe-bar-mini .tribe-bar-submit input[type="submit"]:not([class*="sc_button_hover_"]):hover,
#tribe-events .tribe-events-button:not([class*="sc_button_hover_"]):hover,
.tribe-events-button:not([class*="sc_button_hover_"]):hover,
.tribe-events-cal-links a:not([class*="sc_button_hover_"]):hover,
.tribe-events-sub-nav li a:not([class*="sc_button_hover_"]):hover,
#tribe-events-footer .tribe-events-sub-nav li a:hover {
	background-color: {$colors['text_hover']};
}

/* Events list */
.tribe-events-list-separator-month {
	color: {$colors['text_dark']};
}
.tribe-events-list-separator-month:after {
	border-color: {$colors['alter_bd_color']};
}
.tribe-events-list-separator-month span {
	color: {$colors['text_link']}
}
.tribe-events-list .type-tribe_events + .type-tribe_events {
	border-color: {$colors['bd_color']};
}
.tribe-events-list .tribe-events-event-cost span {
	color: {$colors['inverse_text']};
	border-color: {$colors['text_dark']};
	background: {$colors['text_dark']};
}

/* Events day */
.tribe-events-day .tribe-events-day-time-slot h5 {
	color: {$colors['inverse_text']};
	background: {$colors['text_dark']};
}

/* Single Event */
.single-tribe_events .tribe-events-single-section {
	border-color: {$colors['bd_color']};
}
.single-tribe_events .tribe-events-venue-map {
	color: {$colors['alter_text']};
	border-color: {$colors['alter_bd_hover']};
	background: {$colors['alter_bg_hover']};
}
.single-tribe_events .tribe-events-schedule .tribe-events-cost {
	color: {$colors['text_dark']};
}

.tribe-events-button,
.tribe-common.tribe-events .tribe-events-c-ical__link,
.tribe-common.tribe-events .tribe-events-c-nav__prev,
.tribe-common.tribe-events .tribe-events-c-nav__next,
.tribe-common.tribe-events .tribe-events-c-top-bar__datepicker-button,
.tribe-events-single a.tribe-events-ical, .tribe-events-single a.tribe-events-gcal{
    border-color: {$colors['text_link']};
    background: {$colors['text_link']};
	color: {$colors['inverse_text']};

}
.tribe-common.tribe-events .tribe-events-c-ical__link:hover,
.tribe-common.tribe-events .tribe-events-c-nav__prev:hover,
.tribe-common.tribe-events .tribe-events-c-nav__next:hover,
.tribe-common.tribe-events .tribe-events-c-top-bar__datepicker-button:hover,
.tribe-events-single a.tribe-events-ical:hover, .tribe-events-single a.tribe-events-gcal:hover{
    background: {$colors['text_hover']};
    border-color: {$colors['text_hover']};
    color: {$colors['inverse_text']};
}
.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-next a, 
.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-previous a {
	color: {$colors['inverse_text']};
}
.tribe-common.tribe-events .datepicker .day.current{
	background: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-common-c-btn,
.tribe-common.tribe-events a.tribe-common-c-btn,
.tribe-common.tribe-events .tribe-events-c-events-bar__search-button:before,
.tribe-common.tribe-events .tribe-events-c-view-selector__button:before{
    background: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-common-c-btn:hover,
.tribe-common.tribe-events a.tribe-common-c-btn:hover{
    background: {$colors['text_hover']};
}

.tribe-common.tribe-events .datepicker .day.active,
.tribe-common.tribe-events .datepicker .day.active.focused,
.tribe-common.tribe-events .datepicker .day.active:focus,
.tribe-common.tribe-events .datepicker .day.active:hover,
.tribe-common.tribe-events .datepicker .month.active,
.tribe-common.tribe-events .datepicker .month.active.focused,
.tribe-common.tribe-events .datepicker .month.active:focus,
.tribe-common.tribe-events .datepicker .month.active:hover,
.tribe-common.tribe-events .datepicker .year.active,
.tribe-common.tribe-events .datepicker .year.active.focused,
.tribe-common.tribe-events .datepicker .year.active:focus,
.tribe-common.tribe-events .datepicker .year.active:hover,
.datepicker table tr td.active.active, 
.datepicker table tr td span.active.active,
.datepicker table tr td.active.active:focus, 
.datepicker table tr td span.active.active:focus,
.datepicker table tr td.active.active:hover, 
.datepicker table tr td span.active.active:hover {
    background: {$colors['text_link']};
}
.datepicker table tr td.active.active:focus, 
.datepicker table tr td span.active.active:focus,
.datepicker table tr td.active.active:hover, 
.datepicker table tr td span.active.active:hover {
	color: {$colors['inverse_text']};
}
.tribe-events .datepicker .day.current,
.tribe-events .datepicker .day.current.focused,
.tribe-events .datepicker .day.current:focus,
.tribe-events .datepicker .day.current:hover,
.tribe-events .datepicker .month.current,
.tribe-events .datepicker .month.current.focused,
.tribe-events .datepicker .month.current:focus,
.tribe-events .datepicker .month.current:hover,
.tribe-events .datepicker .year.current,
.tribe-events .datepicker .year.current.focused,
.tribe-events .datepicker .year.current:focus,
.tribe-events .datepicker .year.current:hover{
    background: {$colors['text_link_alpha_07']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__multiday-event-bar-inner{
    background: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__multiday-event-bar-title{
    color: {$colors['inverse_text']};
}

.tribe-events.tribe-common .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date,
.tribe-events.tribe-common .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link{
    color: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-common-c-loader .tribe-common-c-loader__dot {
	background-color: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__mobile-events-icon--event{
    background-color: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__day-date{
    color: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-events-c-top-bar__datepicker-button .tribe-common-c-svgicon path{
    fill: {$colors['inverse_text']};
}

.tribe-common .tribe-common-c-svgicon--messages-not-found .tribe-common-c-svgicon__svg-stroke {
	stroke: {$colors['text_link']};
}

.tribe-events-calendar-month__calendar-event-tooltip-description.tribe-common-b3,
.tribe-common .tribe-events-calendar-list__event-title-link,
.tribe-common .tribe-events-calendar-day__event-title-link,
.tribe-events .tribe-events-calendar-list__event-datetime,
.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,
.tribe-common .tribe-common-b2,
.tribe-common .tribe-common-h5,
.tribe-common .tribe-common-h6,
.tribe-common .tribe-common-h7 a,
.tribe-events .tribe-events-c-messages__message-list-item-link:hover,
.tribe-events-meta-group .tribe-events-single-section-title {
	color: {$colors['text_dark']};
}
.tribe-common .tribe-common-h7 a:hover,
.tribe-common .tribe-events-calendar-list__event-title-link:hover,
.tribe-common .tribe-events-calendar-day__event-title-link:hover,
.tribe-events .tribe-events-c-messages__message-list-item-link {
	color: {$colors['text_link']};
}

.tribe-common.tribe-events .tribe-events-calendar-list__event-description,
.tribe-common.tribe-events .tribe-events-calendar-day__event-description,
.tribe-events-content {
	color: {$colors['text']};
}

.tribe-events .tribe-events-calendar-month__day-cell--selected, .tribe-events .tribe-events-calendar-month__day-cell--selected:focus, .tribe-events .tribe-events-calendar-month__day-cell--selected, .tribe-events .tribe-events-calendar-month__day-cell--selected h3 {
	background-color: {$colors['text_link']} !important;
}

.tribe-events .tribe-events-calendar-month__day-cell--selected em {
	background-color: {$colors['inverse_text']} !important;
}

.tribe-events .tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__day-date-daynum {
	color: {$colors['text_link']};
}

.tribe-events .tribe-events-calendar-month__day-cell--selected .tribe-events-calendar-month__day-date-daynum {
	color: {$colors['text_hover']};
}

.tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button {
	background-color: {$colors['text_link']} !important;
}

.tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:hover {
	background-color: {$colors['text_hover']} !important;
}

.single-tribe_events .tribe-events-c-subscribe-dropdown__export-icon, .tribe-block__events-link .tribe-events-c-subscribe-dropdown__export-icon {
	stroke: {$colors['inverse_text']};
}

.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button-icon path, .tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button-icon path {
	fill: {$colors['inverse_text']};
}

.tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button .tribe-events-c-subscribe-dropdown__button-text {
	color: {$colors['inverse_text']};
}

CSS;
		}
		
		return $css;
	}
}
?>