<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_revslider_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_revslider_theme_setup9', 9 );
	function mckinney_politics_revslider_theme_setup9() {
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',		'mckinney_politics_revslider_tgmpa_required_plugins' );
		}
	}
}

// Check if RevSlider installed and activated
if ( !function_exists( 'mckinney_politics_exists_revslider' ) ) {
	function mckinney_politics_exists_revslider() {
		return function_exists('rev_slider_shortcode');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_revslider_tgmpa_required_plugins' ) ) {
	//Handler of add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_revslider_tgmpa_required_plugins');
	function mckinney_politics_revslider_tgmpa_required_plugins($list=array()) {
		if (in_array('revslider', (array)mckinney_politics_storage_get('required_plugins'))) {
			$path = mckinney_politics_get_file_dir('plugins/install/revslider.zip');
			if (file_exists($path)) {
				$list[] = array(
						'name' 		=> esc_html__('Revolution Slider', 'mckinney-politics'),
						'slug' 		=> 'revslider',
						'version'	=> '6.6.15',
						'source'	=> $path,
						'required' 	=> false
					);
			}
		}
		return $list;
	}
}

// Lists
//------------------------------------------------------------------------

// Add RevSlider in the sliders list, prepended inherit (if need)
if ( !function_exists( 'mckinney_politics_revslider_list_sliders' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_list_sliders',					'mckinney_politics_revslider_list_sliders' );
	function mckinney_politics_revslider_list_sliders($list=array()) {
		$list = is_array($list) ? $list : array();
		$list["revo"] = esc_html__("Layer slider (Revolution)", 'mckinney-politics');
		return $list;
	}
}

// Return Revo Sliders list, prepended inherit (if need)
if ( !function_exists( 'mckinney_politics_get_list_revo_sliders' ) ) {
	function mckinney_politics_get_list_revo_sliders($prepend_inherit=false) {
		if (($list = mckinney_politics_storage_get('list_revo_sliders'))=='') {
			$list = array();
			$list = apply_filters('mckinney_politics_filter_list_revo_sliders', $list);
			if (mckinney_politics_get_theme_setting('use_list_cache')) mckinney_politics_storage_set('list_revo_sliders', $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Add RevSlider in the shortcodes params
if ( !function_exists( 'mckinney_politics_revslider_shortcodes_params' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_shortcodes_params',			'mckinney_politics_revslider_shortcodes_params' );
	function mckinney_politics_revslider_shortcodes_params($list=array()) {
		$list["revo_sliders"] = mckinney_politics_get_list_revo_sliders();
		return $list;
	}
}

// Add RevSlider in the Theme Options params
if ( !function_exists( 'mckinney_politics_revslider_theme_options_params' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_theme_options_params',			'mckinney_politics_revslider_theme_options_params' );
	function mckinney_politics_revslider_theme_options_params($list=array()) {
		$list["list_revo_sliders"] = array('$mckinney_politics_get_list_revo_sliders' => '');
		return $list;
	}
}
?>