<?php
/* Mail Chimp support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_mailchimp_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_mailchimp_theme_setup9', 9 );
	function mckinney_politics_mailchimp_theme_setup9() {
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',			'mckinney_politics_mailchimp_tgmpa_required_plugins' );
		}
	}
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'mckinney_politics_exists_mailchimp' ) ) {
	function mckinney_politics_exists_mailchimp() {
		return function_exists('__mc4wp_load_plugin') || defined('MC4WP_VERSION');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_mailchimp_tgmpa_required_plugins' ) ) {
	//Handler of add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_mailchimp_tgmpa_required_plugins');
	function mckinney_politics_mailchimp_tgmpa_required_plugins($list=array()) {
		if (in_array('mailchimp-for-wp', (array)mckinney_politics_storage_get('required_plugins')))
			$list[] = array(
				'name' 		=> esc_html__('MailChimp for WP', 'mckinney-politics'),
				'slug' 		=> 'mailchimp-for-wp',
				'required' 	=> false
			);
		return $list;
	}
}
?>