<?php
/* WPBakery Page Builder support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_vc_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_vc_theme_setup9', 9 );
	function mckinney_politics_vc_theme_setup9() {
		if (mckinney_politics_exists_visual_composer()) {
			add_action( 'wp_enqueue_scripts', 										'mckinney_politics_vc_frontend_scripts', 1100 );
			add_filter( 'mckinney_politics_filter_merge_styles',						'mckinney_politics_vc_merge_styles' );
			add_filter( 'mckinney_politics_filter_merge_scripts',						'mckinney_politics_vc_merge_scripts' );
			add_filter( 'mckinney_politics_filter_get_css',							'mckinney_politics_vc_get_css', 10, 3 );
	
			// Add/Remove params in the standard VC shortcodes
			//-----------------------------------------------------
			add_filter( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG,					'mckinney_politics_vc_add_params_classes', 10, 3 );
			
			// Color scheme
			$scheme = array(
				"param_name" => "scheme",
				"heading" => esc_html__("Color scheme", 'mckinney-politics'),
				"description" => wp_kses_data( __("Select color scheme to decorate this block", 'mckinney-politics') ),
				"group" => esc_html__('Colors', 'mckinney-politics'),
				"admin_label" => true,
				"value" => array_flip((array)mckinney_politics_get_list_schemes(true)),
				"type" => "dropdown"
			);
			vc_add_param("vc_row", $scheme);
			vc_add_param("vc_row_inner", $scheme);
			vc_add_param("vc_column", $scheme);
			vc_add_param("vc_column_inner", $scheme);
			vc_add_param("vc_column_text", $scheme);
			
			// Alter height and hide on mobile for Empty Space
			vc_add_param("vc_empty_space", array(
				"param_name" => "alter_height",
				"heading" => esc_html__("Alter height", 'mckinney-politics'),
				"description" => wp_kses_data( __("Select alternative height instead value from the field above", 'mckinney-politics') ),
				"admin_label" => true,
				"value" => array(
					esc_html__('Tiny', 'mckinney-politics') => 'tiny',
					esc_html__('Small', 'mckinney-politics') => 'small',
					esc_html__('Medium', 'mckinney-politics') => 'medium',
					esc_html__('Large', 'mckinney-politics') => 'large',
					esc_html__('Huge', 'mckinney-politics') => 'huge',
					esc_html__('From the value above', 'mckinney-politics') => 'none'
				),
				"type" => "dropdown"
			));
			vc_add_param("vc_empty_space", array(
				"param_name" => "hide_on_mobile",
				"heading" => esc_html__("Hide on mobile", 'mckinney-politics'),
				"description" => wp_kses_data( __("Hide this block on the mobile devices, when the columns are arranged one under another", 'mckinney-politics') ),
				"admin_label" => true,
				"std" => 0,
				"value" => array(esc_html__("Hide on mobile", 'mckinney-politics') => "1" ),
				"type" => "checkbox"
			));
			
			// Add Narrow style to the Progress bars
			vc_add_param("vc_progress_bar", array(
				"param_name" => "narrow",
				"heading" => esc_html__("Narrow", 'mckinney-politics'),
				"description" => wp_kses_data( __("Use narrow style for the progress bar", 'mckinney-politics') ),
				"std" => 0,
				"value" => array(esc_html__("Narrow style", 'mckinney-politics') => "1" ),
				"type" => "checkbox"
			));
			
			// Add param 'Closeable' to the Message Box
			vc_add_param("vc_message", array(
				"param_name" => "closeable",
				"heading" => esc_html__("Closeable", 'mckinney-politics'),
				"description" => wp_kses_data( __("Add 'Close' button to the message box", 'mckinney-politics') ),
				"std" => 0,
				"value" => array(esc_html__("Closeable", 'mckinney-politics') => "1" ),
				"type" => "checkbox"
			));
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',		'mckinney_politics_vc_tgmpa_required_plugins' );
			add_filter( 'vc_iconpicker-type-fontawesome',						'mckinney_politics_vc_iconpicker_type_fontawesome' );
		}
	}
}

// Check if WPBakery Page Builder installed and activated
if ( !function_exists( 'mckinney_politics_exists_visual_composer' ) ) {
	function mckinney_politics_exists_visual_composer() {
		return class_exists('Vc_Manager');
	}
}

// Check if WPBakery Page Builder in frontend editor mode
if ( !function_exists( 'mckinney_politics_vc_is_frontend' ) ) {
	function mckinney_politics_vc_is_frontend() {
		return (isset($_GET['vc_editable']) && $_GET['vc_editable']=='true')
			|| (isset($_GET['vc_action']) && $_GET['vc_action']=='vc_inline');
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_vc_tgmpa_required_plugins' ) ) {
	//Handler of add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_vc_tgmpa_required_plugins');
	function mckinney_politics_vc_tgmpa_required_plugins($list=array()) {
		if (in_array('js_composer', (array)mckinney_politics_storage_get('required_plugins'))) {
			$path = mckinney_politics_get_file_dir('plugins/install/js_composer.zip');
			if (file_exists($path)) {
				$list[] = array(
					'name' 		=> esc_html__('WPBakery Page Builder', 'mckinney-politics'),
					'slug' 		=> 'js_composer',
                    'version'	=> '7.0',
					'source'	=> $path,
					'required' 	=> false
				);
			}
		}
		return $list;
	}
}
	
// Enqueue VC custom styles
if ( !function_exists( 'mckinney_politics_vc_frontend_scripts' ) ) {
	//Handler of add_action( 'wp_enqueue_scripts', 'mckinney_politics_vc_frontend_scripts', 1100 );
	function mckinney_politics_vc_frontend_scripts() {
		if (mckinney_politics_is_on(mckinney_politics_get_theme_option('debug_mode')) && file_exists(mckinney_politics_get_file_dir('css/plugin.js_composer.css')))
			wp_enqueue_style( 'mckinney-politics-plugin-js-composer',  mckinney_politics_get_file_url('css/plugin.js_composer.css'), array(), null );
		if (mckinney_politics_is_on(mckinney_politics_get_theme_option('debug_mode')) && file_exists(mckinney_politics_get_file_dir('js/plugin.js_composer.js')))
			wp_enqueue_script( 'mckinney-politics-plugin-js-composer', mckinney_politics_get_file_url('js/plugin.js_composer.js'), array('jquery'), null, true );
	}
}
	
// Merge custom styles
if ( !function_exists( 'mckinney_politics_vc_merge_styles' ) ) {
	//Handler of add_filter('mckinney_politics_filter_merge_styles', 'mckinney_politics_vc_merge_styles');
	function mckinney_politics_vc_merge_styles($css) {
		return $css . mckinney_politics_fgc(mckinney_politics_get_file_dir('css/plugin.js_composer.css'));
	}
}
	
// Merge custom scripts
if ( !function_exists( 'mckinney_politics_vc_merge_scripts' ) ) {
	//Handler of add_filter('mckinney_politics_filter_merge_scripts', 'mckinney_politics_vc_merge_scripts');
	function mckinney_politics_vc_merge_scripts($js) {
		return $js . mckinney_politics_fgc(mckinney_politics_get_file_dir('js/plugin.js_composer.js'));
	}
}
	
// Add theme icons into VC iconpicker list
if ( !function_exists( 'mckinney_politics_vc_iconpicker_type_fontawesome' ) ) {
	//Handler of add_filter( 'vc_iconpicker-type-fontawesome',	'mckinney_politics_vc_iconpicker_type_fontawesome' );
	function mckinney_politics_vc_iconpicker_type_fontawesome($icons) {
		$list = mckinney_politics_get_list_icons();
		if (!is_array($list) || count($list) == 0) return $icons;
		$rez = array();
		foreach ($list as $icon)
			$rez[] = array($icon => str_replace('icon-', '', $icon));
		return array_merge( $icons, array(esc_html__('Theme Icons', 'mckinney-politics') => $rez) );
	}
}

// Shortcodes
//------------------------------------------------------------------------

// Add params in the standard VC shortcodes
if ( !function_exists( 'mckinney_politics_vc_add_params_classes' ) ) {
	//Handler of add_filter( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG,				'mckinney_politics_vc_add_params_classes', 10, 3 );
	function mckinney_politics_vc_add_params_classes($classes, $sc, $atts) {
		if (in_array($sc, array('vc_row', 'vc_row_inner', 'vc_column', 'vc_column_inner', 'vc_column_text'))) {
			if (!empty($atts['scheme']) && !mckinney_politics_is_inherit($atts['scheme']))
				$classes .= ($classes ? ' ' : '') . 'scheme_' . $atts['scheme'];
		} else if (in_array($sc, array('vc_empty_space'))) {
			if (!empty($atts['alter_height']) && !mckinney_politics_is_off($atts['alter_height']))
				$classes .= ($classes ? ' ' : '') . 'height_' . $atts['alter_height'];
			if (!empty($atts['hide_on_mobile']) && (int) $atts['hide_on_mobile'] == 1)
				$classes .= ($classes ? ' ' : '') . 'hide_on_mobile';
		} else if (in_array($sc, array('vc_progress_bar'))) {
			if (!empty($atts['narrow']) && (int) $atts['narrow']==1)
				$classes .= ($classes ? ' ' : '') . 'vc_progress_bar_narrow';
		} else if (in_array($sc, array('vc_message'))) {
			if (!empty($atts['closeable']) && (int) $atts['closeable']==1)
				$classes .= ($classes ? ' ' : '') . 'vc_message_box_closeable';
		}
		return $classes;
	}
}


// Add VC specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'mckinney_politics_vc_get_css' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_css', 'mckinney_politics_vc_get_css', 10, 3 );
	function mckinney_politics_vc_get_css($css, $colors, $fonts) {
		if (isset($css['colors'])) {
			$css['fonts'] .= <<<CSS

.vc_tta .vc_tta-panel-title {
	font-family: {$fonts['p']['family']};
}

.sc_skills_counter .sc_skills_total,
.sc_skills_pie.sc_skills_compact_off .sc_skills_total,
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar .vc_label,
.vc_message_box,
.vc_widget_video + .wpb_text_column,
.vc_widget_slider + .wpb_text_column {
	font-family: {$fonts['h5']['family']};
}

CSS;
		}

		if (isset($css['colors'])) {
			$css['colors'] .= <<<CSS

/* Row and columns */
.scheme_self.wpb_row,
.scheme_self.wpb_column,
.scheme_self.wpb_text_column {
	color: {$colors['text']};
	background-color: {$colors['bg_color']};
}
.scheme_self.vc_row.vc_parallax[class*="scheme_"] .vc_parallax-inner:before {
	background-color: {$colors['bg_color_alpha']};
}

/* Accordion */
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_dark']};
}
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon.sc_button_hover_slide_left {	background: linear-gradient(to right,	{$colors['text_link']} 50%, {$colors['text_dark']} 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon.sc_button_hover_slide_right {	background: linear-gradient(to left,	{$colors['text_link']} 50%, {$colors['text_dark']} 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon.sc_button_hover_slide_top {	background: linear-gradient(to bottom,	{$colors['text_link']} 50%, {$colors['text_dark']} 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon.sc_button_hover_slide_bottom {background: linear-gradient(to top,		{$colors['text_link']} 50%, {$colors['text_dark']} 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon:before,
.vc_tta.vc_tta-accordion .vc_tta-panel-heading .vc_tta-controls-icon:after {
	border-color: {$colors['inverse_text']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a {
	color: {$colors['text_dark']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title > a,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a:hover {
	color: {$colors['text_link']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a:hover .sc_button_hover_slide_left {	background-position: left bottom !important; }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a:hover .sc_button_hover_slide_right {	background-position: right bottom !important; }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a:hover .sc_button_hover_slide_top {	background-position: right top !important; }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a:hover .sc_button_hover_slide_bottom {	background-position: right bottom !important; }

.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title > a .vc_tta-controls-icon,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel .vc_tta-panel-title > a:hover .vc_tta-controls-icon {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title > a .vc_tta-controls-icon:before,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-panel.vc_active .vc_tta-panel-title > a .vc_tta-controls-icon:after {
	border-color: {$colors['inverse_text']};
}

/* Tabs */
.vc_tta.vc_general .vc_tta-tab > a {
	color: {$colors['text_dark']};
}

.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active > a {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_dark']};
}
.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active > a {
    color: {$colors['inverse_text']};
}
.wpb-js-composer .vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab a {
    border: none;
}

.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab > a.sc_button_hover_slide_left {	background: linear-gradient(to right,	{$colors['text_link']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab > a.sc_button_hover_slide_right {	background: linear-gradient(to left,	{$colors['text_link']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab > a.sc_button_hover_slide_top {		background: linear-gradient(to bottom,	{$colors['text_link']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab > a.sc_button_hover_slide_bottom {	background: linear-gradient(to top,		{$colors['text_link']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active > a.sc_button_hover_slide_left {		background: linear-gradient(to right, {$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 210% 100% rgba(0, 0, 0, 0); }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active > a.sc_button_hover_slide_right {		background: linear-gradient(to left,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll left bottom / 210% 100% rgba(0, 0, 0, 0); }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active > a.sc_button_hover_slide_top {		background: linear-gradient(to bottom,	{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right bottom / 100% 210% rgba(0, 0, 0, 0); }
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab.vc_active > a.sc_button_hover_slide_bottom {	background: linear-gradient(to top,		{$colors['text_dark']} 50%, rgba(0,0,0,0) 50%) no-repeat scroll right top / 100% 210% rgba(0, 0, 0, 0); }

.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab:hover > a,
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab > a:hover {
	color: {$colors['inverse_text']};
}
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab:hover > a:not([class*="sc_button_hover_"]),
.vc_tta-color-grey.vc_tta-style-classic .vc_tta-tab > a:not([class*="sc_button_hover_"]):hover {
	background-color: {$colors['text_link']};
}

/* Separator */
.vc_separator.vc_sep_color_grey .vc_sep_line {
	border-color: {$colors['bd_color']};
}

/* Progress bar */

.sc_skills_pie.sc_skills_compact_off .sc_skills_item_title {
	color: {$colors['text_dark']};
}

.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar {
	background-color: {$colors['alter_bg_color']};
}
.vc_progress_bar.vc_progress_bar_narrow.vc_progress-bar-color-bar_red .vc_single_bar .vc_bar {
	background-color: {$colors['text_link']};
}
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar .vc_label {
	color: {$colors['text_dark']};
}
.vc_progress_bar.vc_progress_bar_narrow .vc_single_bar .vc_label .vc_label_units {
	color: {$colors['text_light']};
}

CSS;
		}
		
		return $css;
	}
}
?>