<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_essgrids_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_essgrids_theme_setup9', 9 );
	function mckinney_politics_essgrids_theme_setup9() {
		if (mckinney_politics_exists_essgrids()) {
			add_action( 'wp_enqueue_scripts', 									'mckinney_politics_essgrids_frontend_scripts', 1100 );
			add_filter( 'mckinney_politics_filter_merge_styles',					'mckinney_politics_essgrids_merge_styles' );
			add_filter( 'mckinney_politics_filter_get_css',						'mckinney_politics_essgrids_get_css', 10, 3 );
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',		'mckinney_politics_essgrids_tgmpa_required_plugins' );
		}
	}
}

// Check if plugin installed and activated
if ( !function_exists( 'mckinney_politics_exists_essgrids' ) ) {
	function mckinney_politics_exists_essgrids() {
		return defined('EG_PLUGIN_PATH') || defined( 'ESG_PLUGIN_PATH' );
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_essgrids_tgmpa_required_plugins' ) ) {
	//Handler of add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_essgrids_tgmpa_required_plugins');
	function mckinney_politics_essgrids_tgmpa_required_plugins($list=array()) {
		if (in_array('essgrids', (array)mckinney_politics_storage_get('required_plugins'))) {
			$path = mckinney_politics_get_file_dir('plugins/install/essential-grid.zip');
			if (file_exists($path)) {
				$list[] = array(
						'name' 		=> esc_html__('Essential Grid', 'mckinney-politics'),
						'slug' 		=> 'essential-grid',
						'version'	=> '3.0.19',
						'source'	=> $path,
						'required' 	=> false
					);
			}
		}
		return $list;
	}
}
	
// Enqueue WooCommerce custom styles
if ( !function_exists( 'mckinney_politics_essgrids_frontend_scripts' ) ) {
	//Handler of add_action( 'wp_enqueue_scripts', 'mckinney_politics_essgrids_frontend_scripts', 1100 );
	function mckinney_politics_essgrids_frontend_scripts() {
			if (mckinney_politics_is_on(mckinney_politics_get_theme_option('debug_mode')) && file_exists(mckinney_politics_get_file_dir('css/plugin.essgrids.css')))
				wp_enqueue_style( 'mckinney-politics-plugin-essgrids',  mckinney_politics_get_file_url('css/plugin.essgrids.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'mckinney_politics_essgrids_merge_styles' ) ) {
	//Handler of add_filter('mckinney_politics_filter_merge_styles', 'mckinney_politics_essgrids_merge_styles');
	function mckinney_politics_essgrids_merge_styles($css) {
		return $css . mckinney_politics_fgc(mckinney_politics_get_file_dir('css/plugin.essgrids.css'));
	}
}

// Add plugin's specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'mckinney_politics_essgrids_get_css' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_css', 'mckinney_politics_essgrids_get_css', 10, 3 );
	function mckinney_politics_essgrids_get_css($css, $colors, $fonts) {
		if (isset($css['colors'])) {
			$css['fonts'] .= <<<CSS

.esg-grid .eg-winelist-element-25, .esg-grid .eg-winelist-element-30 {
	font-family: {$fonts['h5']['family']};
}
.esg-grid .eg-main-theme-2-element-23:hover,
.esg-grid .eg-main-theme-2-element-23 {
	font-family: {$fonts['h6']['family']};
}
.esg-grid .eg-main-theme-2-element-6,
.esg-grid .eg-main-theme-2-element-4,
.esg-grid .eg-main-theme-2-element-6:hover,
.esg-grid .eg-main-theme-2-element-4:hover,
input.eg-search-input[type="text"], .eg-search-input,
.esg-grid .eg-main-theme-2-element-3,
.minimal-light .esg-filterbutton,
.minimal-light .esg-navigationbutton,
.minimal-light .esg-sortbutton,
.minimal-light .esg-cartbutton a {
	font-family: {$fonts['p']['family']} !important;
}

CSS;
		}

		if (isset($css['colors'])) {
			$css['colors'] .= <<<CSS

.esg-grid .eg-main-theme-2-element-23 {
	color: {$colors['text_dark']};
}
.esg-grid .eg-main-theme-2-element-23:hover {
	color: {$colors['text_link']};
}
.eg-search-submit:hover, .eg-search-clean:hover,
.minimal-light .esg-navigationbutton:hover,
.minimal-light .esg-filterbutton:hover,
.minimal-light .esg-sortbutton:hover,
.minimal-light .esg-sortbutton-order:hover,
.minimal-light .esg-cartbutton a:hover,
.minimal-light .esg-filterbutton.selected {
	border-color: {$colors['text_link']} !important;
	background-color: {$colors['text_link']} !important;
	color: {$colors['inverse_text']} !important;
}

		
CSS;
		}
		
		return $css;
	}
}
?>