<?php
/* Instagram Feed support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_elegro_payment_theme_setup9')) {
    add_action( 'after_setup_theme', 'mckinney_politics_elegro_payment_theme_setup9', 9 );
    function mckinney_politics_elegro_payment_theme_setup9() {
        if (is_admin()) {
            add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',		'mckinney_politics_elegro_payment_required_plugins' );
        }
    }
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_elegro_payment_required_plugins' ) ) {
    function mckinney_politics_elegro_payment_required_plugins($list=array()) {
        if (in_array('elegro-payment', (array)mckinney_politics_storage_get('required_plugins'))) {
            $list[] = array(
                'name' 		=> esc_html__('Elegro Payment', 'mckinney-politics'),
                'slug' 		=> 'elegro-payment',
                'required' 	=> false
            );
        }
        return $list;
    }
}

// Check if Instagram Feed installed and activated
if ( !function_exists( 'mckinney_politics_exists_elegro_payment' ) ) {
    function mckinney_politics_exists_elegro_payment() {
        return function_exists('init_Elegro_Payment');
    }
}
?>