<?php
/* Content Timeline support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_cool_timeline_theme_setup9')) {
	add_action( 'after_setup_theme', 'mckinney_politics_cool_timeline_theme_setup9', 9 );
	function mckinney_politics_cool_timeline_theme_setup9() {
		if (mckinney_politics_exists_cool_timeline()) {
			add_action( 'wp_enqueue_scripts', 										'mckinney_politics_cool_timeline_frontend_scripts', 1100 );
			add_filter( 'mckinney_politics_filter_merge_styles',						'mckinney_politics_cool_timeline_merge_styles' );
			add_filter( 'mckinney_politics_filter_get_css',							'mckinney_politics_cool_timeline_get_css', 10, 3 );
		}
		if (is_admin()) {
			add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',			'mckinney_politics_cool_timeline_tgmpa_required_plugins' );
		}

	}
}

// Check if plugin is installed and activated
if ( !function_exists( 'mckinney_politics_exists_cool_timeline' ) ) {
	function mckinney_politics_exists_cool_timeline() {
		return class_exists( 'CoolTimeline' );
	}
}
	
// Enqueue custom styles
if ( !function_exists( 'mckinney_politics_cool_timeline_frontend_scripts' ) ) {
	//Handler of add_action( 'wp_enqueue_scripts', 'mckinney_politics_cool_timeline_frontend_scripts', 1100 );
	function mckinney_politics_cool_timeline_frontend_scripts() {
		if ( mckinney_politics_is_on(mckinney_politics_get_theme_option('debug_mode')) && file_exists(mckinney_politics_get_file_dir('css/plugin.cool-timeline.css')))
			wp_enqueue_style( 'mckinney-politics-plugin-cool-timeline',  mckinney_politics_get_file_url('css/plugin.cool-timeline.css'), array(), null );
	}
}
	
// Merge custom styles
if ( !function_exists( 'mckinney_politics_cool_timeline_merge_styles' ) ) {
	//Handler of add_filter('mckinney_politics_filter_merge_styles', 'mckinney_politics_cool_timeline_merge_styles');
	function mckinney_politics_cool_timeline_merge_styles($css) {
		return $css . mckinney_politics_fgc(mckinney_politics_get_file_dir('css/plugin.cool-timeline.css'));
	}
}

// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_cool_timeline_tgmpa_required_plugins' ) ) {
	//Handler of add_filter('mckinney_politics_filter_tgmpa_required_plugins',	'mckinney_politics_cool_timeline_tgmpa_required_plugins');
	function mckinney_politics_cool_timeline_tgmpa_required_plugins($list=array()) {
		if (in_array('cool-timeline', (array)mckinney_politics_storage_get('required_plugins'))) {			

			$list[] = array(
				'name' 		=> esc_html__('Cool Timeline', 'mckinney-politics'),
				'slug' 		=> 'cool-timeline',
				'required' 	=> false
			);			
		}

		return $list;
	}
}

// Set plugin's specific importer options
if ( !function_exists( 'mckinney_politics_cool_timeline_importer_set_options' ) ) {
    if (is_admin()) add_filter( 'trx_addons_filter_importer_options',    'mckinney_politics_cool_timeline_importer_set_options' );
   	
    function mckinney_politics_cool_timeline_importer_set_options($options=array()) {
		if ( in_array('cool-timeline', (array)mckinney_politics_storage_get('required_plugins')) && mckinney_politics_exists_cool_timeline() ) {
			$options['additional_options'][] = 'cool_timeline_settings';	
		}
		return $options;
	}
}

// Add plugin's specific styles into color scheme
//------------------------------------------------------------------------

// Add styles into CSS
if ( !function_exists( 'mckinney_politics_cool_timeline_get_css' ) ) {
	//Handler of add_filter( 'mckinney_politics_filter_get_css', 'mckinney_politics_cool_timeline_get_css', 10, 3 );
	function mckinney_politics_cool_timeline_get_css($css, $colors, $fonts) {
		if (isset($css['colors'])) {
			$css['fonts'] .= <<<CSS
		
.ctl-story-year .rm_year,
.cool-timeline.ultimate-style .timeline-year .icon-placeholder span,
.custom-pagination a, 
.custom-pagination span {
	font-family: {$fonts['p']['family']};
}

CSS;
		}

		if (isset($css['colors'])) {
			$css['colors'] .= <<<CSS

/* Timeline */
/* Popup */
div.pp_default .pp_content_container a.pp_close:before, 
div.pp_default .pp_content_container a.pp_close:after {
	background-color: {$colors['inverse_text']};
}
div.pp_default .pp_content_container a.pp_close:hover:before, 
div.pp_default .pp_content_container a.pp_close:hover:after {
	background-color: {$colors['text_link']};
}
/* Horizontal Style */
.ctl_road_map_wrp .clt_h_nav_btn i {
	color: {$colors['text_dark']};
}
.ctl_road_map_wrp .clt_h_nav_btn.slick-disabled i {
	color: {$colors['text_light']};
}
.ctl_road_map_wrp .clt_h_nav_btn:not(.slick-disabled) i:hover{
	color: {$colors['text_link']};
}
.ctl_road_map_wrp li .ctl-story-year:before {
	border-color: {$colors['text_link']};
    background: {$colors['text_link']};
}
.ctl_road_map_wrp li:hover .ctl-story-year:before {
	background: {$colors['text_dark']};
}
.ctl_road_map_wrp li .ctl-story-year:after {
	background: {$colors['text_link']};
}
.ctl_road_map_wrp li:hover .ctl-story-year:after {
	background: {$colors['text_dark']};
}
.cool_timeline_horizontal li .ctl-story-year .rm_year {
	color: {$colors['text']};
}
.ctl_road_map_wrp li .ctl-story-title, 
.ctl_road_map_wrp li .ctl-story-title a {
	color: {$colors['text_dark']};
}
.ctl_road_map_wrp li .ctl-story-title a:hover {
	color: {$colors['text_hover']};
}
.ctl-popup-content h2 {
	color: {$colors['text_dark']};
}

.disable_horizontal_cool_timeline_slider .cool_timeline_horizontal:before {
	background: {$colors['text_dark']};
}
.disable_horizontal_cool_timeline_slider .cool_timeline_horizontal ul {
	scrollbar-color: {$colors['alter_bg_hover']} {$colors['alter_bg_color']};
}
.disable_horizontal_cool_timeline_slider .cool_timeline_horizontal ul::-webkit-scrollbar-thumb {
	background-color: {$colors['alter_bg_hover']};
}



/* Vertical Style*/
.custom-pagination a:hover,
.custom-pagination span.current {
	color: {$colors['inverse_text']};
	background-color: {$colors['text_link']};
}
.custom-pagination a {
	color: {$colors['text_light']};
	background-color: transparent;
}
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline:before, 
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline.one-sided:before,
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline .timeline-year {
	background-color: {$colors['text_dark']};
}
.cool-timeline.ultimate-style .timeline-post.clean-skin .timeline-meta .meta-details,
.cool-timeline.ultimate-style .timeline-post.clean-skin .timeline-meta .meta-details:after {
	background-color: {$colors['alter_bg_color']};
}
.cool_timeline.clean-skin-tm .cool-timeline.ultimate-style .timeline-post.clean-skin .timeline-content,
.cool_timeline.clean-skin-tm .cool-timeline.ultimate-style .timeline-post.clean-skin .timeline-content:after {
	background-color: {$colors['alter_bg_color']}!important;
}
body:not(.mobile_layout) .cool_timeline.clean-skin-tm .cool-timeline.ultimate-style .timeline-post.clean-skin .timeline-content:hover,
body:not(.mobile_layout) .cool_timeline.clean-skin-tm .cool-timeline.ultimate-style .timeline-post.clean-skin .timeline-content:hover:after {
	color: {$colors['inverse_text']}!important;
	background-color: {$colors['text_link']}!important;
}
body:not(.mobile_layout) .cool_timeline.clean-skin-tm .cool-timeline.ultimate-style .timeline-post.clean-skin .timeline-content:hover .content-title-cmt {
	color: {$colors['inverse_text']}!important;
}
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline .timeline-post.odd .timeline-meta .meta-details,
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline .timeline-post.even .timeline-meta .meta-details,
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline .timeline-post.odd .timeline-content h2.content-title,
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline .timeline-post.even .timeline-content h2.content-title {
	color: {$colors['text_dark']};
}
body:not(.mobile_layout) .cool_timeline.clean-skin-tm .cool-timeline.ultimate-style .timeline-post.clean-skin .timeline-content:hover h2.content-title {
	color: {$colors['inverse_text']}!important;
}
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline .timeline-post.odd .icon-dot-full,
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline .timeline-post.even .icon-dot-full, 
.cool_timeline.clean-skin-tm .cool-timeline.one-sided.white-timeline .timeline-post .icon-dot-full {
	background-color: {$colors['text_link']};
	border-color: {$colors['text_link']};
}
.cool-timeline .timeline-post .timeline-icon {
	background-color: {$colors['text_link']};
}
.cool_timeline.clean-skin-tm .cool-timeline.ultimate-style:not(.compact) .timeline-post.clean-skin:hover .timeline-icon.icon-dot-full {
	border-color: {$colors['text_dark']};
}
.cool_timeline.clean-skin-tm .cool-timeline.ultimate-style:not(.compact) .timeline-post.clean-skin:hover .timeline-icon.icon-dot-full:after {
	background-color: {$colors['text_dark']};
}
.cool_timeline.clean-skin-tm .cool-timeline.white-timeline .timeline-content {
	color: {$colors['text']};
}

.ultimate-style .timeline-post.timeline-mansory .timeline-content .content-title {
	color: {$colors['text_dark']};
	background-color: {$colors['alter_bg_color']};
}
.ultimate-style .timeline-post.timeline-mansory.ctl-left .timeline-content .content-title:after {
	border-left-color: {$colors['alter_bg_color']};
	border-right-color: {$colors['alter_bg_color']};
}
.ultimate-style .timeline-post.timeline-mansory.ctl-right .timeline-content .content-title:after {
	border-left-color: {$colors['alter_bg_color']};
	border-right-color: {$colors['alter_bg_color']};
}
html:not(.vc_mobile) body:not(.mobile_layout) .ultimate-style .timeline-post.timeline-mansory .timeline-content:hover .content-title {
	background-color: {$colors['text_link']};
	color: {$colors['inverse_link']};
}
html:not(.vc_mobile) body:not(.mobile_layout) .ultimate-style .timeline-post.timeline-mansory.ctl-left .timeline-content:hover .content-title:after {
	border-left-color: {$colors['text_link']};
}
html:not(.vc_mobile) body:not(.mobile_layout) .ultimate-style .timeline-post.timeline-mansory.ctl-right .timeline-content:hover .content-title:after {
	border-right-color: {$colors['text_link']};
}
CSS;
		}
		
		return $css;
	}
}
?>