<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if (!function_exists('mckinney_politics_cf7_theme_setup9')) {
    add_action( 'after_setup_theme', 'mckinney_politics_cf7_theme_setup9', 9 );
    function mckinney_politics_cf7_theme_setup9() {
        if (is_admin()) {
            add_filter( 'mckinney_politics_filter_tgmpa_required_plugins',			'mckinney_politics_cf7_required_plugins' );
        }
    }
}


// Check if cf7 installed and activated
if ( !function_exists( 'mckinney_politics_exists_cf7' ) ) {
    function mckinney_politics_exists_cf7() {
        return class_exists('WPCF7');
    }
}


// Filter to add in the required plugins list
if ( !function_exists( 'mckinney_politics_cf7_required_plugins' ) ) {
    function mckinney_politics_cf7_required_plugins($list=array()) {
        if (in_array('contact-form-7', (array)mckinney_politics_storage_get('required_plugins'))){
            $list[] = array(
                'name' 		=> esc_html__('Contact Form 7', 'mckinney-politics'),
                'slug' 		=> 'contact-form-7',
                'required' 	=> false
            );
        }
        return $list;
    }
}
?>