<?php
/**
 * Theme lists
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

// Disable direct call
if ( ! defined( 'ABSPATH' ) ) { exit; }



// Return numbers range
if ( !function_exists( 'mckinney_politics_get_list_range' ) ) {
	function mckinney_politics_get_list_range($from=1, $to=2, $prepend_inherit=false) {
		$list = array();
		for ($i=$from; $i<=$to; $i++)
			$list[$i] = $i;
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}



// Return styles list
if ( !function_exists( 'mckinney_politics_get_list_styles' ) ) {
	function mckinney_politics_get_list_styles($from=1, $to=2, $prepend_inherit=false) {
		$list = array();
		for ($i=$from; $i<=$to; $i++)
			$list[$i] = sprintf(esc_html__('Style %d', 'mckinney-politics'), $i);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}



// Return schemes list
if ( !function_exists( 'mckinney_politics_get_list_schemes' ) ) {
	function mckinney_politics_get_list_schemes($prepend_inherit=false) {
		if (($list = mckinney_politics_storage_get('list_schemes'))=='') {
			$list = mckinney_politics_get_theme_schemes();
			mckinney_politics_storage_set('list_schemes', $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the headers
if ( !function_exists( 'mckinney_politics_get_list_header_styles' ) ) {
	function mckinney_politics_get_list_header_styles($prepend_inherit=false) {
		$list = array(
			'header-1'	=> esc_html__('Header 1',	'mckinney-politics'),
			'header-2'	=> esc_html__('Header 2',	'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the header's positions
if ( !function_exists( 'mckinney_politics_get_list_header_positions' ) ) {
	function mckinney_politics_get_list_header_positions($prepend_inherit=false) {
		$list = array(
			'default'	=> esc_html__('Default','mckinney-politics'),
			'over'		=> esc_html__('Over',	'mckinney-politics'),
			'under'		=> esc_html__('Under',	'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the menu
if ( !function_exists( 'mckinney_politics_get_list_menu_styles' ) ) {
	function mckinney_politics_get_list_menu_styles($prepend_inherit=false) {
		$list = array(
			'top'	=> esc_html__('Top menu',	'mckinney-politics'),
			'side'	=> esc_html__('Side menu',	'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the animations
if ( !function_exists( 'mckinney_politics_get_list_animations' ) ) {
	function mckinney_politics_get_list_animations($prepend_inherit=false) {
		$list = array(
			'none'			=> esc_html__('- None -',	'mckinney-politics'),
			'bounced'		=> esc_html__('Bounced',	'mckinney-politics'),
			'elastic'		=> esc_html__('Elastic',	'mckinney-politics'),
			'flash'			=> esc_html__('Flash',		'mckinney-politics'),
			'flip'			=> esc_html__('Flip',		'mckinney-politics'),
			'pulse'			=> esc_html__('Pulse',		'mckinney-politics'),
			'rubberBand'	=> esc_html__('Rubber Band','mckinney-politics'),
			'shake'			=> esc_html__('Shake',		'mckinney-politics'),
			'swing'			=> esc_html__('Swing',		'mckinney-politics'),
			'tada'			=> esc_html__('Tada',		'mckinney-politics'),
			'wobble'		=> esc_html__('Wobble',		'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the enter animations
if ( !function_exists( 'mckinney_politics_get_list_animations_in' ) ) {
	function mckinney_politics_get_list_animations_in($prepend_inherit=false) {
		$list = array(
			'none'				=> esc_html__('- None -',			'mckinney-politics'),
			'bounceIn'			=> esc_html__('Bounce In',			'mckinney-politics'),
			'bounceInUp'		=> esc_html__('Bounce In Up',		'mckinney-politics'),
			'bounceInDown'		=> esc_html__('Bounce In Down',		'mckinney-politics'),
			'bounceInLeft'		=> esc_html__('Bounce In Left',		'mckinney-politics'),
			'bounceInRight'		=> esc_html__('Bounce In Right',	'mckinney-politics'),
			'elastic'			=> esc_html__('Elastic In',			'mckinney-politics'),
			'fadeIn'			=> esc_html__('Fade In',			'mckinney-politics'),
			'fadeInUp'			=> esc_html__('Fade In Up',			'mckinney-politics'),
			'fadeInUpSmall'		=> esc_html__('Fade In Up Small',	'mckinney-politics'),
			'fadeInUpBig'		=> esc_html__('Fade In Up Big',		'mckinney-politics'),
			'fadeInDown'		=> esc_html__('Fade In Down',		'mckinney-politics'),
			'fadeInDownBig'		=> esc_html__('Fade In Down Big',	'mckinney-politics'),
			'fadeInLeft'		=> esc_html__('Fade In Left',		'mckinney-politics'),
			'fadeInLeftBig'		=> esc_html__('Fade In Left Big',	'mckinney-politics'),
			'fadeInRight'		=> esc_html__('Fade In Right',		'mckinney-politics'),
			'fadeInRightBig'	=> esc_html__('Fade In Right Big',	'mckinney-politics'),
			'flipInX'			=> esc_html__('Flip In X',			'mckinney-politics'),
			'flipInY'			=> esc_html__('Flip In Y',			'mckinney-politics'),
			'lightSpeedIn'		=> esc_html__('Light Speed In',		'mckinney-politics'),
			'rotateIn'			=> esc_html__('Rotate In',			'mckinney-politics'),
			'rotateInUpLeft'	=> esc_html__('Rotate In Down Left','mckinney-politics'),
			'rotateInUpRight'	=> esc_html__('Rotate In Up Right',	'mckinney-politics'),
			'rotateInDownLeft'	=> esc_html__('Rotate In Up Left',	'mckinney-politics'),
			'rotateInDownRight'	=> esc_html__('Rotate In Down Right','mckinney-politics'),
			'rollIn'			=> esc_html__('Roll In',			'mckinney-politics'),
			'slideInUp'			=> esc_html__('Slide In Up',		'mckinney-politics'),
			'slideInDown'		=> esc_html__('Slide In Down',		'mckinney-politics'),
			'slideInLeft'		=> esc_html__('Slide In Left',		'mckinney-politics'),
			'slideInRight'		=> esc_html__('Slide In Right',		'mckinney-politics'),
			'wipeInLeftTop'		=> esc_html__('Wipe In Left Top',	'mckinney-politics'),
			'zoomIn'			=> esc_html__('Zoom In',			'mckinney-politics'),
			'zoomInUp'			=> esc_html__('Zoom In Up',			'mckinney-politics'),
			'zoomInDown'		=> esc_html__('Zoom In Down',		'mckinney-politics'),
			'zoomInLeft'		=> esc_html__('Zoom In Left',		'mckinney-politics'),
			'zoomInRight'		=> esc_html__('Zoom In Right',		'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the out animations
if ( !function_exists( 'mckinney_politics_get_list_animations_out' ) ) {
	function mckinney_politics_get_list_animations_out($prepend_inherit=false) {
		$list = array(
			'none'			=> esc_html__('- None -',			'mckinney-politics'),
			'bounceOut'		=> esc_html__('Bounce Out',			'mckinney-politics'),
			'bounceOutUp'	=> esc_html__('Bounce Out Up',		'mckinney-politics'),
			'bounceOutDown'	=> esc_html__('Bounce Out Down',	'mckinney-politics'),
			'bounceOutLeft'	=> esc_html__('Bounce Out Left',	'mckinney-politics'),
			'bounceOutRight'=> esc_html__('Bounce Out Right',	'mckinney-politics'),
			'fadeOut'		=> esc_html__('Fade Out',			'mckinney-politics'),
			'fadeOutUp'		=> esc_html__('Fade Out Up',		'mckinney-politics'),
			'fadeOutUpBig'	=> esc_html__('Fade Out Up Big',	'mckinney-politics'),
			'fadeOutDownSmall'	=> esc_html__('Fade Out Down Small','mckinney-politics'),
			'fadeOutDownBig'=> esc_html__('Fade Out Down Big',	'mckinney-politics'),
			'fadeOutDown'	=> esc_html__('Fade Out Down',		'mckinney-politics'),
			'fadeOutLeft'	=> esc_html__('Fade Out Left',		'mckinney-politics'),
			'fadeOutLeftBig'=> esc_html__('Fade Out Left Big',	'mckinney-politics'),
			'fadeOutRight'	=> esc_html__('Fade Out Right',		'mckinney-politics'),
			'fadeOutRightBig'=> esc_html__('Fade Out Right Big','mckinney-politics'),
			'flipOutX'		=> esc_html__('Flip Out X',			'mckinney-politics'),
			'flipOutY'		=> esc_html__('Flip Out Y',			'mckinney-politics'),
			'hinge'			=> esc_html__('Hinge Out',			'mckinney-politics'),
			'lightSpeedOut'	=> esc_html__('Light Speed Out',	'mckinney-politics'),
			'rotateOut'		=> esc_html__('Rotate Out',			'mckinney-politics'),
			'rotateOutUpLeft'	=> esc_html__('Rotate Out Down Left',	'mckinney-politics'),
			'rotateOutUpRight'	=> esc_html__('Rotate Out Up Right',	'mckinney-politics'),
			'rotateOutDownLeft'	=> esc_html__('Rotate Out Up Left',		'mckinney-politics'),
			'rotateOutDownRight'=> esc_html__('Rotate Out Down Right',	'mckinney-politics'),
			'rollOut'			=> esc_html__('Roll Out',		'mckinney-politics'),
			'slideOutUp'		=> esc_html__('Slide Out Up',	'mckinney-politics'),
			'slideOutDown'		=> esc_html__('Slide Out Down',	'mckinney-politics'),
			'slideOutLeft'		=> esc_html__('Slide Out Left',	'mckinney-politics'),
			'slideOutRight'		=> esc_html__('Slide Out Right','mckinney-politics'),
			'zoomOut'			=> esc_html__('Zoom Out',		'mckinney-politics'),
			'zoomOutUp'			=> esc_html__('Zoom Out Up',	'mckinney-politics'),
			'zoomOutDown'		=> esc_html__('Zoom Out Down',	'mckinney-politics'),
			'zoomOutLeft'		=> esc_html__('Zoom Out Left',	'mckinney-politics'),
			'zoomOutRight'		=> esc_html__('Zoom Out Right',	'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return classes list for the specified animation
if (!function_exists('mckinney_politics_get_animation_classes')) {
	function mckinney_politics_get_animation_classes($animation, $speed='normal', $loop='none') {
		return mckinney_politics_is_off($animation) ? '' : 'animated '.esc_attr($animation).' '.esc_attr($speed).(!mckinney_politics_is_off($loop) ? ' '.esc_attr($loop) : '');
	}
}


// Return list of categories
if ( !function_exists( 'mckinney_politics_get_list_categories' ) ) {
	function mckinney_politics_get_list_categories($prepend_inherit=false) {
		if (($list = mckinney_politics_storage_get('list_categories'))=='') {
			$list = array();
			$args = array(
				'type'                     => 'post',
				'child_of'                 => 0,
				'parent'                   => '',
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'               => 0,
				'hierarchical'             => 1,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => '',
				'taxonomy'                 => 'category',
				'pad_counts'               => false );
			$taxonomies = get_categories( $args );
			if (is_array($taxonomies) && count($taxonomies) > 0) {
				foreach ($taxonomies as $cat) {
					$list[$cat->term_id] = $cat->name;
				}
			}
			mckinney_politics_storage_set('list_categories', $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of taxonomies
if ( !function_exists( 'mckinney_politics_get_list_terms' ) ) {
	function mckinney_politics_get_list_terms($prepend_inherit=false, $taxonomy='category') {
		if (($list = mckinney_politics_storage_get('list_taxonomies_'.($taxonomy)))=='') {
			$list = array();
			$args = array(
				'child_of'                 => 0,
				'parent'                   => '',
				'orderby'                  => 'name',
				'order'                    => 'ASC',
				'hide_empty'               => 0,
				'hierarchical'             => 1,
				'exclude'                  => '',
				'include'                  => '',
				'number'                   => '',
				'taxonomy'                 => $taxonomy,
				'pad_counts'               => false );
			$taxonomies = get_terms( $taxonomy, $args );
			if (is_array($taxonomies) && count($taxonomies) > 0) {
				foreach ($taxonomies as $cat) {
					$list[$cat->term_id] = $cat->name;
				}
			}
			mckinney_politics_storage_set('list_taxonomies_'.($taxonomy), $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list of post's types
if ( !function_exists( 'mckinney_politics_get_list_posts_types' ) ) {
	function mckinney_politics_get_list_posts_types($prepend_inherit=false) {
		if (($list = mckinney_politics_storage_get('list_posts_types'))=='') {
			$list = get_post_types();
			mckinney_politics_storage_set('list_posts_types', $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list post items from any post type and taxonomy
if ( !function_exists( 'mckinney_politics_get_list_posts' ) ) {
	function mckinney_politics_get_list_posts($prepend_inherit=false, $opt=array()) {
		$opt = array_merge(array(
			'post_type'			=> 'post',
			'post_status'		=> 'publish',
			'taxonomy'			=> 'category',
			'taxonomy_value'	=> '',
			'posts_per_page'	=> -1,
			'orderby'			=> 'post_date',
			'order'				=> 'desc',
			'return'			=> 'id'
			), is_array($opt) ? $opt : array('post_type'=>$opt));

		$hash = 'list_posts_'.($opt['post_type']).'_'.($opt['taxonomy']).'_'.($opt['taxonomy_value']).'_'.($opt['orderby']).'_'.($opt['order']).'_'.($opt['return']).'_'.($opt['posts_per_page']);
		if (($list = mckinney_politics_storage_get($hash))=='') {
			$list = array();
			$list['none'] = esc_html__("- Not selected -", 'mckinney-politics');
			$args = array(
				'post_type' => $opt['post_type'],
				'post_status' => $opt['post_status'],
				'posts_per_page' => $opt['posts_per_page'],
				'ignore_sticky_posts' => true,
				'orderby'	=> $opt['orderby'],
				'order'		=> $opt['order']
			);
			if (!empty($opt['taxonomy_value'])) {
				$args['tax_query'] = array(
					array(
						'taxonomy' => $opt['taxonomy'],
						'field' => (int) $opt['taxonomy_value'] > 0 ? 'id' : 'slug',
						'terms' => $opt['taxonomy_value']
					)
				);
			}
			$posts = get_posts( $args );
			if (is_array($posts) && count($posts) > 0) {
				foreach ($posts as $post) {
					$list[$opt['return']=='id' ? $post->ID : $post->post_title] = $post->post_title;
				}
			}
			mckinney_politics_storage_set($hash, $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of registered users
if ( !function_exists( 'mckinney_politics_get_list_users' ) ) {
	function mckinney_politics_get_list_users($prepend_inherit=false, $roles=array('administrator', 'editor', 'author', 'contributor', 'shop_manager')) {
		if (($list = mckinney_politics_storage_get('list_users'))=='') {
			$list = array();
			$list['none'] = esc_html__("- Not selected -", 'mckinney-politics');
			$args = array(
				'orderby'	=> 'display_name',
				'order'		=> 'ASC' );
			$users = get_users( $args );
			if (is_array($users) && count($users) > 0) {
				foreach ($users as $user) {
					$accept = true;
					if (is_array($user->roles)) {
						if (is_array($user->roles) && count($user->roles) > 0) {
							$accept = false;
							foreach ($user->roles as $role) {
								if (in_array($role, $roles)) {
									$accept = true;
									break;
								}
							}
						}
					}
					if ($accept) $list[$user->user_login] = $user->display_name;
				}
			}
			mckinney_politics_storage_set('list_users', $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return menus list, prepended inherit
if ( !function_exists( 'mckinney_politics_get_list_menus' ) ) {
	function mckinney_politics_get_list_menus($prepend_inherit=false) {
		if (($list = mckinney_politics_storage_get('list_menus'))=='') {
			$list = array();
			$list['default'] = esc_html__("Default", 'mckinney-politics');
			$menus = wp_get_nav_menus();
			if (is_array($menus) && count($menus) > 0) {
				foreach ($menus as $menu) {
					$list[$menu->slug] = $menu->name;
				}
			}
			mckinney_politics_storage_set('list_menus', $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return custom sidebars list, prepended inherit and main sidebars item (if need)
if ( !function_exists( 'mckinney_politics_get_list_sidebars' ) ) {
	function mckinney_politics_get_list_sidebars($prepend_inherit=false) {
		if (($list = mckinney_politics_storage_get('list_sidebars'))=='') {
			$list = apply_filters('mckinney_politics_filter_list_sidebars', array(
				'sidebar_widgets'		=> esc_html__('Sidebar Widgets', 'mckinney-politics'),
				'header_widgets'		=> esc_html__('Header Widgets', 'mckinney-politics'),
				'above_page_widgets'	=> esc_html__('Above Page Widgets', 'mckinney-politics'),
				'above_content_widgets' => esc_html__('Above Content Widgets', 'mckinney-politics'),
				'below_content_widgets' => esc_html__('Below Content Widgets', 'mckinney-politics'),
				'below_page_widgets' 	=> esc_html__('Below Page Widgets', 'mckinney-politics'),
				'footer_widgets'		=> esc_html__('Footer Widgets', 'mckinney-politics')
				)
			);
			$custom_sidebars_number = max(0, min(10, mckinney_politics_get_theme_setting('custom_sidebars')));
			if ($custom_sidebars_number > 0) {
				for ($i=1; $i <= $custom_sidebars_number; $i++) {
					$list['custom_widgets_'.intval($i)] = sprintf(esc_html__('Custom Widgets %d', 'mckinney-politics'), $i);
				}
			}
			mckinney_politics_storage_set('list_sidebars', $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return sidebars positions
if ( !function_exists( 'mckinney_politics_get_list_sidebars_positions' ) ) {
	function mckinney_politics_get_list_sidebars_positions($prepend_inherit=false) {
		$list = array(
			'left'  => esc_html__('Left',  'mckinney-politics'),
			'right' => esc_html__('Right', 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return body styles list, prepended inherit
if ( !function_exists( 'mckinney_politics_get_list_body_styles' ) ) {
	function mckinney_politics_get_list_body_styles($prepend_inherit=false) {
		$list = array(
			'boxed'		=> esc_html__('Boxed',		'mckinney-politics'),
			'wide'		=> esc_html__('Wide',		'mckinney-politics'),
			'fullwide'	=> esc_html__('Fullwide',	'mckinney-politics'),
			'fullscreen'=> esc_html__('Fullscreen',	'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return blog styles list, prepended inherit
if ( !function_exists( 'mckinney_politics_get_list_blog_styles' ) ) {
	function mckinney_politics_get_list_blog_styles($prepend_inherit=false) {
		$list = array(
			'excerpt'	=> esc_html__('Excerpt','mckinney-politics'),
			'classic_2'	=> esc_html__('Classic /2 columns/',	'mckinney-politics'),
			'classic_3'	=> esc_html__('Classic /3 columns/',	'mckinney-politics'),
			'portfolio_2' => esc_html__('Portfolio /2 columns/','mckinney-politics'),
			'portfolio_3' => esc_html__('Portfolio /3 columns/','mckinney-politics'),
			'portfolio_4' => esc_html__('Portfolio /4 columns/','mckinney-politics'),
			'gallery_2' => esc_html__('Gallery /2 columns/',	'mckinney-politics'),
			'gallery_3' => esc_html__('Gallery /3 columns/',	'mckinney-politics'),
			'gallery_4' => esc_html__('Gallery /4 columns/',	'mckinney-politics'),
			'chess_1'	=> esc_html__('Chess /2 column/',		'mckinney-politics'),
			'chess_2'	=> esc_html__('Chess /4 columns/',		'mckinney-politics'),
			'chess_3'	=> esc_html__('Chess /6 columns/',		'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return blog contents list, prepended inherit
if ( !function_exists( 'mckinney_politics_get_list_blog_content' ) ) {
	function mckinney_politics_get_list_blog_content($prepend_inherit=false) {
		$list = array(
			'excerpt'	=> esc_html__('Excerpt',	'mckinney-politics'),
			'fullpost'	=> esc_html__('Full post',	'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with pagination styles
if ( !function_exists( 'mckinney_politics_get_list_paginations' ) ) {
	function mckinney_politics_get_list_paginations($prepend_inherit=false) {
		$list = array(
			'pages'	=> esc_html__("Page numbers", 'mckinney-politics'),
			'links'	=> esc_html__("Older/Newest", 'mckinney-politics'),
			'more'	=> esc_html__("Load more", 'mckinney-politics'),
			'infinite' => esc_html__("Infinite scroll", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the bg image positions
if ( !function_exists( 'mckinney_politics_get_list_bg_image_positions' ) ) {
	function mckinney_politics_get_list_bg_image_positions($prepend_inherit=false) {
		$list = array(
			'left top'		=> esc_html__('Left Top', 'mckinney-politics'),
			'center top'	=> esc_html__("Center Top", 'mckinney-politics'),
			'right top'		=> esc_html__("Right Top", 'mckinney-politics'),
			'left center'	=> esc_html__("Left Center", 'mckinney-politics'),
			'center center'	=> esc_html__("Center Center", 'mckinney-politics'),
			'right center'	=> esc_html__("Right Center", 'mckinney-politics'),
			'left bottom'	=> esc_html__("Left Bottom", 'mckinney-politics'),
			'center bottom'	=> esc_html__("Center Bottom", 'mckinney-politics'),
			'right bottom'	=> esc_html__("Right Bottom", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the bg image repeat
if ( !function_exists( 'mckinney_politics_get_list_bg_image_repeats' ) ) {
	function mckinney_politics_get_list_bg_image_repeats($prepend_inherit=false) {
		$list = array(
			'repeat'	=> esc_html__('Repeat', 'mckinney-politics'),
			'repeat-x'	=> esc_html__('Repeat X', 'mckinney-politics'),
			'repeat-y'	=> esc_html__('Repeat Y', 'mckinney-politics'),
			'no-repeat'	=> esc_html__('No Repeat', 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}


// Return list of the bg image attachment
if ( !function_exists( 'mckinney_politics_get_list_bg_image_attachments' ) ) {
	function mckinney_politics_get_list_bg_image_attachments($prepend_inherit=false) {
		$list = array(
			'scroll'	=> esc_html__('Scroll', 'mckinney-politics'),
			'fixed'		=> esc_html__('Fixed', 'mckinney-politics'),
			'local'		=> esc_html__('Local', 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with 'Yes' and 'No' items
if ( !function_exists( 'mckinney_politics_get_list_yesno' ) ) {
	function mckinney_politics_get_list_yesno($prepend_inherit=false) {
		$list = array(
			"yes"	=> esc_html__("Yes", 'mckinney-politics'),
			"no"	=> esc_html__("No", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with 'On' and 'Of' items
if ( !function_exists( 'mckinney_politics_get_list_onoff' ) ) {
	function mckinney_politics_get_list_onoff($prepend_inherit=false) {
		$list = array(
			"on"	=> esc_html__("On", 'mckinney-politics'),
			"off"	=> esc_html__("Off", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with 'Show' and 'Hide' items
if ( !function_exists( 'mckinney_politics_get_list_showhide' ) ) {
	function mckinney_politics_get_list_showhide($prepend_inherit=false) {
		$list = array(
			"show" => esc_html__("Show", 'mckinney-politics'),
			"hide" => esc_html__("Hide", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with 'Horizontal' and 'Vertical' items
if ( !function_exists( 'mckinney_politics_get_list_directions' ) ) {
	function mckinney_politics_get_list_directions($prepend_inherit=false) {
		$list = array(
			"horizontal" => esc_html__("Horizontal", 'mckinney-politics'),
			"vertical"   => esc_html__("Vertical", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with 'Simple' and 'Advanced' items
if ( !function_exists( 'mckinney_politics_get_list_user_skills' ) ) {
	function mckinney_politics_get_list_user_skills($prepend_inherit=false) {
		$list = array(
			"simple"  => esc_html__("Simple", 'mckinney-politics'),
			"advanced" => esc_html__("Advanced", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with item's shapes
if ( !function_exists( 'mckinney_politics_get_list_shapes' ) ) {
	function mckinney_politics_get_list_shapes($prepend_inherit=false) {
		$list = array(
			"round"  => esc_html__("Round", 'mckinney-politics'),
			"square" => esc_html__("Square", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with item's sizes
if ( !function_exists( 'mckinney_politics_get_list_sizes' ) ) {
	function mckinney_politics_get_list_sizes($prepend_inherit=false) {
		$list = array(
			"tiny"   => esc_html__("Tiny", 'mckinney-politics'),
			"small"  => esc_html__("Small", 'mckinney-politics'),
			"medium" => esc_html__("Medium", 'mckinney-politics'),
			"large"  => esc_html__("Large", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with float items
if ( !function_exists( 'mckinney_politics_get_list_floats' ) ) {
	function mckinney_politics_get_list_floats($prepend_inherit=false) {
		$list = array(
			"none"  => esc_html__("None", 'mckinney-politics'),
			"left"  => esc_html__("Float Left", 'mckinney-politics'),
			"right" => esc_html__("Float Right", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with alignment items
if ( !function_exists( 'mckinney_politics_get_list_alignments' ) ) {
	function mckinney_politics_get_list_alignments($justify=false, $prepend_inherit=false) {
		$list = array(
			"none"	=> esc_html__("None", 'mckinney-politics'),
			"left"	=> esc_html__("Left", 'mckinney-politics'),
			"center"=> esc_html__("Center", 'mckinney-politics'),
			"right"	=> esc_html__("Right", 'mckinney-politics')
		);
		if ($justify) $list["justify"] = esc_html__("Justify", 'mckinney-politics');
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list with columns widths
if ( !function_exists( 'mckinney_politics_get_list_columns' ) ) {
	function mckinney_politics_get_list_columns($prepend_inherit=false) {
		$list = array(
			"none" => esc_html__("None", 'mckinney-politics'),
			"1_1" => esc_html__("100%", 'mckinney-politics'),
			"1_2" => esc_html__("1/2", 'mckinney-politics'),
			"1_3" => esc_html__("1/3", 'mckinney-politics'),
			"2_3" => esc_html__("2/3", 'mckinney-politics'),
			"1_4" => esc_html__("1/4", 'mckinney-politics'),
			"3_4" => esc_html__("3/4", 'mckinney-politics'),
			"1_5" => esc_html__("1/5", 'mckinney-politics'),
			"2_5" => esc_html__("2/5", 'mckinney-politics'),
			"3_5" => esc_html__("3/5", 'mckinney-politics'),
			"4_5" => esc_html__("4/5", 'mckinney-politics'),
			"1_6" => esc_html__("1/6", 'mckinney-politics'),
			"5_6" => esc_html__("5/6", 'mckinney-politics'),
			"1_7" => esc_html__("1/7", 'mckinney-politics'),
			"2_7" => esc_html__("2/7", 'mckinney-politics'),
			"3_7" => esc_html__("3/7", 'mckinney-politics'),
			"4_7" => esc_html__("4/7", 'mckinney-politics'),
			"5_7" => esc_html__("5/7", 'mckinney-politics'),
			"6_7" => esc_html__("6/7", 'mckinney-politics'),
			"1_8" => esc_html__("1/8", 'mckinney-politics'),
			"3_8" => esc_html__("3/8", 'mckinney-politics'),
			"5_8" => esc_html__("5/8", 'mckinney-politics'),
			"7_8" => esc_html__("7/8", 'mckinney-politics'),
			"1_9" => esc_html__("1/9", 'mckinney-politics'),
			"2_9" => esc_html__("2/9", 'mckinney-politics'),
			"4_9" => esc_html__("4/9", 'mckinney-politics'),
			"5_9" => esc_html__("5/9", 'mckinney-politics'),
			"7_9" => esc_html__("7/9", 'mckinney-politics'),
			"8_9" => esc_html__("8/9", 'mckinney-politics'),
			"1_10"=> esc_html__("1/10", 'mckinney-politics'),
			"3_10"=> esc_html__("3/10", 'mckinney-politics'),
			"7_10"=> esc_html__("7/10", 'mckinney-politics'),
			"9_10"=> esc_html__("9/10", 'mckinney-politics'),
			"1_11"=> esc_html__("1/11", 'mckinney-politics'),
			"2_11"=> esc_html__("2/11", 'mckinney-politics'),
			"3_11"=> esc_html__("3/11", 'mckinney-politics'),
			"4_11"=> esc_html__("4/11", 'mckinney-politics'),
			"5_11"=> esc_html__("5/11", 'mckinney-politics'),
			"6_11"=> esc_html__("6/11", 'mckinney-politics'),
			"7_11"=> esc_html__("7/11", 'mckinney-politics'),
			"8_11"=> esc_html__("8/11", 'mckinney-politics'),
			"9_11"=> esc_html__("9/11", 'mckinney-politics'),
			"10_11"=> esc_html__("10/11", 'mckinney-politics'),
			"1_12"=> esc_html__("1/12", 'mckinney-politics'),
			"5_12"=> esc_html__("5/12", 'mckinney-politics'),
			"7_12"=> esc_html__("7/12", 'mckinney-politics'),
			"10_12"=> esc_html__("10/12", 'mckinney-politics'),
			"11_12"=> esc_html__("11/12", 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return list of locations for the featured content
if ( !function_exists( 'mckinney_politics_get_list_featured_locations' ) ) {
	function mckinney_politics_get_list_featured_locations($prepend_inherit=false) {
		$list = array(
			"default" => esc_html__('As in the post defined', 'mckinney-politics'),
			"center"  => esc_html__('Above the text of the post', 'mckinney-politics'),
			"left"    => esc_html__('To the left the text of the post', 'mckinney-politics'),
			"right"   => esc_html__('To the right the text of the post', 'mckinney-politics'),
			"alter"   => esc_html__('Alternates for each post', 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return post-format name
if ( !function_exists( 'mckinney_politics_get_post_format_name' ) ) {
	function mckinney_politics_get_post_format_name($format, $single=true) {
		$name = '';
		if ($format=='gallery')		$name = $single ? esc_html__('gallery', 'mckinney-politics') : esc_html__('galleries', 'mckinney-politics');
		else if ($format=='video')	$name = $single ? esc_html__('video', 'mckinney-politics') : esc_html__('videos', 'mckinney-politics');
		else if ($format=='audio')	$name = $single ? esc_html__('audio', 'mckinney-politics') : esc_html__('audios', 'mckinney-politics');
		else if ($format=='image')	$name = $single ? esc_html__('image', 'mckinney-politics') : esc_html__('images', 'mckinney-politics');
		else if ($format=='quote')	$name = $single ? esc_html__('quote', 'mckinney-politics') : esc_html__('quotes', 'mckinney-politics');
		else if ($format=='link')	$name = $single ? esc_html__('link', 'mckinney-politics') : esc_html__('links', 'mckinney-politics');
		else if ($format=='status')	$name = $single ? esc_html__('status', 'mckinney-politics') : esc_html__('statuses', 'mckinney-politics');
		else if ($format=='aside')	$name = $single ? esc_html__('aside', 'mckinney-politics') : esc_html__('asides', 'mckinney-politics');
		else if ($format=='chat')	$name = $single ? esc_html__('chat', 'mckinney-politics') : esc_html__('chats', 'mckinney-politics');
		else						$name = $single ? esc_html__('standard', 'mckinney-politics') : esc_html__('standards', 'mckinney-politics');
		return $name;
	}
}

// Return post-format icon name (from Fontello library)
if ( !function_exists( 'mckinney_politics_get_post_format_icon' ) ) {
	function mckinney_politics_get_post_format_icon($format) {
		$icon = 'icon-';
		if ($format=='gallery')		$icon .= 'pictures';
		else if ($format=='video')	$icon .= 'video';
		else if ($format=='audio')	$icon .= 'note';
		else if ($format=='image')	$icon .= 'picture';
		else if ($format=='quote')	$icon .= 'quote';
		else if ($format=='link')	$icon .= 'link';
		else if ($format=='status')	$icon .= 'comment';
		else if ($format=='aside')	$icon .= 'doc-text';
		else if ($format=='chat')	$icon .= 'chat';
		else						$icon .= 'book-open';
		return $icon;
	}
}

// Return fonts styles list, prepended inherit
if ( !function_exists( 'mckinney_politics_get_list_fonts_styles' ) ) {
	function mckinney_politics_get_list_fonts_styles($prepend_inherit=false) {
		$list = array(
			'i' => esc_html__('I','mckinney-politics'),
			'u' => esc_html__('U', 'mckinney-politics')
		);
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return Google fonts list
if ( !function_exists( 'mckinney_politics_get_list_fonts' ) ) {
	function mckinney_politics_get_list_fonts($prepend_inherit=false) {
		if (($list = mckinney_politics_storage_get('list_fonts'))=='') {
			// Google and custom fonts list:
			$list = array(
				'Advent Pro' => array('family'=>'sans-serif'),
				'Alegreya Sans' => array('family'=>'sans-serif'),
				'Arimo' => array('family'=>'sans-serif'),
				'Asap' => array('family'=>'sans-serif'),
				'Averia Sans Libre' => array('family'=>'cursive'),
				'Averia Serif Libre' => array('family'=>'cursive'),
				'Bree Serif' => array('family'=>'serif',),
				'Cabin' => array('family'=>'sans-serif'),
				'Cabin Condensed' => array('family'=>'sans-serif'),
				'Cardo' => array('family'=>'serif'),
				'Caudex' => array('family'=>'serif'),
				'Comfortaa' => array('family'=>'cursive'),
				'Cousine' => array('family'=>'sans-serif'),
				'Crimson Text' => array('family'=>'serif'),
				'Cuprum' => array('family'=>'sans-serif'),
				'Dosis' => array('family'=>'sans-serif'),
				'Economica' => array('family'=>'sans-serif'),
				'Exo' => array('family'=>'sans-serif'),
				'Expletus Sans' => array('family'=>'cursive'),
				'Karla' => array('family'=>'sans-serif'),
				'Lato' => array('family'=>'sans-serif'),
				'Lekton' => array('family'=>'sans-serif'),
				'Lobster Two' => array('family'=>'cursive'),
				'Maven Pro' => array('family'=>'sans-serif'),
				'Merriweather' => array('family'=>'serif'),
				'Montserrat' => array('family'=>'sans-serif'),
				'Neuton' => array('family'=>'serif'),
				'Noticia Text' => array('family'=>'serif'),
				'Old Standard TT' => array('family'=>'serif'),
				'Open Sans' => array('family'=>'sans-serif'),
				'Orbitron' => array('family'=>'sans-serif'),
				'Oswald' => array('family'=>'sans-serif'),
				'Overlock' => array('family'=>'cursive'),
				'Oxygen' => array('family'=>'sans-serif'),
				'PT Serif' => array('family'=>'serif'),
				'Puritan' => array('family'=>'sans-serif'),
				'Raleway' => array('family'=>'sans-serif'),
				'Roboto' => array('family'=>'sans-serif'),
				'Roboto Slab' => array('family'=>'sans-serif'),
				'Roboto Condensed' => array('family'=>'sans-serif'),
				'Rosario' => array('family'=>'sans-serif'),
				'Share' => array('family'=>'cursive'),
				'Signika' => array('family'=>'sans-serif'),
				'Signika Negative' => array('family'=>'sans-serif'),
				'Source Sans Pro' => array('family'=>'sans-serif'),
				'Tinos' => array('family'=>'serif'),
				'Ubuntu' => array('family'=>'sans-serif'),
				'Vollkorn' => array('family'=>'serif')
			);
			$list = mckinney_politics_array_merge($list, mckinney_politics_get_list_font_faces());
			mckinney_politics_storage_get('list_fonts', $list);
		}
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}

// Return Custom font-face list
if ( !function_exists( 'mckinney_politics_get_list_font_faces' ) ) {
	function mckinney_politics_get_list_font_faces($prepend_inherit=false) {
		static $list = false;
		if (is_array($list)) return $list;
		$list = array();
		$dir = mckinney_politics_get_folder_dir("css/font-face");
        if ( is_dir($dir) ) {
            $files = glob(sprintf("%s/*", $dir), GLOB_ONLYDIR);
            if ( is_array($files) ) {
                foreach ($files as $file) {
                    $file_name = basename($file);
                    if ( substr($file_name, 0, 1) == '.' || ! is_dir( ($dir) . '/' . ($file_name) ) )
                        continue;
                    $css = file_exists( ($dir) . '/' . ($file_name) . '/' . ($file_name) . '.css' )
                        ? mckinney_politics_get_file_url("css/font-face/".($file_name).'/'.($file_name).'.css')
                        : (file_exists( ($dir) . '/' . ($file_name) . '/stylesheet.css' )
                            ? mckinney_politics_get_file_url("css/font-face/".($file_name).'/stylesheet.css')
                            : '');
                    if ($css != '')
                        $list[$file_name.' ('.esc_html__('uploaded font', 'mckinney-politics').')'] = array('css' => $css);
                }
            }
        }
		return $list;
	}
}

// Return iconed classes list
if ( !function_exists( 'mckinney_politics_get_list_icons' ) ) {
	function mckinney_politics_get_list_icons($prepend_inherit=false) {
		static $list = false;
		if (is_array($list)) return $list;
		$list = mckinney_politics_parse_icons_classes(mckinney_politics_get_file_dir("css/fontello/css/fontello-codes.css"));
		return $prepend_inherit ? mckinney_politics_array_merge(array('inherit' => esc_html__("Inherit", 'mckinney-politics')), $list) : $list;
	}
}
?>