<?php
/**
 * Theme functions: init, enqueue scripts and styles, include required files and widgets
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */


if ( ! defined( 'MCKINNEY_POLITICS_THEME_PATH' ) )	define( 'MCKINNEY_POLITICS_THEME_PATH',	trailingslashit( get_template_directory() ) );

// Theme storage
$MCKINNEY_POLITICS_STORAGE = array(
	'required_plugins' => array(					// Theme required plugin's slugs
		'trx_addons',
		'js_composer',
		'revslider',
		'woocommerce',
		'the-events-calendar',
		'essgrids',
		'mailchimp-for-wp',
		'cool-timeline',
        'elegro-payment',
        'contact-form-7',
        'trx_updater'
	)
);

//-------------------------------------------------------
//-- Theme init
//-------------------------------------------------------

if ( !function_exists('mckinney_politics_theme_setup1') ) {
	
	add_action( 'after_setup_theme', 'mckinney_politics_theme_setup1', 1 );

	function mckinney_politics_theme_setup1() {
		// Set theme content width
		$GLOBALS['content_width'] = apply_filters( 'mckinney_politics_filter_content_width', 1170 );

    }
}

if ( !function_exists('mckinney_politics_theme_setup') ) {
	
	add_action( 'after_setup_theme', 'mckinney_politics_theme_setup' );

	function mckinney_politics_theme_setup() {

		// Add default posts and comments RSS feed links to head 
		add_theme_support( 'automatic-feed-links' );
		
		// Enable support for Post Thumbnails
		add_theme_support( 'post-thumbnails' );
		
		// Add thumb sizes
		// ATTENTION! If you change list below - check filter's names in the 'trx_addons_filter_get_thumb_size' hook
		$thumb_sizes = apply_filters('mckinney_politics_filter_add_thumb_sizes', array(
			'mckinney_politics-thumb-huge'	=> array(1170, 731, true),
			'mckinney_politics-thumb-big' 	=> array( 770, 481, true),
			'mckinney_politics-thumb-med' 	=> array( 370, 260, true),
			'mckinney_politics-thumb-small'	=> array( 270, 169, true),
			'mckinney_politics-thumb-tiny' 	=> array( 107,  70, true),
			'mckinney_politics-thumb-portrait'=> array( 324, 250, true),
			'mckinney_politics-thumb-avatar'	=> array( 370, 370, true),
			'mckinney_politics-thumb-masonry'	=> array( 370,   0, false),		// Only downscale, not crop
			'mckinney_politics-thumb-masonry-big' => array( 770,   0, false),	// Only downscale, not crop
			'mckinney_politics-thumb-big-extra' 	=> array( 660, 880, true),
			)
		);
		$mult = mckinney_politics_get_theme_option('retina_ready', 1);
		if ($mult > 1) $GLOBALS['content_width'] = apply_filters( 'mckinney_politics_filter_content_width', 1170*$mult);
		foreach ($thumb_sizes as $k=>$v) {
			// Add Original dimensions
			add_image_size( $k, $v[0], $v[1], $v[2]);
			// Add Retina dimensions
			if ($mult > 1) add_image_size( $k.'-@retina', $v[0]*$mult, $v[1]*$mult, $v[2]);
		}
		
		// Custom header setup
		add_theme_support( 'custom-header', array(
			'header-text'=>false
			)
		);

		// Custom backgrounds setup
		add_theme_support( 'custom-background', array()	);
		
		// Supported posts formats
		add_theme_support( 'post-formats', array('gallery', 'video', 'audio', 'link', 'quote', 'image', 'status', 'aside', 'chat') ); 
 
 		// Autogenerate title tag
		add_theme_support('title-tag');
 		
		// Add theme menus
		add_theme_support('nav-menus');
		
		// Switch default markup for search form, comment form, and comments to output valid HTML5.
		add_theme_support( 'html5', array('search-form', 'comment-form', 'comment-list', 'gallery', 'caption') );
		
		// WooCommerce Support
		add_theme_support( 'woocommerce' );
		
		// Editor custom stylesheet - for user
		add_editor_style( array_merge(
			array(
				'css/editor-style.css',
				mckinney_politics_get_file_url('css/fontello/css/fontello-embedded.css')
			),
			mckinney_politics_theme_fonts_for_editor()
			)
		);	
		
		// Make theme available for translation
		// Translations can be filed in the /languages/ directory
		load_theme_textdomain( 'mckinney-politics', mckinney_politics_get_folder_dir('languages') );
	
		// Register navigation menu
		register_nav_menus(array(
			'menu_main' => esc_html__('Main Menu', 'mckinney-politics')
			)
		);

		// Excerpt filters
		add_filter( 'excerpt_length',						'mckinney_politics_excerpt_length' );
		add_filter( 'excerpt_more',							'mckinney_politics_excerpt_more' );
		
		// Add required meta tags in the head
		add_action('wp_head',		 						'mckinney_politics_wp_head', 1);

		// Enqueue scripts and styles for frontend
		add_action('wp_enqueue_scripts', 					'mckinney_politics_wp_scripts', 1000);			//priority 1000 - load styles before plugin custom styles with priority 1100
		add_action('wp_enqueue_scripts', 					'mckinney_politics_wp_scripts_responsive', 2000);	//priority 2000 - load responsive after all other styles
		
		// Add body classes
		add_filter( 'body_class',							'mckinney_politics_add_body_classes' );

		// Enqueue scripts and styles for admin
		add_action("admin_enqueue_scripts",					'mckinney_politics_admin_scripts');

		// Register sidebars
		add_action('widgets_init', 							'mckinney_politics_widgets_init');

		// TGM Activation plugin
		add_action('tgmpa_register',						'mckinney_politics_register_plugins');

		// Set options for importer (before other plugins)
		add_filter( 'mckinney_politics_filter_importer_options',		'mckinney_politics_importer_set_options', 9 );

	}

}


//-------------------------------------------------------
//-- Thumb sizes
//-------------------------------------------------------
if ( !function_exists('mckinney_politics_image_sizes') ) {
	add_filter( 'image_size_names_choose', 'mckinney_politics_image_sizes' );
	function mckinney_politics_image_sizes( $sizes ) {
		$thumb_sizes = apply_filters('mckinney_politics_filter_add_thumb_sizes', array(
			'mckinney_politics-thumb-full'	=> esc_html__( 'Fullsize image', 'mckinney-politics' ),
			'mckinney_politics-thumb-big'		=> esc_html__( 'Large image', 'mckinney-politics' ),
			'mckinney_politics-thumb-med'		=> esc_html__( 'Medium image', 'mckinney-politics' ),
			'mckinney_politics-thumb-small'	=> esc_html__( 'Small image', 'mckinney-politics' ),
			'mckinney_politics-thumb-avatar'	=> esc_html__( 'Big square avatar', 'mckinney-politics' ),
			'mckinney_politics-thumb-tiny'	=> esc_html__( 'Small square avatar', 'mckinney-politics' ),
			'mckinney_politics-thumb-masonry'	=> esc_html__( 'Masonry (scaled)', 'mckinney-politics' ),
			'mckinney_politics-thumb-masonry-big'	=> esc_html__( 'Masonry Large (scaled)', 'mckinney-politics' )
			)
		);
		$mult = mckinney_politics_get_theme_option('retina_ready', 1);
		foreach($thumb_sizes as $k=>$v) {
			$sizes[$k] = $v;
			if ($mult > 1) $sizes[$k.'-@retina'] = $v.' '.esc_html__('@2x', 'mckinney-politics' );
		}
		return $sizes;
	}
}


//-------------------------------------------------------
//-- Theme scripts and styles
//-------------------------------------------------------

// Load frontend scripts
if ( !function_exists( 'mckinney_politics_wp_scripts' ) ) {
	//Handler of add_action('wp_enqueue_scripts', 'mckinney_politics_wp_scripts', 1000);
	function mckinney_politics_wp_scripts() {

		// Enqueue styles
		//------------------------

		// Links to selected fonts
		$links = mckinney_politics_theme_fonts_links();
		if (count($links) > 0) {
			foreach ($links as $slug => $link) {
				wp_enqueue_style( 'mckinney-politics-font-'.trim($slug), $link );
			}
		}
		
		// Fontello styles must be loaded before main stylesheet
		// This style NEED theme prefix, because style 'fontello' some plugin contain different set of characters
		// and can't be used instead this style!
		wp_enqueue_style( 'fontello-icons',  mckinney_politics_get_file_url('css/fontello/css/fontello-embedded.css') );

		// Main stylesheet
		wp_enqueue_style( 'mckinney-politics-main', get_stylesheet_uri(), array(), null );
		
		// Animations
		if ( (mckinney_politics_get_theme_option('blog_animation')!='none' || mckinney_politics_get_theme_option('menu_animation_in')!='none' || mckinney_politics_get_theme_option('menu_animation_out')!='none') && (mckinney_politics_get_theme_option('animation_on_mobile')=='yes' || !wp_is_mobile()) && !mckinney_politics_vc_is_frontend())
			wp_enqueue_style( 'mckinney-politics-animation',	mckinney_politics_get_file_url('css/animation.css') );

		// Custom colors
		if ( !is_customize_preview() && !isset($_GET['color_scheme']) && mckinney_politics_is_off(mckinney_politics_get_theme_option('debug_mode')) )
			wp_enqueue_style( 'mckinney-politics-colors', mckinney_politics_get_file_url('css/__colors.css') );
		else
			wp_add_inline_style( 'mckinney-politics-main', mckinney_politics_customizer_get_css() );

		// Merged styles
		if ( mckinney_politics_is_off(mckinney_politics_get_theme_option('debug_mode')) )
			wp_enqueue_style( 'mckinney-politics-styles', mckinney_politics_get_file_url('css/__styles.css') );

		// Add post nav background
		mckinney_politics_add_bg_in_post_nav();

		// Disable loading JQuery UI CSS
		wp_deregister_style('jquery_ui');
		wp_deregister_style('date-picker-css');


		// Enqueue scripts	
		//------------------------
		
		// Disable slider on "Cool timeline" shortcode
		wp_enqueue_script( 'slick', mckinney_politics_get_file_url('js/slick.min.js'), array('jquery'), null, true );
		
		// Modernizr will load in head before other scripts and styles
		if ( substr(mckinney_politics_get_theme_option('blog_style'), 0, 7) == 'gallery' || substr(mckinney_politics_get_theme_option('blog_style'), 0, 9) == 'portfolio' )
			wp_enqueue_script( 'modernizr', mckinney_politics_get_file_url('js/theme.gallery/modernizr.min.js'), array(), null, false );
		
		// Merged scripts
		if ( mckinney_politics_is_off(mckinney_politics_get_theme_option('debug_mode')) )
			wp_enqueue_script( 'mckinney-politics-init', mckinney_politics_get_file_url('js/__scripts.js'), array('jquery'), null, true );
		else {
			// Skip link focus
			wp_enqueue_script( 'skip-link-focus-fix', mckinney_politics_get_file_url('js/skip-link-focus-fix.js') );
			// Superfish Menu
			wp_enqueue_script( 'superfish', mckinney_politics_get_file_url('js/superfish.js'), array('jquery') );
			// Background video
			$header_video = mckinney_politics_get_theme_option('header_video');
			if (!empty($header_video) && !mckinney_politics_is_inherit($header_video))
				wp_enqueue_script( 'bideo', mckinney_politics_get_file_url('js/bideo.js'), array() );
			// Theme scripts
			wp_enqueue_script( 'mckinney-politics-utils', mckinney_politics_get_file_url('js/_utils.js'), array('jquery'), null, true );
			wp_enqueue_script( 'mckinney-politics-init', mckinney_politics_get_file_url('js/_init.js'), array('jquery'), null, true );
		}
		
		// Comments
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}

		// Media elements library	
		if (mckinney_politics_get_theme_setting('use_mediaelements')) {
			wp_enqueue_style ( 'mediaelement' );
			wp_enqueue_style ( 'wp-mediaelement' );
			wp_enqueue_script( 'mediaelement' );
			wp_enqueue_script( 'wp-mediaelement' );
		}

		wp_localize_script( 'mckinney-politics-init', 'MCKINNEY_POLITICS_STORAGE', apply_filters( 'mckinney_politics_filter_localize_script', array(
			// AJAX parameters
			'ajax_url' => esc_url(admin_url('admin-ajax.php')),
			'ajax_nonce' => esc_attr(wp_create_nonce(admin_url('admin-ajax.php'))),
			
			// Site base url
			'site_url' => get_site_url(),
			
			// User logged in
			'user_logged_in' => is_user_logged_in() ? true : false,
			
			// Menu width for mobile mode
			'mobile_layout_width' => max(480, mckinney_politics_get_theme_option('mobile_layout_width')),

			// Use menu cache
			'menu_cache' => mckinney_politics_is_on(mckinney_politics_get_theme_option('menu_cache')),

			// Menu animation
			'menu_animation_in' => mckinney_politics_get_theme_option('menu_animation_in'),
            'menu_animation_out' => mckinney_politics_get_theme_option('menu_animation_out'),

			// Video background
			'background_video' => mckinney_politics_get_theme_option('header_video'),

			// Video and Audio tag wrapper
			'use_mediaelements' => mckinney_politics_get_theme_setting('use_mediaelements') ? true : false,

			// Messages max length
			'message_maxlength'	=> intval(mckinney_politics_get_theme_setting('message_maxlength')),
						
			// Site color scheme
			'site_scheme' => 'scheme_' . trim(mckinney_politics_get_theme_option('color_scheme')),

			
			// Internal vars - do not change it!
			
			// Flag for review mechanism
			'admin_mode' => false,

			// E-mail mask
			'email_mask' => '^([a-zA-Z0-9_\\-]+\\.)*[a-zA-Z0-9_\\-]+@[a-z0-9_\\-]+(\\.[a-z0-9_\\-]+)*\\.[a-z]{2,6}$',
			
			// Strings for translation
			'strings' => array(
					'ajax_error'		=> esc_html__('Invalid server answer!', 'mckinney-politics'),
					'error_global'		=> esc_html__('Error data validation!', 'mckinney-politics'),
					'name_empty' 		=> esc_html__("The name can't be empty", 'mckinney-politics'),
					'name_long'			=> esc_html__('Too long name', 'mckinney-politics'),
					'email_empty'		=> esc_html__('Too short (or empty) email address', 'mckinney-politics'),
					'email_long'		=> esc_html__('Too long email address', 'mckinney-politics'),
					'email_not_valid'	=> esc_html__('Invalid email address', 'mckinney-politics'),
					'text_empty'		=> esc_html__("The message text can't be empty", 'mckinney-politics'),
					'text_long'			=> esc_html__('Too long message text', 'mckinney-politics'),
					'search_error'		=> esc_html__('Search error! Try again later.', 'mckinney-politics'),
					'send_complete'		=> esc_html__("Send message complete!", 'mckinney-politics'),
					'send_error'		=> esc_html__('Transmit failed!', 'mckinney-politics')
					)
			))
		);
	}
}

// Load responsive styles (priority 2000 - load it after main styles and plugins custom styles)
if ( !function_exists( 'mckinney_politics_wp_scripts_responsive' ) ) {
	//Handler of add_action('wp_enqueue_scripts', 'mckinney_politics_wp_scripts_responsive', 2000);
	function mckinney_politics_wp_scripts_responsive() {
		wp_enqueue_style( 'mckinney-politics-responsive', mckinney_politics_get_file_url('css/responsive.css') );
	}
}

//  Add meta tags and inline scripts in the header for frontend
if (!function_exists('mckinney_politics_wp_head')) {
	//Handler of add_action('wp_head',	'mckinney_politics_wp_head', 1);
	function mckinney_politics_wp_head() {
		?>
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<link rel="profile" href="//gmpg.org/xfn/11">
		<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
		<?php
	}
}

// Add theme specified classes into the body
if ( !function_exists('mckinney_politics_add_body_classes') ) {
	//Handler of add_filter( 'body_class', 'mckinney_politics_add_body_classes' );
	function mckinney_politics_add_body_classes( $classes ) {
		$classes[] = 'body_tag';	// Need for the .scheme_self
		$classes[] = 'body_style_' . trim(mckinney_politics_get_theme_option('body_style'));
		$classes[] = 'scheme_' . trim(mckinney_politics_get_theme_option('color_scheme'));
		$blog_mode = mckinney_politics_storage_get('blog_mode');
		$classes[] = 'blog_mode_' . trim($blog_mode);
		if (in_array($blog_mode, array('post', 'page'))) {
			$classes[] = 'is_single';
		} else {
			$classes[] = ' is_stream';
			$classes[] = 'blog_style_'.trim(mckinney_politics_get_theme_option('blog_style'));
		}
		if (mckinney_politics_sidebar_present()) {
			$classes[] = 'sidebar_show sidebar_' . trim(mckinney_politics_get_theme_option('sidebar_position')) ;
		} else {
			$classes[] = 'sidebar_hide';
			if (mckinney_politics_is_on(mckinney_politics_get_theme_option('expand_content')))
				 $classes[] = 'expand_content';
		}
		if (mckinney_politics_is_on(mckinney_politics_get_theme_option('remove_margins')))
			 $classes[] = 'remove_margins';
		$classes[] = 'header_style_' . trim(mckinney_politics_get_theme_option("header_style"));
		$classes[] = 'header_position_' . trim(mckinney_politics_get_theme_option("header_position"));
		$classes[] = 'header_title_' . (mckinney_politics_need_page_title() ? 'on' : 'off');
		$classes[] = 'menu_style_' . trim(mckinney_politics_get_theme_option("menu_style"));
		$classes[] = 'no_layout';
		return $classes;
	}
}
	
// Load required styles and scripts for admin mode
if ( !function_exists( 'mckinney_politics_admin_scripts' ) ) {
	//Handler of add_action("admin_enqueue_scripts", 'mckinney_politics_admin_scripts');
	function mckinney_politics_admin_scripts() {

		// Add theme styles
		wp_enqueue_style(  'mckinney-politics-admin',  mckinney_politics_get_file_url('css/admin.css') );

		// Links to selected fonts
		$screen = get_current_screen();
		if (mckinney_politics_allow_override_options($screen->id) && mckinney_politics_allow_override_options($screen->post_type)) {
			// Load fontello icons
			// This style NEED theme prefix, because style 'fontello' some plugin contain different set of characters
			// and can't be used instead this style!
			wp_enqueue_style(  'fontello-icons', mckinney_politics_get_file_url('css/fontello/css/fontello-embedded.css') );
			// Load theme fonts
			$links = mckinney_politics_theme_fonts_links(false);
			if (count($links) > 0) {
				foreach ($links as $slug => $link) {
					wp_enqueue_style( 'mckinney-politics-font-'.trim($slug), $link );
				}
			}
		}

		// Add theme scripts
		wp_enqueue_script( 'mckinney-politics-utils', mckinney_politics_get_file_url('js/_utils.js'), array('jquery'), null, true );
		wp_enqueue_script( 'mckinney-politics-admin', mckinney_politics_get_file_url('js/_admin.js'), array('jquery'), null, true );

		wp_localize_script( 'mckinney-politics-admin', 'MCKINNEY_POLITICS_STORAGE', apply_filters( 'mckinney_politics_filter_localize_script_admin', array(
			'admin_mode' => true,
			'ajax_url' => esc_url(admin_url('admin-ajax.php')),
			'ajax_nonce' => esc_attr(wp_create_nonce(admin_url('admin-ajax.php'))),
			'importer_error_msg' => esc_html__('Errors that occurred during the import process:', 'mckinney-politics'),
			'user_logged_in' => true
			))
		);
	}
}


//-------------------------------------------------------
//-- Sidebars and widgets
//-------------------------------------------------------

// Register widgetized areas
if ( !function_exists('mckinney_politics_widgets_init') ) {
	// Handler of add_action('widgets_init', 'mckinney_politics_widgets_init');
	function mckinney_politics_widgets_init() {
		$sidebars = mckinney_politics_get_list_sidebars();
		if (is_array($sidebars) && count($sidebars) > 0) {
			$args = mckinney_politics_get_widgets_args();
			foreach ($sidebars as $id=>$name) {
				register_sidebar( array_merge( array(
													'name'          => $name,
													'id'            => $id
												),
												$args
											)
				);
			}
		}
	}
}


//-------------------------------------------------------
//-- Theme fonts
//-------------------------------------------------------

// Return links for all theme fonts
if ( !function_exists('mckinney_politics_theme_fonts_links') ) {
	function mckinney_politics_theme_fonts_links($all_tags=true) {
		$links = array();
		
		/*
		Translators: If there are characters in your language that are not supported
		by chosen font(s), translate this to 'off'. Do not translate into your own language.
		*/
		$google_fonts_enabled = ( 'off' !== esc_html_x( 'on', 'Google fonts: on or off', 'mckinney-politics' ) );
		$custom_fonts_enabled = ( 'off' !== esc_html_x( 'on', 'Custom fonts (included in the theme): on or off', 'mckinney-politics' ) );
		
		if ( ($google_fonts_enabled || $custom_fonts_enabled) && !mckinney_politics_storage_empty('theme_fonts') ) {
			$theme_fonts = mckinney_politics_storage_get('theme_fonts');
			if (count($theme_fonts) > 0) {
				$google_fonts = '';
				foreach ($theme_fonts as $tag => $font) {
					if (!$all_tags && in_array($tag, array('logo', 'info', 'menu', 'submenu', 'decor'))) continue;	// Skip non content tags (for admin mode)
					if (empty($font['family']) || mckinney_politics_is_inherit($font['family']) || (empty($font['link']) && empty($font['css']))) continue;
					$font_name = str_replace('"', '', ($pos=strpos($font['family'], ','))!==false ? substr($font['family'], 0, $pos) : $font['family']);
					if (!empty($font['css'])) {
						if ($custom_fonts_enabled) {
							$links[str_replace(' ', '-', $font_name)] = $font['css'];
						}
					} else {
						if ($google_fonts_enabled) {
							$google_fonts .= ($google_fonts ? '|' : '') 
											. (!empty($font['link']) ? $font['link'] : str_replace(' ', '+', $font_name).':400,400italic,700,700italic');
						}
					}
				}
				if ($google_fonts && $google_fonts_enabled)
					$links['google_fonts'] = mckinney_politics_get_protocol() . '://fonts.googleapis.com/css?family=' . trim($google_fonts) . '&subset=latin,latin-ext';
			}
		}
		return $links;
	}
}

// Return links for WP Editor
if ( !function_exists('mckinney_politics_theme_fonts_for_editor') ) {
	function mckinney_politics_theme_fonts_for_editor() {
		$links = array_values(mckinney_politics_theme_fonts_links(false));
		if (is_array($links) && count($links) > 0) {
			for ($i=0; $i<count($links); $i++) {
				$links[$i] = str_replace(',', '%2C', $links[$i]);
			}
		}
		return $links;
	}
}


//-------------------------------------------------------
//-- The Excerpt
//-------------------------------------------------------
if ( !function_exists('mckinney_politics_excerpt_length') ) {
	function mckinney_politics_excerpt_length( $length ) {
		return max(1, mckinney_politics_get_theme_setting('max_excerpt_length'));
	}
}

if ( !function_exists('mckinney_politics_excerpt_more') ) {
	function mckinney_politics_excerpt_more( $more ) {
		return '&hellip;';
	}
}

/**
 * Fire the wp_body_open action.
 *
 * Added for backwards compatibility to support pre 5.2.0 WordPress versions.
 */
if ( ! function_exists( 'wp_body_open' ) ) {
    function wp_body_open() {
        /**
         * Triggered after the opening <body> tag.
         */
        do_action('wp_body_open');
    }
}

//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( ! function_exists( 'mckinney_politics_importer_set_options' ) ) {
    add_filter( 'trx_addons_filter_importer_options', 'mckinney_politics_importer_set_options', 9 );
    function mckinney_politics_importer_set_options( $options=array() ) {
        if ( is_array( $options ) ) {
            // Save or not installer's messages to the log-file
            $options['debug'] = false;
            // Prepare demo data
            if ( is_dir( MCKINNEY_POLITICS_THEME_PATH . 'demo/' ) ) {
                $options['demo_url'] = MCKINNEY_POLITICS_THEME_PATH . 'demo/';
            } else {
                $options['demo_url'] = esc_url( mckinney_politics_get_protocol().'://demofiles.themerex.net/mckinney-politics' ); // Demo-site domain
            }

            // Required plugins
            $options['required_plugins'] =  array(
                'essential-grid',
                'revslider',
                'mailchimp-for-wp',
                'js_composer',
                'woocommerce'
            );

            $options['theme_slug'] = 'mckinney_politics';

            // Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
            // Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
            $options['regenerate_thumbnails'] = 0;
            // Default demo
            $options['files']['default']['title'] = esc_html__( 'Mckinney Politics', 'mckinney-politics' );
            $options['files']['default']['domain_dev'] = esc_url( mckinney_politics_get_protocol().'://mckinney-politics.themerex.net'); // Developers domain
          	$options['files']['default']['domain_demo']= esc_url( mckinney_politics_get_protocol().'://mckinney-politics.themerex.net'); // Demo-site domain

        }
        return $options;
    }
}



//-------------------------------------------------------
//-- Third party plugins
//-------------------------------------------------------

// Register optional plugins
if ( !function_exists( 'mckinney_politics_register_plugins' ) ) {
	function mckinney_politics_register_plugins() {
		tgmpa(	apply_filters('mckinney_politics_filter_tgmpa_required_plugins', array(
				// Plugins to include in the autoinstall queue.
				)),
				array(
					'id'           => 'tgmpa',                 // Unique ID for hashing notices for multiple instances of TGMPA.
					'default_path' => '',                      // Default absolute path to bundled plugins.
					'menu'         => 'tgmpa-install-plugins', // Menu slug.
					'parent_slug'  => 'themes.php',            // Parent menu slug.
					'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
					'has_notices'  => true,                    // Show admin notices or not.
					'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
					'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
					'is_automatic' => true,                    // Automatically activate plugins after installation or not.
					'message'      => ''                       // Message to output right before the plugins table.
				)
			);
	}
}



//-------------------------------------------------------
//-- Include theme (or child) PHP-files
//-------------------------------------------------------

require_once trailingslashit( get_template_directory() ) . 'includes/utils.php';
require_once trailingslashit( get_template_directory() ) . 'includes/storage.php';
require_once trailingslashit( get_template_directory() ) . 'includes/lists.php';
require_once trailingslashit( get_template_directory() ) . 'includes/wp.php';

require_once trailingslashit( get_template_directory() ) . 'includes/theme.tags.php';
require_once trailingslashit( get_template_directory() ) . 'includes/theme.hovers/theme.hovers.php';

if (is_admin()) {
	require_once trailingslashit( get_template_directory() ) . 'includes/tgmpa/class-tgm-plugin-activation.php';
}

require_once trailingslashit( get_template_directory() ) . 'theme-options/theme.customizer.php';

// Plugins support
if (is_array($MCKINNEY_POLITICS_STORAGE['required_plugins']) && count($MCKINNEY_POLITICS_STORAGE['required_plugins']) > 0) {
	foreach ($MCKINNEY_POLITICS_STORAGE['required_plugins'] as $plugin_slug) {
		require_once trailingslashit( get_template_directory() ) . 'plugins/plugin.'.trim(mckinney_politics_esc($plugin_slug)).'.php';
	}
}
?>