<?php
/**
 * The default template for displaying content of the single post, page or attachment
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'post_item_single post_type_'.esc_attr(get_post_type()) 
												. ' post_format_'.esc_attr(str_replace('post-format-', '', get_post_format())) 
												. ' itemscope'
												); ?>
		itemscope itemtype="//schema.org/<?php echo esc_attr(is_single() ? 'BlogPosting' : 'Article'); ?>">

	<?php

	// Featured image
	if ( !get_query_var('mckinney_politics_featured_showed', false) )
		mckinney_politics_show_post_featured();

	// Title and post meta
	if ( !get_query_var('mckinney_politics_title_showed', false) && !in_array(get_post_format(), array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			the_title( '<h2 class="post_title entry-title" itemprop="headline">', '</h2>' );
			// Post meta
			mckinney_politics_show_post_meta(array(
				'seo' => true,
				'share' => false,
				'counters' => 'comments,views,likes'
				)
			);
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	?>
	<div class="post_content entry-content" itemprop="articleBody">
		<?php
			the_content( );

			wp_link_pages( array(
				'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'mckinney-politics' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'mckinney-politics' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

			// Taxonomies and share
			if ( is_single() && !is_attachment() ) {
				?>
				<div class="post_meta post_meta_single"><?php
					
					// Post taxonomies
					?><span class="post_meta_item post_tags"><span class="post_meta_label"><?php esc_html_e('Tags:', 'mckinney-politics'); ?></span> <?php the_tags( '', ', ', '' ); ?></span><?php

					// Share
					$output = mckinney_politics_get_share_links(array(
							'type' => 'block',
							'caption' => '',
							'echo' => false
						));
					if ($output) {
						?><span class="post_meta_item post_share"><?php mckinney_politics_show_layout($output); ?></span><?php
					}
					?>
				</div>
				<?php
			}
		?>
	</div><!-- .entry-content -->

	<?php
		// Author bio.
		if ( is_single() && !is_attachment() && get_the_author_meta( 'description' ) ) {
			get_template_part( 'templates/author-bio' );
		}
	?>

</article>
