<?php
/**
 * The Classic template for displaying content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage MCKINNEY_POLITICS
 * @since MCKINNEY_POLITICS 1.0
 */

$blog_style = explode('_', mckinney_politics_get_theme_option('blog_style'));
$columns = empty($blog_style[1]) ? 2 : max(2, $blog_style[1]);
$expanded = !mckinney_politics_sidebar_present() && mckinney_politics_is_on(mckinney_politics_get_theme_option('expand_content'));
$post_format = get_post_format();
$post_format = empty($post_format) ? 'standard' : str_replace('post-format-', '', $post_format);
$animation = mckinney_politics_get_theme_option('blog_animation');

?><div class="column-1_<?php echo esc_attr($columns); ?>"><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_classic post_layout_classic_'.esc_attr($columns).' post_format_'.esc_attr($post_format) ); ?>
	<?php echo (!mckinney_politics_is_off($animation) ? ' data-animation="'.esc_attr(mckinney_politics_get_animation_classes($animation)).'"' : ''); ?>
	>

	<?php

	// Featured image
	mckinney_politics_show_post_featured( array( 'thumb_size' => mckinney_politics_get_thumb_size(
													strpos(mckinney_politics_get_theme_option('body_style'), 'full')!==false 
														? ( $columns > 2 ? 'big' : 'huge' )
														: (	$columns > 2
															? ($expanded ? 'med' : 'small')
															: ($expanded ? 'big' : 'med')
															)
														)
										) );

	if ( !in_array($post_format, array('link', 'aside', 'status', 'quote')) ) {
		?>
		<div class="post_header entry-header">
			<?php 
			// Post meta
			mckinney_politics_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
			// Post title
			the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
			?>
		</div><!-- .entry-header -->
		<?php
	}		
	?>

	<div class="post_content entry-content">
		<div class="post_content_inner">
			<?php
			$show_learn_more = false;
			if (has_excerpt()) {
				the_excerpt();
			} else if (strpos(get_the_content('!--more'), '!--more')!==false) {
				the_content( '' );
			} else if (in_array($post_format, array('link', 'aside', 'status', 'quote'))) {
				the_content();
			} else {
				the_excerpt();
			}
			?>
		</div>
		<?php
		// Post meta
		if (in_array($post_format, array('link', 'aside', 'status', 'quote'))) {
			mckinney_politics_show_post_meta(array(
				'share' => false,
				'counters' => 'comments'
				)
			);
		}
		// More button
		if ( $show_learn_more ) {
			?><p><a class="more-link" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'mckinney-politics'); ?></a></p><?php
		}
		?>
	</div><!-- .entry-content -->

</article></div>