<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$kiante_logo = kiante_get_option( 'theme_logo' );
$kiante_logo_id = isset($kiante_logo['id']) && !empty($kiante_logo['id']) ? $kiante_logo['id'] : '';
$kiante_logo_url = isset( $kiante_logo[ 'url' ] ) ? $kiante_logo[ 'url' ] : '';
$kiante_logo_alt = get_post_meta($kiante_logo_id,'_wp_attachment_image_alt',true);


$kiante_header_top = kiante_get_option('header_top_enable');


$header_date = kiante_get_option('header_top_calender');
$header_weather = kiante_get_option('header_top_weather');
$waether_text = kiante_get_option('waether_text');

$kiante_header_search = kiante_get_option('search_bar_enable', true);
$login_btn_enable = kiante_get_option('login_btn_enable');
$register_btn_enable = kiante_get_option('register_btn_enable');

$kiante_header_social = kiante_get_option('header_social_enable');
$kiante_social_icon = kiante_get_option( 'social-icon' );



?>

<header id="theme-header-one" class="theme_header__main header-style-one">
	
	<?php if($kiante_header_top == true) : ?>
	<div class="top-header-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-md-6 col-sm-6">
				
					<?php if($header_weather == true) :?>
					<div class="header-weather">
						<?php echo esc_html($waether_text); ?>
					</div>
					<?php endif; ?>
					
					<?php if($header_date == true) :?>
					<div class="header-date">
						<?php echo date(get_option('date_format')); ?>
					</div>
					<?php endif; ?>
					
				</div>
				<div class="col-md-6 col-sm-6 text-right header-top-right-box">
					
					
					<?php if($kiante_header_social == true) : ?>
					
					<div class="htop_social">
					
					<?php 
						if ( ! empty( $kiante_social_icon ) ) : 
						foreach( $kiante_social_icon as $item ) :
					?>
					
					
						<a href="<?php echo esc_url( $item['link'] ); ?>" target="_blank" class="social-list__link"><i class="<?php echo esc_attr( $item['icon'] ); ?>"></i></a>
						
						
					<?php 
						endforeach; 
						endif; 
					?>

					
					</div>
					
					<?php endif; ?>
					
					
				</div>
			</div>
		</div>	
	</div>
	<?php endif; ?>
	
	
	
	<div class="logo-area">
		<div class="container">
			<div class="row align-items-center">
				<div class="col-lg-2 col-md-12">
				
					<div class="logo theme-logo">
					<?php  
					if ( has_custom_logo() || !empty( $kiante_logo_url ) ) {
						if( isset( $kiante_logo['url'] ) && !empty( $kiante_logo_url ) ) { 
							?>
								<a href="<?php echo esc_url( site_url('/')) ?>" class="logo">
									<img class="img-fluid" src="<?php echo esc_url( $kiante_logo_url ); ?>" alt="<?php echo esc_attr( $kiante_logo_alt  ) ?>">
								</a>
						    <?php 
						} else {
							 the_custom_logo();
						}

					} else {
						printf('<h1 class="text-logo"><a href="%1$s">%2$s</a></h1>',esc_url(site_url('/')),esc_html(get_bloginfo('name')));
					}
					?>
					</div>

				</div>
				
				<div class="col-lg-9 col-md-12 nav-design-one">
					<div class="nav-menu-wrapper nav-menu-wrapper-two">
						<div class="container nav-wrapp-one">
							<div class="kiante-responsive-menu"></div>
							<div class="mainmenu">
								<?php
									wp_nav_menu( array(
										'theme_location' => 'primary',
										'menu_id'        => 'primary-menu',
										'fallback_cb'  => 'kiante_fallback_menu',
									) );
								?>
							</div>
						</div>
					</div>	
				</div>
				
				
				<div class="col-lg-1">
					<div class="header-right-content text-right">
					
						
						<div class="header-search-box header-search-two">
						<a href="#" class="search-box-btn"><i class="icofont-search-1"></i></a>
						</div>

					</div>
				</div>

			</div>
		</div>
	</div>

	
</header>


<div class="body-overlay" id="body-overlay"></div>

<!-- search popup area start -->
<div class="search-popup" id="search-popup">
	<form role="search" method="get" id="searchform" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
		<div class="form-group">
			<input type="text" class="search-input" value="<?php echo get_search_query(); ?>" name="s" id="s" placeholder="<?php esc_attr_e('Search.....','kiante'); ?>" required />
		</div>
			<button type="submit" id="searchsubmit" class="search-button submit-btn"><i class="icofont-search-1"></i></button>
	</form>							
</div>
<!-- search Popup end-->

