<?php
/*
 * Theme Options
 * @package Kiante
 * @since 1.0.0
 * */

if ( !defined('ABSPATH') ){
    exit(); // exit if access directly
}

if( class_exists( 'CSF' ) ) {

  //
  // Set a unique slug-like ID
  $prefix = 'kiante';

  //
  // Create options
  CSF::createOptions( $prefix.'_theme_options', array(
    'menu_title' => esc_html__('Theme Option','kiante'),
    'menu_slug'  => 'kiante-theme-option',
    'menu_type' => 'menu',
    'enqueue_webfont'         => true,
    'show_footer' => false,
    'framework_title'      => esc_html__('Kiante Theme Options','kiante'),
  ) );

  //
  // Create a section
  CSF::createSection( $prefix.'_theme_options', array(
    'title'  => esc_html__('General','kiante'),
    'icon'  => 'fa fa-wrench',
    'fields' => array(

		array(
			'type' => 'subheading',
			'content' => '<h3>' . esc_html__('Site Logo', 'kiante') . '</h3>',
		) ,
			
		array(
			'id' => 'theme_logo',
			'title' => esc_html__('Main Logo','kiante'),
			'type' => 'media',
			'library' => 'image',
			'desc' => esc_html__('Upload Your Static Logo Image on Header Static', 'kiante')
		), 
		
		
		array(
			'id' => 'logo_width',
			'type' => 'slider',
			'title' => esc_html__('Set Logo Width','kiante'),
			'min' => 0,
			'max' => 300,
			'step' => 1,
			'unit' => 'px',
			'default' => 102,
			'desc' => esc_html__('Set Logo Width in px. Default Width 184px.', 'kiante') ,
		) ,
		
	  
      array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Preloader','kiante').'</h3>'
      ),
	  
	  
      array(
        'id' => 'preloader_enable',
        'title' => esc_html__('Enable Preloader','kiante'),
        'type' => 'switcher',
        'desc' => esc_html__('Enable or Disable Preloader', 'kiante') ,
        'default' => true,
      ),
	  
      array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Back Top Options','kiante').'</h3>'
      ),
	  
	  
      array(
        'id' => 'back_top_enable',
        'title' => esc_html__('Scroll Top Button','kiante'),
        'type' => 'switcher',
        'desc' => esc_html__('Enable or Disable scroll button', 'kiante') ,
        'default' => true,
      ),

    )
  ) );

  /*-------------------------------------------------------
     ** Entire Site Header  Options
   --------------------------------------------------------*/
  
    CSF::createSection( $prefix.'_theme_options', array(
    'title'  => esc_html__('Header','kiante'),
    'id' => 'header_options',
    'icon' => 'fa fa-header',
    'fields' => array(
      array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Header Layout','kiante').'</h3>'
      ),
        //
        // nav select
       array(
            'id' => 'nav_menu',
            'type' => 'image_select',
            'title' => esc_html__('Select Header Navigation Style','kiante'),
            'options' => array(
                'nav-style-one' => KIANTE_IMG . '/admin/header-style/style1.png',
                'nav-style-two' => KIANTE_IMG . '/admin/header-style/style2.png',
            ),
			
            'default' => 'nav-style-one'
        ),
	
	
	array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Header Top Promotion','kiante').'</h3>'
      ),
	  
	array(
        'id' => 'header_top_promo',
        'title' => esc_html__('Show Header Top Promotion Text','kiante'),
        'type' => 'switcher',
        'default' => true,
		'desc' => esc_html__('Enable Header Promotion', 'kiante') ,
    ),

	array(
		'id'         => 'promo_title',
		'type'       => 'text',
		'title'      => esc_html__('Promo Highlighted Title','kiante'),
		'default'    => esc_html__('New','kiante'),
		'desc'       => esc_html__('Type Title','kiante'),
		'dependency' => array( 'header_top_promo', '==', 'true' ),
	),
	
	array(
		'id'         => 'promo_text',
		'type'       => 'text',
		'title'      => esc_html__('Promo Text','kiante'),
		'default'    => esc_html__('Incredible offer for our exclusive subscribers!','kiante'),
		'desc'       => esc_html__('Type Promotion offer text','kiante'),
		'dependency' => array( 'header_top_promo', '==', 'true' ),
	),
	
	array(
		'id'         => 'promo_text_btn',
		'type'       => 'text',
		'title'      => esc_html__('Promo Button Text','kiante'),
		'default'    => esc_html__('Read More','kiante'),
		'desc'       => esc_html__('Type Promotion Button text','kiante'),
		'dependency' => array( 'header_top_promo', '==', 'true' ),
	),
	
	array(
		'id'         => 'promo_btn_link',
		'type'       => 'text',
		'title'      => esc_html__('Promo Button Link','kiante'),
		'default'    => esc_html__('#','kiante'),
		'desc'       => esc_html__('Type Promotion Button Link','kiante'),
		'dependency' => array( 'header_top_promo', '==', 'true' ),
	),
	  
	  
	array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Header Top Bar','kiante').'</h3>'
      ),
	  
      array(
        'id' => 'header_top_enable',
        'title' => esc_html__('Show Header Top','kiante'),
        'type' => 'switcher',
        'default' => true,
		'desc' => esc_html__('Enable Header Top', 'kiante') ,
      ),

		
		array(
			'id' => 'header_top_weather',
			'title' => esc_html__('Show weather box', 'kiante') ,
			'type' => 'switcher',
			'desc' => esc_html__('Enable Header weather box', 'kiante') ,
			'dependency' => array(
				'header_top_enable',
				'==',
				'true'
			) ,
			'default' => true,
		) ,
		
		array(
		'id'         => 'waether_text',
		'type'       => 'text',
		'title'      => esc_html__('Header Weather Text','kiante'),
		'default'    => esc_html__('15°C New York','kiante'),
		'desc'       => esc_html__('Type Header Weather Text','kiante'),
		'dependency' => array( 'header_top_enable', '==', 'true' ),
	),
		
		
		array(
			'id' => 'header_top_calender',
			'title' => esc_html__('Show Current Date', 'kiante') ,
			'type' => 'switcher',
			'desc' => esc_html__('Enable Header Current Date', 'kiante') ,
			'dependency' => array(
				'header_top_enable',
				'==',
				'true'
			) ,
			'default' => true,
		) ,
		
		array(
			'id' => 'top_text_btn_enable',
			'title' => esc_html__('Show Header Top Button', 'kiante') ,
			'type' => 'switcher',
			'desc' => esc_html__('Enable Header Top Button', 'kiante') ,
			'dependency' => array(
				'header_top_enable',
				'==',
				'true'
			) ,
			'default' => true,
		) ,
		
	
		array(
			'id'         => 'top_text_btn',
			'type'       => 'text',
			'title'      => esc_html__('Top Button Text', 'kiante') ,
			'default'    => esc_html__('Buy Theme', 'kiante') ,
			'desc'       => esc_html__('Type text', 'kiante') ,
			'dependency' => array( 'header_top_enable', '==', 'true' ),
		),
			
		array(
		'id'         => 'top_text_btn_link',
		'type'       => 'text',
		'title'      => esc_html__('Top Button Link', 'kiante') ,
		'default'    => esc_html__('#', 'kiante') ,
		'desc'       => esc_html__('Type Button Link', 'kiante') ,
		'dependency' => array( 'header_top_enable', '==', 'true' ),
	),
	
	
	array(
		'id' => 'top_bar_nav',
		'title' => esc_html__('Top Bar Menu','kiante'),
		'type' => 'switcher',
		'desc' => esc_html__('You can set menu on Top bar in Header Style 4','kiante'),
		'default' => false,
	),

	  
	       	
		
	array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Search Bar & Login Option','kiante').'</h3>'
      ),
	  
      array(
        'id' => 'search_bar_enable',
        'title' => esc_html__('Search Bar Display In Header','kiante'),
        'type' => 'switcher',
		'desc' => esc_html__('Enable or Disable Search Bar', 'kiante') ,
        'default' => true,
      ),
	  
	  array(
        'id' => 'login_btn_enable',
        'title' => esc_html__('Show Login Button','kiante'),
        'type' => 'switcher',
		'desc' => esc_html__('Enable or Disable Login Button', 'kiante') ,
        'default' => true,
      ), 
	  
	  array(
        'id' => 'register_btn_enable',
        'title' => esc_html__('Show Register Button','kiante'),
        'type' => 'switcher',
		'desc' => esc_html__('Enable or Disable Register Button', 'kiante') ,
        'default' => true,
      ),
	  
	  
		
	array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Social Options','kiante').'</h3>'
     ),	
	
      array(
        'id' => 'header_social_enable',
        'title' => esc_html__('Do You want to Show Header Social Icons','kiante'),
        'type' => 'switcher',
		'desc' => esc_html__('Enable or Disable Social Bar', 'kiante') ,
        'default' => false,
      ),
	  
		
	array(
        'id'     => 'social-icon',
        'type'   => 'repeater',
        'title'  => esc_html__('Repeater','kiante'),
        'dependency' => array('header_social_enable','==','true'),
        'fields' => array(
          array(
            'id'    => 'icon',
            'type'  => 'icon',
            'title' => esc_html__('Pick Up Your Social Icon','kiante'),
          ),
          array(
            'id'    => 'link',
            'type'  => 'text',
            'title' => esc_html__('Inter Social Url','kiante'),
          ),

        ),
      ),	
		
		

    )
  ));
  
   
    /*-------------------------------------
     ** Typography Options
     -------------------------------------*/
    CSF::createSection($prefix . '_theme_options', array(
        'title' => esc_html__('Typography', 'kiante') ,
		'id' => 'typography_options',
		'icon' => 'fa fa-font',
        'fields' => array(

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Body', 'kiante') . '</h3>'
            ) ,

            array(
                'id' => 'body-typography',
                'type' => 'typography',
                'output' => 'body',
                'default' => array(
					'color' => '#111111',
                    'font-family' => 'Roboto',
                    'font-weight' => '400',
                    'font-size' => '16',
                    'line-height' => '26',
					'letter-spacing' => false,
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                ) ,

            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h1', 'kiante') . '</h3>'
            ) ,

            array(
                'id' => 'heading-one-typo',
                'type' => 'typography',

                'output' => 'h1',
                'default' => array(
                    'color' => '#111111',
                    'font-family' => 'Lora',
                    'font-weight' => '400',
					'font-size' => '42',
                    'line-height' => '50',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h2', 'kiante') . '</h3>'
            ) ,

            array(
                'id' => 'heading-two-typo',
                'type' => 'typography',

                'output' => 'h2',
                'default' => array(
                    'color' => '#111111',
                    'font-family' => 'Lora',
                    'font-weight' => '400',
					'font-size' => '28',
                    'line-height' => '36',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h3', 'kiante') . '</h3>'
            ) ,

            array(
                'id' => 'heading-three-typo',
                'type' => 'typography',

                'output' => 'h3',
                'default' => array(
                    'color' => '#111111',
                    'font-family' => 'Lora',
                    'font-weight' => '400',
					'font-size' => '24',
                    'line-height' => '28',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h4', 'kiante') . '</h3>'
            ) ,

            array(
                'id' => 'heading-four-typo',
                'type' => 'typography',

                'output' => 'h4',
                'default' => array(
                    'color' => '#111111',
                    'font-family' => 'Lora',
                    'font-weight' => '400',
					'font-size' => '18',
                    'line-height' => '28',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h5', 'kiante') . '</h3>'
            ) ,

            array(
                'id' => 'heading-five-typo',
                'type' => 'typography',

                'output' => 'h5',
                'default' => array(
                    'color' => '#111111',
                    'font-family' => 'Lora',
                    'font-weight' => '400',
					'font-size' => '14',
                    'line-height' => '24',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

            array(
                'type' => 'subheading',
                'content' => '<h3>' . esc_html__('Heading h6', 'kiante') . '</h3>'
            ) ,

            array(
                'id' => 'heading-six-typo',
                'type' => 'typography',
                'output' => 'h6',
                'default' => array(
                    'color' => '#111111',
                    'font-family' => 'Lora',
                    'font-weight' => '400',
					'font-size' => '14',
                    'line-height' => '28',
                    'subset' => 'latin-ext',
                    'type' => 'google',
                    'unit' => 'px',
                    'letter-spacing' => false,
                ) ,
                'extra-styles' => array(
                    '300',
                    '400',
                    '500',
                    '600',
                    '800',
                    '900'
                ) ,
            ) ,

        )
    ));
  
  
  
  

  /*-------------------------------------------------------
     ** Pages and Template
   --------------------------------------------------------*/

   // blog optoins
    CSF::createSection( $prefix.'_theme_options', array(
    'title'  => esc_html__('Blog','kiante'),
    'id' => 'blog_page',
    'icon' => 'fa fa-bookmark',
    'fields' => array(
      array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Blog Options','kiante').'</h3>'
      ),
	  
	  	array(
			'id'         => 'blog_title',
			'type'       => 'text',
			'title'      => esc_html__('Blog Page Title','kiante'),
			'default'    => esc_html__('Blog Page','kiante'),
			'desc'       => esc_html__('Type Blog Page Title','kiante'),
		),
		
		array(
			'id' => 'page-spacing-blog',
			'type' => 'spacing',
			'title' => esc_html__('Blog Page Spacing','kiante'),
			'output' => '.main-container.blog-spacing',
			'output_mode' => 'padding', // or margin, relative
			'default' => array(
				'top' => '80',
				'right' => '0',
				'bottom' => '80',
				'left' => '0',
				'unit' => 'px',
			) ,
		) ,
		
		array(
			'id' => 'blog_breadcrumb_enable',
			'title' => esc_html__('Breadcrumb', 'kiante') ,
			'type' => 'switcher',
			'desc' => esc_html__('Enable Breadcrumb', 'kiante') ,
			'default' => true,
		) ,
			
		

	 
    )
  ));
  
  
    // category 
	
  CSF::createSection( $prefix.'_theme_options', array(
    'title'  => esc_html__('Category','kiante'),
    'id' => 'cat_page',
    'icon' => 'fa fa-list-ul',
    'fields' => array(
      array(
        'type' => 'subheading',
        'content' => '<h3>' . esc_html__('Theme Category Options. You can Customize Each Catgeory by Editing Individually.', 'kiante') . '</h3>'
      ),
       array(
			'id' => 'kiante_cat_layout',
            'type' => 'image_select',
            'title' => esc_html__('Select Category Layout','kiante'),
            'options' => array(
                'catt-one' => KIANTE_IMG . '/admin/page/style1.png',
                'catt-two' => KIANTE_IMG . '/admin/page/style2.png',
            ),
            'default' => 'catt-one'
        ),
		
		array(
			'id' => 'page-spacing-category',
			'type' => 'spacing',
			'title' => esc_html__('Category Page Spacing','kiante'),
			'output' => '.main-container.cat-page-spacing',
			'output_mode' => 'padding', // or margin, relative
			'default' => array(
				'top' => '80',
				'right' => '0',
				'bottom' => '80',
				'left' => '0',
				'unit' => 'px',
			) ,
		) ,


    )
  ));
  
  

  // blog single optoins
    CSF::createSection( $prefix.'_theme_options', array(
    'title'  => esc_html__('Single','kiante'),
    'id' => 'single_page',
    'icon' => 'fa fa-pencil-square-o',
    'fields' => array(
      array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Blog Single Page Option','kiante').'</h3>'
      ),
	  
       array(
            'id' => 'kiante_single_blog_layout',
            'type' => 'image_select',
            'title' => esc_html__('Select Single Blog Style','kiante'),
            'options' => array(
                'single-one' => KIANTE_IMG . '/admin/page/blog-1.png',
                'single-two' => KIANTE_IMG . '/admin/page/blog-2.png',
            ),
            'default' => 'single-one'
        ),
		
		array(
			'id' => 'page-spacing-single',
			'type' => 'spacing',
			'title' => esc_html__('Single Blog Spacing','kiante'),
			'output' => '.single-one-bwrap',
			'output_mode' => 'padding', // or margin, relative
			'default' => array(
				'top' => '40',
				'right' => '0',
				'bottom' => '80',
				'left' => '0',
				'unit' => 'px',
			) ,
		) ,
		
		array(
			'id'         => 'blog_prev_title',
			'type'       => 'text',
			'title'      => esc_html__('Previous Post Text','kiante'),
			'default'    => esc_html__('Previous Post','kiante'),
			'desc'       => esc_html__('Type Previous Post Link Title','kiante'),
		),
		
		array(
			'id'         => 'blog_next_title',
			'type'       => 'text',
			'title'      => esc_html__('Next Post Text','kiante'),
			'default'    => esc_html__('Next Post','kiante'),
			'desc'       => esc_html__('Type Next Post Link Title','kiante'),
		),
			
		array(
			'id' => 'blog_single_cat',
			'title' => esc_html__('Show Catgeory','kiante'),
			'type' => 'switcher',
			'desc' => esc_html__('Show Category Name','kiante'),
			'default' => true,
		),
		
		array(
			'id' => 'blog_single_author',
			'title' => esc_html__('Show Author','kiante'),
			'type' => 'switcher',
			'desc' => esc_html__('Single Post Author','kiante'),
			'default' => true,
		),

		array(
			'id' => 'blog_nav',
			'title' => esc_html__('Show Navigation','kiante'),
			'type' => 'switcher',
			'desc' => esc_html__('Post Navigation','kiante'),
			'default' => true,
		),
		
		array(
			'id' => 'blog_tags',
			'title' => esc_html__('Show Tags','kiante'),
			'type' => 'switcher',
			'desc' => esc_html__('Show Post Tags','kiante'),
			'default' => true,
		),
		
		array(
			'id' => 'blog_related',
			'title' => esc_html__('Show Related Posts','kiante'),
			'type' => 'switcher',
			'desc' => esc_html__('Related Posts','kiante'),
			'default' => true,
		),
		
		array(
			'id' => 'blog_views',
			'title' => esc_html__('Show Post Views','kiante'),
			'type' => 'switcher',
			'desc' => esc_html__('Post views','kiante'),
			'default' => false,
		),


    )
  ));


  /*-------------------------------------------------------
       ** Footer  Options
  --------------------------------------------------------*/
  CSF::createSection( $prefix.'_theme_options', array(
    'title'  => esc_html__('Footer','kiante'),
    'id' => 'footer_options',
    'icon' => 'fa fa-copyright',
    'fields' => array(
      array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Footer Options','kiante').'</h3>'
      ),
	  
	array(
        'id' => 'footer_nav',
        'title' => esc_html__('Footer Right Menu','kiante'),
        'type' => 'switcher',
		'desc' => esc_html__('You can set Yes or No to show Footer menu','kiante'),
        'default' => false,
      ),
	  
	  
      array(
        'type' => 'subheading',
        'content' =>'<h3>'.esc_html__('Footer Copyright Area Options','kiante').'</h3>'
      ),

      array(
        'id' => 'copyright_text',
        'title' => esc_html__('Copyright Area Text','kiante'),
        'type' => 'textarea',
        'desc' => esc_html__('Footer Copyright Text','kiante'),
      ),


	  
    )
  ));


  // Backup section
  CSF::createSection( $prefix.'_theme_options', array(
    'title'  => esc_html__('Backup','kiante'),
    'id'    => 'backup_options',
    'icon'  => 'fa fa-window-restore',
    'fields' => array(
        array(
            'type' => 'backup',
        ),   
    )
  ) );
  

}