<?php if (!defined('ABSPATH')) die('Direct access forbidden.');

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package kiante
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
 

/** Echo Variable **/

function kiante_return( $s ) {
   return $s;
}


/** Get Tag List **/

if( !function_exists('kiante_post_tags')){
	
	function kiante_post_tags() {
		$terms = get_terms( array(
			'taxonomy'    => 'post_tag',
			'hide_empty'  => false,
			'posts_per_page' => -1, 
		) );
		$cat_list = [];
		foreach($terms as $post) {
		$cat_list[$post->term_id]  = [$post->name];
		}
		return $cat_list;
	}
}

/** Post Read Time **/

function kiante_reading_time() {
	
	global $post;
	
	$content = get_post_field( 'post_content', $post->ID );
	$word_count = str_word_count( strip_tags( $content ) );
	$readingtime = ceil($word_count / 200);
	if ($readingtime == 1) {
	$timer = " min read";
	} else {
	$timer = " min read";
	}
	$totalreadingtime = $readingtime . $timer;
	return $totalreadingtime;
}



/** Post View **/
 
function kiante_get_post_view() {

	$count = get_post_meta( get_the_ID(), 'post_views_count', true );
	return "$count";
}


function kiante_set_post_view() {

	$key = 'post_views_count';
	$post_id = get_the_ID();
	$count = (int) get_post_meta( $post_id, $key, true );
	$count++;

	update_post_meta( $post_id, $key, $count );

}


// return embed code video url
// ----------------------------------------------------------------------------------------
function kiante_video_embed($url){
    //This is a general function for generating an embed link of an FB/Vimeo/Youtube Video.
	$embed_url = '';
    if(strpos($url, 'facebook.com/') !== false) {
		
        //it is FB video
        $embed_url = esc_url('https://www.facebook.com/plugins/video.php?href='.rawurlencode($url).'&show_text=1&width=200');
		
    }else if(strpos($url, 'vimeo.com/') !== false) {
        //it is Vimeo video
        $video_id = explode("vimeo.com/",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
		
        $embed_url = esc_url('https://player.vimeo.com/video/'.$video_id);
			
    }else if(strpos($url, 'youtube.com/') !== false) {
        //it is Youtube video
        $video_id = explode("v=",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
		$embed_url =esc_url('https://www.youtube.com/embed/'.$video_id);
		
    }else if(strpos($url, 'youtu.be/') !== false){
        //it is Youtube video
        $video_id = explode("youtu.be/",$url)[1];
        if(strpos($video_id, '&') !== false){
            $video_id = explode("&",$video_id)[0];
        }
        $embed_url =esc_url('https://www.youtube.com/embed/'.$video_id);
    }
	
	else{
        //for new valid video URL
    }
    return $embed_url;
}  


//*** Prev Next Post ***//

if(!function_exists('kiante_theme_post_navigation')) {
  function kiante_theme_post_navigation() { 

    $previous_post       = get_previous_post();
    $prev_thumbnail      = (is_object($previous_post) && !empty($previous_post)) ? get_the_post_thumbnail($previous_post->ID):'';
    $next_post           = get_next_post();
    $next_post_thumbnail = (is_object($next_post) && !empty($next_post)) ? get_the_post_thumbnail($next_post->ID):'';
    $col_class           = ($previous_post && $next_post) ? 'col-sm-6':'col-sm-12';
    if($previous_post || $next_post):
  ?>
    
	<div class="theme_blog_navigation__Wrap">
    <div class="row">

      <?php if ($previous_post): ?>
      <div class="<?php echo esc_attr($col_class); ?>">
        <div class="theme_blog_Nav post_nav_Left <?php echo (empty($prev_thumbnail)) ? 'no-thumb':''; ?>">
          <?php if(!empty($prev_thumbnail)): ?>
            <div class="theme_blog_nav_Img prev_nav_left_Img">
              <?php echo wp_kses_post($prev_thumbnail); ?>
            </div>
          <?php endif; ?>
          <div class="theme_blog_nav_Inner">
            <div class="theme_blog_nav_Label">
			
				<?php $blog_prev_title = kiante_get_option('blog_prev_title');  ?>
				<?php echo esc_html($blog_prev_title); ?>
			
			</div>
            <h3 class="theme_blog_nav_Title"><?php previous_post_link('%link', '%title'); ?></h3>
          </div>
        </div>

      </div>
	  
      <?php endif; ?>
      <?php if ($next_post): ?>
	  
      <div class="<?php echo esc_attr($col_class); ?>">
	  
        <div class="theme_blog_Nav post_nav_Right <?php echo (empty($next_post_thumbnail)) ? 'no-thumb':''; ?>">
          <?php if(!empty($next_post_thumbnail)): ?>
            <div class="theme_blog_nav_Img prev_nav_Right_Img">
             <?php echo wp_kses_post($next_post_thumbnail); ?>
            </div>
          <?php endif; ?>
          <div class="theme_blog_Inner">
            <div class="theme_blog_nav_Label">
			
			<?php $blog_next_title = kiante_get_option('blog_next_title');  ?>
			<?php echo esc_html($blog_next_title); ?>
			
			</div>
            <h3 class="theme_blog_nav_Title"><?php next_post_link('%link', '%title'); ?></h3>
          </div>
        </div>
      </div>
      <?php endif; ?>


    </div>
    </div>

  <?php endif;
  }
}






/* -------------------------------------------- *
* TGM for Plugin activation
* -------------------------------------------- */
add_action( 'tgmpa_register', 'kiante_plugins_include');

if(!function_exists('kiante_plugins_include')):
    function kiante_plugins_include(){
        $plugins = array(
            array(
                'name'                  => esc_html__( 'Kiante Extra', 'kiante' ),
                'slug'                  => 'kiante-extra',
                'required'              => false,
                'version'               => '',
                'force_activation'      => false,
                'force_deactivation'    => false,
                'source'              => get_template_directory_uri().'/inc/plugins/kiante-extra.zip',
            ),
            array(
                'name'                  => esc_html__( 'Elementor', 'kiante' ),
                'slug'                  => 'elementor',
                'required'              => false,
            ),
            array(
                'name'                  => esc_html__( 'MC4WP: Mailchimp for WordPress', 'kiante' ),
                'slug'                  => 'mailchimp-for-wp',
                'required'              => false,
            ),
            array(
                'name'                  => esc_html__( 'Contact Form 7', 'kiante' ),
                'slug'                  => 'contact-form-7',
                'required'              => false,
            ),
            array(
                'name'         => 'Svg Support',
                'slug'         => 'svg-support',
                'required'     => false,
            ),
            array(
                'name'                  => esc_html__( 'One Click Demo Import', 'kiante' ),
                'slug'                  => 'one-click-demo-import',
                'required'              => false,
            ),    
        );

        $config = array(
            'domain'            => 'kiante',
            'default_path'      => '',
            'menu'              => 'install-required-plugins',
            'has_notices'       => true,
            'dismissable'       => true, 
            'dismiss_msg'       => '', 
            'is_automatic'      => false,
            'message'           => ''
        );

        tgmpa( $plugins, $config );
    }

endif;


/**
 * [ocdi_import_files description]
 * @return [type] [description]
 */
function kiante_import_files() {
    return array(
        array(
            'import_file_name'           => esc_html__('kiante Demo Data', 'kiante-extra'),
            'local_import_file'            => trailingslashit( get_template_directory() ) . '/inc/demo/content.xml',
            'local_import_widget_file'     => trailingslashit( get_template_directory() ) . '/inc/demo/widgets.wie',
            'local_import_customizer_file' => trailingslashit( get_template_directory() ) . '/inc/demo/customize.dat',
            'local_import_redux'           => array(
                array(
                    'file_path'   => trailingslashit( get_template_directory() ) . '/inc/demo/theme-settings.json',
                    'option_name' => 'kiante_option_name',
                ),
            ),
            'import_preview_image_url'     => 'http://www.your_domain.com/inc/demo/preview_import_image1.jpg',
            'import_notice'                => __( 'After you import this demo, you will have to setup the slider separately.', 'your-textdomain' ),
            'preview_url'                  => 'kiante.wowtheme7.com',
        ),   
    );
}
add_filter( 'pt-ocdi/import_files', 'kiante_import_files' );

/**
 * [kiante_after_import_setup description]
 * @return [type] [description]
 */
function kiante_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Primary Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'main-menu' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home One' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );

}
add_action( 'pt-ocdi/after_import', 'kiante_after_import_setup' );
