<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package kiante
 */
 
$kiante_preloader = kiante_get_option('preloader_enable', false);
 
 
?>
<!DOCTYPE html>
  <html <?php language_attributes(); ?>> 
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<?php wp_head(); ?>
    </head>
	
	
    <body <?php body_class(); ?> >
		
		<?php wp_body_open(); ?>

		<!-- Theme Preloader -->
		<?php if($kiante_preloader == true) :?>
		<div id="preloader">
			<div class="spinner">
				<div class="double-bounce1"></div>
				<div class="double-bounce2"></div>
			</div>
		</div>
		<?php endif; ?>


		<div class="body-inner-content">
      
		<?php
		
		// Select Header Style
		
		$kiante_nav_global = kiante_get_option( 'nav_menu' ); // Global
		$kiante_nav_style =  get_post_meta( get_the_ID(), 'kiante_post_meta', true ); // Post Metabox

		if( is_page() && !empty( $kiante_nav_style  ) ) {
		 
			get_template_part( 'template-parts/headers/'.$kiante_nav_style['nav_menu'].'' ); 
		
		} elseif ( class_exists( 'CSF' ) && !empty( $kiante_nav_global ) ) {
			
			get_template_part( 'template-parts/headers/'.$kiante_nav_global.'' ); 
			
		} else {
			
			get_template_part( 'template-parts/headers/nav-style-one' ); 
			
		}
	
		?>
		