<?php
/**
 * Kiante functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package kiante
 */


/**
 * define theme info
 * @since 1.0.0
 * */
 
 if (is_child_theme()){
	$theme = wp_get_theme();
	$parent_theme = $theme->Template;
	$theme_info = wp_get_theme($parent_theme);
}else{
	$theme_info = wp_get_theme();
}

define('KIANTE_DEV_MODE',true);
$kiante_version = KIANTE_DEV_MODE ? time() : $theme_info->get('Version');
define('KIANTE_NAME',$theme_info->get('Name'));
define('KIANTE_VERSION',$kiante_version);
define('KIANTE_AUTHOR',$theme_info->get('Author'));
define('KIANTE_AUTHOR_URI',$theme_info->get('AuthorURI'));


/**
 * Define Const for theme Dir
 * @since 1.0.0
 * */

define('KIANTE_THEME_URI', get_template_directory_uri());
define('KIANTE_IMG', KIANTE_THEME_URI . '/assets/images');
define('KIANTE_CSS', KIANTE_THEME_URI . '/assets/css');
define('KIANTE_JS', KIANTE_THEME_URI . '/assets/js');
define('KIANTE_THEME_DIR', get_template_directory());
define('KIANTE_IMG_DIR', KIANTE_THEME_DIR . '/assets/images');
define('KIANTE_CSS_DIR', KIANTE_THEME_DIR . '/assets/css');
define('KIANTE_JS_DIR', KIANTE_THEME_DIR . '/assets/js');
define('KIANTE_INC', KIANTE_THEME_DIR . '/inc');
define('KIANTE_THEME_OPTIONS',KIANTE_INC .'/theme-options');
define('KIANTE_THEME_OPTIONS_IMG',KIANTE_THEME_OPTIONS .'/img');

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
*/
	 
function kiante_setup(){
	
	// make the theme available for translation
	load_theme_textdomain( 'kiante', get_template_directory() . '/languages' );
	
	// add support for post formats
    add_theme_support('post-formats', [
        'standard', 'image', 'video', 'audio','gallery'
    ]);

    // add support for automatic feed links
    add_theme_support('automatic-feed-links');

    // let WordPress manage the document title
    add_theme_support('title-tag');
	
	// add editor style theme support
	function kiante_theme_add_editor_styles() {
		add_editor_style( 'custom-style.css' );
	}
	add_action( 'admin_init', 'kiante_theme_add_editor_styles' );

    // add support for post thumbnails
    add_theme_support('post-thumbnails');
	
	// hard crop center center
    set_post_thumbnail_size(770, 470, ['center', 'center']);
	add_image_size( 'kiante-box-slider-small', 96, 96, true );
	
	
	// register navigation menus
    register_nav_menus(
        [
            'primary' => esc_html__('Primary Menu', 'kiante'),
        ]
    );
	
	
	// HTML5 markup support for search form, comment form, and comments
    add_theme_support('html5', array(
        'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
    ));
	
	
	/**
	 * Add support for core custom logo.
	 *
	 * @link https://codex.wordpress.org/Theme_Logo
	 */
	add_theme_support( 'custom-logo', array(
		'height'      => 150,
		'width'       => 300,
		'flex-width'  => true,
		'flex-height' => true,
	) );
	
	
	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );
	
	
	/*
     * Enable support for wide alignment class for Gutenberg blocks.
     */
    add_theme_support( 'align-wide' );
    add_theme_support( 'editor-styles' );
    add_theme_support( 'wp-block-styles' );
		
}

add_action('after_setup_theme', 'kiante_setup');

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
*/
 
function kiante_widget_init() {
	

        register_sidebar( array (
			'name' => esc_html__('Blog widget area', 'kiante'),
			'id' => 'sidebar-1',
			'description' => esc_html__('Blog Sidebar Widget.', 'kiante'),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h3 class="widget-title">',
			'after_title' => '</h3>',
			
		) );
		
		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area One', 'kiante' ),
			'id'            => 'footer-widget-1',
			'description'   => esc_html__( 'Add Footer  widgets here.', 'kiante' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area Two', 'kiante' ),
			'id'            => 'footer-widget-2',
			'description'   => esc_html__( 'Add Footer widgets here.', 'kiante' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area Three', 'kiante' ),
			'id'            => 'footer-widget-3',
			'description'   => esc_html__( 'Add Footer widgets here.', 'kiante' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer Widget Area Four', 'kiante' ),
			'id'            => 'footer-widget-4',
			'description'   => esc_html__( 'Add Footer widgets here.', 'kiante' ),
			'before_widget' => '<div id="%1$s" class="footer-widget widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		) );		
					
}

add_action('widgets_init', 'kiante_widget_init');


/**
 * Enqueue scripts and styles.
 */
function kiante_scripts() {

	wp_enqueue_style( 'font-awesomelib', KIANTE_CSS . '/font-awesome.css');
	wp_enqueue_style( 'icon-font',  KIANTE_CSS . '/icon-font.css' );
	wp_enqueue_style( 'remixicon',  KIANTE_CSS . '/remixicon.css' );
	wp_enqueue_style( 'animate',  KIANTE_CSS . '/animate.css' );
	wp_enqueue_style( 'magnific-popup',  KIANTE_CSS . '/magnific-popup.css' );
	wp_enqueue_style( 'owl-carousel',  KIANTE_CSS . '/owl.carousel.min.css' );
	wp_enqueue_style( 'owl-theme',  KIANTE_CSS . '/owl.theme.min.css' );
	wp_enqueue_style( 'slick',  KIANTE_CSS . '/slick.css' );
	wp_enqueue_style( 'slicknav',  KIANTE_CSS . '/slicknav.css' );
	wp_enqueue_style( 'swiper',  KIANTE_CSS . '/swiper.min.css' );
	wp_enqueue_style( 'flickity',  KIANTE_CSS . '/flickity.min.css' );

    // theme css

	wp_enqueue_style( 'bootstrap', KIANTE_CSS . '/bootstrap.min.css', array(), '4.0', 'all');
	wp_enqueue_style( 'theme-fonts', KIANTE_CSS . '/theme-fonts.css', array(), '1.0', 'all');
	wp_enqueue_style( 'kiante-main',  KIANTE_CSS . '/main.css' );
	wp_enqueue_style( 'kiante-responsive',  KIANTE_CSS . '/responsive.css' );	
	
	wp_enqueue_style( 'kiante-style', get_stylesheet_uri() );

	wp_enqueue_script( 'bootstrap',  KIANTE_JS . '/bootstrap.min.js', array( 'jquery' ),  '4.0', true );
	wp_enqueue_script( 'popper',  KIANTE_JS . '/popper.min.js', array( 'jquery' ),  '1.0', true );
	wp_enqueue_script( 'jquery-magnific-popup',  KIANTE_JS . '/jquery.magnific-popup.min.js', array( 'jquery' ),  '1.0', true );
	wp_enqueue_script( 'jquery-appear',  KIANTE_JS . '/jquery.appear.min.js', array( 'jquery' ),  '1.0', true );
	wp_enqueue_script( 'owl-carousel',  KIANTE_JS . '/owl.carousel.min.js', array( 'jquery' ),  '1.0', true );
	wp_enqueue_script( 'jquery-easypiechart', KIANTE_JS . '/jquery.easypiechart.min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'slick', KIANTE_JS . '/slick.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'swiper', KIANTE_JS . '/swiper.min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'jquery-slicknav', KIANTE_JS . '/jquery.slicknav.min.js', array( 'jquery' ), '1.0', true );
	wp_enqueue_script( 'jquery-flickity', KIANTE_JS . '/flickity.min.js', array( 'jquery' ), '1.0', true );
	
	// Custom JS Scripts
	
	wp_enqueue_script( 'kiante-scripts',  KIANTE_JS . '/scripts.js', array( 'jquery' ),  '1.0', true );
	
	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
	

}

add_action( 'wp_enqueue_scripts', 'kiante_scripts' );


/*
* Include codester helper functions
* @since 1.0.0
*/

if ( file_exists( KIANTE_INC.'/cs-framework-functions.php' ) ) {
	require_once  KIANTE_INC.'/cs-framework-functions.php';
}

/**
 * Theme option panel & Metaboxes.
*/
 if ( file_exists( KIANTE_THEME_OPTIONS.'/theme-options.php' ) ) {
	require_once  KIANTE_THEME_OPTIONS.'/theme-options.php';
}

if ( file_exists( KIANTE_THEME_OPTIONS.'/theme-metabox.php' ) ) {
	require_once  KIANTE_THEME_OPTIONS.'/theme-metabox.php';
}

if ( file_exists( KIANTE_THEME_OPTIONS.'/theme-customizer.php' ) ) {
	require_once  KIANTE_THEME_OPTIONS.'/theme-customizer.php';
}


if ( file_exists( KIANTE_THEME_OPTIONS.'/theme-inline-styles.php' ) ) {
	require_once  KIANTE_THEME_OPTIONS.'/theme-inline-styles.php';
}


/**
 * Required plugin installer 
*/

require get_template_directory() . '/inc/required-plugins.php';


/**
 * Custom template tags & functions for this theme.
*/
require get_template_directory() . '/inc/template-tags.php';
require get_template_directory() . '/inc/template-functions.php';

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
*/
function kiante_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'kiante_content_width', 640 );
}

add_action( 'after_setup_theme', 'kiante_content_width', 0 );

/**
 * Nav menu fallback function
*/

function kiante_fallback_menu() {
	get_template_part( 'template-parts/default', 'menu' );
}

function kiante_svg_upload( $upload_mimes ) {
    $upload_mimes['svg'] = 'image/svg+xml';
    $upload_mimes['svgz'] = 'image/svg+xml';
    return $upload_mimes;
}
add_filter( 'upload_mimes', 'kiante_svg_upload', 10, 1 );




