<?php
/*
Plugin Name: Kiante Extra
Plugin URI: https://wowtheme7.com/kiante-extra
Description: This is a helper plugin for Kiante Theme.
Author: Gossip Themes
Version: 1.0.1
Author URI: https://wowtheme7.com
*/


/**
 * If this file is called directly, abort.
 * @package kiante
 * @since 1.0.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}


/**  Related Theme Type */

global $related_theme_type;
$related_theme_type = array('Kiante','Kiante Child');
//define current theme name
$current_theme = !empty( wp_get_theme() ) ? wp_get_theme()->get('Name') : '';
define('CURRENT_THEME_NAME',$current_theme);


/*
 * Define Plugin Dir Path
 * @since 1.0.0
 * */
define('KIANTE_EXTRA_SELF_PATH','kiante-extra/kiante-extra.php');
define('KIANTE_EXTRA_ROOT_PATH',plugin_dir_path(__FILE__));
define('KIANTE_EXTRA_ROOT_URL',plugin_dir_url(__FILE__));
define('KIANTE_EXTRA_LIB',KIANTE_EXTRA_ROOT_PATH.'/lib');
define('KIANTE_EXTRA_INC',KIANTE_EXTRA_ROOT_PATH .'/inc');
define('KIANTE_EXTRA_ADMIN',KIANTE_EXTRA_INC .'/admin');
define('KIANTE_EXTRA_ADMIN_ASSETS',KIANTE_EXTRA_ROOT_URL .'inc/admin/assets');
define('KIANTE_EXTRA_CSS',KIANTE_EXTRA_ROOT_URL .'assets/css');
define('KIANTE_EXTRA_JS',KIANTE_EXTRA_ROOT_URL .'assets/js');
define('KIANTE_EXTRA_ELEMENTOR',KIANTE_EXTRA_INC .'/elementor');
define('KIANTE_EXTRA_SHORTCODES',KIANTE_EXTRA_INC .'/shortcodes');
define('KIANTE_EXTRA_WIDGETS',KIANTE_EXTRA_INC .'/widgets');

/** Plugin version **/
define('KIANTE_CORE_VERSION','1.0.0');

//initial file
include_once ABSPATH .'wp-admin/includes/plugin.php';

if ( is_plugin_active(KIANTE_EXTRA_SELF_PATH) ) {

	if ( !in_array(CURRENT_THEME_NAME,$GLOBALS['related_theme_type']) && file_exists(KIANTE_EXTRA_INC .'/cs-framework-functions.php') ) {
		
		require_once KIANTE_EXTRA_INC .'/cs-framework-functions.php';
		
	}

	//plugin core file include
	
	if ( file_exists(KIANTE_EXTRA_INC .'/class-kiante-extra-init.php') ) {
		require_once KIANTE_EXTRA_INC .'/class-kiante-extra-init.php';
	};
	
	//Demo data import 
	
	if (file_exists(KIANTE_EXTRA_INC .'/demo-import.php')){
		require_once KIANTE_EXTRA_INC .'/demo-import.php';
	};

	//plugin core file include
	
	// if ( file_exists(KIANTE_EXTRA_INC .'/hugebinary-header-footer.php') ) {
	// 	require_once KIANTE_EXTRA_INC .'/hugebinary-header-footer.php';
	// }
	
}


/**
 * Theme builder
 */
if ( file_exists( KIANTE_EXTRA_ROOT_PATH . '/theme-builder/hugebinary-header-footer.php' ) ) {
    require_once KIANTE_EXTRA_ROOT_PATH . '/theme-builder/hugebinary-header-footer.php';
}
