<?php

/**
 * Elementor Widget
 * @package Kiante
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class kiante_main_menu extends Widget_Base {


	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'main-menu';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Main Menu', 'kiante-extra' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'fas fa-th-large'; 
	}





	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'kiante_widgets' ];
	}

	/**
	 * Register Elementor widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	 
	
	protected function register_controls() {		
		$this->post_query_options();	
		$this->meta_options();	
	}
	
	
	/**
    * Post Query Options
    */
    private function post_query_options() {
	
		$this->start_controls_section(
            'post_query_option',
            [
                'label' => __( 'Post Options', 'kiante-extra' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('logo_img', [
            'label' => esc_html__('Logo Img', 'kiante-core'),
            'type' => Controls_Manager::MEDIA,
            'description' => esc_html__('Enter read button text', 'kiante-core'),
        ]);

		$this->end_controls_section();
	
	}	
	
	/**
    * Meta Options
    */
    private function meta_options() {
	
	
		$this->start_controls_section(
            'meta_option',
            [
                'label' => __( 'Color Options', 'kiante-extra' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control('menu_text_color', [
            'label' => esc_html__('Menu Text Color', 'caller-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .nav-menu-wrapper .mainmenu
                 ul li a , .nav-menu-wrapper-two .mainmenu ul > li.menu-item-has-children > a:after" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('sub_menu_text_color', [
            'label' => esc_html__('Sub Menu Text Color', 'caller-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} .nav-menu-wrapper-two .mainmenu li ul.sub-menu li a" => "color: {{VALUE}}",
            ]
        ]);
        $this->add_control('sarch_text_color', [
            'label' => esc_html__('Search Text Color', 'caller-core'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                "{{WRAPPER}} a.search-box-btn" => "color: {{VALUE}}",
            ]
        ]);
	
		$this->end_controls_section();
	
	}		
		


	protected function render() {
		
		
		$settings = $this->get_settings_for_display();

		

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$kiante_logo = kiante_get_option( 'theme_logo' );
$kiante_logo_id = isset($kiante_logo['id']) && !empty($kiante_logo['id']) ? $kiante_logo['id'] : '';
$kiante_logo_url = isset( $kiante_logo[ 'url' ] ) ? $kiante_logo[ 'url' ] : '';
$kiante_logo_alt = get_post_meta($kiante_logo_id,'_wp_attachment_image_alt',true);


$kiante_header_top = kiante_get_option('header_top_enable');


$header_date = kiante_get_option('header_top_calender');
$header_weather = kiante_get_option('header_top_weather');
$waether_text = kiante_get_option('waether_text');

$kiante_header_search = kiante_get_option('search_bar_enable', true);
$login_btn_enable = kiante_get_option('login_btn_enable');
$register_btn_enable = kiante_get_option('register_btn_enable');

$kiante_header_social = kiante_get_option('header_social_enable');
$kiante_social_icon = kiante_get_option( 'social-icon' );

$logo_img = $settings['logo_img'];



?>

	<header id="theme-header-one" class="theme_header__main header-style-one">	
		<div class="container">
			<div class="logo-area">
				<div class="row align-items-center">
					<div class="col-lg-11 col-md-12 nav-design-one p-lg-0">
						<div class="row">
							<div class="col-lg-3 d-inline d-lg-none">
								<?php if(!empty($logo_img['url'])){ ?>
									<div class="logo theme-logo">
										<a href="<?php echo esc_url( site_url('/')) ?>" class="logo">
											<img class="img-fluid" src="<?php echo esc_url($settings['logo_img']['url']); ?>" alt="<?php echo esc_attr( $kiante_logo_alt  ) ?>">
										</a>
									</div>
								<?php }else { ?>
									<div class="logo theme-logo">
										<?php  
											if ( has_custom_logo() || !empty( $kiante_logo_url ) ) {
												if( isset( $kiante_logo['url'] ) && !empty( $kiante_logo_url ) ) { 
													?>
														<a href="<?php echo esc_url( site_url('/')) ?>" class="logo">
															<img class="img-fluid" src="<?php echo esc_url( $kiante_logo_url ); ?>" alt="<?php echo esc_attr( $kiante_logo_alt  ) ?>">
														</a>
												    <?php 
												} else {
													 the_custom_logo();
												}
											} else {
												printf('<h1 class="text-logo"><a href="%1$s">%2$s</a></h1>',esc_url(site_url('/')),esc_html(get_bloginfo('name')));
											}
										?>
									</div>
								<?php } ?>
							</div>
							<div class="col-lg-9">
								<div class="nav-menu-wrapper nav-menu-wrapper-two d-inline-block">
									<div class="container nav-wrapp-one p-0">
										<div class="kiante-responsive-menu"></div>
										<div class="mainmenu pl-0">
											<?php
												wp_nav_menu( array(
													'theme_location' => 'primary',
													'menu_id'        => 'primary-menu',
													'fallback_cb'  => 'kiante_fallback_menu',
												) );
											?>
										</div>
									</div>
								</div>	
							</div>
						</div>
					</div>
					<div class="col-lg-1 d-lg-block d-none">
						<div class="header-right-content text-right">
							<div class="header-search-box header-search-two">
								<a href="#" class="search-box-btn"><i class="icofont-search-1"></i></a>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</header>

	<div class="body-overlay" id="body-overlay"></div>
	<!-- search popup area start -->
	<div class="search-popup" id="search-popup">
		<form role="search" method="get" id="searchform" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
			<div class="form-group">
				<input type="text" class="search-input" value="<?php echo get_search_query(); ?>" name="s" id="s" placeholder="<?php esc_attr_e('Search.....','kiante'); ?>" required />
			</div>
				<button type="submit" id="searchsubmit" class="search-button submit-btn"><i class="icofont-search-1"></i></button>
		</form>							
	</div>
	<!-- search Popup end-->


		
	
		<?php 
      }	
	
}


Plugin::instance()->widgets_manager->register_widget_type( new kiante_main_menu() );