<?php
/**
 * All Elementor widget init
 * @package Kiante
 * @since 1.0.0
 */

if ( !defined('ABSPATH') ){
	exit(); // exit if access directly
}


if ( !class_exists('Kiante_Elementor_Widget_Init') ){

	class Kiante_Elementor_Widget_Init{
		/*
			* $instance
			* @since 1.0.0
			* */
		private static $instance;
		/*
		* construct()
		* @since 1.0.0
		* */
		public function __construct() {
			add_action( 'elementor/elements/categories_registered', array($this,'_widget_categories') );
			//elementor widget registered
			add_action('elementor/widgets/widgets_registered',array($this,'_widget_registered'));
			// elementor editor css
			
			add_action( 'wp_enqueue_scripts', array($this,'load_assets_for_elementor'));
			
			
			add_action( 'elementor/controls/controls_registered', array($this,'modify_controls'), 10, 1 );
			
			add_action( 'elementor/init', [ $this, 'init' ] );
			
		}
		
		
		public function init(){
			
		}
		/*
	   * getInstance()
	   * @since 1.0.0
	   * */
		public static function getInstance(){
			if ( null == self::$instance ){
				self::$instance = new self();
			}
			return self::$instance;
		}
		/**
		 * _widget_categories()
		 * @since 1.0.0
		 * */
		public function _widget_categories($elements_manager){
			$elements_manager->add_category(
				'kiante_widgets',
				[
					'title' => __( 'Kiante Widgets', 'kiante-extra' ),
					'icon' => 'fa fa-plug',
				]
			);
		}

		/**
		 * _widget_registered()
		 * @since 1.0.0
		 * */
		public function _widget_registered(){
			if( !class_exists('Elementor\Widget_Base') ){
				return;
			}
			$elementor_widgets = array(
			

				'post-grid-one',
				'post-grid-two',
				'post-list-one',
				'breaking-news',
				'post-small-grid-slider',
				'post-full-width-slider',
				'main-menu',
				
				

			);
			
			$elementor_widgets = apply_filters('kiante_elementor_widget',$elementor_widgets);

			if ( is_array($elementor_widgets) && !empty($elementor_widgets) ) {
				foreach ( $elementor_widgets as $widget ){
					$widget_file = 'plugins/elementor/widget/'.$widget.'.php';
					$template_file = locate_template($widget_file);
					if ( !$template_file || !is_readable( $template_file ) ) {
						$template_file = KIANTE_EXTRA_ELEMENTOR.'/widgets/class-'.$widget.'-elementor-widget.php';
					}
					if ( $template_file && is_readable( $template_file ) ) {
						include_once $template_file;
					}
				}
			}

		}


		/**
		 * Adding custom icon to icon control in Elementor
		*/
		
		public function modify_controls( $controls_registry ) {
			// Get existing icons
			$icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );

			// Append new icons
			$new_icons = array_merge(
				array(

					'flaticon-star' => esc_html__('Star','kiante-extra'),

				),
				$icons
			);

			// Then we set a new list of icons as the options of the icon control
			$controls_registry->get_control( 'icon' )->set_settings( 'options', $new_icons );
		}

		/**
		 * load custom assets for elementor
		 * @since 1.0.0
		 * */
		public function load_assets_for_elementor(){
			wp_enqueue_style( 'flaticon-css', KIANTE_EXTRA_CSS.'/flaticon.css');
			wp_enqueue_style( 'test-css', KIANTE_EXTRA_CSS.'/test.css');
			
			//wp_enqueue_script( 'kiante-elementor-scripts', KIANTE_EXTRA_JS.'/scripts.js', array( 'jquery' ),  '1.0', true );
		}

	}

	if ( class_exists('Kiante_Elementor_Widget_Init') ){
		Kiante_Elementor_Widget_Init::getInstance();
	}

}//end if