<?php
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version		1.0.0
 * 
 * Tribe Events Fonts Rules
 * Created by CMSMasters
 * 
 */


function islam_house_tribe_events_fonts($custom_css) {
	$cmsmasters_option = islam_house_get_global_options();
	
	
	$custom_css .= "
/***************** Start Tribe Events Font Styles ******************/

	/* Start Content Font */
	.tribe-events-tooltip,
	.tribe-events-tooltip a,
	.cmsmasters_event_big_week,
	table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-], 
	table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-] a, 
	html .datepicker .datepicker-days tbody > tr > td.day,
	.tribe-mini-calendar tbody, 
	.tribe-mini-calendar tbody a, 
	.tribe-this-week-events-widget .tribe-this-week-widget-header-date {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_content_font_google_font']) . $cmsmasters_option['islam-house' . '_content_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_content_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_content_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_content_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_content_font_font_style'] . ";
	}
	
	html .datepicker .datepicker-days tbody > tr > td.day {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_content_font_font_size'] - 4) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_content_font_line_height'] - 6) . "px;
		font-weight:600;
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .cmsmasters_event_big_week {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_content_font_font_size'] - 2) . "px;
	}

	table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-], 
	table.tribe-events-calendar tbody td div[id*=tribe-events-daynum-] a, 
	.tribe-this-week-events-widget .tribe-this-week-widget-header-date {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_content_font_font_size'] - 1) . "px;
	}
	
	.tribe-mini-calendar tbody, 
	.tribe-mini-calendar tbody a, 
	.tribe-mini-calendar thead th, 
	.tribe-events-grid .column.first > span,
	.tribe-events-grid .tribe-week-grid-hours div,
	.tribe-events-tooltip .description, 
	.tribe-events-widget-link a, 
	.tribe-this-week-events-widget .tribe-events-viewmore a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_content_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_content_font_line_height'] - 6) . "px;
	}
	/* Finish Content Font */
	
	
	/* Start H1 Font */
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-number,
	.cmsmasters_event_big_day {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h1_font_google_font']) . $cmsmasters_option['islam-house' . '_h1_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h1_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h1_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h1_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h1_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h1_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h1_font_text_decoration'] . ";
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-number {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h1_font_font_size'] + 10) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h1_font_line_height'] + 45) . "px;
	}
	
	.cmsmasters_event_big_day {
		font-size:90px;
		line-height:80px;
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .cmsmasters_event_big_day {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h1_font_font_size'] + 10) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h1_font_line_height'] + 20) . "px;
		font-weight:700;
	}
	
	@media only screen and (max-width: 540px) and (min-width: 321px) {
		.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-number {
			font-size:35px;
			line-height:70px;
		}
		
		.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-number .tribe-countdown-under {
			font-size:20px !important;
			line-height:30px !important; 
		}
	}
	/* Finish H1 Font */
	
	
	/* Start H2 Font */
	.cmsmasters_event_day,
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-list-widget .tribe-events-list-widget-content-wrap .entry-title a,
	.tribe-mobile-day .tribe-mobile-day-date,
	.tribe-events-countdown-widget .tribe-countdown-time {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h2_font_google_font']) . $cmsmasters_option['islam-house' . '_h2_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h2_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h2_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h2_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h2_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h2_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h2_font_text_decoration'] . ";
	}
	
	.tribe-events-countdown-widget .tribe-countdown-time {
		font-size:36px;
		line-height:40px;
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-time {
		font-size:40px;
		line-height:40px;
	}
	
	.tribe-events-list .tribe-events-list-event-title,
	.tribe-events-list .tribe-events-list-event-title a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h2_font_font_size'] - 12) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h2_font_line_height'] - 14) . "px;
	}
	
	@media only screen and (min-width: 1440px) {
		.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-time {
			font-size:60px;
			line-height:60px;
		}
	
		.tribe-events-list .tribe-events-list-event-title,
		.tribe-events-list .tribe-events-list-event-title a {
			font-size:" . $cmsmasters_option['islam-house' . '_h2_font_font_size'] . "px;
			line-height:" . $cmsmasters_option['islam-house' . '_h2_font_line_height'] . "px;
		}
	}
	
	@media only screen and (max-width: 950px) {
		.tribe-events-list .tribe-events-list-event-title,
		.tribe-events-list .tribe-events-list-event-title a {
			font-size:" . ((int) $cmsmasters_option['islam-house' . '_h2_font_font_size'] - 14) . "px;
			line-height:" . ((int) $cmsmasters_option['islam-house' . '_h2_font_line_height'] - 18) . "px;
		}
	}
	/* Finish H2 Font */
	
	
	/* Start H3 Font */
	.tribe-events-related-events-title,
		.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap .entry-title a,
	.tribe-events-page-title {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h3_font_google_font']) . $cmsmasters_option['islam-house' . '_h3_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h3_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h3_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h3_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h3_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h3_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h3_font_text_decoration'] . ";
	}
	
	.tribe-events-related-events-title {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h3_font_font_size'] - 2) . "px;
	}
	
	.tribe-events-photo .tribe-events-list-event-title,
	.tribe-events-photo .tribe-events-list-event-title a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h3_font_font_size'] + 2) . "px;
	}
	
		.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap .entry-title a {
			font-weight:700;
		}
	
	@media only screen and (max-width: 1439px) {
		.tribe-events-photo .tribe-events-list-event-title, 
		.tribe-events-photo .tribe-events-list-event-title a {
			font-size:28px;
			line-height:38px;
		}
	}
	/* Finish H3 Font */
	
	
	/* Start H4 Font */
	.tribe-events-venue-widget .tribe-venue-widget-venue-name a {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h4_font_google_font']) . $cmsmasters_option['islam-house' . '_h4_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h4_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h4_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h4_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h4_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h4_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h4_font_text_decoration'] . ";
	}
	/* Finish H4 Font */
	
	
	/* Start H5 Font */
	.tribe-events-venue-widget .vcalendar .entry-title, 
	.tribe-events-venue-widget .vcalendar .entry-title a, 
	html .datepicker .datepicker-days thead > tr > th.dow,
	html .datepicker .table-condensed tbody > tr > td span.month,
	html .datepicker .table-condensed tbody > tr > td span.year,
	html .datepicker .table-condensed tbody > tr > td span.decade,
	html .datepicker .table-condensed tbody > tr > td span.century,
	.tribe_mini_calendar_widget .tribe-mini-calendar-list-wrapper .entry-title, 
	.tribe_mini_calendar_widget .tribe-mini-calendar-list-wrapper .entry-title a,
	.tribe-mini-calendar [id*=tribe-mini-calendar-month], 
	.tribe-events-grid .tribe-week-event .vevent .entry-title a,
	.cmsmasters_event_month,
	.tribe-events-list .tribe-events-day-time-slot > h5, 
	.tribe-events-tooltip .entry-title,
	.cmsmasters_event_big_month,
	.tribe-events-list .tribe-events-list-separator-month,
	.tribe-bar-filters-inner > div label, 
	table.tribe-events-calendar tbody td .tribe-events-month-event-title, 
	table.tribe-events-calendar tbody td .tribe-events-month-event-title a, 
	.tribe-mobile-day .tribe-events-read-more {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h5_font_google_font']) . $cmsmasters_option['islam-house' . '_h5_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h5_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h5_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h5_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h5_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h5_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h5_font_text_decoration'] . ";
	}
	
	html .datepicker .datepicker-days thead > tr > th.dow {
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] + 12) . "px;
		font-weight:500;
	}
	
	html .datepicker .table-condensed tbody > tr > td span.month,
	html .datepicker .table-condensed tbody > tr > td span.year,
	html .datepicker .table-condensed tbody > tr > td span.decade,
	html .datepicker .table-condensed tbody > tr > td span.century {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 4) . "px;
		line-height:54px;
	}
	
	.cmsmasters_event_big_month {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] + 4) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] + 4) . "px;
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .cmsmasters_event_big_month {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] + 10) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] + 10) . "px;
		font-weight:700;
	}
	
	.widget .vcalendar .entry-title, 
	.widget .vcalendar .entry-title a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] - 3) . "px;
	}
	
	.tribe-this-week-events-widget .tribe-this-week-event .entry-title,
	.tribe-this-week-events-widget .tribe-this-week-event .entry-title a,
	.tribe-events-venue-widget .vcalendar .entry-title, 
	.tribe-events-venue-widget .vcalendar .entry-title a, 
	.tribe_mini_calendar_widget .tribe-mini-calendar-list-wrapper .entry-title, 
	.tribe_mini_calendar_widget .tribe-mini-calendar-list-wrapper .entry-title a,
	.tribe-mini-calendar-list-wrapper .entry-title,
	.tribe-mini-calendar-list-wrapper .entry-title a,
	.tribe-events-list .tribe-events-day-time-slot > h5, 
	.tribe-events-list .tribe-events-list-separator-month {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] - 4) . "px;
	}
	
	.tribe-mini-calendar [id*=tribe-mini-calendar-month], 
	.tribe-events-grid .tribe-week-event .vevent .entry-title a,
	.cmsmasters_event_month,
	.tribe-events-tooltip .entry-title,
	table.tribe-events-calendar tbody td .tribe-events-month-event-title, 
	table.tribe-events-calendar tbody td .tribe-events-month-event-title a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] - 4) . "px;
	}
	/* Finish H5 Font */
	
	
	/* Start H6 Font */
	.tribe-events-countdown-widget .tribe-countdown-text, 
	.tribe-events-countdown-widget .tribe-countdown-text a,
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap .cmsmasters_widget_event_info,
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap .cmsmasters_widget_event_info a,
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-list-widget .tribe-events-list-widget-content-wrap .cmsmasters_widget_event_info,
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-list-widget .tribe-events-list-widget-content-wrap .cmsmasters_widget_event_info a,
	.tribe-this-week-events-widget .tribe-this-week-event .duration, 
	.tribe-this-week-events-widget .tribe-this-week-event .tribe-venue,
	.tribe-this-week-events-widget .tribe-this-week-event .tribe-venue a,
	.tribe-this-week-events-widget .tribe-events-page-title, 
	.widget .vcalendar .cmsmasters_widget_event_info, 
	.widget .vcalendar .cmsmasters_widget_event_info a, 
	.tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info, 
	.tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info a, 
	.tribe-events-organizer .cmsmasters_events_organizer_header_right a, 
	#tribe-events-content > .tribe-events-button, 
	.tribe-events-tooltip .duration .published,
	table.tribe-events-calendar tbody td .tribe-events-viewmore a,
	.cmsmasters_single_event_meta .cmsmasters_event_meta_info_item, 
	.cmsmasters_single_event_meta .cmsmasters_event_meta_info_item a, 
	.cmsmasters_single_event .tribe-events-cost, 
	.cmsmasters_single_event .cmsmasters_single_event_header_right a, 
	.tribe-events-list .tribe-events-event-meta .published, 
	.tribe-events-list .tribe-events-event-meta .published a, 
	.tribe-events-list .tribe-events-event-meta .tribe-events-address,
	.tribe-events-list .tribe-events-event-cost, 
	.tribe-events-list .tribe-events-event-meta,  
	.tribe-events-list .tribe-events-event-meta a, 
	.tribe-events-photo .tribe-events-event-meta, 
	.tribe-events-photo .tribe-events-event-meta a, 
	.cmsmasters_single_event .tribe-events-schedule, 
	.cmsmasters_single_event .tribe-events-schedule a, 
	.tribe-events-venue .tribe-events-event-meta, 
	.tribe-events-venue .tribe-events-event-meta a, 
	.tribe-events-organizer .tribe-events-event-meta, 
	.tribe-events-organizer .tribe-events-event-meta a, 
	.tribe-events-venue .cmsmasters_events_venue_header_right a, 
	.tribe_mini_calendar_widget .tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info, 
	.tribe_mini_calendar_widget .tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info a, 
	.tribe-events-venue-widget .vcalendar .cmsmasters_widget_event_info, 
	.tribe-events-venue-widget .vcalendar .cmsmasters_widget_event_info a, 
	.tribe-mobile-day .tribe-events-event-schedule-details, 
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget span.tribe-countdown-under,
	.tribe-mobile-day .tribe-event-schedule-details {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h6_font_google_font']) . $cmsmasters_option['islam-house' . '_h6_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h6_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h6_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h6_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h6_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h6_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h6_font_text_decoration'] . ";
	}
	
	.tribe-bar-filters .tribe-bar-submit .tribe-events-button {
		line-height:46px;
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-time .tribe-countdown-under {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_font_size'] + 8) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_line_height'] + 10) . "px;
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-list-widget .tribe-events-list-widget-content-wrap .cmsmasters_widget_event_info,
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-list-widget .tribe-events-list-widget-content-wrap .cmsmasters_widget_event_info a,
	.tribe-events-organizer .tribe-events-event-meta, 
	.tribe-events-organizer .tribe-events-event-meta a, 
	.tribe-events-venue .tribe-events-event-meta, 
	.tribe-events-venue .tribe-events-event-meta a, 
	.cmsmasters_single_event .tribe-events-cost, 
	.cmsmasters_single_event .tribe-events-schedule, 
	.cmsmasters_single_event .tribe-events-schedule a, 
	.tribe-events-list .tribe-events-event-meta .published, 
	.tribe-events-list .tribe-events-event-meta .published a, 
	.tribe-events-list .tribe-events-event-meta .tribe-events-address, 
	.tribe-events-list .tribe-events-event-meta, 
	.tribe-events-list .tribe-events-event-meta a, 
	.tribe-events-list .tribe-events-event-cost {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_font_size'] - 1) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_line_height'] - 4) . "px;
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap .cmsmasters_widget_event_info,
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-adv-list-widget .tribe-events-list-widget-content-wrap .cmsmasters_widget_event_info a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_font_size'] + 2) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_line_height'] + 10) . "px;
	}
	
	.tribe-this-week-events-widget .tribe-this-week-event .duration, 
	.tribe-this-week-events-widget .tribe-this-week-event .tribe-venue,
	.tribe-this-week-events-widget .tribe-this-week-event .tribe-venue a,
	.tribe_mini_calendar_widget .tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info, 
	.tribe_mini_calendar_widget .tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info a, 
	.tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info, 
	.tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info a, 
	.tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info, 
	.tribe-mini-calendar-list-wrapper .cmsmasters_widget_event_info a, 
	.tribe-events-tooltip .duration .published,
	table.tribe-events-calendar tbody td .tribe-events-viewmore a,
	ul.tribe-related-events .tribe-related-event-info .published {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_line_height'] - 6) . "px;
	}
	
	.widget .vcalendar .cmsmasters_widget_event_info, 
	.widget .vcalendar .cmsmasters_widget_event_info a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_font_size'] - 3) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_line_height'] - 6) . "px;
	}
	/* Finish H6 Font */
	
	
	/* Start Button Font */
	.tribe-events-countdown-widget .tribe-countdown-time .tribe-countdown-under
	.tribe-events-grid .tribe-grid-header span,
	table.tribe-events-calendar thead th, 
	#tribe-bar-views .tribe-bar-views-list li, 
	#tribe-bar-views .tribe-bar-views-list li a {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_button_font_google_font']) . $cmsmasters_option['islam-house' . '_button_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_button_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_button_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_button_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_button_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_button_font_text_transform'] . ";
	}
	
	.tribe-events-countdown-widget .tribe-countdown-time .tribe-countdown-under {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_button_font_font_size'] - 2) . "px;
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-time .tribe-countdown-under, 
	.tribe-events-countdown-widget .tribe-countdown-time .tribe-countdown-under {
		text-transform:capitalize;
	}
	
	.tribe-events-countdown-widget .tribe-countdown-time .tribe-countdown-under, 
	.tribe-events-grid .tribe-grid-header span,
	table.tribe-events-calendar thead th {
		line-height:20px;
	}
	
	@media only screen and (max-width: 950px) {
		table.tribe-events-calendar thead th {
			font-size:20px;
		}
	}
	
	@media only screen and (max-width: 768px) {
		table.tribe-events-calendar thead th {
			font-size:18px;
		}
	}
	/* Finish Button Font */
	
	
	/* Start Small Text Font */
	html .datepicker .datepicker-switch {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_small_font_google_font']) . $cmsmasters_option['islam-house' . '_small_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_small_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_small_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_small_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_small_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_small_font_text_transform'] . ";
	}
	
	html .datepicker .datepicker-switch {
		font-weight:600;
	}
	/* Finish Small Text Font */
	
	
	/* Start Quote Text Font */
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-text a {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_button_font_google_font']) . $cmsmasters_option['islam-house' . '_button_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_quote_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_quote_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_quote_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_quote_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_button_font_text_transform'] . ";
	}
	
	.cmsmasters_sidebar.sidebar_layout_11 .tribe-events-countdown-widget .tribe-countdown-text a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_quote_font_font_size'] + 2) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_quote_font_line_height'] + 6) . "px;
	}
	/* Finish Quote Text Font */

/***************** Finish Tribe Events Font Styles ******************/

";
	
	
	return $custom_css;
}

add_filter('islam_house_theme_fonts_filter', 'islam_house_tribe_events_fonts');

