<?php
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version		1.0.9
 *
 * Theme Settings Defaults
 * Created by CMSMasters
 *
 */


/* Theme Settings General Default Values */
if (!function_exists('islam_house_settings_general_defaults')) {

	function islam_house_settings_general_defaults($id = false) {
		$settings = array(
			'general' => array(
				'islam-house' . '_theme_layout' => 		'liquid',
				'islam-house' . '_logo_type' => 		'image',
				'islam-house' . '_logo_url' => 			'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo.png',
				'islam-house' . '_logo_url_retina' => 	'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_retina.png',
				'islam-house' . '_logo_title' => 		get_bloginfo('name') ? get_bloginfo('name') : 'Islam House',
				'islam-house' . '_logo_subtitle' => 	'',
				'islam-house' . '_logo_custom_color' => 0,
				'islam-house' . '_logo_title_color' => 	'',
				'islam-house' . '_logo_subtitle_color' => ''
			),
			'bg' => array(
				'islam-house' . '_bg_col' => 			'#f9f9f9',
				'islam-house' . '_bg_img_enable' => 	0,
				'islam-house' . '_bg_img' => 			'',
				'islam-house' . '_bg_rep' => 			'no-repeat',
				'islam-house' . '_bg_pos' => 			'top center',
				'islam-house' . '_bg_att' => 			'scroll',
				'islam-house' . '_bg_size' => 		    'cover'
			),
			'header' => array(
				'islam-house' . '_fixed_header' => 				    1,
				'islam-house' . '_header_overlaps' => 		        0,
				'islam-house' . '_header_top_line' => 			    0,
				'islam-house' . '_header_top_height' => 			'40',
				'islam-house' . '_header_top_line_short_info' => 	'',
				'islam-house' . '_header_top_line_add_cont' => 	    'nav',
				'islam-house' . '_header_styles' => 				'c_nav',
				'islam-house' . '_header_mid_height' => 			'270',
				'islam-house' . '_header_bot_height' => 			'75',
				'islam-house' . '_woocommerce_cart_dropdown' => 	1,
				'islam-house' . '_header_search' => 				1,
				'islam-house' . '_header_add_cont' => 			    'none',
				'islam-house' . '_header_add_cont_cust_html' => 	''
			),
			'content' => array(
				'islam-house' . '_layout' => 					'r_sidebar',
				'islam-house' . '_archives_layout' => 		    'r_sidebar',
				'islam-house' . '_search_layout' => 			'r_sidebar',
				'islam-house' . '_other_layout' => 			    'r_sidebar',
				'islam-house' . '_heading_alignment' => 		'center',
				'islam-house' . '_heading_scheme' => 			'default',
				'islam-house' . '_heading_bg_image_enable' =>   1,
				'islam-house' . '_heading_bg_image' => 		    '|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/headline.jpg',
				'islam-house' . '_heading_bg_repeat' => 		'no-repeat',
				'islam-house' . '_heading_bg_attachment' => 	'scroll',
				'islam-house' . '_heading_bg_size' => 		    'cover',
				'islam-house' . '_heading_bg_color' => 		    'rgba(255,253,246,0)',
				'islam-house' . '_heading_height' => 			'300',
				'islam-house' . '_breadcrumbs' => 			    1,
				'islam-house' . '_bottom_scheme' => 			'default',
				'islam-house' . '_bottom_sidebar' => 			0,
				'islam-house' . '_bottom_sidebar_layout' => 	'14141414'
			),
			'footer' => array(
				'islam-house' . '_footer_scheme' => 			'footer',
				'islam-house' . '_footer_type' => 				'default',
				'islam-house' . '_footer_additional_content' => 'social',
				'islam-house' . '_footer_logo' => 				1,
				'islam-house' . '_footer_logo_url' => 			'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_footer.png',
				'islam-house' . '_footer_logo_url_retina' => 	'|' . get_template_directory_uri() . '/theme-vars/theme-style' . CMSMASTERS_THEME_STYLE . '/img/logo_footer_retina.png',
				'islam-house' . '_footer_nav' => 				0,
				'islam-house' . '_footer_social' => 			1,
				'islam-house' . '_footer_html' => 				'',
				'islam-house' . '_footer_copyright' => 			'This is a sample website - cmsmasters &copy; ' . date('Y') . ' / All Rights Reserved'
			)
		);


		if ($id) {
			return $settings[$id];
		} else {
			return $settings;
		}
	}

}



/* Theme Settings Fonts Default Values */
if (!function_exists('islam_house_settings_font_defaults')) {

	function islam_house_settings_font_defaults($id = false) {
		$settings = array(
			'content' => array(
				'islam-house' . '_content_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'Muli:400,600',
					'font_size' => 			'18',
					'line_height' => 		'28',
					'font_weight' => 		'normal',
					'font_style' => 		'normal'
				)
			),
			'link' => array(
				'islam-house' . '_link_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'Muli:400,600',
					'font_size' => 			'18',
					'line_height' => 		'30',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'none',
					'text_decoration' => 	'none'
				),
				'islam-house' . '_link_hover_decoration' => 	'none'
			),
			'nav' => array(
				'islam-house' . '_nav_title_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'El+Messiri:400,500,600,700',
					'font_size' => 			'20',
					'line_height' => 		'30',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'uppercase'
				),
				'islam-house' . '_nav_dropdown_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'Muli:400,600',
					'font_size' => 			'17',
					'line_height' => 		'26',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'none'
				)
			),
			'heading' => array(
				'islam-house' . '_h1_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'El+Messiri:400,500,600,700',
					'font_size' => 			'70',
					'line_height' => 		'80',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'none',
					'text_decoration' => 	'none'
				),
				'islam-house' . '_h2_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'El+Messiri:400,500,600,700',
					'font_size' => 			'44',
					'line_height' => 		'54',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'none',
					'text_decoration' => 	'none'
				),
				'islam-house' . '_h3_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'El+Messiri:400,500,600,700',
					'font_size' => 			'32',
					'line_height' => 		'40',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'none',
					'text_decoration' => 	'none'
				),
				'islam-house' . '_h4_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'El+Messiri:400,500,600,700',
					'font_size' => 			'24',
					'line_height' => 		'32',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'none',
					'text_decoration' => 	'none'
				),
				'islam-house' . '_h5_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'El+Messiri:400,500,600,700',
					'font_size' => 			'20',
					'line_height' => 		'28',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'none',
					'text_decoration' => 	'none'
				),
				'islam-house' . '_h6_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'Lora:400,400italic,700,700italic',
					'font_size' => 			'18',
					'line_height' => 		'24',
					'font_weight' => 		'normal',
					'font_style' => 		'italic',
					'text_transform' => 	'none',
					'text_decoration' => 	'none'
				)
			),
			'other' => array(
				'islam-house' . '_button_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'El+Messiri:400,500,600,700',
					'font_size' => 			'22',
					'line_height' => 		'60',
					'font_weight' => 		'600',
					'font_style' => 		'normal',
					'text_transform' => 	'default'
				),
				'islam-house' . '_small_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'Muli:400,600',
					'font_size' => 			'16',
					'line_height' => 		'26',
					'font_weight' => 		'400',
					'font_style' => 		'normal',
					'text_transform' => 	'none'
				),
				'islam-house' . '_input_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'Muli:400,600',
					'font_size' => 			'18',
					'line_height' => 		'28',
					'font_weight' => 		'normal',
					'font_style' => 		'normal'
				),
				'islam-house' . '_quote_font' => array(
					'system_font' => 		"Arial, Helvetica, 'Nimbus Sans L', sans-serif",
					'google_font' => 		'El+Messiri:400,500,600,700',
					'font_size' => 			'40',
					'line_height' => 		'60',
					'font_weight' => 		'600',
					'font_style' => 		'normal'
				)
			),
			'google' => array(
				'islam-house' . '_google_web_fonts' => array(
					'Lora:400,400italic,700,700italic|Lora',
					'El+Messiri:400,500,600,700|El Messiri',
					'Muli:400,600|Muli'
				)
			)
		);


		if ($id) {
			return $settings[$id];
		} else {
			return $settings;
		}
	}

}



// WP Color Picker Palettes
if (!function_exists('cmsmasters_color_picker_palettes')) {

	function cmsmasters_color_picker_palettes() {
		$palettes = array(
			'#816d4f',
			'#c8831c',
			'#b2bd31',
			'#594f41',
			'#fffdf6',
			'#f6edde',
			'#e7e2db'
		);


		return $palettes;
	}

}



// Theme Settings Color Schemes Default Colors
if (!function_exists('islam_house_color_schemes_defaults')) {

	function islam_house_color_schemes_defaults($id = false) {
		$settings = array(
			'default' => array( // content default color scheme
				'color' => 		'#816d4f',
				'link' => 		'#c8831c',
				'hover' => 		'#b2bd31',
				'heading' => 	'#594f41',
				'bg' => 		'#fffdf6',
				'alternate' => 	'#f6edde',
				'border' => 	'#e7e2db'
			),
			'header' => array( // Header color scheme
				'mid_color' => 		'#816d4f',
				'mid_link' => 		'#816d4f',
				'mid_hover' => 		'rgba(129,109,79,0.6)',
				'mid_bg' => 		'rgba(255,253,246,0)',
				'mid_bg_scroll' => 	'#fffdf6',
				'mid_border' => 	'rgba(234,234,234,0)',
				'bot_color' => 		'#ffc876',
				'bot_link' => 		'#ffc876',
				'bot_hover' => 		'rgba(255,200,118,0.7)',
				'bot_bg' => 		'#555e3e',
				'bot_bg_scroll' => 	'#555e3e',
				'bot_border' => 	'rgba(234,234,234,0)'
			),
			'navigation' => array( // Navigation color scheme
				'title_link' => 			'#ffc876',
				'title_link_hover' => 		'rgba(255,200,118,0.7)',
				'title_link_current' => 	'#ffc876',
				'title_link_subtitle' => 	'rgba(255,200,118,0.6)',
				'title_link_bg' => 			'rgba(255,255,255,0)',
				'title_link_bg_hover' => 	'rgba(255,255,255,0)',
				'title_link_bg_current' => 	'rgba(255,255,255,0)',
				'title_link_border' => 		'rgba(221,221,221,0)',
				'dropdown_text' => 			'rgba(129,109,79,0.7)',
				'dropdown_bg' => 			'#f6edde',
				'dropdown_border' => 		'rgba(234,234,234,0)',
				'dropdown_link' => 			'#816d4f',
				'dropdown_link_hover' => 	'#c8831c',
				'dropdown_link_subtitle' => 'rgba(129,109,79,0.7)',
				'dropdown_link_highlight' => 'rgba(255,255,255,0)',
				'dropdown_link_border' => 	'rgba(255,255,255,0)'
			),
			'header_top' => array( // Header Top color scheme
				'color' => 					'#ffc876',
				'link' => 					'#ffc876',
				'hover' => 					'rgba(255,200,118,0.6)',
				'bg' => 					'#7f643c',
				'border' => 				'rgba(255,255,255,0)',
				'title_link' => 			'#ffdaa4',
				'title_link_hover' => 		'rgba(255,218,164,0.7)',
				'title_link_bg' => 			'rgba(255,255,255,0)',
				'title_link_bg_hover' => 	'rgba(255,255,255,0)',
				'title_link_border' => 		'rgba(255,255,255,0)',
				'dropdown_bg' => 			'#6c5738',
				'dropdown_border' => 		'rgba(221,221,221,0)',
				'dropdown_link' => 			'rgba(255,227,186,0.6)',
				'dropdown_link_hover' => 	'#ffdaa4',
				'dropdown_link_highlight' => 'rgba(255,255,255,0)',
				'dropdown_link_border' => 	'rgba(255,255,255,0)'
			),
			'footer' => array( // Footer color scheme
				'color' => 		'rgba(255,218,161,0.7)',
				'link' => 		'#ffdaa1',
				'hover' => 		'#ffc46b',
				'heading' => 	'#ffdaa1',
				'bg' => 		'#71873c',
				'alternate' => 	'rgba(255,255,255,0)',
				'border' => 	'rgba(255,255,255,0)'
			),
			'first' => array( // custom color scheme 1
				'color' => 		'#ffb94f',
				'link' => 		'#ffdaa1',
				'hover' => 		'#ffb94f',
				'heading' => 	'#594f41',
				'bg' => 		'#fffdf6',
				'alternate' => 	'#f6edde',
				'border' => 	'#e7e2db'
			),
			'second' => array( // custom color scheme 2
				'color' => 		'#fff4cd',
				'link' => 		'#ffb94f',
				'hover' => 		'#b2bd31',
				'heading' => 	'#ffeacb',
				'bg' => 		'#fffdf6',
				'alternate' => 	'#4e663b',
				'border' => 	'rgba(255,253,246,0.37)'
			),
			'third' => array( // custom color scheme 3
				'color' => 		'#816d4f',
				'link' => 		'#c8831c',
				'hover' => 		'#b2bd31',
				'heading' => 	'#594f41',
				'bg' => 		'#f6edde',
				'alternate' => 	'#fffdf6',
				'border' => 	'#e7e2db'
			)
		);


		if ($id) {
			return $settings[$id];
		} else {
			return $settings;
		}
	}

}



// Theme Settings Elements Default Values
if (!function_exists('islam_house_settings_element_defaults')) {

	function islam_house_settings_element_defaults($id = false) {
		$settings = array(
			'sidebar' => array(
				'islam-house' . '_sidebar' => 	''
			),
			'icon' => array(
				'islam-house' . '_social_icons' => array(
					'cmsmasters-icon-linkedin|#|' . esc_html__('Linkedin', 'islam-house') . '|true||',
					'cmsmasters-icon-facebook|#|' . esc_html__('Facebook', 'islam-house') . '|true||',
					'cmsmasters-icon-twitter|#|' . esc_html__('Twitter', 'islam-house') . '|true||',
					'cmsmasters-icon-skype|#|' . esc_html__('Skype', 'islam-house') . '|true||'
				)
			),
			'lightbox' => array(
				'islam-house' . '_ilightbox_skin' => 					'dark',
				'islam-house' . '_ilightbox_path' => 					'vertical',
				'islam-house' . '_ilightbox_infinite' => 				0,
				'islam-house' . '_ilightbox_aspect_ratio' => 			1,
				'islam-house' . '_ilightbox_mobile_optimizer' => 		1,
				'islam-house' . '_ilightbox_max_scale' => 			1,
				'islam-house' . '_ilightbox_min_scale' => 			0.2,
				'islam-house' . '_ilightbox_inner_toolbar' => 		0,
				'islam-house' . '_ilightbox_smart_recognition' => 	0,
				'islam-house' . '_ilightbox_fullscreen_one_slide' => 	0,
				'islam-house' . '_ilightbox_fullscreen_viewport' => 	'center',
				'islam-house' . '_ilightbox_controls_toolbar' => 		1,
				'islam-house' . '_ilightbox_controls_arrows' => 		0,
				'islam-house' . '_ilightbox_controls_fullscreen' => 	1,
				'islam-house' . '_ilightbox_controls_thumbnail' => 	1,
				'islam-house' . '_ilightbox_controls_keyboard' => 	1,
				'islam-house' . '_ilightbox_controls_mousewheel' => 	1,
				'islam-house' . '_ilightbox_controls_swipe' => 		1,
				'islam-house' . '_ilightbox_controls_slideshow' => 	0
			),
			'sitemap' => array(
				'islam-house' . '_sitemap_nav' => 		1,
				'islam-house' . '_sitemap_categs' => 		1,
				'islam-house' . '_sitemap_tags' => 		1,
				'islam-house' . '_sitemap_month' => 		1,
				'islam-house' . '_sitemap_pj_categs' => 	1,
				'islam-house' . '_sitemap_pj_tags' => 	1
			),
			'error' => array(
				'islam-house' . '_error_color' => 			'#594f41',
				'islam-house' . '_error_bg_color' => 			'#fffdf6',
				'islam-house' . '_error_bg_img_enable' => 	0,
				'islam-house' . '_error_bg_image' => 			'',
				'islam-house' . '_error_bg_rep' => 			'no-repeat',
				'islam-house' . '_error_bg_pos' => 			'top center',
				'islam-house' . '_error_bg_att' => 			'scroll',
				'islam-house' . '_error_bg_size' => 			'cover',
				'islam-house' . '_error_search' => 			1,
				'islam-house' . '_error_sitemap_button' => 	1,
				'islam-house' . '_error_sitemap_link' => 		''
			),
			'code' => array(
				'islam-house' . '_custom_css' => 			'',
				'islam-house' . '_custom_js' => 			'',
				'islam-house' . '_gmap_api_key' => 		'',
				'islam-house' . '_twitter_access_token' => ''
			),
			'recaptcha' => array(
				'islam-house' . '_recaptcha_public_key' => 	'',
				'islam-house' . '_recaptcha_private_key' => 	''
			)
		);


		if ($id) {
			return $settings[$id];
		} else {
			return $settings;
		}
	}

}



// Theme Settings Single Posts Default Values
if (!function_exists('islam_house_settings_single_defaults')) {

	function islam_house_settings_single_defaults($id = false) {
		$settings = array(
			'post' => array(
				'islam-house' . '_blog_post_layout' => 		'fullwidth',
				'islam-house' . '_blog_post_title' => 		1,
				'islam-house' . '_blog_post_date' => 			1,
				'islam-house' . '_blog_post_cat' => 			1,
				'islam-house' . '_blog_post_author' => 		1,
				'islam-house' . '_blog_post_comment' => 		1,
				'islam-house' . '_blog_post_tag' => 			1,
				'islam-house' . '_blog_post_like' => 			1,
				'islam-house' . '_blog_post_nav_box' => 		1,
				'islam-house' . '_blog_post_nav_order_cat' => 0,
				'islam-house' . '_blog_post_share_box' => 	1,
				'islam-house' . '_blog_post_author_box' => 	1,
				'islam-house' . '_blog_more_posts_box' => 	'popular',
				'islam-house' . '_blog_more_posts_count' => 	'4',
				'islam-house' . '_blog_more_posts_pause' => 	'4'
			),
			'project' => array(
				'islam-house' . '_portfolio_project_title' => 		1,
				'islam-house' . '_portfolio_project_details_title' => esc_html__('Project details', 'islam-house'),
				'islam-house' . '_portfolio_project_date' => 			1,
				'islam-house' . '_portfolio_project_cat' => 			1,
				'islam-house' . '_portfolio_project_author' => 		1,
				'islam-house' . '_portfolio_project_comment' => 		1,
				'islam-house' . '_portfolio_project_tag' => 			0,
				'islam-house' . '_portfolio_project_like' => 			1,
				'islam-house' . '_portfolio_project_link' => 			0,
				'islam-house' . '_portfolio_project_share_box' => 	1,
				'islam-house' . '_portfolio_project_nav_box' => 		1,
				'islam-house' . '_portfolio_project_nav_order_cat' => 0,
				'islam-house' . '_portfolio_project_author_box' => 	0,
				'islam-house' . '_portfolio_more_projects_box' => 	'popular',
				'islam-house' . '_portfolio_more_projects_count' => 	'4',
				'islam-house' . '_portfolio_more_projects_pause' => 	'4',
				'islam-house' . '_portfolio_project_slug' => 			'project',
				'islam-house' . '_portfolio_pj_categs_slug' => 		'pj-categs',
				'islam-house' . '_portfolio_pj_tags_slug' => 			'pj-tags'
			),
			'profile' => array(
				'islam-house' . '_profile_post_title' => 			1,
				'islam-house' . '_profile_post_details_title' => 	esc_html__('Profile details', 'islam-house'),
				'islam-house' . '_profile_post_cat' => 			1,
				'islam-house' . '_profile_post_comment' => 		1,
				'islam-house' . '_profile_post_like' => 			1,
				'islam-house' . '_profile_post_nav_box' => 		1,
				'islam-house' . '_profile_post_nav_order_cat' => 	0,
				'islam-house' . '_profile_post_share_box' => 		0,
				'islam-house' . '_profile_post_slug' => 			'profile',
				'islam-house' . '_profile_pl_categs_slug' => 		'pl-categs'
			)
		);


		if ($id) {
			return $settings[$id];
		} else {
			return $settings;
		}
	}

}



/* Project Puzzle Proportion */
if (!function_exists('islam_house_project_puzzle_proportion')) {

	function islam_house_project_puzzle_proportion() {
		return 1;
	}

}



/* Theme Image Thumbnails Size */
if (!function_exists('islam_house_get_image_thumbnail_list')) {

	function islam_house_get_image_thumbnail_list() {
		$list = array(
			'cmsmasters-small-thumb' => array(
				'width' => 		70,
				'height' => 	70,
				'crop' => 		true
			),
			'cmsmasters-square-thumb' => array(
				'width' => 		300,
				'height' => 	300,
				'crop' => 		true,
				'title' => 		esc_attr__('Square', 'islam-house')
			),
			'cmsmasters-blog-masonry-thumb' => array(
				'width' => 		580,
				'height' => 	420,
				'crop' => 		true,
				'title' => 		esc_attr__('Masonry Blog', 'islam-house')
			),
			'cmsmasters-project-grid-thumb' => array(
				'width' => 		480,
				'height' => 	287,
				'crop' => 		true,
				'title' => 		esc_attr__('Project Grid', 'islam-house')
			),
			'cmsmasters-project-thumb' => array(
				'width' => 		580,
				'height' => 	580,
				'crop' => 		true,
				'title' => 		esc_attr__('Project', 'islam-house')
			),
			'cmsmasters-project-masonry-thumb' => array(
				'width' => 		580,
				'height' => 	9999,
				'title' => 		esc_attr__('Masonry Project', 'islam-house')
			),
			'post-thumbnail' => array(
				'width' => 		1020,
				'height' => 	593,
				'crop' => 		true,
				'title' => 		esc_attr__('Featured', 'islam-house')
			),
			'cmsmasters-masonry-thumb' => array(
				'width' => 		1020,
				'height' => 	9999,
				'title' => 		esc_attr__('Masonry', 'islam-house')
			),
			'cmsmasters-full-thumb' => array(
				'width' => 		1360,
				'height' => 	762,
				'crop' => 		true,
				'title' => 		esc_attr__('Full', 'islam-house')
			),
			'cmsmasters-project-full-thumb' => array(
				'width' => 		1360,
				'height' => 	820,
				'crop' => 		true,
				'title' => 		esc_attr__('Project Full', 'islam-house')
			),
			'cmsmasters-full-masonry-thumb' => array(
				'width' => 		1360,
				'height' => 	9999,
				'title' => 		esc_attr__('Masonry Full', 'islam-house')
			)
		);


		return $list;
	}

}



/* Project Post Type Registration Rename */
if (!function_exists('islam_house_project_labels')) {

	function islam_house_project_labels() {
		return array(
			'name' => 					esc_html__('Projects', 'islam-house'),
			'singular_name' => 			esc_html__('Project', 'islam-house'),
			'menu_name' => 				esc_html__('Projects', 'islam-house'),
			'all_items' => 				esc_html__('All Projects', 'islam-house'),
			'add_new' => 				esc_html__('Add New', 'islam-house'),
			'add_new_item' => 			esc_html__('Add New Project', 'islam-house'),
			'edit_item' => 				esc_html__('Edit Project', 'islam-house'),
			'new_item' => 				esc_html__('New Project', 'islam-house'),
			'view_item' => 				esc_html__('View Project', 'islam-house'),
			'search_items' => 			esc_html__('Search Projects', 'islam-house'),
			'not_found' => 				esc_html__('No projects found', 'islam-house'),
			'not_found_in_trash' => 	esc_html__('No projects found in Trash', 'islam-house')
		);
	}

}

// add_filter('cmsmasters_project_labels_filter', 'islam_house_project_labels');


if (!function_exists('islam_house_pj_categs_labels')) {

	function islam_house_pj_categs_labels() {
		return array(
			'name' => 					esc_html__('Project Categories', 'islam-house'),
			'singular_name' => 			esc_html__('Project Category', 'islam-house')
		);
	}

}

// add_filter('cmsmasters_pj_categs_labels_filter', 'islam_house_pj_categs_labels');


if (!function_exists('islam_house_pj_tags_labels')) {

	function islam_house_pj_tags_labels() {
		return array(
			'name' => 					esc_html__('Project Tags', 'islam-house'),
			'singular_name' => 			esc_html__('Project Tag', 'islam-house')
		);
	}

}

// add_filter('cmsmasters_pj_tags_labels_filter', 'islam_house_pj_tags_labels');



/* Profile Post Type Registration Rename */
if (!function_exists('islam_house_profile_labels')) {

	function islam_house_profile_labels() {
		return array(
			'name' => 					esc_html__('Profiles', 'islam-house'),
			'singular_name' => 			esc_html__('Profiles', 'islam-house'),
			'menu_name' => 				esc_html__('Profiles', 'islam-house'),
			'all_items' => 				esc_html__('All Profiles', 'islam-house'),
			'add_new' => 				esc_html__('Add New', 'islam-house'),
			'add_new_item' => 			esc_html__('Add New Profile', 'islam-house'),
			'edit_item' => 				esc_html__('Edit Profile', 'islam-house'),
			'new_item' => 				esc_html__('New Profile', 'islam-house'),
			'view_item' => 				esc_html__('View Profile', 'islam-house'),
			'search_items' => 			esc_html__('Search Profiles', 'islam-house'),
			'not_found' => 				esc_html__('No Profiles found', 'islam-house'),
			'not_found_in_trash' => 	esc_html__('No Profiles found in Trash', 'islam-house')
		);
	}

}

// add_filter('cmsmasters_profile_labels_filter', 'islam_house_profile_labels');


if (!function_exists('islam_house_pl_categs_labels')) {

	function islam_house_pl_categs_labels() {
		return array(
			'name' => 					esc_html__('Profile Categories', 'islam-house'),
			'singular_name' => 			esc_html__('Profile Category', 'islam-house')
		);
	}

}

// add_filter('cmsmasters_pl_categs_labels_filter', 'islam_house_pl_categs_labels');

