<?php
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version 	1.1.2
 * 
 * TGM-Plugin-Activation 2.6.1
 * Created by CMSMasters
 * 
 */


require_once(get_template_directory() . '/framework/class/class-tgm-plugin-activation.php');


if (!function_exists('islam_house_register_theme_plugins')) {

function islam_house_register_theme_plugins() { 
	$plugins = array( 
		array( 
			'name'					=> esc_html__('CMSMasters Content Composer', 'islam-house'), 
			'slug'					=> 'cmsmasters-content-composer', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-content-composer.zip', 
			'required'				=> true, 
			'version'				=> '2.5.3',
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		),
		array(
			'name'					=> esc_html__('CMSMasters Custom Fonts', 'islam-house'),
			'slug'					=> 'cmsmasters-custom-fonts',
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-custom-fonts.zip',
			'required'				=> true,
			'version'				=> '1.0.1',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array( 
			'name'					=> esc_html__('CMSMasters Mega Menu', 'islam-house'), 
			'slug'					=> 'cmsmasters-mega-menu', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-mega-menu.zip', 
			'required'				=> true, 
			'version'				=> '1.2.9',
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		), 
		array( 
			'name'					=> esc_html__('CMSMasters Donations', 'islam-house'), 
			'slug'					=> 'cmsmasters-donations', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-donations.zip', 
			'required'				=> true, 
			'version'				=> '1.3.7',
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		),
		array(
			'name'					=> esc_html__('CMSMasters Importer', 'islam-house'),
			'slug'					=> 'cmsmasters-importer',
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-importer.zip',
			'required'				=> true,
			'version'				=> '1.0.7',
			'force_activation'		=> false,
			'force_deactivation' 	=> false
		),
		array( 
			'name'					=> esc_html__('CMSMasters Sermons', 'islam-house'), 
			'slug'					=> 'cmsmasters-sermons', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/cmsmasters-sermons.zip', 
			'required'				=> true, 
			'version'				=> '1.1.0',
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		),
		array(
			'name' 					=> esc_html__('MP Timetable', 'islam-house'),
			'slug' 					=> 'mp-timetable',
			'required'				=> false
		),
		array( 
			'name' 					=> esc_html__('LayerSlider WP', 'islam-house'), 
			'slug' 					=> 'LayerSlider', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/LayerSlider.zip', 
			'required'				=> false, 
			'version'				=> '7.7.11',
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		), 
		array( 
			'name' 					=> esc_html__('Revolution Slider', 'islam-house'), 
			'slug' 					=> 'revslider', 
			'source'				=> get_template_directory() . '/theme-vars/plugins/revslider.zip', 
			'required'				=> false, 
			'version'				=> '6.6.15',
			'force_activation'		=> false, 
			'force_deactivation' 	=> false 
		),
 		array( 
			'name'					=> esc_html__('Envato Market', 'islam-house'), 
			'slug'					=> 'envato-market',
			'source'				=> 'https://envato.github.io/wp-envato-market/dist/envato-market.zip',
		    'required'              => false
	    ),
		array(
			'name'					=> esc_html__('GDPR Cookie Consent', 'islam-house'),
			'slug'					=> 'cookie-law-info',
			'required'				=> false
		),
		array( 
			'name' 					=> esc_html__('WooCommerce', 'islam-house'), 
			'slug' 					=> 'woocommerce', 
			'required'				=> false 
		), 
		array( 
			'name' 					=> esc_html__('The Events Calendar', 'islam-house'), 
			'slug' 					=> 'the-events-calendar', 
			'required'				=> false 
		), 
		array( 
			'name' 					=> esc_html__('Contact Form 7', 'islam-house'), 
			'slug' 					=> 'contact-form-7', 
			'required' 				=> false 
		), 
	);
	
	
	$config = array( 
		'id' => 			'islam-house', 
		'menu' => 			'theme-required-plugins', 
		'strings' => array( 
			'page_title' => 	esc_html__('Theme Required & Recommended Plugins', 'islam-house'), 
			'menu_title' => 	esc_html__('Theme Plugins', 'islam-house'), 
			'return' => 		esc_html__('Return to Theme Required & Recommended Plugins', 'islam-house') 
		) 
	);
	
	
	tgmpa($plugins, $config);
}

}

add_action('tgmpa_register', 'islam_house_register_theme_plugins');

