<?php
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version 	1.0.0
 * 
 * MP Timetable Fonts Rules
 * Created by CMSMasters
 * 
 */


function islam_house_mp_timetable_fonts($custom_css) {
	$cmsmasters_option = islam_house_get_global_options();
	
	
	$custom_css .= "
/***************** Start MP Timetable Font Styles ******************/

	/* Start Content Font */
	.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-description,		
	.mptt_content,
	.mptt-main-wrapper .mptt-event.events-list .event .event-description,
	.mptt-main-wrapper .mptt-column.events-list .event .event-description {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_content_font_google_font']) . $cmsmasters_option['islam-house' . '_content_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_content_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_content_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_content_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_content_font_font_style'] . ";
	}
	
	.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-description,
	.mptt-main-wrapper .mptt-event.events-list .event .event-description,
	.mptt-main-wrapper .mptt-column.events-list .event .event-description {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_content_font_font_size'] - 4) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_content_font_line_height'] - 8) . "px;
	}
	/* Finish Content Font */

	
	/* Start H3 Font */
	.mptt_h3 {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h3_font_google_font']) . $cmsmasters_option['islam-house' . '_h3_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h3_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h3_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h3_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h3_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h3_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h3_font_text_decoration'] . ";
	}
	/* Finish H3 Font */
	
	
	/* Start H5 Font */
	.mptt-shortcode-wrapper .mptt-shortcode-table tr.mptt-shortcode-row th,
	.cmsmasters_mp_timetable_shortcode .mptt-inner-event-content .event-title,
	.mptt-main-wrapper .mptt-event.events-list .event .event-title,
	.mptt-main-wrapper .mptt-event.events-list .event .event-title a,
	.mptt-main-wrapper .mptt-column.events-list .event .event-title,
	.mptt-main-wrapper .mptt-column.events-list .event .event-title a {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h5_font_google_font']) . $cmsmasters_option['islam-house' . '_h5_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h5_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h5_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h5_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h5_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h5_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h5_font_text_decoration'] . ";
	}
	
	.cmsmasters_mp_timetable_shortcode .mptt-inner-event-content .event-title {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 2) . "px;
		line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] - 4) . "px;
	}
	
	.mptt-shortcode-wrapper .mptt-shortcode-table tr.mptt-shortcode-row th,
	.mptt-main-wrapper .mptt-event.events-list .event .event-title,
	.mptt-main-wrapper .mptt-event.events-list .event .event-title a,
	.mptt-main-wrapper .mptt-column.events-list .event .event-title,
	.mptt-main-wrapper .mptt-column.events-list .event .event-title a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 2) . "px;
		font-weight:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_weight'] + 100) . ";
	}
	
	@media only screen and (min-width:768px) and (max-width: 1024px) {
		.mptt-shortcode-wrapper .mptt-shortcode-table tr.mptt-shortcode-row th,
		.mptt-main-wrapper .mptt-event.events-list .event .event-title,
		.mptt-main-wrapper .mptt-event.events-list .event .event-title a,
		.mptt-main-wrapper .mptt-column.events-list .event .event-title,
		.mptt-main-wrapper .mptt-column.events-list .event .event-title a {
			font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 3) . "px;
		}   
		
		.cmsmasters_mp_timetable_shortcode .mptt-inner-event-content .event-title {
			font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 4) . "px;
			line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] - 6) . "px;
		}
		
		.mptt-shortcode-wrapper .mptt-shortcode-table tbody td.mptt-shortcode-hours {
			font-size:15px;
		}
	}
	
	@media only screen and (min-width:768px) and (max-width: 900px) {
		.mptt-shortcode-wrapper .mptt-shortcode-table tr.mptt-shortcode-row th,
		.mptt-main-wrapper .mptt-event.events-list .event .event-title,
		.mptt-main-wrapper .mptt-event.events-list .event .event-title a,
		.mptt-main-wrapper .mptt-column.events-list .event .event-title,
		.mptt-main-wrapper .mptt-column.events-list .event .event-title a {
			font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 6) . "px;
		}   
		
		.cmsmasters_mp_timetable_shortcode .mptt-inner-event-content .event-title {
			font-size:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_font_size'] - 6) . "px;
			line-height:" . ((int) $cmsmasters_option['islam-house' . '_h5_font_line_height'] - 8) . "px;
		}
		
		.mptt-shortcode-wrapper .mptt-shortcode-table tbody td.mptt-shortcode-hours {
			font-size:15px;
		}
		
		.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .timeslot {
            font-size: 13px !important;
            line-height: 17px !important;
		}
	}
	/* Finish H5 Font */
	
	
	/* Start H6 Font */
	.upcoming-events-widget .events-list .event .column-title,
	.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .timeslot,
	.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-subtitle,
	.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-user,
	.mptt-main-wrapper .mptt-event.events-list .event .timeslot,
	.mptt-main-wrapper .mptt-event.events-list .event .timeslot *,
	.mptt-main-wrapper .mptt-event.events-list .event .event-subtitle,
	.mptt-main-wrapper .mptt-event.events-list .event .event-user a,
	.mptt-main-wrapper .mptt-column.events-list .event .timeslot,
	.mptt-main-wrapper .mptt-column.events-list .event .timeslot *,
	.mptt-main-wrapper .mptt-column.events-list .event .event-subtitle,
	.mptt-main-wrapper .mptt-column.events-list .event .event-user a {
		font-family:" . islam_house_get_google_font($cmsmasters_option['islam-house' . '_h6_font_google_font']) . $cmsmasters_option['islam-house' . '_h6_font_system_font'] . ";
		font-size:" . $cmsmasters_option['islam-house' . '_h6_font_font_size'] . "px;
		line-height:" . $cmsmasters_option['islam-house' . '_h6_font_line_height'] . "px;
		font-weight:" . $cmsmasters_option['islam-house' . '_h6_font_font_weight'] . ";
		font-style:" . $cmsmasters_option['islam-house' . '_h6_font_font_style'] . ";
		text-transform:" . $cmsmasters_option['islam-house' . '_h6_font_text_transform'] . ";
		text-decoration:" . $cmsmasters_option['islam-house' . '_h6_font_text_decoration'] . ";
	}
	
	.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .timeslot,		
	.mptt-main-wrapper .mptt-event.events-list .event .timeslot,
	.mptt-main-wrapper .mptt-event.events-list .event .timeslot *,
	.mptt-main-wrapper .mptt-column.events-list .event .timeslot,
	.mptt-main-wrapper .mptt-column.events-list .event .timeslot * {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_font_size'] - 4) . "px;
	}
	
	.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-subtitle,
	.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-user,
	.mptt-main-wrapper .mptt-event.events-list .event .event-subtitle,
	.mptt-main-wrapper .mptt-event.events-list .event .event-user a,
	.mptt-main-wrapper .mptt-column.events-list .event .event-subtitle,
	.mptt-main-wrapper .mptt-column.events-list .event .event-user a {
		font-size:" . ((int) $cmsmasters_option['islam-house' . '_h6_font_font_size'] - 3) . "px;
	}
	/* Finish H6 Font */
	

/***************** Finish MP Timetable Font Styles ******************/

";
	
	
	return $custom_css;
}

add_filter('islam_house_theme_fonts_filter', 'islam_house_mp_timetable_fonts');

