<?php
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version 	1.0.0
 * 
 * MP Timetable Colors Rules
 * Created by CMSMasters
 * 
 */


function islam_house_mp_timetable_colors($custom_css) {
	$cmsmasters_option = islam_house_get_global_options();
	
	
	$cmsmasters_color_schemes = cmsmasters_color_schemes_list();
	
	
	foreach ($cmsmasters_color_schemes as $scheme => $title) {
		$rule = (($scheme != 'default') ? "html .cmsmasters_color_scheme_{$scheme} " : '');
		
		
		$custom_css .= "
/***************** Start {$title} MP Timetable Color Scheme Rules ******************/

	/* Start Main Content Font Color */
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tr.mptt-shortcode-row th,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-subtitle,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-description,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .event-user,
	{$rule}.mptt_color,
	{$rule}.mptt-main-wrapper .mptt-event.events-list .event .event-user a,
	{$rule}.mptt-main-wrapper .mptt-event.events-list .event .event-title,
	{$rule}.mptt-main-wrapper .mptt-event.events-list .event .event-title a,
	{$rule}.mptt-main-wrapper .mptt-column.events-list .event .event-user a,
	{$rule}.mptt-main-wrapper .mptt-column.events-list .event .event-title,
	{$rule}.mptt-main-wrapper .mptt-column.events-list .event .event-title a {
		" . cmsmasters_color_css('color', $cmsmasters_option['islam-house' . '_' . $scheme . '_color']) . "
	}
	/* Finish Main Content Font Color */
	
	
	/* Start Primary Color */
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container .timeslot,
	{$rule}.mptt-main-wrapper .mptt-event.events-list .event .event-title a:hover,
	{$rule}.mptt-main-wrapper .mptt-event.events-list .event .event-user a:hover,
	{$rule}.mptt-main-wrapper .mptt-event.events-list .event .timeslot,
	{$rule}.mptt-main-wrapper .mptt-event.events-list .event .timeslot *, 
	{$rule}.mptt-main-wrapper .mptt-column.events-list .event .event-title a:hover,
	{$rule}.mptt-main-wrapper .mptt-column.events-list .event .event-user a:hover,
	{$rule}.mptt-main-wrapper .mptt-column.events-list .event .timeslot,
	{$rule}.mptt-main-wrapper .mptt-column.events-list .event .timeslot * {
		" . cmsmasters_color_css('color', $cmsmasters_option['islam-house' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container:hover {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['islam-house' . '_' . $scheme . '_link']) . "
	}
	
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-list .mptt-column .mptt-events-list .mptt-list-event,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container:hover {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['islam-house' . '_' . $scheme . '_link']) . "
	}
	/* Finish Primary Color */
	
	
	/* Start Highlight Color */
	{$rule}.mptt-navigation-tabs li.active a,
	{$rule}.mptt_hover {
		" . cmsmasters_color_css('color', $cmsmasters_option['islam-house' . '_' . $scheme . '_hover']) . "
	}
	/* Finish Highlight Color */
	
	
	/* Start Heading Color */
	{$rule}.mptt_heading,
	{$rule}.cmsmasters_mp_timetable_shortcode .mptt-inner-event-content .event-title {
		" . cmsmasters_color_css('color', $cmsmasters_option['islam-house' . '_' . $scheme . '_heading']) . "
	}
	/* Finish Headings Color */
	
	
	/* Start Main Background Color */
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container:hover .event-title,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container:hover .event-subtitle,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container:hover .timeslot,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container:hover .event-description,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container:hover .event-user,
	{$rule}.mptt_bg {
		" . cmsmasters_color_css('color', $cmsmasters_option['islam-house' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container:hover .event-title:hover {
		color:rgba(" . cmsmasters_color2rgb($cmsmasters_option['islam-house' . '_' . $scheme . '_bg']) . ", 0.5);
	}
	
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody tr,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody td.event {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['islam-house' . '_' . $scheme . '_bg']) . "
	}
	
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tr.mptt-shortcode-row th,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody td,
	{$rule}.mptt-event.events-list .event > *,
	{$rule}.mptt-column.events-list .event > * {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['islam-house' . '_' . $scheme . '_bg']) . "
	}
	/* Finish Main Background Color */
	
	
	/* Start Alternate Background Color */
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody td.event {
		" . cmsmasters_color_css('color', $cmsmasters_option['islam-house' . '_' . $scheme . '_alternate']) . "
	}
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tr.mptt-shortcode-row th,
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody tr:nth-child(2n+2),
	{$rule}.mptt-main-wrapper .mptt-event.events-list .event:nth-child(odd),
	{$rule}.mptt-main-wrapper .mptt-column.events-list .event:nth-child(odd) {
		" . cmsmasters_color_css('background-color', $cmsmasters_option['islam-house' . '_' . $scheme . '_alternate']) . "
	}
	/* Start Alternate Background Color */
	
	
	/* Start Borders Color */
	{$rule}.mptt_border {
		" . cmsmasters_color_css('color', $cmsmasters_option['islam-house' . '_' . $scheme . '_border']) . "
	}
	
	{$rule}.mptt-shortcode-wrapper .mptt-shortcode-table tbody .mptt-event-container,
	{$rule}.upcoming-events-widget .mptt-widget.events-list .event {
		" . cmsmasters_color_css('border-color', $cmsmasters_option['islam-house' . '_' . $scheme . '_border']) . "
	}
	/* Finish Borders Color */

/***************** Finish {$title} MP Timetable Color Scheme Rules ******************/

";
	}
	
	
	return $custom_css;
}

add_filter('islam_house_theme_colors_secondary_filter', 'islam_house_mp_timetable_colors');

