<?php
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version 	1.0.4
 * 
 * MP Timetable Functions
 * Created by CMSMasters
 * 
 */


/* Load Parts */
require_once(get_template_directory() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/admin/plugin-options.php');
require_once(get_template_directory() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/plugin-colors.php');
require_once(get_template_directory() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/function/plugin-fonts.php');


if (CMSMASTERS_CONTENT_COMPOSER && class_exists('Cmsmasters_Content_Composer')) {
	require_once(get_template_directory() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/cmsmasters-c-c/cmsmasters-c-c-plugin-functions.php');
	
	require_once(get_template_directory() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/cmsmasters-c-c/cmsmasters-c-c-plugin-shortcodes.php');
}


/* Register CSS Styles and Scripts */
function islam_house_mp_timetable_register_styles_scripts() {
	wp_dequeue_style('mptt-style');
	
	
	wp_enqueue_style('islam-house-mp-timetable-style', get_template_directory_uri() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/css/plugin-style.css', array(), '1.0.0', 'screen');
	
	wp_enqueue_style('islam-house-mp-timetable-adaptive', get_template_directory_uri() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/css/plugin-adaptive.css', array(), '1.0.0', 'screen');
	
	
	if (is_rtl()) {
		wp_enqueue_style('islam-house-mp-timetable-rtl', get_template_directory_uri() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/css/plugin-rtl.css', array(), '1.0.0', 'screen');
	}
}

add_action('wp_enqueue_scripts', 'islam_house_mp_timetable_register_styles_scripts');


/* Add theme support for MP Timetable */
function islam_house_mp_timetable_support() {
    add_theme_support('mp-timetable');
}

add_action('after_setup_theme', 'islam_house_mp_timetable_support');


/* Remove Shortcode Button from editor */
function islam_house_mp_timetable_mce_buttons_remove($buttons) {
	foreach ($buttons as $key => $val) {
		if ($val == 'addTimeTableButton') {
			unset($buttons[$key]);
		}
	}
	
	
	return $buttons;
}

add_filter('mce_buttons', 'islam_house_mp_timetable_mce_buttons_remove', 2000);

