<?php
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version 	1.0.0
 * 
 * MP Timetable Content Composer Shortcodes
 * Created by CMSMasters
 * 
 */


function islam_house_mp_timetable_shortcodes($shortcodes) {
	$shortcodes[] = 'cmsmasters_mp_timetable';
	
	
	return $shortcodes;
}

add_filter('cmsmasters_custom_shortcodes_filter', 'islam_house_mp_timetable_shortcodes');


/**
 * MP Timetable
 */
function cmsmasters_mp_timetable($atts, $content = null) {
	extract(shortcode_atts(array( 
		'shortcode_id' => 				'', 
		'columns' => 					'', 
		'event' => 						'', 
		'event_category' => 			'', 
		'fields_to_display' => 			'', 
		'row_height' => 				'45',
		'measure' => 					'1', 
		'filter_style' => 				'dropdown_list', 
		'filter_label' => 				'All Events', 
		'hide_all_events_view' => 		'0', 
		'hide_hours_column' => 			'0', 
		'hide_empty' => 				'0', 
		'group_events' => 				'0', 
		'disable_event_url' => 			'0', 
		'text_align' => 				'center', 
		'text_align_vertical' => 		'default', 
		'id' => 						'', 
		'responsive' => 				'1', 
		'classes' => 					'' 
	), $atts));
	
	
	$unique_id = $shortcode_id;
	
	
    $out = '<div id="cmsmasters_mp_timetable_shortcode_' . $unique_id . '" class="cmsmasters_mp_timetable_shortcode' . 
	(($classes != '') ? ' ' . $classes : '') . 
	'">';
	
	
	$out .= do_shortcode('[mp-timetable' . 
		($columns != '' ? ' col="' . $columns . '"' : '') . 
		($event != '' ? ' events="' . $event . '"' : '') . 
		($event_category != '' ? ' event_categ="' . $event_category . '"' : '') . 
		' title="' . (strpos($fields_to_display, 'title') === false ? '0' : '1')  . '"' . 
		' time="' . (strpos($fields_to_display, 'time') === false ? '0' : '1')  . '"' . 
		' sub-title="' . (strpos($fields_to_display, 'sub') === false ? '0' : '1')  . '"' . 
		' description="' . (strpos($fields_to_display, 'description') === false ? '0' : '1')  . '"' . 
		' user="' . (strpos($fields_to_display, 'user') === false ? '0' : '1')  . '"' . 
		' row_height="' . (($row_height != '' && $row_height != '0') ? $row_height : '45') . '"' .
		' font_size=""' .
		' increment="' . $measure . '"' .
		' view="' . $filter_style . '"' . 
		' label="' . $filter_label . '"' . 
		' hide_label="' . $hide_all_events_view . '"' . 
		' hide_hrs="' . $hide_hours_column . '"' . 
		' hide_empty_rows="' . $hide_empty . '"' . 
		' group="' . $group_events . '"' . 
		' disable_event_url="' . $disable_event_url . '"' . 
		' text_align="' . $text_align . '"' . 
		' text_align_vertical="' . $text_align_vertical . '"' . 
		' id="' . $id . '"' . 
		' responsive="' . $responsive . '"' . 
	']');
	
	
	$out .= '</div>';
	
	
	return $out;
}

