<?php
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version 	1.0.0
 * 
 * MP Timetable Content Composer Functions 
 * Created by CMSMasters
 * 
 */


/* Register JS Scripts */
function islam_house_mp_timetable_register_c_c_scripts() {
	global $pagenow;
	
	
	$cmsmasters_option = islam_house_get_global_options();
	
	
	if ( 
		$pagenow == 'post-new.php' || 
		($pagenow == 'post.php' && isset($_GET['post']) && get_post_type($_GET['post']) != 'attachment') 
	) {
		wp_enqueue_script('islam-house-mp-timetable-extend', get_template_directory_uri() . '/mp-timetable/cmsmasters-framework/theme-style' . CMSMASTERS_THEME_STYLE . '/cmsmasters-c-c/js/cmsmasters-c-c-plugin-extend.js', array('cmsmasters_composer_shortcodes_js'), '1.0.0', true);
		
		wp_localize_script('islam-house-mp-timetable-extend', 'cmsmasters_mp_timetable_shortcodes', array(
			'mp_timetable_columns' => 								islam_house_mp_timetable_columns(),
			'mp_timetable_events' => 								islam_house_mp_timetable_events(),
			'mp_timetable_event_categories' => 						islam_house_mp_timetable_event_categories(),
			'mp_timetable_title' =>									esc_html__('Timetable', 'islam-house'),
			'mp_timetable_field_columns_title' =>					esc_html__('Columns (required)', 'islam-house'),
			'mp_timetable_field_columns_descr' =>					esc_html__('Select the columns that are to be displayed in timetable', 'islam-house'),
			'mp_timetable_field_columns_descr_note' =>				esc_html__('Hold the CTRL key to select multiple items', 'islam-house'),
			'mp_timetable_field_event_title' =>						esc_html__('Events', 'islam-house'),
			'mp_timetable_field_event_descr' =>						esc_html__('Select the events that are to be displayed in timetable', 'islam-house'),
			'mp_timetable_field_event_descr_note' =>				esc_html__('Hold the CTRL key to select multiple items', 'islam-house'),
			'mp_timetable_field_event_category_title' =>			esc_html__('Event categories', 'islam-house'),
			'mp_timetable_field_event_category_descr' =>			esc_html__('Select the events categories that are to be displayed in timetable', 'islam-house'),
			'mp_timetable_field_event_category_descr_note' =>		esc_html__('Hold the CTRL key to select multiple items', 'islam-house'),
			'mp_timetable_field_fields_to_display_title' =>			esc_html__('Fields to display', 'islam-house'),
			'mp_timetable_field_fields_to_display_descr' =>			esc_html__('Check the event parameter(s) to be displayed in the timetable.', 'islam-house'),
			'mp_timetable_choice_title' =>							esc_html__('Title', 'islam-house'),
			'mp_timetable_choice_time' =>							esc_html__('Time', 'islam-house'),
			'mp_timetable_choice_subtitle' =>						esc_html__('Subtitle', 'islam-house'),
			'mp_timetable_choice_description' =>					esc_html__('Description', 'islam-house'),
			'mp_timetable_choice_user' =>							esc_html__('User', 'islam-house'),
			'mp_timetable_field_row_height_title' =>				esc_html__('Row height', 'islam-house'),
			'mp_timetable_field_measure_title' =>					esc_html__('Hour measure', 'islam-house'),
			'mp_timetable_field_measure_descr' =>					esc_html__('Choose hour measure for event hours', 'islam-house'),
			'mp_timetable_field_measure_choice_hour' =>				esc_html__('Hour (1h)', 'islam-house'),
			'mp_timetable_field_measure_choice_half_hour' =>		esc_html__('Half hour (30min)', 'islam-house'),
			'mp_timetable_field_measure_choice_quarter_hour' =>		esc_html__('Quarter hour (15min)', 'islam-house'),
			'mp_timetable_field_filter_style_title' =>				esc_html__('Filter style', 'islam-house'),
			'mp_timetable_field_filter_style_descr' =>				esc_html__('Choose between dropdown menu and tabs for event filtering', 'islam-house'),
			'mp_timetable_field_filter_style_choice_dropdown_list' =>	esc_html__('Dropdown list', 'islam-house'),
			'mp_timetable_field_filter_style_choice_tabs' =>		esc_html__('Tabs', 'islam-house'),
			'mp_timetable_field_filter_style_choice_none' =>		esc_html__('None', 'islam-house'),
			'mp_timetable_field_filter_label_title' =>				esc_html__('Filter label', 'islam-house'),
			'mp_timetable_field_filter_label_descr' =>				esc_html__('Specify text label for all events', 'islam-house'),
			'mp_timetable_field_filter_label_def' =>				esc_html__('All Events', 'islam-house'),
			'mp_timetable_field_hide_all_events_view_title' =>		esc_html__('Hide \'All Events\' view', 'islam-house'),
			'mp_timetable_field_hide_hours_column_title' =>			esc_html__('Hide first (hours) column', 'islam-house'),
			'mp_timetable_field_hide_empty_title' =>				esc_html__('Hide empty rows', 'islam-house'),
			'mp_timetable_field_group_events_title' =>				esc_html__('Merge cells with common events', 'islam-house'),
			'mp_timetable_field_disable_event_url_title' =>			esc_html__('Disable event url', 'islam-house'),
			'mp_timetable_field_text_align_title' =>				esc_html__('Text align', 'islam-house'),
			'mp_timetable_field_text_align_descr' =>				esc_html__('Specify text align in timetable event block', 'islam-house'),
			'mp_timetable_field_text_align_vertical_title' =>		esc_html__('Vertical align', 'islam-house'),
			'mp_timetable_choice_default' =>						esc_html__('Default', 'islam-house'),
			'mp_timetable_choice_top' =>							esc_html__('Top', 'islam-house'),
			'mp_timetable_choice_middle' =>							esc_html__('Middle', 'islam-house'),
			'mp_timetable_choice_bottom' =>							esc_html__('Bottom', 'islam-house'),
			'mp_timetable_field_id_title' =>						esc_html__('Id', 'islam-house'),
			'mp_timetable_field_id_descr' =>						esc_html__('Assign a unique identifier to a timetable if you use more than one table on a single page', 'islam-house'),
			'mp_timetable_field_id_descr_note' =>					esc_html__('Otherwise, leave this field blank', 'islam-house'),
			'mp_timetable_field_responsive_title' =>				esc_html__('Mobile behavior', 'islam-house'),
			'mp_timetable_field_responsive_descr' =>				esc_html__('Tick "List" to display events in a list view on mobile devices. Tick "Table" to display events in a table.', 'islam-house'),
			'mp_timetable_choice_list' =>							esc_html__('List', 'islam-house'),
			'mp_timetable_choice_table' =>							esc_html__('Table', 'islam-house')
		));
	}
}

add_action('admin_enqueue_scripts', 'islam_house_mp_timetable_register_c_c_scripts');


/* Columns */
function islam_house_mp_timetable_columns() {
	$mp_timetable_columns = get_posts(array(
		'numberposts' => -1, 
		'post_type' => 'mp-column'
	));
	
	
	$out = array();
	
	
	if (!empty($mp_timetable_columns)) {
		foreach ($mp_timetable_columns as $mp_timetable_column) {
			$out[urldecode($mp_timetable_column->ID)] = esc_html($mp_timetable_column->post_title);
		}
	}
	
	
	return $out;
}


/* Events */
function islam_house_mp_timetable_events() {
	$mp_timetable_events = get_posts(array(
		'numberposts' => -1, 
		'post_type' => 'mp-event'
	));
	
	
	$out = array();
	
	
	if (!empty($mp_timetable_events)) {
		foreach ($mp_timetable_events as $mp_timetable_event) {
			$out[urldecode($mp_timetable_event->ID)] = esc_html($mp_timetable_event->post_title);
		}
	}
	
	
	return $out;
}


/* Event Categories */
function islam_house_mp_timetable_event_categories() {
	$categories = get_terms('mp-event_category', array( 
		'hide_empty' => 0 
	));
	
	
	$out = array();
	
	
	if (!empty($categories)) {
		foreach ($categories as $category) {
			$out[urldecode(esc_attr($category->term_id))] = esc_html($category->name);
		}
	}
	
	
	return $out;
}

