<?php 
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version 	1.0.0
 * 
 * Admin Panel General Options
 * Created by CMSMasters
 * 
 */


function islam_house_options_general_tabs() {
	$cmsmasters_option = islam_house_get_global_options();
	
	$tabs = array();
	
	$tabs['general'] = esc_attr__('General', 'islam-house');
	
	if ($cmsmasters_option['islam-house' . '_theme_layout'] === 'boxed') {
		$tabs['bg'] = esc_attr__('Background', 'islam-house');
	}
	
	if (CMSMASTERS_THEME_STYLE_COMPATIBILITY) {
		$tabs['theme_style'] = esc_attr__('Theme Style', 'islam-house');
	}
	
	$tabs['header'] = esc_attr__('Header', 'islam-house');
	$tabs['content'] = esc_attr__('Content', 'islam-house');
	$tabs['footer'] = esc_attr__('Footer', 'islam-house');
	
	return apply_filters('cmsmasters_options_general_tabs_filter', $tabs);
}


function islam_house_options_general_sections() {
	$tab = islam_house_get_the_tab();
	
	switch ($tab) {
	case 'general':
		$sections = array();
		
		$sections['general_section'] = esc_attr__('General Options', 'islam-house');
		
		break;
	case 'bg':
		$sections = array();
		
		$sections['bg_section'] = esc_attr__('Background Options', 'islam-house');
		
		break;
	case 'theme_style':
		$sections = array();
		
		$sections['theme_style_section'] = esc_attr__('Theme Design Style', 'islam-house');
		
		break;
	case 'header':
		$sections = array();
		
		$sections['header_section'] = esc_attr__('Header Options', 'islam-house');
		
		break;
	case 'content':
		$sections = array();
		
		$sections['content_section'] = esc_attr__('Content Options', 'islam-house');
		
		break;
	case 'footer':
		$sections = array();
		
		$sections['footer_section'] = esc_attr__('Footer Options', 'islam-house');
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_general_sections_filter', $sections, $tab);
} 


function islam_house_options_general_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = islam_house_get_the_tab();
	}
	
	$options = array();
	
	
	$defaults = islam_house_settings_general_defaults();
	
	
	switch ($tab) {
	case 'general':
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_theme_layout', 
			'title' => esc_html__('Theme Layout', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_theme_layout'], 
			'choices' => array( 
				esc_html__('Liquid', 'islam-house') . '|liquid', 
				esc_html__('Boxed', 'islam-house') . '|boxed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_logo_type', 
			'title' => esc_html__('Logo Type', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_logo_type'], 
			'choices' => array( 
				esc_html__('Image', 'islam-house') . '|image', 
				esc_html__('Text', 'islam-house') . '|text' 
			) 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_logo_url', 
			'title' => esc_html__('Logo Image', 'islam-house'), 
			'desc' => esc_html__('Choose your website logo image.', 'islam-house'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['islam-house' . '_logo_url'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_logo_url_retina', 
			'title' => esc_html__('Retina Logo Image', 'islam-house'), 
			'desc' => esc_html__('Choose logo image for retina displays. Logo for Retina displays should be twice the size of the default one.', 'islam-house'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['islam-house' . '_logo_url_retina'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_logo_title', 
			'title' => esc_html__('Logo Title', 'islam-house'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['islam-house' . '_logo_title'], 
			'class' => 'nohtml' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_logo_subtitle', 
			'title' => esc_html__('Logo Subtitle', 'islam-house'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['islam-house' . '_logo_subtitle'], 
			'class' => 'nohtml' 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_logo_custom_color', 
			'title' => esc_html__('Custom Text Colors', 'islam-house'), 
			'desc' => esc_html__('enable', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_logo_custom_color'] 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_logo_title_color', 
			'title' => esc_html__('Logo Title Color', 'islam-house'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['islam-house' . '_logo_title_color'] 
		);
		
		$options[] = array( 
			'section' => 'general_section', 
			'id' => 'islam-house' . '_logo_subtitle_color', 
			'title' => esc_html__('Logo Subtitle Color', 'islam-house'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['islam-house' . '_logo_subtitle_color'] 
		);
		
		break;
	case 'bg':
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'islam-house' . '_bg_col', 
			'title' => esc_html__('Background Color', 'islam-house'), 
			'desc' => '', 
			'type' => 'color', 
			'std' => $defaults[$tab]['islam-house' . '_bg_col'] 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'islam-house' . '_bg_img_enable', 
			'title' => esc_html__('Background Image Visibility', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_bg_img_enable'] 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'islam-house' . '_bg_img', 
			'title' => esc_html__('Background Image', 'islam-house'), 
			'desc' => esc_html__('Choose your custom website background image url.', 'islam-house'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['islam-house' . '_bg_img'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'islam-house' . '_bg_rep', 
			'title' => esc_html__('Background Repeat', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_bg_rep'], 
			'choices' => array( 
				esc_html__('No Repeat', 'islam-house') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'islam-house') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'islam-house') . '|repeat-y', 
				esc_html__('Repeat', 'islam-house') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'islam-house' . '_bg_pos', 
			'title' => esc_html__('Background Position', 'islam-house'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['islam-house' . '_bg_pos'], 
			'choices' => array( 
				esc_html__('Top Left', 'islam-house') . '|top left', 
				esc_html__('Top Center', 'islam-house') . '|top center', 
				esc_html__('Top Right', 'islam-house') . '|top right', 
				esc_html__('Center Left', 'islam-house') . '|center left', 
				esc_html__('Center Center', 'islam-house') . '|center center', 
				esc_html__('Center Right', 'islam-house') . '|center right', 
				esc_html__('Bottom Left', 'islam-house') . '|bottom left', 
				esc_html__('Bottom Center', 'islam-house') . '|bottom center', 
				esc_html__('Bottom Right', 'islam-house') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'islam-house' . '_bg_att', 
			'title' => esc_html__('Background Attachment', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_bg_att'], 
			'choices' => array( 
				esc_html__('Scroll', 'islam-house') . '|scroll', 
				esc_html__('Fixed', 'islam-house') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'bg_section', 
			'id' => 'islam-house' . '_bg_size', 
			'title' => esc_html__('Background Size', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'islam-house') . '|auto', 
				esc_html__('Cover', 'islam-house') . '|cover', 
				esc_html__('Contain', 'islam-house') . '|contain' 
			) 
		);
		
		break;
	case 'theme_style':
		$options[] = array( 
			'section' => 'theme_style_section', 
			'id' => 'islam-house' . '_theme_style', 
			'title' => esc_html__('Choose Theme Style', 'islam-house'), 
			'desc' => '', 
			'type' => 'select_theme_style', 
			'std' => '', 
			'choices' => islam_house_all_theme_styles() 
		);
		
		break;
	case 'header':
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_fixed_header', 
			'title' => esc_html__('Fixed Header', 'islam-house'), 
			'desc' => esc_html__('enable', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_fixed_header'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_overlaps', 
			'title' => esc_html__('Header Overlaps Content by Default', 'islam-house'), 
			'desc' => esc_html__('enable', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_header_overlaps'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_top_line', 
			'title' => esc_html__('Top Line', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_header_top_line'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_top_height', 
			'title' => esc_html__('Top Height', 'islam-house'), 
			'desc' => esc_html__('pixels', 'islam-house'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['islam-house' . '_header_top_height'], 
			'min' => '10' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_top_line_short_info', 
			'title' => esc_html__('Top Short Info', 'islam-house'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'islam-house') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['islam-house' . '_header_top_line_short_info'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_top_line_add_cont', 
			'title' => esc_html__('Top Additional Content', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_header_top_line_add_cont'], 
			'choices' => array( 
				esc_html__('None', 'islam-house') . '|none', 
				esc_html__('Top Line Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'islam-house') . '|social', 
				esc_html__('Top Line Navigation (will be shown if set in Appearance - Menus tab)', 'islam-house') . '|nav' 
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_styles', 
			'title' => esc_html__('Header Styles', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_header_styles'], 
			'choices' => array( 
				esc_html__('Default Style', 'islam-house') . '|default', 
				esc_html__('Compact Style Left Navigation', 'islam-house') . '|l_nav', 
				esc_html__('Compact Style Right Navigation', 'islam-house') . '|r_nav', 
				esc_html__('Compact Style Center Navigation', 'islam-house') . '|c_nav'
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_mid_height', 
			'title' => esc_html__('Header Middle Height', 'islam-house'), 
			'desc' => esc_html__('pixels', 'islam-house'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['islam-house' . '_header_mid_height'], 
			'min' => '40' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_bot_height', 
			'title' => esc_html__('Header Bottom Height', 'islam-house'), 
			'desc' => esc_html__('pixels', 'islam-house'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['islam-house' . '_header_bot_height'], 
			'min' => '20' 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_search', 
			'title' => esc_html__('Header Search', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_header_search'] 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_add_cont', 
			'title' => esc_html__('Header Additional Content', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_header_add_cont'], 
			'choices' => array( 
				esc_html__('None', 'islam-house') . '|none', 
				esc_html__('Header Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'islam-house') . '|social', 
				esc_html__('Header Custom HTML', 'islam-house') . '|cust_html' 
			) 
		);
		
		$options[] = array( 
			'section' => 'header_section', 
			'id' => 'islam-house' . '_header_add_cont_cust_html', 
			'title' => esc_html__('Header Custom HTML', 'islam-house'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'islam-house') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['islam-house' . '_header_add_cont_cust_html'], 
			'class' => '' 
		);
		
		break;
	case 'content':
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_layout', 
			'title' => esc_html__('Layout Type by Default', 'islam-house'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'islam-house'), 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['islam-house' . '_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_archives_layout', 
			'title' => esc_html__('Archives Layout Type', 'islam-house'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Archive Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'islam-house'), 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['islam-house' . '_archives_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_search_layout', 
			'title' => esc_html__('Search Layout Type', 'islam-house'), 
			'desc' => esc_html__('Choosing layout with a sidebar please make sure to add widgets to the Search Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'islam-house'), 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['islam-house' . '_search_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_other_layout', 
			'title' => esc_html__('Other Layout Type', 'islam-house'), 
			'desc' => esc_html__('Layout for pages of non-listed types. Choosing layout with a sidebar please make sure to add widgets to the Sidebar in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'islam-house'), 
			'type' => 'radio_img', 
			'std' => $defaults[$tab]['islam-house' . '_other_layout'], 
			'choices' => array( 
				esc_html__('Right Sidebar', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_r.jpg' . '|r_sidebar', 
				esc_html__('Left Sidebar', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/sidebar_l.jpg' . '|l_sidebar', 
				esc_html__('Full Width', 'islam-house') . '|' . get_template_directory_uri() . '/framework/admin/inc/img/fullwidth.jpg' . '|fullwidth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_alignment', 
			'title' => esc_html__('Heading Alignment by Default', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_heading_alignment'], 
			'choices' => array( 
				esc_html__('Left', 'islam-house') . '|left', 
				esc_html__('Right', 'islam-house') . '|right', 
				esc_html__('Center', 'islam-house') . '|center' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_scheme', 
			'title' => esc_html__('Heading Color Scheme by Default', 'islam-house'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['islam-house' . '_heading_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_bg_image_enable', 
			'title' => esc_html__('Heading Background Image Visibility by Default', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_heading_bg_image_enable'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_bg_image', 
			'title' => esc_html__('Heading Background Image by Default', 'islam-house'), 
			'desc' => esc_html__('Choose your custom heading background image by default.', 'islam-house'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['islam-house' . '_heading_bg_image'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_bg_repeat', 
			'title' => esc_html__('Heading Background Repeat by Default', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_heading_bg_repeat'], 
			'choices' => array( 
				esc_html__('No Repeat', 'islam-house') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'islam-house') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'islam-house') . '|repeat-y', 
				esc_html__('Repeat', 'islam-house') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_bg_attachment', 
			'title' => esc_html__('Heading Background Attachment by Default', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_heading_bg_attachment'], 
			'choices' => array( 
				esc_html__('Scroll', 'islam-house') . '|scroll', 
				esc_html__('Fixed', 'islam-house') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_bg_size', 
			'title' => esc_html__('Heading Background Size by Default', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_heading_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'islam-house') . '|auto', 
				esc_html__('Cover', 'islam-house') . '|cover', 
				esc_html__('Contain', 'islam-house') . '|contain' 
			) 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_bg_color', 
			'title' => esc_html__('Heading Background Color Overlay by Default', 'islam-house'), 
			'desc' => '',  
			'type' => 'rgba', 
			'std' => $defaults[$tab]['islam-house' . '_heading_bg_color'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_heading_height', 
			'title' => esc_html__('Heading Height by Default', 'islam-house'), 
			'desc' => esc_html__('pixels', 'islam-house'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['islam-house' . '_heading_height'], 
			'min' => '0' 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_breadcrumbs', 
			'title' => esc_html__('Breadcrumbs Visibility by Default', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_breadcrumbs'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_bottom_scheme', 
			'title' => esc_html__('Bottom Color Scheme', 'islam-house'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['islam-house' . '_bottom_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_bottom_sidebar', 
			'title' => esc_html__('Bottom Sidebar Visibility by Default', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house') . '<br><br>' . esc_html__('Please make sure to add widgets in the Appearance - Widgets tab. The empty sidebar won\'t be displayed.', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_bottom_sidebar'] 
		);
		
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_bottom_sidebar_layout', 
			'title' => esc_html__('Bottom Sidebar Layout by Default', 'islam-house'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['islam-house' . '_bottom_sidebar_layout'], 
			'choices' => array( 
				'1/1|11', 
				'1/2 + 1/2|1212', 
				'1/3 + 2/3|1323', 
				'2/3 + 1/3|2313', 
				'1/4 + 3/4|1434', 
				'3/4 + 1/4|3414', 
				'1/3 + 1/3 + 1/3|131313', 
				'1/2 + 1/4 + 1/4|121414', 
				'1/4 + 1/2 + 1/4|141214', 
				'1/4 + 1/4 + 1/2|141412', 
				'1/4 + 1/4 + 1/4 + 1/4|14141414' 
			) 
		);
		
		break;
	case 'footer':
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_scheme', 
			'title' => esc_html__('Footer Color Scheme', 'islam-house'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['islam-house' . '_footer_scheme'], 
			'choices' => cmsmasters_color_schemes_list() 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_type', 
			'title' => esc_html__('Footer Type', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_footer_type'], 
			'choices' => array( 
				esc_html__('Default', 'islam-house') . '|default', 
				esc_html__('Small', 'islam-house') . '|small' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_additional_content', 
			'title' => esc_html__('Footer Additional Content', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_footer_additional_content'], 
			'choices' => array( 
				esc_html__('None', 'islam-house') . '|none', 
				esc_html__('Footer Navigation (will be shown if set in Appearance - Menus tab)', 'islam-house') . '|nav', 
				esc_html__('Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'islam-house') . '|social', 
				esc_html__('Custom HTML', 'islam-house') . '|text' 
			) 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_logo', 
			'title' => esc_html__('Footer Logo', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_footer_logo'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_logo_url', 
			'title' => esc_html__('Footer Logo', 'islam-house'), 
			'desc' => esc_html__('Choose your website footer logo image.', 'islam-house'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['islam-house' . '_footer_logo_url'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_logo_url_retina', 
			'title' => esc_html__('Footer Logo for Retina', 'islam-house'), 
			'desc' => esc_html__('Choose your website footer logo image for retina.', 'islam-house'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['islam-house' . '_footer_logo_url_retina'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_nav', 
			'title' => esc_html__('Footer Navigation', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_footer_nav'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_social', 
			'title' => esc_html__('Footer Social Icons (will be shown if Cmsmasters Content Composer plugin is active)', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_footer_social'] 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_html', 
			'title' => esc_html__('Footer Custom HTML', 'islam-house'), 
			'desc' => '<strong>' . esc_html__('HTML tags are allowed!', 'islam-house') . '</strong>', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['islam-house' . '_footer_html'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'footer_section', 
			'id' => 'islam-house' . '_footer_copyright', 
			'title' => esc_html__('Copyright Text', 'islam-house'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['islam-house' . '_footer_copyright'], 
			'class' => '' 
		);
		
		break;
	}
	
	return apply_filters('cmsmasters_options_general_fields_filter', $options, $tab);
}

