<?php 
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version		1.0.0
 * 
 * Admin Panel Fonts Options
 * Created by CMSMasters
 * 
 */


function islam_house_options_font_tabs() {
	$tabs = array();
	
	$tabs['content'] = esc_attr__('Content', 'islam-house');
	$tabs['link'] = esc_attr__('Links', 'islam-house');
	$tabs['nav'] = esc_attr__('Navigation', 'islam-house');
	$tabs['heading'] = esc_attr__('Heading', 'islam-house');
	$tabs['other'] = esc_attr__('Other', 'islam-house');
	$tabs['google'] = esc_attr__('Google Fonts', 'islam-house');
	
	return apply_filters('cmsmasters_options_font_tabs_filter', $tabs);
}


function islam_house_options_font_sections() {
	$tab = islam_house_get_the_tab();
	
	switch ($tab) {
	case 'content':
		$sections = array();
		
		$sections['content_section'] = esc_html__('Content Font Options', 'islam-house');
		
		break;
	case 'link':
		$sections = array();
		
		$sections['link_section'] = esc_html__('Links Font Options', 'islam-house');
		
		break;
	case 'nav':
		$sections = array();
		
		$sections['nav_section'] = esc_html__('Navigation Font Options', 'islam-house');
		
		break;
	case 'heading':
		$sections = array();
		
		$sections['heading_section'] = esc_html__('Headings Font Options', 'islam-house');
		
		break;
	case 'other':
		$sections = array();
		
		$sections['other_section'] = esc_html__('Other Fonts Options', 'islam-house');
		
		break;
	case 'google':
		$sections = array();
		
		$sections['google_section'] = esc_html__('Serving Google Fonts from CDN', 'islam-house');
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_font_sections_filter', $sections, $tab);
} 


function islam_house_options_font_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = islam_house_get_the_tab();
	}
	
	
	$options = array();
	
	
	$defaults = islam_house_settings_font_defaults();
	
	
	switch ($tab) {
	case 'content':
		$options[] = array( 
			'section' => 'content_section', 
			'id' => 'islam-house' . '_content_font', 
			'title' => esc_html__('Main Content Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_content_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		break;
	case 'link':
		$options[] = array( 
			'section' => 'link_section', 
			'id' => 'islam-house' . '_link_font', 
			'title' => esc_html__('Links Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_link_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'link_section', 
			'id' => 'islam-house' . '_link_hover_decoration', 
			'title' => esc_html__('Links Hover Text Decoration', 'islam-house'), 
			'desc' => '', 
			'type' => 'select_scheme', 
			'std' => $defaults[$tab]['islam-house' . '_link_hover_decoration'], 
			'choices' => islam_house_text_decoration_list() 
		);
		
		break;
	case 'nav':
		$options[] = array( 
			'section' => 'nav_section', 
			'id' => 'islam-house' . '_nav_title_font', 
			'title' => esc_html__('Navigation Title Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_nav_title_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'nav_section', 
			'id' => 'islam-house' . '_nav_dropdown_font', 
			'title' => esc_html__('Navigation Dropdown Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_nav_dropdown_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		break;
	case 'heading':
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'islam-house' . '_h1_font', 
			'title' => esc_html__('H1 Tag Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_h1_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'islam-house' . '_h2_font', 
			'title' => esc_html__('H2 Tag Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_h2_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'islam-house' . '_h3_font', 
			'title' => esc_html__('H3 Tag Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_h3_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'islam-house' . '_h4_font', 
			'title' => esc_html__('H4 Tag Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_h4_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'islam-house' . '_h5_font', 
			'title' => esc_html__('H5 Tag Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_h5_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		$options[] = array( 
			'section' => 'heading_section', 
			'id' => 'islam-house' . '_h6_font', 
			'title' => esc_html__('H6 Tag Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_h6_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform', 
				'text_decoration' 
			) 
		);
		
		break;
	case 'other':
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'islam-house' . '_button_font', 
			'title' => esc_html__('Button Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_button_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'islam-house' . '_small_font', 
			'title' => esc_html__('Small Tag Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_small_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style', 
				'text_transform' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'islam-house' . '_input_font', 
			'title' => esc_html__('Text Fields Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_input_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		$options[] = array( 
			'section' => 'other_section', 
			'id' => 'islam-house' . '_quote_font', 
			'title' => esc_html__('Blockquote Font', 'islam-house'), 
			'desc' => '', 
			'type' => 'typorgaphy', 
			'std' => $defaults[$tab]['islam-house' . '_quote_font'], 
			'choices' => array( 
				'system_font', 
				'google_font', 
				'font_size', 
				'line_height', 
				'font_weight', 
				'font_style' 
			) 
		);
		
		break;
	case 'google':
		$options[] = array( 
			'section' => 'google_section', 
			'id' => 'islam-house' . '_google_web_fonts', 
			'title' => esc_html__('Google Fonts', 'islam-house'), 
			'desc' => '', 
			'type' => 'google_web_fonts', 
			'std' => $defaults[$tab]['islam-house' . '_google_web_fonts'] 
		);
		
		$options[] = array( 
			'section' => 'google_section', 
			'id' => 'islam-house' . '_google_web_fonts_subset', 
			'title' => esc_html__('Google Fonts Subset', 'islam-house'), 
			'desc' => '', 
			'type' => 'select_multiple', 
			'std' => '', 
			'choices' => array( 
				esc_html__('Latin Extended', 'islam-house') . '|' . 'latin-ext', 
				esc_html__('Arabic', 'islam-house') . '|' . 'arabic', 
				esc_html__('Cyrillic', 'islam-house') . '|' . 'cyrillic', 
				esc_html__('Cyrillic Extended', 'islam-house') . '|' . 'cyrillic-ext', 
				esc_html__('Greek', 'islam-house') . '|' . 'greek', 
				esc_html__('Greek Extended', 'islam-house') . '|' . 'greek-ext', 
				esc_html__('Vietnamese', 'islam-house') . '|' . 'vietnamese', 
				esc_html__('Japanese', 'islam-house') . '|' . 'japanese', 
				esc_html__('Korean', 'islam-house') . '|' . 'korean', 
				esc_html__('Thai', 'islam-house') . '|' . 'thai', 
				esc_html__('Bengali', 'islam-house') . '|' . 'bengali', 
				esc_html__('Devanagari', 'islam-house') . '|' . 'devanagari', 
				esc_html__('Gujarati', 'islam-house') . '|' . 'gujarati', 
				esc_html__('Gurmukhi', 'islam-house') . '|' . 'gurmukhi', 
				esc_html__('Hebrew', 'islam-house') . '|' . 'hebrew', 
				esc_html__('Kannada', 'islam-house') . '|' . 'kannada', 
				esc_html__('Khmer', 'islam-house') . '|' . 'khmer', 
				esc_html__('Malayalam', 'islam-house') . '|' . 'malayalam', 
				esc_html__('Myanmar', 'islam-house') . '|' . 'myanmar', 
				esc_html__('Oriya', 'islam-house') . '|' . 'oriya', 
				esc_html__('Sinhala', 'islam-house') . '|' . 'sinhala', 
				esc_html__('Tamil', 'islam-house') . '|' . 'tamil', 
				esc_html__('Telugu', 'islam-house') . '|' . 'telugu' 
			) 
		);
		
		break;
	}
	
	return apply_filters('cmsmasters_options_font_fields_filter', $options, $tab);	
}

