<?php 
/**
 * @package 	WordPress
 * @subpackage 	Islam House
 * @version 	1.0.9
 * 
 * Admin Panel Element Options
 * Created by CMSMasters
 * 
 */


function islam_house_options_element_tabs() {
	$tabs = array();
	
	$tabs['sidebar'] = esc_attr__('Sidebars', 'islam-house');
	
	if (class_exists('Cmsmasters_Content_Composer')) {
		$tabs['icon'] = esc_attr__('Social Icons', 'islam-house');
	}
	
	$tabs['lightbox'] = esc_attr__('Lightbox', 'islam-house');
	$tabs['sitemap'] = esc_attr__('Sitemap', 'islam-house');
	$tabs['error'] = esc_attr__('404', 'islam-house');
	$tabs['code'] = esc_attr__('Custom Codes', 'islam-house');
	
	if (class_exists('Cmsmasters_Form_Builder')) {
		$tabs['recaptcha'] = esc_attr__('reCAPTCHA', 'islam-house');
	}
	
	return apply_filters('cmsmasters_options_element_tabs_filter', $tabs);
}


function islam_house_options_element_sections() {
	$tab = islam_house_get_the_tab();
	
	switch ($tab) {
	case 'sidebar':
		$sections = array();
		
		$sections['sidebar_section'] = esc_attr__('Custom Sidebars', 'islam-house');
		
		break;
	case 'icon':
		$sections = array();
		
		$sections['icon_section'] = esc_attr__('Social Icons', 'islam-house');
		
		break;
	case 'lightbox':
		$sections = array();
		
		$sections['lightbox_section'] = esc_attr__('Theme Lightbox Options', 'islam-house');
		
		break;
	case 'sitemap':
		$sections = array();
		
		$sections['sitemap_section'] = esc_attr__('Sitemap Page Options', 'islam-house');
		
		break;
	case 'error':
		$sections = array();
		
		$sections['error_section'] = esc_attr__('404 Error Page Options', 'islam-house');
		
		break;
	case 'code':
		$sections = array();
		
		$sections['code_section'] = esc_attr__('Custom Codes', 'islam-house');
		
		break;
	case 'recaptcha':
		$sections = array();
		
		$sections['recaptcha_section'] = esc_attr__('Form Builder Plugin reCAPTCHA Keys', 'islam-house');
		
		break;
	default:
		$sections = array();
		
		
		break;
	}
	
	return apply_filters('cmsmasters_options_element_sections_filter', $sections, $tab);	
} 


function islam_house_options_element_fields($set_tab = false) {
	if ($set_tab) {
		$tab = $set_tab;
	} else {
		$tab = islam_house_get_the_tab();
	}
	
	
	$options = array();
	
	
	$defaults = islam_house_settings_element_defaults();
	
	
	switch ($tab) {
	case 'sidebar':
		$options[] = array( 
			'section' => 'sidebar_section', 
			'id' => 'islam-house' . '_sidebar', 
			'title' => esc_html__('Custom Sidebars', 'islam-house'), 
			'desc' => '', 
			'type' => 'sidebar', 
			'std' => $defaults[$tab]['islam-house' . '_sidebar'] 
		);
		
		break;
	case 'icon':
		$options[] = array( 
			'section' => 'icon_section', 
			'id' => 'islam-house' . '_social_icons', 
			'title' => esc_html__('Social Icons', 'islam-house'), 
			'desc' => '', 
			'type' => 'social', 
			'std' => $defaults[$tab]['islam-house' . '_social_icons'] 
		);
		
		break;
	case 'lightbox':
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_skin', 
			'title' => esc_html__('Skin', 'islam-house'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_skin'], 
			'choices' => array( 
				esc_html__('Dark', 'islam-house') . '|dark', 
				esc_html__('Light', 'islam-house') . '|light', 
				esc_html__('Mac', 'islam-house') . '|mac', 
				esc_html__('Metro Black', 'islam-house') . '|metro-black', 
				esc_html__('Metro White', 'islam-house') . '|metro-white', 
				esc_html__('Parade', 'islam-house') . '|parade', 
				esc_html__('Smooth', 'islam-house') . '|smooth' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_path', 
			'title' => esc_html__('Path', 'islam-house'), 
			'desc' => esc_html__('Sets path for switching windows', 'islam-house'), 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_path'], 
			'choices' => array( 
				esc_html__('Vertical', 'islam-house') . '|vertical', 
				esc_html__('Horizontal', 'islam-house') . '|horizontal' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_infinite', 
			'title' => esc_html__('Infinite', 'islam-house'), 
			'desc' => esc_html__('Sets the ability to infinite the group', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_infinite'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_aspect_ratio', 
			'title' => esc_html__('Keep Aspect Ratio', 'islam-house'), 
			'desc' => esc_html__('Sets the resizing method used to keep aspect ratio within the viewport', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_aspect_ratio'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_mobile_optimizer', 
			'title' => esc_html__('Mobile Optimizer', 'islam-house'), 
			'desc' => esc_html__('Make lightboxes optimized for giving better experience with mobile devices', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_mobile_optimizer'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_max_scale', 
			'title' => esc_html__('Max Scale', 'islam-house'), 
			'desc' => esc_html__('Sets the maximum viewport scale of the content', 'islam-house'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_max_scale'], 
			'min' => 0.1, 
			'max' => 2, 
			'step' => 0.05 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_min_scale', 
			'title' => esc_html__('Min Scale', 'islam-house'), 
			'desc' => esc_html__('Sets the minimum viewport scale of the content', 'islam-house'), 
			'type' => 'number', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_min_scale'], 
			'min' => 0.1, 
			'max' => 2, 
			'step' => 0.05 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_inner_toolbar', 
			'title' => esc_html__('Inner Toolbar', 'islam-house'), 
			'desc' => esc_html__('Bring buttons into windows, or let them be over the overlay', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_inner_toolbar'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_smart_recognition', 
			'title' => esc_html__('Smart Recognition', 'islam-house'), 
			'desc' => esc_html__('Sets content auto recognize from web pages', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_smart_recognition'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_fullscreen_one_slide', 
			'title' => esc_html__('Fullscreen One Slide', 'islam-house'), 
			'desc' => esc_html__('Decide to fullscreen only one slide or hole gallery the fullscreen mode', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_fullscreen_one_slide'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_fullscreen_viewport', 
			'title' => esc_html__('Fullscreen Viewport', 'islam-house'), 
			'desc' => esc_html__('Sets the resizing method used to fit content within the fullscreen mode', 'islam-house'), 
			'type' => 'select', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_fullscreen_viewport'], 
			'choices' => array( 
				esc_html__('Center', 'islam-house') . '|center', 
				esc_html__('Fit', 'islam-house') . '|fit', 
				esc_html__('Fill', 'islam-house') . '|fill', 
				esc_html__('Stretch', 'islam-house') . '|stretch' 
			) 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_controls_toolbar', 
			'title' => esc_html__('Toolbar Controls', 'islam-house'), 
			'desc' => esc_html__('Sets buttons be available or not', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_controls_toolbar'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_controls_arrows', 
			'title' => esc_html__('Arrow Controls', 'islam-house'), 
			'desc' => esc_html__('Enable the arrow buttons', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_controls_arrows'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_controls_fullscreen', 
			'title' => esc_html__('Fullscreen Controls', 'islam-house'), 
			'desc' => esc_html__('Sets the fullscreen button', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_controls_fullscreen'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_controls_thumbnail', 
			'title' => esc_html__('Thumbnails Controls', 'islam-house'), 
			'desc' => esc_html__('Sets the thumbnail navigation', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_controls_thumbnail'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_controls_keyboard', 
			'title' => esc_html__('Keyboard Controls', 'islam-house'), 
			'desc' => esc_html__('Sets the keyboard navigation', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_controls_keyboard'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_controls_mousewheel', 
			'title' => esc_html__('Mouse Wheel Controls', 'islam-house'), 
			'desc' => esc_html__('Sets the mousewheel navigation', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_controls_mousewheel'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_controls_swipe', 
			'title' => esc_html__('Swipe Controls', 'islam-house'), 
			'desc' => esc_html__('Sets the swipe navigation', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_controls_swipe'] 
		);
		
		$options[] = array( 
			'section' => 'lightbox_section', 
			'id' => 'islam-house' . '_ilightbox_controls_slideshow', 
			'title' => esc_html__('Slideshow Controls', 'islam-house'), 
			'desc' => esc_html__('Enable the slideshow feature and button', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_ilightbox_controls_slideshow'] 
		);
		
		break;
	case 'sitemap':
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'islam-house' . '_sitemap_nav', 
			'title' => esc_html__('Website Pages', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_sitemap_nav'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'islam-house' . '_sitemap_categs', 
			'title' => esc_html__('Blog Archives by Categories', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_sitemap_categs'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'islam-house' . '_sitemap_tags', 
			'title' => esc_html__('Blog Archives by Tags', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_sitemap_tags'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'islam-house' . '_sitemap_month', 
			'title' => esc_html__('Blog Archives by Month', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_sitemap_month'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'islam-house' . '_sitemap_pj_categs', 
			'title' => esc_html__('Portfolio Archives by Categories', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_sitemap_pj_categs'] 
		);
		
		$options[] = array( 
			'section' => 'sitemap_section', 
			'id' => 'islam-house' . '_sitemap_pj_tags', 
			'title' => esc_html__('Portfolio Archives by Tags', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_sitemap_pj_tags'] 
		);
		
		break;
	case 'error':
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_color', 
			'title' => esc_html__('Text Color', 'islam-house'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['islam-house' . '_error_color'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_bg_color', 
			'title' => esc_html__('Background Color', 'islam-house'), 
			'desc' => '', 
			'type' => 'rgba', 
			'std' => $defaults[$tab]['islam-house' . '_error_bg_color'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_bg_img_enable', 
			'title' => esc_html__('Background Image Visibility', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_error_bg_img_enable'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_bg_image', 
			'title' => esc_html__('Background Image', 'islam-house'), 
			'desc' => esc_html__('Choose your custom error page background image.', 'islam-house'), 
			'type' => 'upload', 
			'std' => $defaults[$tab]['islam-house' . '_error_bg_image'], 
			'frame' => 'select', 
			'multiple' => false 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_bg_rep', 
			'title' => esc_html__('Background Repeat', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_error_bg_rep'], 
			'choices' => array( 
				esc_html__('No Repeat', 'islam-house') . '|no-repeat', 
				esc_html__('Repeat Horizontally', 'islam-house') . '|repeat-x', 
				esc_html__('Repeat Vertically', 'islam-house') . '|repeat-y', 
				esc_html__('Repeat', 'islam-house') . '|repeat' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_bg_pos', 
			'title' => esc_html__('Background Position', 'islam-house'), 
			'desc' => '', 
			'type' => 'select', 
			'std' => $defaults[$tab]['islam-house' . '_error_bg_pos'], 
			'choices' => array( 
				esc_html__('Top Left', 'islam-house') . '|top left', 
				esc_html__('Top Center', 'islam-house') . '|top center', 
				esc_html__('Top Right', 'islam-house') . '|top right', 
				esc_html__('Center Left', 'islam-house') . '|center left', 
				esc_html__('Center Center', 'islam-house') . '|center center', 
				esc_html__('Center Right', 'islam-house') . '|center right', 
				esc_html__('Bottom Left', 'islam-house') . '|bottom left', 
				esc_html__('Bottom Center', 'islam-house') . '|bottom center', 
				esc_html__('Bottom Right', 'islam-house') . '|bottom right' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_bg_att', 
			'title' => esc_html__('Background Attachment', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_error_bg_att'], 
			'choices' => array( 
				esc_html__('Scroll', 'islam-house') . '|scroll', 
				esc_html__('Fixed', 'islam-house') . '|fixed' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_bg_size', 
			'title' => esc_html__('Background Size', 'islam-house'), 
			'desc' => '', 
			'type' => 'radio', 
			'std' => $defaults[$tab]['islam-house' . '_error_bg_size'], 
			'choices' => array( 
				esc_html__('Auto', 'islam-house') . '|auto', 
				esc_html__('Cover', 'islam-house') . '|cover', 
				esc_html__('Contain', 'islam-house') . '|contain' 
			) 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_search', 
			'title' => esc_html__('Search Line', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_error_search'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_sitemap_button', 
			'title' => esc_html__('Sitemap Button', 'islam-house'), 
			'desc' => esc_html__('show', 'islam-house'), 
			'type' => 'checkbox', 
			'std' => $defaults[$tab]['islam-house' . '_error_sitemap_button'] 
		);
		
		$options[] = array( 
			'section' => 'error_section', 
			'id' => 'islam-house' . '_error_sitemap_link', 
			'title' => esc_html__('Sitemap Page URL', 'islam-house'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['islam-house' . '_error_sitemap_link'], 
			'class' => '' 
		);
		
		break;
	case 'code':
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'islam-house' . '_custom_css', 
			'title' => esc_html__('Custom CSS', 'islam-house'), 
			'desc' => '', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['islam-house' . '_custom_css'], 
			'class' => 'allowlinebreaks' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'islam-house' . '_custom_js', 
			'title' => esc_html__('Custom JavaScript', 'islam-house'), 
			'desc' => '', 
			'type' => 'textarea', 
			'std' => $defaults[$tab]['islam-house' . '_custom_js'], 
			'class' => 'allowlinebreaks' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'islam-house' . '_gmap_api_key', 
			'title' => esc_html__('Google Maps API key', 'islam-house'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['islam-house' . '_gmap_api_key'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'code_section', 
			'id' => 'islam-house' . '_twitter_access_token', 
			'title' => esc_html__('Twitter Access Token', 'islam-house'), 
			'desc' => sprintf(
				/* translators: Twitter access token. %s: Link to twitter access token generator */
				esc_html__( 'Generate %s and paste Access Token to this field.', 'islam-house' ),
				'<a href="' . esc_url( 'https://api.cmsmasters.net/wp-json/cmsmasters-api/v1/twitter-request-token' ) . '" target="_blank">' .
					esc_html__( 'twitter access token', 'islam-house' ) .
				'</a>'
			), 
			'type' => 'text', 
			'std' => $defaults[$tab]['islam-house' . '_twitter_access_token'], 
			'class' => '' 
		);
		
		break;
	case 'recaptcha':
		$options[] = array( 
			'section' => 'recaptcha_section', 
			'id' => 'islam-house' . '_recaptcha_public_key', 
			'title' => esc_html__('reCAPTCHA Public Key', 'islam-house'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['islam-house' . '_recaptcha_public_key'], 
			'class' => '' 
		);
		
		$options[] = array( 
			'section' => 'recaptcha_section', 
			'id' => 'islam-house' . '_recaptcha_private_key', 
			'title' => esc_html__('reCAPTCHA Private Key', 'islam-house'), 
			'desc' => '', 
			'type' => 'text', 
			'std' => $defaults[$tab]['islam-house' . '_recaptcha_private_key'], 
			'class' => '' 
		);
		
		break;
	}
	
	return apply_filters('cmsmasters_options_element_fields_filter', $options, $tab);	
}

