jQuery(document).ready(function($){
	"use strict";
	var bfres_upload;
	var bfres_selector;

	function bfres_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		bfres_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( bfres_upload ) {
			bfres_upload.open();
			return;
		} else {
			// Create the media frame.
			bfres_upload = wp.media.frames.bfres_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			bfres_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = bfres_upload.state().get('selection').first();

				bfres_upload.close();
				bfres_selector.find('.upload_image').val(attachment.attributes.url).change();
				if ( attachment.attributes.type == 'image' ) {
					bfres_selector.find('.bfres_screenshot').empty().hide().prepend('<img src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		bfres_upload.open();
	}

	function bfres_remove_file(selector) {
		selector.find('.bfres_screenshot').slideUp('fast').next().val('').trigger('change');
	}
	
	$('body').on('click', '.bfres_upload_image_action .remove-image', function(event) {
		bfres_remove_file( $(this).parent().parent() );
	});

	$('body').on('click', '.bfres_upload_image_action .add-image', function(event) {
		bfres_add_file(event, $(this).parent().parent());
	});

});