<?php

if ( !function_exists( 'bfres_product_metaboxes' ) ) {
	function bfres_product_metaboxes(array $metaboxes) {
		$prefix = 'goal_product_';
        $headers = array_merge( array('global' => esc_html__( 'Global Setting', 'bfres' )), bfres_get_header_layouts() );
	    $fields = array(
            array(
                'id' => $prefix.'header_type',
                'type' => 'select',
                'name' => esc_html__('Header Layout Type', 'bfres'),
                'options' => $headers
            ),
	    	array(
                'id' => $prefix.'layout_type',
                'type' => 'select',
                'name' => esc_html__('Layout Type', 'bfres'),
                'options' => array(
                    '' => esc_html__('Global Settings', 'bfres'),
                    'v1' => esc_html__('Layout 1', 'bfres'),
                    'v2' => esc_html__('Layout 2', 'bfres'),
                    'v3' => esc_html__('Layout 3', 'bfres'),
                    'v4' => esc_html__('Layout 4', 'bfres'),
                    'v5' => esc_html__('Layout 5', 'bfres'),
                    'v6' => esc_html__('Layout 6', 'bfres'),
                    'v7' => esc_html__('Layout 7', 'bfres'),
                )
            ),
            array(
                'id' => $prefix.'bg_color',
                'type' => 'colorpicker',
                'name' => esc_html__('Background Color', 'bfres'),
                'description' => esc_html__('For Layout 2 ', 'bfres'),
            ),
	    	array(
  				'name' => esc_html__( 'Review Video', 'bfres' ),
  				'id'   => $prefix.'review_video',
  				'type' => 'text',
  				'description' => esc_html__( 'You can enter a video youtube or vimeo', 'bfres' ),
  			),
        array(
          'name' => esc_html__( 'Features', 'bfres' ),
          'id'   => $prefix.'features',
          'type' => 'wysiwyg'
        ),
    	);
		
		// if ( bfres_is_sizeguides_activated() ) {
		// 	$fields[] = array(
  //               'id' => $prefix.'sizeguides_enable',
  //               'type' => 'select',
  //               'name' => esc_html__('Size Guides Enable', 'bfres'),
  //               'options' => array(
  //                   '' => esc_html__('Global Settings', 'bfres'),
  //                   'enable' => esc_html__('Enable', 'bfres'),
  //                   'disable' => esc_html__('Disable', 'bfres'),
  //               )
  //           );
		// }

	    $metaboxes[$prefix . 'display_setting'] = array(
			'id'                        => $prefix . 'display_setting',
			'title'                     => esc_html__( 'More Information', 'bfres' ),
			'object_types'              => array( 'product' ),
			'context'                   => 'normal',
			'priority'                  => 'low',
			'show_names'                => true,
			'fields'                    => $fields
		);

	    return $metaboxes;
	}
}
add_filter( 'cmb2_meta_boxes', 'bfres_product_metaboxes' );
