<?php
/**
 * The template part for displaying results in search pages
 *
 * Learn more: {@link https://codex.wordpress.org/Template_Hierarchy}
 *
 * @package WordPress
 * @subpackage Bfres
 * @since Bfres 1.0
 */
?>
<?php 
    $thumbsize = !isset($thumbsize) ? bfres_get_config( 'blog_item_thumbsize', 'full' ) : $thumbsize;
    $thumb = bfres_display_post_thumb($thumbsize);
?>

<article <?php post_class('post post-layout post-list-item'); ?>>
    
    <div class="list-inner ">
        <?php if ( is_sticky() && is_home() && ! is_paged() ) : ?>
            <span class="post-sticky"><?php echo esc_html__('Featured','bfres'); ?></span>
        <?php endif; ?>
        <div class="row <?php echo (!empty($thumb))?'flex-middle-sm':''; ?>">
            <?php
                if ( !empty($thumb) ) {
                    ?>
                    <div class="image top-image col-sm-6 col-xs-12">
                        <?php echo trim($thumb); ?>
                        <a href="<?php the_permalink(); ?>" class="date">
                            <span class="moth"><?php the_time( 'M' ); ?></span>
                            <span class="day"><?php the_time( 'd'); ?></span>
                        </a>
                    </div>
                    <?php
                }
            ?>
            <div class="<?php echo (!empty($thumb))?'col-xs-12 col-sm-6':'col-sm-12 col-xs-12 no-image'; ?>">
            
                <div class="post-info">
                    <?php if ( 'post' == get_post_type() ) : ?>
                    <div class="top-info">
                        <div class="post-author">
                            <a class="post-user" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><i class="icon-user-avatar"></i><?php echo get_the_author(); ?>
                            </a>
                        </div>
                        <?php bfres_post_categories($post); ?>
                    </div>
                    <?php endif; ?>

                    <?php if (get_the_title()) { ?>
                        <h4 class="entry-title">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h4>
                    <?php } ?>

                    

                    <?php if (bfres_get_config('show_excerpt', false)) { ?>
                        <div class="description"><?php echo bfres_substring( get_the_excerpt(), 20, '...' ); ?></div>
                    <?php } else{ ?>
                        <div class="description"><?php echo bfres_substring( get_the_content(), 20, '...' ); ?></div>
                    <?php } ?>
                    
                    <div class="bottom-info ">
                        <?php if (bfres_get_config('show_readmore', false)) { ?>
                        <a class=" btn btn-theme readmore radius-5x" href="<?php the_permalink(); ?>">
                            <span><?php esc_html_e('Read More', 'bfres'); ?>
                        </span>
                        </a>
                        <?php } ?>
                    </div>
                </div>
            </div>
            
        </div>
    </div>
</article>